package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnModel`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object environment;
 * CfnModelProps cfnModelProps = CfnModelProps.builder()
 *         .executionRoleArn("executionRoleArn")
 *         // the properties below are optional
 *         .containers(List.of(ContainerDefinitionProperty.builder()
 *                 .containerHostname("containerHostname")
 *                 .environment(environment)
 *                 .image("image")
 *                 .imageConfig(ImageConfigProperty.builder()
 *                         .repositoryAccessMode("repositoryAccessMode")
 *                         // the properties below are optional
 *                         .repositoryAuthConfig(RepositoryAuthConfigProperty.builder()
 *                                 .repositoryCredentialsProviderArn("repositoryCredentialsProviderArn")
 *                                 .build())
 *                         .build())
 *                 .inferenceSpecificationName("inferenceSpecificationName")
 *                 .mode("mode")
 *                 .modelDataUrl("modelDataUrl")
 *                 .modelPackageName("modelPackageName")
 *                 .multiModelConfig(MultiModelConfigProperty.builder()
 *                         .modelCacheSetting("modelCacheSetting")
 *                         .build())
 *                 .build()))
 *         .enableNetworkIsolation(false)
 *         .inferenceExecutionConfig(InferenceExecutionConfigProperty.builder()
 *                 .mode("mode")
 *                 .build())
 *         .modelName("modelName")
 *         .primaryContainer(ContainerDefinitionProperty.builder()
 *                 .containerHostname("containerHostname")
 *                 .environment(environment)
 *                 .image("image")
 *                 .imageConfig(ImageConfigProperty.builder()
 *                         .repositoryAccessMode("repositoryAccessMode")
 *                         // the properties below are optional
 *                         .repositoryAuthConfig(RepositoryAuthConfigProperty.builder()
 *                                 .repositoryCredentialsProviderArn("repositoryCredentialsProviderArn")
 *                                 .build())
 *                         .build())
 *                 .inferenceSpecificationName("inferenceSpecificationName")
 *                 .mode("mode")
 *                 .modelDataUrl("modelDataUrl")
 *                 .modelPackageName("modelPackageName")
 *                 .multiModelConfig(MultiModelConfigProperty.builder()
 *                         .modelCacheSetting("modelCacheSetting")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.831Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs.
     * <p>
     * Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a> .
     * <p>
     * <blockquote>
     * <p>
     * To be able to pass this role to SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

    /**
     * Specifies the containers in the inference pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
        return null;
    }

    /**
     * Isolates the model container.
     * <p>
     * No inbound or outbound network calls can be made to or from the model container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
        return null;
    }

    /**
     * Specifies details of how containers in a multi-container endpoint are called.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceExecutionConfig() {
        return null;
    }

    /**
     * The name of the new model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelName() {
        return null;
    }

    /**
     * The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryContainer() {
        return null;
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html) object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. `VpcConfig` is used in hosting services and in batch transform. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelProps> {
        java.lang.String executionRoleArn;
        java.lang.Object containers;
        java.lang.Object enableNetworkIsolation;
        java.lang.Object inferenceExecutionConfig;
        java.lang.String modelName;
        java.lang.Object primaryContainer;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnModelProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. This parameter is required.
         *                         Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">SageMaker Roles</a> .
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         To be able to pass this role to SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getContainers}
         * @param containers Specifies the containers in the inference pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(software.amazon.awscdk.IResolvable containers) {
            this.containers = containers;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getContainers}
         * @param containers Specifies the containers in the inference pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(java.util.List<? extends java.lang.Object> containers) {
            this.containers = containers;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getEnableNetworkIsolation}
         * @param enableNetworkIsolation Isolates the model container.
         *                               No inbound or outbound network calls can be made to or from the model container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getEnableNetworkIsolation}
         * @param enableNetworkIsolation Isolates the model container.
         *                               No inbound or outbound network calls can be made to or from the model container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNetworkIsolation(software.amazon.awscdk.IResolvable enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getInferenceExecutionConfig}
         * @param inferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are called.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceExecutionConfig(software.amazon.awscdk.services.sagemaker.CfnModel.InferenceExecutionConfigProperty inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getInferenceExecutionConfig}
         * @param inferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are called.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceExecutionConfig(software.amazon.awscdk.IResolvable inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getModelName}
         * @param modelName The name of the new model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getPrimaryContainer}
         * @param primaryContainer The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryContainer(software.amazon.awscdk.services.sagemaker.CfnModel.ContainerDefinitionProperty primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getPrimaryContainer}
         * @param primaryContainer The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryContainer(software.amazon.awscdk.IResolvable primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getTags}
         * @param tags A list of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getVpcConfig}
         * @param vpcConfig A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html) object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. `VpcConfig` is used in hosting services and in batch transform. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnModel.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelProps#getVpcConfig}
         * @param vpcConfig A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html) object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. `VpcConfig` is used in hosting services and in batch transform. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelProps {
        private final java.lang.String executionRoleArn;
        private final java.lang.Object containers;
        private final java.lang.Object enableNetworkIsolation;
        private final java.lang.Object inferenceExecutionConfig;
        private final java.lang.String modelName;
        private final java.lang.Object primaryContainer;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inferenceExecutionConfig = software.amazon.jsii.Kernel.get(this, "inferenceExecutionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.primaryContainer = software.amazon.jsii.Kernel.get(this, "primaryContainer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
            this.containers = builder.containers;
            this.enableNetworkIsolation = builder.enableNetworkIsolation;
            this.inferenceExecutionConfig = builder.inferenceExecutionConfig;
            this.modelName = builder.modelName;
            this.primaryContainer = builder.primaryContainer;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.Object getContainers() {
            return this.containers;
        }

        @Override
        public final java.lang.Object getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final java.lang.Object getInferenceExecutionConfig() {
            return this.inferenceExecutionConfig;
        }

        @Override
        public final java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        public final java.lang.Object getPrimaryContainer() {
            return this.primaryContainer;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            if (this.getContainers() != null) {
                data.set("containers", om.valueToTree(this.getContainers()));
            }
            if (this.getEnableNetworkIsolation() != null) {
                data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
            }
            if (this.getInferenceExecutionConfig() != null) {
                data.set("inferenceExecutionConfig", om.valueToTree(this.getInferenceExecutionConfig()));
            }
            if (this.getModelName() != null) {
                data.set("modelName", om.valueToTree(this.getModelName()));
            }
            if (this.getPrimaryContainer() != null) {
                data.set("primaryContainer", om.valueToTree(this.getPrimaryContainer()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelProps.Jsii$Proxy that = (CfnModelProps.Jsii$Proxy) o;

            if (!executionRoleArn.equals(that.executionRoleArn)) return false;
            if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
            if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
            if (this.inferenceExecutionConfig != null ? !this.inferenceExecutionConfig.equals(that.inferenceExecutionConfig) : that.inferenceExecutionConfig != null) return false;
            if (this.modelName != null ? !this.modelName.equals(that.modelName) : that.modelName != null) return false;
            if (this.primaryContainer != null ? !this.primaryContainer.equals(that.primaryContainer) : that.primaryContainer != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionRoleArn.hashCode();
            result = 31 * result + (this.containers != null ? this.containers.hashCode() : 0);
            result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
            result = 31 * result + (this.inferenceExecutionConfig != null ? this.inferenceExecutionConfig.hashCode() : 0);
            result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
            result = 31 * result + (this.primaryContainer != null ? this.primaryContainer.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
