package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Service service;
 * CnameInstanceProps cnameInstanceProps = CnameInstanceProps.builder()
 *         .instanceCname("instanceCname")
 *         .service(service)
 *         // the properties below are optional
 *         .customAttributes(Map.of(
 *                 "customAttributesKey", "customAttributes"))
 *         .instanceId("instanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:46.026Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.CnameInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CnameInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CnameInstanceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.CnameInstanceBaseProps {

    /**
     * The Cloudmap service this resource is registered to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService getService();

    /**
     * @return a {@link Builder} of {@link CnameInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CnameInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CnameInstanceProps> {
        software.amazon.awscdk.services.servicediscovery.IService service;
        java.lang.String instanceCname;
        java.util.Map<java.lang.String, java.lang.String> customAttributes;
        java.lang.String instanceId;

        /**
         * Sets the value of {@link CnameInstanceProps#getService}
         * @param service The Cloudmap service this resource is registered to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.servicediscovery.IService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link CnameInstanceProps#getInstanceCname}
         * @param instanceCname If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in response to DNS queries, for example, example.com. This value is required if the service specified by ServiceId includes settings for an CNAME record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCname(java.lang.String instanceCname) {
            this.instanceCname = instanceCname;
            return this;
        }

        /**
         * Sets the value of {@link CnameInstanceProps#getCustomAttributes}
         * @param customAttributes Custom attributes of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CnameInstanceProps#getInstanceId}
         * @param instanceId The id of the instance resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CnameInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CnameInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CnameInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CnameInstanceProps {
        private final software.amazon.awscdk.services.servicediscovery.IService service;
        private final java.lang.String instanceCname;
        private final java.util.Map<java.lang.String, java.lang.String> customAttributes;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
            this.instanceCname = software.amazon.jsii.Kernel.get(this, "instanceCname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.instanceCname = java.util.Objects.requireNonNull(builder.instanceCname, "instanceCname is required");
            this.customAttributes = builder.customAttributes;
            this.instanceId = builder.instanceId;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.IService getService() {
            return this.service;
        }

        @Override
        public final java.lang.String getInstanceCname() {
            return this.instanceCname;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            data.set("instanceCname", om.valueToTree(this.getInstanceCname()));
            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.CnameInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CnameInstanceProps.Jsii$Proxy that = (CnameInstanceProps.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (!instanceCname.equals(that.instanceCname)) return false;
            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.instanceCname.hashCode());
            result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
