package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * S3 location of the input data that the model can consume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTransformJob.Builder.create(this, "Batch Inference")
 *         .transformJobName("MyTransformJob")
 *         .modelName("MyModelName")
 *         .modelClientOptions(ModelClientOptions.builder()
 *                 .invocationsMaxRetries(3) // default is 0
 *                 .invocationsTimeout(Duration.minutes(5))
 *                 .build())
 *         .transformInput(TransformInput.builder()
 *                 .transformDataSource(TransformDataSource.builder()
 *                         .s3DataSource(TransformS3DataSource.builder()
 *                                 .s3Uri("s3://inputbucket/train")
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .transformOutput(TransformOutput.builder()
 *                 .s3OutputPath("s3://outputbucket/TransformJobOutputPath")
 *                 .build())
 *         .transformResources(TransformResources.builder()
 *                 .instanceCount(1)
 *                 .instanceType(InstanceType.of(InstanceClass.M4, InstanceSize.XLARGE))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:46.403Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.TransformDataSource")
@software.amazon.jsii.Jsii.Proxy(TransformDataSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransformDataSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 location of the input data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource getS3DataSource();

    /**
     * @return a {@link Builder} of {@link TransformDataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformDataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransformDataSource> {
        software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource s3DataSource;

        /**
         * Sets the value of {@link TransformDataSource#getS3DataSource}
         * @param s3DataSource S3 location of the input data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DataSource(software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformDataSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransformDataSource build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransformDataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformDataSource {
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource s3DataSource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3DataSource = software.amazon.jsii.Kernel.get(this, "s3DataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3DataSource = java.util.Objects.requireNonNull(builder.s3DataSource, "s3DataSource is required");
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformS3DataSource getS3DataSource() {
            return this.s3DataSource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3DataSource", om.valueToTree(this.getS3DataSource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.TransformDataSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformDataSource.Jsii$Proxy that = (TransformDataSource.Jsii$Proxy) o;

            return this.s3DataSource.equals(that.s3DataSource);
        }

        @Override
        public final int hashCode() {
            int result = this.s3DataSource.hashCode();
            return result;
        }
    }
}
