package software.amazon.awscdk.services.synthetics;

/**
 * Properties for defining a `CfnCanary`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.synthetics.*;
 * CfnCanaryProps cfnCanaryProps = CfnCanaryProps.builder()
 *         .artifactS3Location("artifactS3Location")
 *         .code(CodeProperty.builder()
 *                 .handler("handler")
 *                 // the properties below are optional
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .script("script")
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         .runtimeVersion("runtimeVersion")
 *         .schedule(ScheduleProperty.builder()
 *                 .expression("expression")
 *                 // the properties below are optional
 *                 .durationInSeconds("durationInSeconds")
 *                 .build())
 *         .startCanaryAfterCreation(false)
 *         // the properties below are optional
 *         .artifactConfig(ArtifactConfigProperty.builder()
 *                 .s3Encryption(S3EncryptionProperty.builder()
 *                         .encryptionMode("encryptionMode")
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .build())
 *                 .build())
 *         .failureRetentionPeriod(123)
 *         .runConfig(RunConfigProperty.builder()
 *                 .activeTracing(false)
 *                 .environmentVariables(Map.of(
 *                         "environmentVariablesKey", "environmentVariables"))
 *                 .memoryInMb(123)
 *                 .timeoutInSeconds(123)
 *                 .build())
 *         .successRetentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visualReference(VisualReferenceProperty.builder()
 *                 .baseCanaryRunId("baseCanaryRunId")
 *                 // the properties below are optional
 *                 .baseScreenshots(List.of(BaseScreenshotProperty.builder()
 *                         .screenshotName("screenshotName")
 *                         // the properties below are optional
 *                         .ignoreCoordinates(List.of("ignoreCoordinates"))
 *                         .build()))
 *                 .build())
 *         .vpcConfig(VPCConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:46.411Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.CfnCanaryProps")
@software.amazon.jsii.Jsii.Proxy(CfnCanaryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCanaryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
     * <p>
     * Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArtifactS3Location();

    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCode();

    /**
     * The ARN of the IAM role to be used to run the canary.
     * <p>
     * This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
     * <p>
     * <ul>
     * <li><code>s3:PutObject</code></li>
     * <li><code>s3:GetBucketLocation</code></li>
     * <li><code>s3:ListAllMyBuckets</code></li>
     * <li><code>cloudwatch:PutMetricData</code></li>
     * <li><code>logs:CreateLogGroup</code></li>
     * <li><code>logs:CreateLogStream</code></li>
     * <li><code>logs:PutLogEvents</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

    /**
     * The name for this canary.
     * <p>
     * Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
     * <p>
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the runtime version to use for the canary.
     * <p>
     * For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuntimeVersion();

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSchedule();

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     * <p>
     * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStartCanaryAfterCreation();

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArtifactConfig() {
        return null;
    }

    /**
     * The number of days to retain data about failed runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFailureRetentionPeriod() {
        return null;
    }

    /**
     * A structure that contains input information for a canary run.
     * <p>
     * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRunConfig() {
        return null;
    }

    /**
     * The number of days to retain data about successful runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSuccessRetentionPeriod() {
        return null;
    }

    /**
     * The list of key-value pairs that are associated with the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVisualReference() {
        return null;
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCanaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCanaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCanaryProps> {
        java.lang.String artifactS3Location;
        java.lang.Object code;
        java.lang.String executionRoleArn;
        java.lang.String name;
        java.lang.String runtimeVersion;
        java.lang.Object schedule;
        java.lang.Object startCanaryAfterCreation;
        java.lang.Object artifactConfig;
        java.lang.Number failureRetentionPeriod;
        java.lang.Object runConfig;
        java.lang.Number successRetentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object visualReference;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnCanaryProps#getArtifactS3Location}
         * @param artifactS3Location The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. This parameter is required.
         *                           Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactS3Location(java.lang.String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getCode}
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         *             This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getCode}
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         *             This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.IResolvable code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getExecutionRoleArn}
         * @param executionRoleArn The ARN of the IAM role to be used to run the canary. This parameter is required.
         *                         This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
         *                         <p>
         *                         <ul>
         *                         <li><code>s3:PutObject</code></li>
         *                         <li><code>s3:GetBucketLocation</code></li>
         *                         <li><code>s3:ListAllMyBuckets</code></li>
         *                         <li><code>cloudwatch:PutMetricData</code></li>
         *                         <li><code>logs:CreateLogGroup</code></li>
         *                         <li><code>logs:CreateLogStream</code></li>
         *                         <li><code>logs:PutLogEvents</code></li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getName}
         * @param name The name for this canary. This parameter is required.
         *             Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
         *             <p>
         *             Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getRuntimeVersion}
         * @param runtimeVersion Specifies the runtime version to use for the canary. This parameter is required.
         *                       For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeVersion(java.lang.String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getSchedule}
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getSchedule}
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getStartCanaryAfterCreation}
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         *                                 A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(java.lang.Boolean startCanaryAfterCreation) {
            this.startCanaryAfterCreation = startCanaryAfterCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getStartCanaryAfterCreation}
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         *                                 A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(software.amazon.awscdk.IResolvable startCanaryAfterCreation) {
            this.startCanaryAfterCreation = startCanaryAfterCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getArtifactConfig}
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getArtifactConfig}
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(software.amazon.awscdk.IResolvable artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getFailureRetentionPeriod}
         * @param failureRetentionPeriod The number of days to retain data about failed runs of this canary.
         *                               If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureRetentionPeriod(java.lang.Number failureRetentionPeriod) {
            this.failureRetentionPeriod = failureRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getRunConfig}
         * @param runConfig A structure that contains input information for a canary run.
         *                  If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getRunConfig}
         * @param runConfig A structure that contains input information for a canary run.
         *                  If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(software.amazon.awscdk.IResolvable runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getSuccessRetentionPeriod}
         * @param successRetentionPeriod The number of days to retain data about successful runs of this canary.
         *                               If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successRetentionPeriod(java.lang.Number successRetentionPeriod) {
            this.successRetentionPeriod = successRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getTags}
         * @param tags The list of key-value pairs that are associated with the canary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getVisualReference}
         * @param visualReference If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReference(software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getVisualReference}
         * @param visualReference If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReference(software.amazon.awscdk.IResolvable visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getVpcConfig}
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         *                  For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCanaryProps#getVpcConfig}
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         *                  For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCanaryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCanaryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCanaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCanaryProps {
        private final java.lang.String artifactS3Location;
        private final java.lang.Object code;
        private final java.lang.String executionRoleArn;
        private final java.lang.String name;
        private final java.lang.String runtimeVersion;
        private final java.lang.Object schedule;
        private final java.lang.Object startCanaryAfterCreation;
        private final java.lang.Object artifactConfig;
        private final java.lang.Number failureRetentionPeriod;
        private final java.lang.Object runConfig;
        private final java.lang.Number successRetentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object visualReference;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactS3Location = software.amazon.jsii.Kernel.get(this, "artifactS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeVersion = software.amazon.jsii.Kernel.get(this, "runtimeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.startCanaryAfterCreation = software.amazon.jsii.Kernel.get(this, "startCanaryAfterCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.artifactConfig = software.amazon.jsii.Kernel.get(this, "artifactConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failureRetentionPeriod = software.amazon.jsii.Kernel.get(this, "failureRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.runConfig = software.amazon.jsii.Kernel.get(this, "runConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.successRetentionPeriod = software.amazon.jsii.Kernel.get(this, "successRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.visualReference = software.amazon.jsii.Kernel.get(this, "visualReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactS3Location = java.util.Objects.requireNonNull(builder.artifactS3Location, "artifactS3Location is required");
            this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
            this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.runtimeVersion = java.util.Objects.requireNonNull(builder.runtimeVersion, "runtimeVersion is required");
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.startCanaryAfterCreation = java.util.Objects.requireNonNull(builder.startCanaryAfterCreation, "startCanaryAfterCreation is required");
            this.artifactConfig = builder.artifactConfig;
            this.failureRetentionPeriod = builder.failureRetentionPeriod;
            this.runConfig = builder.runConfig;
            this.successRetentionPeriod = builder.successRetentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.visualReference = builder.visualReference;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        @Override
        public final java.lang.Object getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Object getStartCanaryAfterCreation() {
            return this.startCanaryAfterCreation;
        }

        @Override
        public final java.lang.Object getArtifactConfig() {
            return this.artifactConfig;
        }

        @Override
        public final java.lang.Number getFailureRetentionPeriod() {
            return this.failureRetentionPeriod;
        }

        @Override
        public final java.lang.Object getRunConfig() {
            return this.runConfig;
        }

        @Override
        public final java.lang.Number getSuccessRetentionPeriod() {
            return this.successRetentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVisualReference() {
            return this.visualReference;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactS3Location", om.valueToTree(this.getArtifactS3Location()));
            data.set("code", om.valueToTree(this.getCode()));
            data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("runtimeVersion", om.valueToTree(this.getRuntimeVersion()));
            data.set("schedule", om.valueToTree(this.getSchedule()));
            data.set("startCanaryAfterCreation", om.valueToTree(this.getStartCanaryAfterCreation()));
            if (this.getArtifactConfig() != null) {
                data.set("artifactConfig", om.valueToTree(this.getArtifactConfig()));
            }
            if (this.getFailureRetentionPeriod() != null) {
                data.set("failureRetentionPeriod", om.valueToTree(this.getFailureRetentionPeriod()));
            }
            if (this.getRunConfig() != null) {
                data.set("runConfig", om.valueToTree(this.getRunConfig()));
            }
            if (this.getSuccessRetentionPeriod() != null) {
                data.set("successRetentionPeriod", om.valueToTree(this.getSuccessRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisualReference() != null) {
                data.set("visualReference", om.valueToTree(this.getVisualReference()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_synthetics.CfnCanaryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCanaryProps.Jsii$Proxy that = (CfnCanaryProps.Jsii$Proxy) o;

            if (!artifactS3Location.equals(that.artifactS3Location)) return false;
            if (!code.equals(that.code)) return false;
            if (!executionRoleArn.equals(that.executionRoleArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!runtimeVersion.equals(that.runtimeVersion)) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (!startCanaryAfterCreation.equals(that.startCanaryAfterCreation)) return false;
            if (this.artifactConfig != null ? !this.artifactConfig.equals(that.artifactConfig) : that.artifactConfig != null) return false;
            if (this.failureRetentionPeriod != null ? !this.failureRetentionPeriod.equals(that.failureRetentionPeriod) : that.failureRetentionPeriod != null) return false;
            if (this.runConfig != null ? !this.runConfig.equals(that.runConfig) : that.runConfig != null) return false;
            if (this.successRetentionPeriod != null ? !this.successRetentionPeriod.equals(that.successRetentionPeriod) : that.successRetentionPeriod != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.visualReference != null ? !this.visualReference.equals(that.visualReference) : that.visualReference != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactS3Location.hashCode();
            result = 31 * result + (this.code.hashCode());
            result = 31 * result + (this.executionRoleArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.runtimeVersion.hashCode());
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.startCanaryAfterCreation.hashCode());
            result = 31 * result + (this.artifactConfig != null ? this.artifactConfig.hashCode() : 0);
            result = 31 * result + (this.failureRetentionPeriod != null ? this.failureRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.runConfig != null ? this.runConfig.hashCode() : 0);
            result = 31 * result + (this.successRetentionPeriod != null ? this.successRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visualReference != null ? this.visualReference.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
