/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.quicksight.CfnDataSource;
import software.amazon.awscdk.services.quicksight.CfnDataSourceProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @Nullable CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastUpdatedTime() {
        return (String)Kernel.get((Object)this, (String)"attrLastUpdatedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getAlternateDataSourceParameters() {
        return Kernel.get((Object)this, (String)"alternateDataSourceParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAlternateDataSourceParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"alternateDataSourceParameters", (Object)value);
    }

    public void setAlternateDataSourceParameters(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof DataSourceParametersProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"alternateDataSourceParameters", value);
    }

    @Nullable
    public String getAwsAccountId() {
        return (String)Kernel.get((Object)this, (String)"awsAccountId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAwsAccountId(@Nullable String value) {
        Kernel.set((Object)this, (String)"awsAccountId", (Object)value);
    }

    @Nullable
    public Object getCredentials() {
        return Kernel.get((Object)this, (String)"credentials", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCredentials(@Nullable DataSourceCredentialsProperty value) {
        Kernel.set((Object)this, (String)"credentials", (Object)value);
    }

    public void setCredentials(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"credentials", (Object)value);
    }

    @Nullable
    public String getDataSourceId() {
        return (String)Kernel.get((Object)this, (String)"dataSourceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDataSourceId(@Nullable String value) {
        Kernel.set((Object)this, (String)"dataSourceId", (Object)value);
    }

    @Nullable
    public Object getDataSourceParameters() {
        return Kernel.get((Object)this, (String)"dataSourceParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSourceParameters(@Nullable DataSourceParametersProperty value) {
        Kernel.set((Object)this, (String)"dataSourceParameters", (Object)value);
    }

    public void setDataSourceParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dataSourceParameters", (Object)value);
    }

    @Nullable
    public Object getErrorInfo() {
        return Kernel.get((Object)this, (String)"errorInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setErrorInfo(@Nullable DataSourceErrorInfoProperty value) {
        Kernel.set((Object)this, (String)"errorInfo", (Object)value);
    }

    public void setErrorInfo(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"errorInfo", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getPermissions() {
        return Kernel.get((Object)this, (String)"permissions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPermissions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"permissions", (Object)value);
    }

    public void setPermissions(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ResourcePermissionProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.quicksight.CfnDataSource.ResourcePermissionProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"permissions", value);
    }

    @Nullable
    public Object getSslProperties() {
        return Kernel.get((Object)this, (String)"sslProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSslProperties(@Nullable SslPropertiesProperty value) {
        Kernel.set((Object)this, (String)"sslProperties", (Object)value);
    }

    public void setSslProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sslProperties", (Object)value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)this, (String)"type", (Object)value);
    }

    @Nullable
    public Object getVpcConnectionProperties() {
        return Kernel.get((Object)this, (String)"vpcConnectionProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConnectionProperties(@Nullable VpcConnectionPropertiesProperty value) {
        Kernel.set((Object)this, (String)"vpcConnectionProperties", (Object)value);
    }

    public void setVpcConnectionProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConnectionProperties", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder alternateDataSourceParameters(IResolvable alternateDataSourceParameters) {
            this.props().alternateDataSourceParameters(alternateDataSourceParameters);
            return this;
        }

        public Builder alternateDataSourceParameters(List<? extends Object> alternateDataSourceParameters) {
            this.props().alternateDataSourceParameters(alternateDataSourceParameters);
            return this;
        }

        public Builder awsAccountId(String awsAccountId) {
            this.props().awsAccountId(awsAccountId);
            return this;
        }

        public Builder credentials(DataSourceCredentialsProperty credentials) {
            this.props().credentials(credentials);
            return this;
        }

        public Builder credentials(IResolvable credentials) {
            this.props().credentials(credentials);
            return this;
        }

        public Builder dataSourceId(String dataSourceId) {
            this.props().dataSourceId(dataSourceId);
            return this;
        }

        public Builder dataSourceParameters(DataSourceParametersProperty dataSourceParameters) {
            this.props().dataSourceParameters(dataSourceParameters);
            return this;
        }

        public Builder dataSourceParameters(IResolvable dataSourceParameters) {
            this.props().dataSourceParameters(dataSourceParameters);
            return this;
        }

        public Builder errorInfo(DataSourceErrorInfoProperty errorInfo) {
            this.props().errorInfo(errorInfo);
            return this;
        }

        public Builder errorInfo(IResolvable errorInfo) {
            this.props().errorInfo(errorInfo);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder permissions(IResolvable permissions) {
            this.props().permissions(permissions);
            return this;
        }

        public Builder permissions(List<? extends Object> permissions) {
            this.props().permissions(permissions);
            return this;
        }

        public Builder sslProperties(SslPropertiesProperty sslProperties) {
            this.props().sslProperties(sslProperties);
            return this;
        }

        public Builder sslProperties(IResolvable sslProperties) {
            this.props().sslProperties(sslProperties);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public Builder vpcConnectionProperties(VpcConnectionPropertiesProperty vpcConnectionProperties) {
            this.props().vpcConnectionProperties(vpcConnectionProperties);
            return this;
        }

        public Builder vpcConnectionProperties(IResolvable vpcConnectionProperties) {
            this.props().vpcConnectionProperties(vpcConnectionProperties);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDataSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDataSourceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.VpcConnectionPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConnectionPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getVpcConnectionArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConnectionPropertiesProperty> {
            String vpcConnectionArn;

            public Builder vpcConnectionArn(String vpcConnectionArn) {
                this.vpcConnectionArn = vpcConnectionArn;
                return this;
            }

            public VpcConnectionPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.TeradataParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TeradataParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TeradataParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public TeradataParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.SslPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SslPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDisableSsl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SslPropertiesProperty> {
            Object disableSsl;

            public Builder disableSsl(Boolean disableSsl) {
                this.disableSsl = disableSsl;
                return this;
            }

            public Builder disableSsl(IResolvable disableSsl) {
                this.disableSsl = disableSsl;
                return this;
            }

            public SslPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.SqlServerParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqlServerParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqlServerParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public SqlServerParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.SparkParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SparkParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SparkParametersProperty> {
            String host;
            Number port;

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public SparkParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.SnowflakeParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnowflakeParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public String getWarehouse();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnowflakeParametersProperty> {
            String database;
            String host;
            String warehouse;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder warehouse(String warehouse) {
                this.warehouse = warehouse;
                return this;
            }

            public SnowflakeParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.S3ParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getManifestFileLocation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ParametersProperty> {
            Object manifestFileLocation;

            public Builder manifestFileLocation(ManifestFileLocationProperty manifestFileLocation) {
                this.manifestFileLocation = manifestFileLocation;
                return this;
            }

            public Builder manifestFileLocation(IResolvable manifestFileLocation) {
                this.manifestFileLocation = manifestFileLocation;
                return this;
            }

            public S3ParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourcePermissionProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getActions();

        @NotNull
        public String getPrincipal();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            List<String> actions;
            String principal;

            public Builder actions(List<String> actions) {
                this.actions = actions;
                return this;
            }

            public Builder principal(String principal) {
                this.principal = principal;
                return this;
            }

            public ResourcePermissionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.RedshiftParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @Nullable
        default public String getClusterId() {
            return null;
        }

        @Nullable
        default public String getHost() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftParametersProperty> {
            String database;
            String clusterId;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder clusterId(String clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public RedshiftParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.RdsParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RdsParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getInstanceId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RdsParametersProperty> {
            String database;
            String instanceId;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder instanceId(String instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public RdsParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.PrestoParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrestoParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getCatalog();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrestoParametersProperty> {
            String catalog;
            String host;
            Number port;

            public Builder catalog(String catalog) {
                this.catalog = catalog;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public PrestoParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.PostgreSqlParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PostgreSqlParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PostgreSqlParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public PostgreSqlParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.OracleParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OracleParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OracleParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public OracleParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.MySqlParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MySqlParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MySqlParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public MySqlParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.MariaDbParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MariaDbParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MariaDbParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public MariaDbParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.ManifestFileLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ManifestFileLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ManifestFileLocationProperty> {
            String bucket;
            String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public ManifestFileLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.DatabricksParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabricksParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        @NotNull
        public String getSqlEndpointPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabricksParametersProperty> {
            String host;
            Number port;
            String sqlEndpointPath;

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder sqlEndpointPath(String sqlEndpointPath) {
                this.sqlEndpointPath = sqlEndpointPath;
                return this;
            }

            public DatabricksParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmazonElasticsearchParameters() {
            return null;
        }

        @Nullable
        default public Object getAmazonOpenSearchParameters() {
            return null;
        }

        @Nullable
        default public Object getAthenaParameters() {
            return null;
        }

        @Nullable
        default public Object getAuroraParameters() {
            return null;
        }

        @Nullable
        default public Object getAuroraPostgreSqlParameters() {
            return null;
        }

        @Nullable
        default public Object getDatabricksParameters() {
            return null;
        }

        @Nullable
        default public Object getMariaDbParameters() {
            return null;
        }

        @Nullable
        default public Object getMySqlParameters() {
            return null;
        }

        @Nullable
        default public Object getOracleParameters() {
            return null;
        }

        @Nullable
        default public Object getPostgreSqlParameters() {
            return null;
        }

        @Nullable
        default public Object getPrestoParameters() {
            return null;
        }

        @Nullable
        default public Object getRdsParameters() {
            return null;
        }

        @Nullable
        default public Object getRedshiftParameters() {
            return null;
        }

        @Nullable
        default public Object getS3Parameters() {
            return null;
        }

        @Nullable
        default public Object getSnowflakeParameters() {
            return null;
        }

        @Nullable
        default public Object getSparkParameters() {
            return null;
        }

        @Nullable
        default public Object getSqlServerParameters() {
            return null;
        }

        @Nullable
        default public Object getTeradataParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceParametersProperty> {
            Object amazonElasticsearchParameters;
            Object amazonOpenSearchParameters;
            Object athenaParameters;
            Object auroraParameters;
            Object auroraPostgreSqlParameters;
            Object databricksParameters;
            Object mariaDbParameters;
            Object mySqlParameters;
            Object oracleParameters;
            Object postgreSqlParameters;
            Object prestoParameters;
            Object rdsParameters;
            Object redshiftParameters;
            Object s3Parameters;
            Object snowflakeParameters;
            Object sparkParameters;
            Object sqlServerParameters;
            Object teradataParameters;

            public Builder amazonElasticsearchParameters(AmazonElasticsearchParametersProperty amazonElasticsearchParameters) {
                this.amazonElasticsearchParameters = amazonElasticsearchParameters;
                return this;
            }

            public Builder amazonElasticsearchParameters(IResolvable amazonElasticsearchParameters) {
                this.amazonElasticsearchParameters = amazonElasticsearchParameters;
                return this;
            }

            public Builder amazonOpenSearchParameters(AmazonOpenSearchParametersProperty amazonOpenSearchParameters) {
                this.amazonOpenSearchParameters = amazonOpenSearchParameters;
                return this;
            }

            public Builder amazonOpenSearchParameters(IResolvable amazonOpenSearchParameters) {
                this.amazonOpenSearchParameters = amazonOpenSearchParameters;
                return this;
            }

            public Builder athenaParameters(AthenaParametersProperty athenaParameters) {
                this.athenaParameters = athenaParameters;
                return this;
            }

            public Builder athenaParameters(IResolvable athenaParameters) {
                this.athenaParameters = athenaParameters;
                return this;
            }

            public Builder auroraParameters(AuroraParametersProperty auroraParameters) {
                this.auroraParameters = auroraParameters;
                return this;
            }

            public Builder auroraParameters(IResolvable auroraParameters) {
                this.auroraParameters = auroraParameters;
                return this;
            }

            public Builder auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty auroraPostgreSqlParameters) {
                this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
                return this;
            }

            public Builder auroraPostgreSqlParameters(IResolvable auroraPostgreSqlParameters) {
                this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
                return this;
            }

            public Builder databricksParameters(DatabricksParametersProperty databricksParameters) {
                this.databricksParameters = databricksParameters;
                return this;
            }

            public Builder databricksParameters(IResolvable databricksParameters) {
                this.databricksParameters = databricksParameters;
                return this;
            }

            public Builder mariaDbParameters(MariaDbParametersProperty mariaDbParameters) {
                this.mariaDbParameters = mariaDbParameters;
                return this;
            }

            public Builder mariaDbParameters(IResolvable mariaDbParameters) {
                this.mariaDbParameters = mariaDbParameters;
                return this;
            }

            public Builder mySqlParameters(MySqlParametersProperty mySqlParameters) {
                this.mySqlParameters = mySqlParameters;
                return this;
            }

            public Builder mySqlParameters(IResolvable mySqlParameters) {
                this.mySqlParameters = mySqlParameters;
                return this;
            }

            public Builder oracleParameters(OracleParametersProperty oracleParameters) {
                this.oracleParameters = oracleParameters;
                return this;
            }

            public Builder oracleParameters(IResolvable oracleParameters) {
                this.oracleParameters = oracleParameters;
                return this;
            }

            public Builder postgreSqlParameters(PostgreSqlParametersProperty postgreSqlParameters) {
                this.postgreSqlParameters = postgreSqlParameters;
                return this;
            }

            public Builder postgreSqlParameters(IResolvable postgreSqlParameters) {
                this.postgreSqlParameters = postgreSqlParameters;
                return this;
            }

            public Builder prestoParameters(PrestoParametersProperty prestoParameters) {
                this.prestoParameters = prestoParameters;
                return this;
            }

            public Builder prestoParameters(IResolvable prestoParameters) {
                this.prestoParameters = prestoParameters;
                return this;
            }

            public Builder rdsParameters(RdsParametersProperty rdsParameters) {
                this.rdsParameters = rdsParameters;
                return this;
            }

            public Builder rdsParameters(IResolvable rdsParameters) {
                this.rdsParameters = rdsParameters;
                return this;
            }

            public Builder redshiftParameters(RedshiftParametersProperty redshiftParameters) {
                this.redshiftParameters = redshiftParameters;
                return this;
            }

            public Builder redshiftParameters(IResolvable redshiftParameters) {
                this.redshiftParameters = redshiftParameters;
                return this;
            }

            public Builder s3Parameters(S3ParametersProperty s3Parameters) {
                this.s3Parameters = s3Parameters;
                return this;
            }

            public Builder s3Parameters(IResolvable s3Parameters) {
                this.s3Parameters = s3Parameters;
                return this;
            }

            public Builder snowflakeParameters(SnowflakeParametersProperty snowflakeParameters) {
                this.snowflakeParameters = snowflakeParameters;
                return this;
            }

            public Builder snowflakeParameters(IResolvable snowflakeParameters) {
                this.snowflakeParameters = snowflakeParameters;
                return this;
            }

            public Builder sparkParameters(SparkParametersProperty sparkParameters) {
                this.sparkParameters = sparkParameters;
                return this;
            }

            public Builder sparkParameters(IResolvable sparkParameters) {
                this.sparkParameters = sparkParameters;
                return this;
            }

            public Builder sqlServerParameters(SqlServerParametersProperty sqlServerParameters) {
                this.sqlServerParameters = sqlServerParameters;
                return this;
            }

            public Builder sqlServerParameters(IResolvable sqlServerParameters) {
                this.sqlServerParameters = sqlServerParameters;
                return this;
            }

            public Builder teradataParameters(TeradataParametersProperty teradataParameters) {
                this.teradataParameters = teradataParameters;
                return this;
            }

            public Builder teradataParameters(IResolvable teradataParameters) {
                this.teradataParameters = teradataParameters;
                return this;
            }

            public DataSourceParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceErrorInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceErrorInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMessage() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceErrorInfoProperty> {
            String message;
            String type;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DataSourceErrorInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCopySourceArn() {
            return null;
        }

        @Nullable
        default public Object getCredentialPair() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceCredentialsProperty> {
            String copySourceArn;
            Object credentialPair;
            String secretArn;

            public Builder copySourceArn(String copySourceArn) {
                this.copySourceArn = copySourceArn;
                return this;
            }

            public Builder credentialPair(CredentialPairProperty credentialPair) {
                this.credentialPair = credentialPair;
                return this;
            }

            public Builder credentialPair(IResolvable credentialPair) {
                this.credentialPair = credentialPair;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public DataSourceCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.CredentialPairProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CredentialPairProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        @Nullable
        default public Object getAlternateDataSourceParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CredentialPairProperty> {
            String password;
            String username;
            Object alternateDataSourceParameters;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public Builder alternateDataSourceParameters(IResolvable alternateDataSourceParameters) {
                this.alternateDataSourceParameters = alternateDataSourceParameters;
                return this;
            }

            public Builder alternateDataSourceParameters(List<? extends Object> alternateDataSourceParameters) {
                this.alternateDataSourceParameters = alternateDataSourceParameters;
                return this;
            }

            public CredentialPairProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraPostgreSqlParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuroraPostgreSqlParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuroraPostgreSqlParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public AuroraPostgreSqlParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuroraParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuroraParametersProperty> {
            String database;
            String host;
            Number port;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public AuroraParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.AthenaParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AthenaParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getWorkGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AthenaParametersProperty> {
            String workGroup;

            public Builder workGroup(String workGroup) {
                this.workGroup = workGroup;
                return this;
            }

            public AthenaParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonOpenSearchParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AmazonOpenSearchParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomain();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AmazonOpenSearchParametersProperty> {
            String domain;

            public Builder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public AmazonOpenSearchParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonElasticsearchParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AmazonElasticsearchParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomain();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AmazonElasticsearchParametersProperty> {
            String domain;

            public Builder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public AmazonElasticsearchParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

