/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.awscdk.services.stepfunctions.tasks.EcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.IEcsLaunchTarget;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EcsRunTaskProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EcsRunTaskProps
extends JsiiSerializable,
TaskStateBaseProps {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public IEcsLaunchTarget getLaunchTarget();

    @NotNull
    public TaskDefinition getTaskDefinition();

    @Nullable
    default public Boolean getAssignPublicIp() {
        return null;
    }

    @Nullable
    default public List<ContainerOverride> getContainerOverrides() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsRunTaskProps> {
        ICluster cluster;
        IEcsLaunchTarget launchTarget;
        TaskDefinition taskDefinition;
        Boolean assignPublicIp;
        List<ContainerOverride> containerOverrides;
        List<ISecurityGroup> securityGroups;
        SubnetSelection subnets;
        String comment;
        Credentials credentials;
        Duration heartbeat;
        Timeout heartbeatTimeout;
        String inputPath;
        IntegrationPattern integrationPattern;
        String outputPath;
        String resultPath;
        Map<String, Object> resultSelector;
        Timeout taskTimeout;
        Duration timeout;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder launchTarget(IEcsLaunchTarget launchTarget) {
            this.launchTarget = launchTarget;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public Builder containerOverrides(List<? extends ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.resultSelector = resultSelector;
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public EcsRunTaskProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

