/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition;
import software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateModel")
public class SageMakerCreateModel
extends TaskStateBase
implements IGrantable,
IConnectable {
    protected SageMakerCreateModel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SageMakerCreateModel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SageMakerCreateModel(@NotNull Construct scope, @NotNull String id, @NotNull SageMakerCreateModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"addSecurityGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SageMakerCreateModel> {
        private final Construct scope;
        private final String id;
        private final SageMakerCreateModelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SageMakerCreateModelProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder modelName(String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        public Builder primaryContainer(IContainerDefinition primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        public Builder containers(List<? extends IContainerDefinition> containers) {
            this.props.containers(containers);
            return this;
        }

        public Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder tags(TaskInput tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public SageMakerCreateModel build() {
            return new SageMakerCreateModel(this.scope, this.id, this.props.build());
        }
    }
}

