/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule;
import software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleOptions;
import software.amazon.awscdk.services.ec2.ClientVpnEndpointAttributes;
import software.amazon.awscdk.services.ec2.ClientVpnEndpointProps;
import software.amazon.awscdk.services.ec2.ClientVpnRoute;
import software.amazon.awscdk.services.ec2.ClientVpnRouteOptions;
import software.amazon.awscdk.services.ec2.ClientVpnSessionTimeout;
import software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler;
import software.amazon.awscdk.services.ec2.IClientVpnEndpoint;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.TransportProtocol;
import software.amazon.awscdk.services.ec2.VpnPort;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.ILogStream;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IDependable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.ClientVpnEndpoint")
public class ClientVpnEndpoint
extends Resource
implements IClientVpnEndpoint {
    protected ClientVpnEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClientVpnEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ClientVpnEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull ClientVpnEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IClientVpnEndpoint fromEndpointAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClientVpnEndpointAttributes attrs) {
        return (IClientVpnEndpoint)JsiiObject.jsiiStaticCall(ClientVpnEndpoint.class, (String)"fromEndpointAttributes", (NativeType)NativeType.forClass(IClientVpnEndpoint.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public ClientVpnAuthorizationRule addAuthorizationRule(@NotNull String id, @NotNull ClientVpnAuthorizationRuleOptions props) {
        return (ClientVpnAuthorizationRule)Kernel.call((Object)this, (String)"addAuthorizationRule", (NativeType)NativeType.forClass(ClientVpnAuthorizationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ClientVpnRoute addRoute(@NotNull String id, @NotNull ClientVpnRouteOptions props) {
        return (ClientVpnRoute)Kernel.call((Object)this, (String)"addRoute", (NativeType)NativeType.forClass(ClientVpnRoute.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getEndpointId() {
        return (String)Kernel.get((Object)this, (String)"endpointId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IDependable getTargetNetworksAssociated() {
        return (IDependable)Kernel.get((Object)this, (String)"targetNetworksAssociated", (NativeType)NativeType.forClass(IDependable.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClientVpnEndpoint> {
        private final Construct scope;
        private final String id;
        private final ClientVpnEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClientVpnEndpointProps.Builder();
        }

        public Builder cidr(String cidr) {
            this.props.cidr(cidr);
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            this.props.serverCertificateArn(serverCertificateArn);
            return this;
        }

        public Builder authorizeAllUsersToVpcCidr(Boolean authorizeAllUsersToVpcCidr) {
            this.props.authorizeAllUsersToVpcCidr(authorizeAllUsersToVpcCidr);
            return this;
        }

        public Builder clientCertificateArn(String clientCertificateArn) {
            this.props.clientCertificateArn(clientCertificateArn);
            return this;
        }

        public Builder clientConnectionHandler(IClientVpnConnectionHandler clientConnectionHandler) {
            this.props.clientConnectionHandler(clientConnectionHandler);
            return this;
        }

        public Builder clientLoginBanner(String clientLoginBanner) {
            this.props.clientLoginBanner(clientLoginBanner);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder logging(Boolean logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder logGroup(ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        public Builder logStream(ILogStream logStream) {
            this.props.logStream(logStream);
            return this;
        }

        public Builder port(VpnPort port) {
            this.props.port(port);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder selfServicePortal(Boolean selfServicePortal) {
            this.props.selfServicePortal(selfServicePortal);
            return this;
        }

        public Builder sessionTimeout(ClientVpnSessionTimeout sessionTimeout) {
            this.props.sessionTimeout(sessionTimeout);
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        public Builder transportProtocol(TransportProtocol transportProtocol) {
            this.props.transportProtocol(transportProtocol);
            return this;
        }

        public Builder userBasedAuthentication(ClientVpnUserBasedAuthentication userBasedAuthentication) {
            this.props.userBasedAuthentication(userBasedAuthentication);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public ClientVpnEndpoint build() {
            return new ClientVpnEndpoint(this.scope, this.id, this.props.build());
        }
    }
}

