/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnOutput;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.pipelines.CodeBuildStepProps;
import software.amazon.awscdk.pipelines.IFileSetProducer;
import software.amazon.awscdk.pipelines.ShellStep;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.codebuild.Cache;
import software.amazon.awscdk.services.codebuild.IFileSystemLocation;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.pipelines.CodeBuildStep")
public class CodeBuildStep
extends ShellStep {
    protected CodeBuildStep(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeBuildStep(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CodeBuildStep(@NotNull String id, @NotNull CodeBuildStepProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String exportedVariable(@NotNull String variableName) {
        return (String)Kernel.call((Object)this, (String)"exportedVariable", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(variableName, "variableName is required")});
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public IProject getProject() {
        return (IProject)Kernel.get((Object)this, (String)"project", (NativeType)NativeType.forClass(IProject.class));
    }

    @Nullable
    public IRole getActionRole() {
        return (IRole)Kernel.get((Object)this, (String)"actionRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public BuildEnvironment getBuildEnvironment() {
        return (BuildEnvironment)Kernel.get((Object)this, (String)"buildEnvironment", (NativeType)NativeType.forClass(BuildEnvironment.class));
    }

    @Nullable
    public Cache getCache() {
        return (Cache)((Object)Kernel.get((Object)this, (String)"cache", (NativeType)NativeType.forClass(Cache.class)));
    }

    @Nullable
    public List<IFileSystemLocation> getFileSystemLocations() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"fileSystemLocations", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IFileSystemLocation.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public BuildSpec getPartialBuildSpec() {
        return (BuildSpec)((Object)Kernel.get((Object)this, (String)"partialBuildSpec", (NativeType)NativeType.forClass(BuildSpec.class)));
    }

    @Nullable
    public String getProjectName() {
        return (String)Kernel.get((Object)this, (String)"projectName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public List<PolicyStatement> getRolePolicyStatements() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"rolePolicyStatements", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public List<ISecurityGroup> getSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISecurityGroup.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public SubnetSelection getSubnetSelection() {
        return (SubnetSelection)Kernel.get((Object)this, (String)"subnetSelection", (NativeType)NativeType.forClass(SubnetSelection.class));
    }

    @Nullable
    public Duration getTimeout() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    @Nullable
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodeBuildStep> {
        private final String id;
        private final CodeBuildStepProps.Builder props;

        public static Builder create(String id) {
            return new Builder(id);
        }

        private Builder(String id) {
            this.id = id;
            this.props = new CodeBuildStepProps.Builder();
        }

        public Builder commands(List<String> commands) {
            this.props.commands(commands);
            return this;
        }

        public Builder additionalInputs(Map<String, ? extends IFileSetProducer> additionalInputs) {
            this.props.additionalInputs(additionalInputs);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.props.env(env);
            return this;
        }

        public Builder envFromCfnOutputs(Map<String, ? extends CfnOutput> envFromCfnOutputs) {
            this.props.envFromCfnOutputs(envFromCfnOutputs);
            return this;
        }

        public Builder input(IFileSetProducer input) {
            this.props.input(input);
            return this;
        }

        public Builder installCommands(List<String> installCommands) {
            this.props.installCommands(installCommands);
            return this;
        }

        public Builder primaryOutputDirectory(String primaryOutputDirectory) {
            this.props.primaryOutputDirectory(primaryOutputDirectory);
            return this;
        }

        public Builder actionRole(IRole actionRole) {
            this.props.actionRole(actionRole);
            return this;
        }

        public Builder buildEnvironment(BuildEnvironment buildEnvironment) {
            this.props.buildEnvironment(buildEnvironment);
            return this;
        }

        public Builder cache(Cache cache) {
            this.props.cache(cache);
            return this;
        }

        public Builder fileSystemLocations(List<? extends IFileSystemLocation> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        public Builder partialBuildSpec(BuildSpec partialBuildSpec) {
            this.props.partialBuildSpec(partialBuildSpec);
            return this;
        }

        public Builder projectName(String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder rolePolicyStatements(List<? extends PolicyStatement> rolePolicyStatements) {
            this.props.rolePolicyStatements(rolePolicyStatements);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public CodeBuildStep build() {
            return new CodeBuildStep(this.id, this.props.build());
        }
    }
}

