/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupAttributes;
import software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupProps;
import software.amazon.awscdk.services.codedeploy.IEcsApplication;
import software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.IEcsDeploymentGroup;
import software.amazon.awscdk.services.ecs.IBaseService;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.EcsDeploymentGroup")
public class EcsDeploymentGroup
extends Resource
implements IEcsDeploymentGroup {
    protected EcsDeploymentGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsDeploymentGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsDeploymentGroup(@NotNull Construct scope, @NotNull String id, @NotNull EcsDeploymentGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEcsDeploymentGroup fromEcsDeploymentGroupAttributes(@NotNull Construct scope, @NotNull String id, @NotNull EcsDeploymentGroupAttributes attrs) {
        return (IEcsDeploymentGroup)JsiiObject.jsiiStaticCall(EcsDeploymentGroup.class, (String)"fromEcsDeploymentGroupAttributes", (NativeType)NativeType.forClass(IEcsDeploymentGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAlarm(@NotNull IAlarm alarm) {
        Kernel.call((Object)this, (String)"addAlarm", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(alarm, "alarm is required")});
    }

    @Override
    @NotNull
    public IEcsApplication getApplication() {
        return (IEcsApplication)Kernel.get((Object)this, (String)"application", (NativeType)NativeType.forClass(IEcsApplication.class));
    }

    @Override
    @NotNull
    public IEcsDeploymentConfig getDeploymentConfig() {
        return (IEcsDeploymentConfig)Kernel.get((Object)this, (String)"deploymentConfig", (NativeType)NativeType.forClass(IEcsDeploymentConfig.class));
    }

    @Override
    @NotNull
    public String getDeploymentGroupArn() {
        return (String)Kernel.get((Object)this, (String)"deploymentGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDeploymentGroupName() {
        return (String)Kernel.get((Object)this, (String)"deploymentGroupName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsDeploymentGroup> {
        private final Construct scope;
        private final String id;
        private final EcsDeploymentGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EcsDeploymentGroupProps.Builder();
        }

        public Builder blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig blueGreenDeploymentConfig) {
            this.props.blueGreenDeploymentConfig(blueGreenDeploymentConfig);
            return this;
        }

        public Builder service(IBaseService service) {
            this.props.service(service);
            return this;
        }

        public Builder alarms(List<? extends IAlarm> alarms) {
            this.props.alarms(alarms);
            return this;
        }

        public Builder application(IEcsApplication application) {
            this.props.application(application);
            return this;
        }

        public Builder autoRollback(AutoRollbackConfig autoRollback) {
            this.props.autoRollback(autoRollback);
            return this;
        }

        public Builder deploymentConfig(IEcsDeploymentConfig deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.props.deploymentGroupName(deploymentGroupName);
            return this;
        }

        public Builder ignorePollAlarmsFailure(Boolean ignorePollAlarmsFailure) {
            this.props.ignorePollAlarmsFailure(ignorePollAlarmsFailure);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public EcsDeploymentGroup build() {
            return new EcsDeploymentGroup(this.scope, this.id, this.props.build());
        }
    }
}

