/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.docdb;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.docdb.DatabaseInstanceAttributes;
import software.amazon.awscdk.services.docdb.DatabaseInstanceProps;
import software.amazon.awscdk.services.docdb.Endpoint;
import software.amazon.awscdk.services.docdb.IDatabaseCluster;
import software.amazon.awscdk.services.docdb.IDatabaseInstance;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_docdb.DatabaseInstance")
public class DatabaseInstance
extends Resource
implements IDatabaseInstance {
    protected DatabaseInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseInstance(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDatabaseInstance fromDatabaseInstanceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseInstanceAttributes attrs) {
        return (IDatabaseInstance)JsiiObject.jsiiStaticCall(DatabaseInstance.class, (String)"fromDatabaseInstanceAttributes", (NativeType)NativeType.forClass(IDatabaseInstance.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public IDatabaseCluster getCluster() {
        return (IDatabaseCluster)Kernel.get((Object)this, (String)"cluster", (NativeType)NativeType.forClass(IDatabaseCluster.class));
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstanceArn() {
        return (String)Kernel.get((Object)this, (String)"instanceArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getInstanceEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"instanceEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getInstanceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"instanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseInstance> {
        private final Construct scope;
        private final String id;
        private final DatabaseInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseInstanceProps.Builder();
        }

        public Builder cluster(IDatabaseCluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder dbInstanceName(String dbInstanceName) {
            this.props.dbInstanceName(dbInstanceName);
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public DatabaseInstance build() {
            return new DatabaseInstance(this.scope, this.id, this.props.build());
        }
    }
}

