/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions;
import software.amazon.awscdk.services.ec2.INetworkAcl;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.NetworkAclEntry;
import software.amazon.awscdk.services.ec2.NetworkAclProps;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.NetworkAcl")
public class NetworkAcl
extends Resource
implements INetworkAcl {
    protected NetworkAcl(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkAcl(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkAcl(@NotNull Construct scope, @NotNull String id, @NotNull NetworkAclProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkAcl fromNetworkAclId(@NotNull Construct scope, @NotNull String id, @NotNull String networkAclId) {
        return (INetworkAcl)JsiiObject.jsiiStaticCall(NetworkAcl.class, (String)"fromNetworkAclId", (NativeType)NativeType.forClass(INetworkAcl.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkAclId, "networkAclId is required")});
    }

    @Override
    @NotNull
    public NetworkAclEntry addEntry(@NotNull String id, @NotNull CommonNetworkAclEntryOptions options) {
        return (NetworkAclEntry)Kernel.call((Object)this, (String)"addEntry", (NativeType)NativeType.forClass(NetworkAclEntry.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void associateWithSubnet(@NotNull String id, @NotNull SubnetSelection selection) {
        Kernel.call((Object)this, (String)"associateWithSubnet", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(selection, "selection is required")});
    }

    @Override
    @NotNull
    public String getNetworkAclId() {
        return (String)Kernel.get((Object)this, (String)"networkAclId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getNetworkAclVpcId() {
        return (String)Kernel.get((Object)this, (String)"networkAclVpcId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkAcl> {
        private final Construct scope;
        private final String id;
        private final NetworkAclProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkAclProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder networkAclName(String networkAclName) {
            this.props.networkAclName(networkAclName);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public NetworkAcl build() {
            return new NetworkAcl(this.scope, this.id, this.props.build());
        }
    }
}

