/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnOutput;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.pipelines.CodeBuildStepProps;
import software.amazon.awscdk.pipelines.IFileSetProducer;
import software.amazon.awscdk.pipelines.ShellStepProps;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.codebuild.Cache;
import software.amazon.awscdk.services.codebuild.IFileSystemLocation;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.pipelines.CodeBuildStepProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CodeBuildStepProps
extends JsiiSerializable,
ShellStepProps {
    @Nullable
    default public IRole getActionRole() {
        return null;
    }

    @Nullable
    default public BuildEnvironment getBuildEnvironment() {
        return null;
    }

    @Nullable
    default public Cache getCache() {
        return null;
    }

    @Nullable
    default public List<IFileSystemLocation> getFileSystemLocations() {
        return null;
    }

    @Nullable
    default public BuildSpec getPartialBuildSpec() {
        return null;
    }

    @Nullable
    default public String getProjectName() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public List<PolicyStatement> getRolePolicyStatements() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnetSelection() {
        return null;
    }

    @Nullable
    default public Duration getTimeout() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodeBuildStepProps> {
        IRole actionRole;
        BuildEnvironment buildEnvironment;
        Cache cache;
        List<IFileSystemLocation> fileSystemLocations;
        BuildSpec partialBuildSpec;
        String projectName;
        IRole role;
        List<PolicyStatement> rolePolicyStatements;
        List<ISecurityGroup> securityGroups;
        SubnetSelection subnetSelection;
        Duration timeout;
        IVpc vpc;
        List<String> commands;
        Map<String, IFileSetProducer> additionalInputs;
        Map<String, String> env;
        Map<String, CfnOutput> envFromCfnOutputs;
        IFileSetProducer input;
        List<String> installCommands;
        String primaryOutputDirectory;

        public Builder actionRole(IRole actionRole) {
            this.actionRole = actionRole;
            return this;
        }

        public Builder buildEnvironment(BuildEnvironment buildEnvironment) {
            this.buildEnvironment = buildEnvironment;
            return this;
        }

        public Builder cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileSystemLocations(List<? extends IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = fileSystemLocations;
            return this;
        }

        public Builder partialBuildSpec(BuildSpec partialBuildSpec) {
            this.partialBuildSpec = partialBuildSpec;
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder rolePolicyStatements(List<? extends PolicyStatement> rolePolicyStatements) {
            this.rolePolicyStatements = rolePolicyStatements;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder commands(List<String> commands) {
            this.commands = commands;
            return this;
        }

        public Builder additionalInputs(Map<String, ? extends IFileSetProducer> additionalInputs) {
            this.additionalInputs = additionalInputs;
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public Builder envFromCfnOutputs(Map<String, ? extends CfnOutput> envFromCfnOutputs) {
            this.envFromCfnOutputs = envFromCfnOutputs;
            return this;
        }

        public Builder input(IFileSetProducer input) {
            this.input = input;
            return this;
        }

        public Builder installCommands(List<String> installCommands) {
            this.installCommands = installCommands;
            return this;
        }

        public Builder primaryOutputDirectory(String primaryOutputDirectory) {
            this.primaryOutputDirectory = primaryOutputDirectory;
            return this;
        }

        public CodeBuildStepProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

