/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pinpoint;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.pinpoint.CfnApplicationSettings;
import software.amazon.awscdk.services.pinpoint.CfnApplicationSettingsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnApplicationSettings")
public class CfnApplicationSettings
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplicationSettings.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplicationSettings(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationSettings(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplicationSettings(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationSettingsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationId", (Object)Objects.requireNonNull(value, "applicationId is required"));
    }

    @Nullable
    public Object getCampaignHook() {
        return Kernel.get((Object)this, (String)"campaignHook", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCampaignHook(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    public void setCampaignHook(@Nullable CampaignHookProperty value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    @Nullable
    public Object getCloudWatchMetricsEnabled() {
        return Kernel.get((Object)this, (String)"cloudWatchMetricsEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCloudWatchMetricsEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"cloudWatchMetricsEnabled", (Object)value);
    }

    public void setCloudWatchMetricsEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cloudWatchMetricsEnabled", (Object)value);
    }

    @Nullable
    public Object getLimits() {
        return Kernel.get((Object)this, (String)"limits", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLimits(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    public void setLimits(@Nullable LimitsProperty value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    @Nullable
    public Object getQuietTime() {
        return Kernel.get((Object)this, (String)"quietTime", (NativeType)NativeType.forClass(Object.class));
    }

    public void setQuietTime(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"quietTime", (Object)value);
    }

    public void setQuietTime(@Nullable QuietTimeProperty value) {
        Kernel.set((Object)this, (String)"quietTime", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplicationSettings> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationSettingsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationSettingsProps.Builder();
        }

        public Builder applicationId(String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        public Builder campaignHook(IResolvable campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder campaignHook(CampaignHookProperty campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }

        public Builder cloudWatchMetricsEnabled(IResolvable cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }

        public Builder limits(IResolvable limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder limits(LimitsProperty limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder quietTime(IResolvable quietTime) {
            this.props.quietTime(quietTime);
            return this;
        }

        public Builder quietTime(QuietTimeProperty quietTime) {
            this.props.quietTime(quietTime);
            return this;
        }

        public CfnApplicationSettings build() {
            return new CfnApplicationSettings(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.QuietTimeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QuietTimeProperty
    extends JsiiSerializable {
        @NotNull
        public String getEnd();

        @NotNull
        public String getStart();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QuietTimeProperty> {
            String end;
            String start;

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public Builder start(String start) {
                this.start = start;
                return this;
            }

            public QuietTimeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.LimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LimitsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDaily() {
            return null;
        }

        @Nullable
        default public Number getMaximumDuration() {
            return null;
        }

        @Nullable
        default public Number getMessagesPerSecond() {
            return null;
        }

        @Nullable
        default public Number getTotal() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LimitsProperty> {
            Number daily;
            Number maximumDuration;
            Number messagesPerSecond;
            Number total;

            public Builder daily(Number daily) {
                this.daily = daily;
                return this;
            }

            public Builder maximumDuration(Number maximumDuration) {
                this.maximumDuration = maximumDuration;
                return this;
            }

            public Builder messagesPerSecond(Number messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            public Builder total(Number total) {
                this.total = total;
                return this;
            }

            public LimitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.CampaignHookProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignHookProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLambdaFunctionName() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getWebUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignHookProperty> {
            String lambdaFunctionName;
            String mode;
            String webUrl;

            public Builder lambdaFunctionName(String lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder webUrl(String webUrl) {
                this.webUrl = webUrl;
                return this;
            }

            public CampaignHookProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

