/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.quicksight.CfnAnalysis;
import software.amazon.awscdk.services.quicksight.CfnAnalysisProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis")
public class CfnAnalysis
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAnalysis.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAnalysis(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnalysis(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAnalysis(@NotNull Construct scope, @NotNull String id, @NotNull CfnAnalysisProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrDataSetArns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrDataSetArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public IResolvable getAttrErrors() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrErrors", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrLastUpdatedTime() {
        return (String)Kernel.get((Object)this, (String)"attrLastUpdatedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrSheets() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrSheets", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getAnalysisId() {
        return (String)Kernel.get((Object)this, (String)"analysisId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAnalysisId(@NotNull String value) {
        Kernel.set((Object)this, (String)"analysisId", (Object)Objects.requireNonNull(value, "analysisId is required"));
    }

    @NotNull
    public String getAwsAccountId() {
        return (String)Kernel.get((Object)this, (String)"awsAccountId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAwsAccountId(@NotNull String value) {
        Kernel.set((Object)this, (String)"awsAccountId", (Object)Objects.requireNonNull(value, "awsAccountId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getDefinition() {
        return Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definition", (Object)value);
    }

    public void setDefinition(@Nullable AnalysisDefinitionProperty value) {
        Kernel.set((Object)this, (String)"definition", (Object)value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    public void setParameters(@Nullable ParametersProperty value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    @Nullable
    public Object getPermissions() {
        return Kernel.get((Object)this, (String)"permissions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPermissions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"permissions", (Object)value);
    }

    public void setPermissions(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ResourcePermissionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnAnalysis.ResourcePermissionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"permissions", value);
    }

    @Nullable
    public Object getSourceEntity() {
        return Kernel.get((Object)this, (String)"sourceEntity", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceEntity(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sourceEntity", (Object)value);
    }

    public void setSourceEntity(@Nullable AnalysisSourceEntityProperty value) {
        Kernel.set((Object)this, (String)"sourceEntity", (Object)value);
    }

    @Nullable
    public String getStatus() {
        return (String)Kernel.get((Object)this, (String)"status", (NativeType)NativeType.forClass(String.class));
    }

    public void setStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"status", (Object)value);
    }

    @Nullable
    public String getThemeArn() {
        return (String)Kernel.get((Object)this, (String)"themeArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setThemeArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"themeArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAnalysis> {
        private final Construct scope;
        private final String id;
        private final CfnAnalysisProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAnalysisProps.Builder();
        }

        public Builder analysisId(String analysisId) {
            this.props.analysisId(analysisId);
            return this;
        }

        public Builder awsAccountId(String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder definition(IResolvable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definition(AnalysisDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(ParametersProperty parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder permissions(IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }

        public Builder permissions(List<? extends Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        public Builder sourceEntity(IResolvable sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }

        public Builder sourceEntity(AnalysisSourceEntityProperty sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }

        public Builder status(String status) {
            this.props.status(status);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder themeArn(String themeArn) {
            this.props.themeArn(themeArn);
            return this;
        }

        public CfnAnalysis build() {
            return new CfnAnalysis(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(WordCloudChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public WordCloudVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public WordCloudSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCloudLayout() {
            return null;
        }

        @Nullable
        default public Number getMaximumStringLength() {
            return null;
        }

        @Nullable
        default public String getWordCasing() {
            return null;
        }

        @Nullable
        default public String getWordOrientation() {
            return null;
        }

        @Nullable
        default public String getWordPadding() {
            return null;
        }

        @Nullable
        default public String getWordScaling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudOptionsProperty> {
            String cloudLayout;
            Number maximumStringLength;
            String wordCasing;
            String wordOrientation;
            String wordPadding;
            String wordScaling;

            public Builder cloudLayout(String cloudLayout) {
                this.cloudLayout = cloudLayout;
                return this;
            }

            public Builder maximumStringLength(Number maximumStringLength) {
                this.maximumStringLength = maximumStringLength;
                return this;
            }

            public Builder wordCasing(String wordCasing) {
                this.wordCasing = wordCasing;
                return this;
            }

            public Builder wordOrientation(String wordOrientation) {
                this.wordOrientation = wordOrientation;
                return this;
            }

            public Builder wordPadding(String wordPadding) {
                this.wordPadding = wordPadding;
                return this;
            }

            public Builder wordScaling(String wordScaling) {
                this.wordScaling = wordScaling;
                return this;
            }

            public WordCloudOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getWordCloudAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudFieldWellsProperty> {
            Object wordCloudAggregatedFieldWells;

            public Builder wordCloudAggregatedFieldWells(IResolvable wordCloudAggregatedFieldWells) {
                this.wordCloudAggregatedFieldWells = wordCloudAggregatedFieldWells;
                return this;
            }

            public Builder wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWellsProperty wordCloudAggregatedFieldWells) {
                this.wordCloudAggregatedFieldWells = wordCloudAggregatedFieldWells;
                return this;
            }

            public WordCloudFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getWordCloudOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudChartConfigurationProperty> {
            Object categoryLabelOptions;
            Object fieldWells;
            Object sortConfiguration;
            Object wordCloudOptions;

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(WordCloudFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(WordCloudSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder wordCloudOptions(IResolvable wordCloudOptions) {
                this.wordCloudOptions = wordCloudOptions;
                return this;
            }

            public Builder wordCloudOptions(WordCloudOptionsProperty wordCloudOptions) {
                this.wordCloudOptions = wordCloudOptions;
                return this;
            }

            public WordCloudChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WordCloudAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WordCloudAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGroupBy() {
            return null;
        }

        @Nullable
        default public Object getSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WordCloudAggregatedFieldWellsProperty> {
            Object groupBy;
            Object size;

            public Builder groupBy(IResolvable groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder groupBy(List<? extends Object> groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder size(IResolvable size) {
                this.size = size;
                return this;
            }

            public Builder size(List<? extends Object> size) {
                this.size = size;
                return this;
            }

            public WordCloudAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WhatIfRangeScenarioProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WhatIfRangeScenarioProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndDate();

        @NotNull
        public String getStartDate();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WhatIfRangeScenarioProperty> {
            String endDate;
            String startDate;
            Number value;

            public Builder endDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder startDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public WhatIfRangeScenarioProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WhatIfPointScenarioProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WhatIfPointScenarioProperty
    extends JsiiSerializable {
        @NotNull
        public String getDate();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WhatIfPointScenarioProperty> {
            String date;
            Number value;

            public Builder date(String date) {
                this.date = date;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public WhatIfPointScenarioProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(WaterfallChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public WaterfallVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBreakdownItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallChartSortConfigurationProperty> {
            Object breakdownItemsLimit;
            Object categorySort;

            public Builder breakdownItemsLimit(IResolvable breakdownItemsLimit) {
                this.breakdownItemsLimit = breakdownItemsLimit;
                return this;
            }

            public Builder breakdownItemsLimit(ItemsLimitConfigurationProperty breakdownItemsLimit) {
                this.breakdownItemsLimit = breakdownItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public WaterfallChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallChartOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallChartOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTotalBarLabel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallChartOptionsProperty> {
            String totalBarLabel;

            public Builder totalBarLabel(String totalBarLabel) {
                this.totalBarLabel = totalBarLabel;
                return this;
            }

            public WaterfallChartOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getWaterfallChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallChartFieldWellsProperty> {
            Object waterfallChartAggregatedFieldWells;

            public Builder waterfallChartAggregatedFieldWells(IResolvable waterfallChartAggregatedFieldWells) {
                this.waterfallChartAggregatedFieldWells = waterfallChartAggregatedFieldWells;
                return this;
            }

            public Builder waterfallChartAggregatedFieldWells(WaterfallChartAggregatedFieldWellsProperty waterfallChartAggregatedFieldWells) {
                this.waterfallChartAggregatedFieldWells = waterfallChartAggregatedFieldWells;
                return this;
            }

            public WaterfallChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getCategoryAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        @Nullable
        default public Object getWaterfallChartOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallChartConfigurationProperty> {
            Object categoryAxisDisplayOptions;
            Object categoryAxisLabelOptions;
            Object dataLabels;
            Object fieldWells;
            Object legend;
            Object primaryYAxisDisplayOptions;
            Object primaryYAxisLabelOptions;
            Object sortConfiguration;
            Object visualPalette;
            Object waterfallChartOptions;

            public Builder categoryAxisDisplayOptions(IResolvable categoryAxisDisplayOptions) {
                this.categoryAxisDisplayOptions = categoryAxisDisplayOptions;
                return this;
            }

            public Builder categoryAxisDisplayOptions(AxisDisplayOptionsProperty categoryAxisDisplayOptions) {
                this.categoryAxisDisplayOptions = categoryAxisDisplayOptions;
                return this;
            }

            public Builder categoryAxisLabelOptions(IResolvable categoryAxisLabelOptions) {
                this.categoryAxisLabelOptions = categoryAxisLabelOptions;
                return this;
            }

            public Builder categoryAxisLabelOptions(ChartAxisLabelOptionsProperty categoryAxisLabelOptions) {
                this.categoryAxisLabelOptions = categoryAxisLabelOptions;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(WaterfallChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(AxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(WaterfallChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder waterfallChartOptions(IResolvable waterfallChartOptions) {
                this.waterfallChartOptions = waterfallChartOptions;
                return this;
            }

            public Builder waterfallChartOptions(WaterfallChartOptionsProperty waterfallChartOptions) {
                this.waterfallChartOptions = waterfallChartOptions;
                return this;
            }

            public WaterfallChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.WaterfallChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WaterfallChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBreakdowns() {
            return null;
        }

        @Nullable
        default public Object getCategories() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WaterfallChartAggregatedFieldWellsProperty> {
            Object breakdowns;
            Object categories;
            Object values;

            public Builder breakdowns(IResolvable breakdowns) {
                this.breakdowns = breakdowns;
                return this;
            }

            public Builder breakdowns(List<? extends Object> breakdowns) {
                this.breakdowns = breakdowns;
                return this;
            }

            public Builder categories(IResolvable categories) {
                this.categories = categories;
                return this;
            }

            public Builder categories(List<? extends Object> categories) {
                this.categories = categories;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public WaterfallChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualTitleLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFormatText() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualTitleLabelOptionsProperty> {
            Object formatText;
            String visibility;

            public Builder formatText(IResolvable formatText) {
                this.formatText = formatText;
                return this;
            }

            public Builder formatText(ShortFormatTextProperty formatText) {
                this.formatText = formatText;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public VisualTitleLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualSubtitleLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFormatText() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualSubtitleLabelOptionsProperty> {
            Object formatText;
            String visibility;

            public Builder formatText(IResolvable formatText) {
                this.formatText = formatText;
                return this;
            }

            public Builder formatText(LongFormatTextProperty formatText) {
                this.formatText = formatText;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public VisualSubtitleLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBarChartVisual() {
            return null;
        }

        @Nullable
        default public Object getBoxPlotVisual() {
            return null;
        }

        @Nullable
        default public Object getComboChartVisual() {
            return null;
        }

        @Nullable
        default public Object getCustomContentVisual() {
            return null;
        }

        @Nullable
        default public Object getEmptyVisual() {
            return null;
        }

        @Nullable
        default public Object getFilledMapVisual() {
            return null;
        }

        @Nullable
        default public Object getFunnelChartVisual() {
            return null;
        }

        @Nullable
        default public Object getGaugeChartVisual() {
            return null;
        }

        @Nullable
        default public Object getGeospatialMapVisual() {
            return null;
        }

        @Nullable
        default public Object getHeatMapVisual() {
            return null;
        }

        @Nullable
        default public Object getHistogramVisual() {
            return null;
        }

        @Nullable
        default public Object getInsightVisual() {
            return null;
        }

        @Nullable
        default public Object getKpiVisual() {
            return null;
        }

        @Nullable
        default public Object getLineChartVisual() {
            return null;
        }

        @Nullable
        default public Object getPieChartVisual() {
            return null;
        }

        @Nullable
        default public Object getPivotTableVisual() {
            return null;
        }

        @Nullable
        default public Object getRadarChartVisual() {
            return null;
        }

        @Nullable
        default public Object getSankeyDiagramVisual() {
            return null;
        }

        @Nullable
        default public Object getScatterPlotVisual() {
            return null;
        }

        @Nullable
        default public Object getTableVisual() {
            return null;
        }

        @Nullable
        default public Object getTreeMapVisual() {
            return null;
        }

        @Nullable
        default public Object getWaterfallVisual() {
            return null;
        }

        @Nullable
        default public Object getWordCloudVisual() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualProperty> {
            Object barChartVisual;
            Object boxPlotVisual;
            Object comboChartVisual;
            Object customContentVisual;
            Object emptyVisual;
            Object filledMapVisual;
            Object funnelChartVisual;
            Object gaugeChartVisual;
            Object geospatialMapVisual;
            Object heatMapVisual;
            Object histogramVisual;
            Object insightVisual;
            Object kpiVisual;
            Object lineChartVisual;
            Object pieChartVisual;
            Object pivotTableVisual;
            Object radarChartVisual;
            Object sankeyDiagramVisual;
            Object scatterPlotVisual;
            Object tableVisual;
            Object treeMapVisual;
            Object waterfallVisual;
            Object wordCloudVisual;

            public Builder barChartVisual(IResolvable barChartVisual) {
                this.barChartVisual = barChartVisual;
                return this;
            }

            public Builder barChartVisual(BarChartVisualProperty barChartVisual) {
                this.barChartVisual = barChartVisual;
                return this;
            }

            public Builder boxPlotVisual(IResolvable boxPlotVisual) {
                this.boxPlotVisual = boxPlotVisual;
                return this;
            }

            public Builder boxPlotVisual(BoxPlotVisualProperty boxPlotVisual) {
                this.boxPlotVisual = boxPlotVisual;
                return this;
            }

            public Builder comboChartVisual(IResolvable comboChartVisual) {
                this.comboChartVisual = comboChartVisual;
                return this;
            }

            public Builder comboChartVisual(ComboChartVisualProperty comboChartVisual) {
                this.comboChartVisual = comboChartVisual;
                return this;
            }

            public Builder customContentVisual(IResolvable customContentVisual) {
                this.customContentVisual = customContentVisual;
                return this;
            }

            public Builder customContentVisual(CustomContentVisualProperty customContentVisual) {
                this.customContentVisual = customContentVisual;
                return this;
            }

            public Builder emptyVisual(IResolvable emptyVisual) {
                this.emptyVisual = emptyVisual;
                return this;
            }

            public Builder emptyVisual(EmptyVisualProperty emptyVisual) {
                this.emptyVisual = emptyVisual;
                return this;
            }

            public Builder filledMapVisual(IResolvable filledMapVisual) {
                this.filledMapVisual = filledMapVisual;
                return this;
            }

            public Builder filledMapVisual(FilledMapVisualProperty filledMapVisual) {
                this.filledMapVisual = filledMapVisual;
                return this;
            }

            public Builder funnelChartVisual(IResolvable funnelChartVisual) {
                this.funnelChartVisual = funnelChartVisual;
                return this;
            }

            public Builder funnelChartVisual(FunnelChartVisualProperty funnelChartVisual) {
                this.funnelChartVisual = funnelChartVisual;
                return this;
            }

            public Builder gaugeChartVisual(IResolvable gaugeChartVisual) {
                this.gaugeChartVisual = gaugeChartVisual;
                return this;
            }

            public Builder gaugeChartVisual(GaugeChartVisualProperty gaugeChartVisual) {
                this.gaugeChartVisual = gaugeChartVisual;
                return this;
            }

            public Builder geospatialMapVisual(IResolvable geospatialMapVisual) {
                this.geospatialMapVisual = geospatialMapVisual;
                return this;
            }

            public Builder geospatialMapVisual(GeospatialMapVisualProperty geospatialMapVisual) {
                this.geospatialMapVisual = geospatialMapVisual;
                return this;
            }

            public Builder heatMapVisual(IResolvable heatMapVisual) {
                this.heatMapVisual = heatMapVisual;
                return this;
            }

            public Builder heatMapVisual(HeatMapVisualProperty heatMapVisual) {
                this.heatMapVisual = heatMapVisual;
                return this;
            }

            public Builder histogramVisual(IResolvable histogramVisual) {
                this.histogramVisual = histogramVisual;
                return this;
            }

            public Builder histogramVisual(HistogramVisualProperty histogramVisual) {
                this.histogramVisual = histogramVisual;
                return this;
            }

            public Builder insightVisual(IResolvable insightVisual) {
                this.insightVisual = insightVisual;
                return this;
            }

            public Builder insightVisual(InsightVisualProperty insightVisual) {
                this.insightVisual = insightVisual;
                return this;
            }

            public Builder kpiVisual(IResolvable kpiVisual) {
                this.kpiVisual = kpiVisual;
                return this;
            }

            public Builder kpiVisual(KPIVisualProperty kpiVisual) {
                this.kpiVisual = kpiVisual;
                return this;
            }

            public Builder lineChartVisual(IResolvable lineChartVisual) {
                this.lineChartVisual = lineChartVisual;
                return this;
            }

            public Builder lineChartVisual(LineChartVisualProperty lineChartVisual) {
                this.lineChartVisual = lineChartVisual;
                return this;
            }

            public Builder pieChartVisual(IResolvable pieChartVisual) {
                this.pieChartVisual = pieChartVisual;
                return this;
            }

            public Builder pieChartVisual(PieChartVisualProperty pieChartVisual) {
                this.pieChartVisual = pieChartVisual;
                return this;
            }

            public Builder pivotTableVisual(IResolvable pivotTableVisual) {
                this.pivotTableVisual = pivotTableVisual;
                return this;
            }

            public Builder pivotTableVisual(PivotTableVisualProperty pivotTableVisual) {
                this.pivotTableVisual = pivotTableVisual;
                return this;
            }

            public Builder radarChartVisual(IResolvable radarChartVisual) {
                this.radarChartVisual = radarChartVisual;
                return this;
            }

            public Builder radarChartVisual(RadarChartVisualProperty radarChartVisual) {
                this.radarChartVisual = radarChartVisual;
                return this;
            }

            public Builder sankeyDiagramVisual(IResolvable sankeyDiagramVisual) {
                this.sankeyDiagramVisual = sankeyDiagramVisual;
                return this;
            }

            public Builder sankeyDiagramVisual(SankeyDiagramVisualProperty sankeyDiagramVisual) {
                this.sankeyDiagramVisual = sankeyDiagramVisual;
                return this;
            }

            public Builder scatterPlotVisual(IResolvable scatterPlotVisual) {
                this.scatterPlotVisual = scatterPlotVisual;
                return this;
            }

            public Builder scatterPlotVisual(ScatterPlotVisualProperty scatterPlotVisual) {
                this.scatterPlotVisual = scatterPlotVisual;
                return this;
            }

            public Builder tableVisual(IResolvable tableVisual) {
                this.tableVisual = tableVisual;
                return this;
            }

            public Builder tableVisual(TableVisualProperty tableVisual) {
                this.tableVisual = tableVisual;
                return this;
            }

            public Builder treeMapVisual(IResolvable treeMapVisual) {
                this.treeMapVisual = treeMapVisual;
                return this;
            }

            public Builder treeMapVisual(TreeMapVisualProperty treeMapVisual) {
                this.treeMapVisual = treeMapVisual;
                return this;
            }

            public Builder waterfallVisual(IResolvable waterfallVisual) {
                this.waterfallVisual = waterfallVisual;
                return this;
            }

            public Builder waterfallVisual(WaterfallVisualProperty waterfallVisual) {
                this.waterfallVisual = waterfallVisual;
                return this;
            }

            public Builder wordCloudVisual(IResolvable wordCloudVisual) {
                this.wordCloudVisual = wordCloudVisual;
                return this;
            }

            public Builder wordCloudVisual(WordCloudVisualProperty wordCloudVisual) {
                this.wordCloudVisual = wordCloudVisual;
                return this;
            }

            public VisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualPaletteProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualPaletteProperty
    extends JsiiSerializable {
        @Nullable
        default public String getChartColor() {
            return null;
        }

        @Nullable
        default public Object getColorMap() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualPaletteProperty> {
            String chartColor;
            Object colorMap;

            public Builder chartColor(String chartColor) {
                this.chartColor = chartColor;
                return this;
            }

            public Builder colorMap(IResolvable colorMap) {
                this.colorMap = colorMap;
                return this;
            }

            public Builder colorMap(List<? extends Object> colorMap) {
                this.colorMap = colorMap;
                return this;
            }

            public VisualPaletteProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualCustomActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualCustomActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActionOperations();

        @NotNull
        public String getCustomActionId();

        @NotNull
        public String getName();

        @NotNull
        public String getTrigger();

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualCustomActionProperty> {
            Object actionOperations;
            String customActionId;
            String name;
            String trigger;
            String status;

            public Builder actionOperations(IResolvable actionOperations) {
                this.actionOperations = actionOperations;
                return this;
            }

            public Builder actionOperations(List<? extends Object> actionOperations) {
                this.actionOperations = actionOperations;
                return this;
            }

            public Builder customActionId(String customActionId) {
                this.customActionId = customActionId;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder trigger(String trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public VisualCustomActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisualCustomActionOperationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisualCustomActionOperationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilterOperation() {
            return null;
        }

        @Nullable
        default public Object getNavigationOperation() {
            return null;
        }

        @Nullable
        default public Object getSetParametersOperation() {
            return null;
        }

        @Nullable
        default public Object getUrlOperation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisualCustomActionOperationProperty> {
            Object filterOperation;
            Object navigationOperation;
            Object setParametersOperation;
            Object urlOperation;

            public Builder filterOperation(IResolvable filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            public Builder filterOperation(CustomActionFilterOperationProperty filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            public Builder navigationOperation(IResolvable navigationOperation) {
                this.navigationOperation = navigationOperation;
                return this;
            }

            public Builder navigationOperation(CustomActionNavigationOperationProperty navigationOperation) {
                this.navigationOperation = navigationOperation;
                return this;
            }

            public Builder setParametersOperation(IResolvable setParametersOperation) {
                this.setParametersOperation = setParametersOperation;
                return this;
            }

            public Builder setParametersOperation(CustomActionSetParametersOperationProperty setParametersOperation) {
                this.setParametersOperation = setParametersOperation;
                return this;
            }

            public Builder urlOperation(IResolvable urlOperation) {
                this.urlOperation = urlOperation;
                return this;
            }

            public Builder urlOperation(CustomActionURLOperationProperty urlOperation) {
                this.urlOperation = urlOperation;
                return this;
            }

            public VisualCustomActionOperationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.VisibleRangeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisibleRangeOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPercentRange() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisibleRangeOptionsProperty> {
            Object percentRange;

            public Builder percentRange(IResolvable percentRange) {
                this.percentRange = percentRange;
                return this;
            }

            public Builder percentRange(PercentVisibleRangeProperty percentRange) {
                this.percentRange = percentRange;
                return this;
            }

            public VisibleRangeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.UniqueValuesComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UniqueValuesComputationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCategory();

        @NotNull
        public String getComputationId();

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UniqueValuesComputationProperty> {
            Object category;
            String computationId;
            String name;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(DimensionFieldProperty category) {
                this.category = category;
                return this;
            }

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public UniqueValuesComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.UnaggregatedFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UnaggregatedFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UnaggregatedFieldProperty> {
            Object column;
            String fieldId;
            Object formatConfiguration;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(FormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public UnaggregatedFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TrendArrowOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrendArrowOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrendArrowOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public TrendArrowOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TreeMapVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TreeMapVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TreeMapVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(TreeMapConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public TreeMapVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TreeMapSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TreeMapSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTreeMapGroupItemsLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTreeMapSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TreeMapSortConfigurationProperty> {
            Object treeMapGroupItemsLimitConfiguration;
            Object treeMapSort;

            public Builder treeMapGroupItemsLimitConfiguration(IResolvable treeMapGroupItemsLimitConfiguration) {
                this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration;
                return this;
            }

            public Builder treeMapGroupItemsLimitConfiguration(ItemsLimitConfigurationProperty treeMapGroupItemsLimitConfiguration) {
                this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration;
                return this;
            }

            public Builder treeMapSort(IResolvable treeMapSort) {
                this.treeMapSort = treeMapSort;
                return this;
            }

            public Builder treeMapSort(List<? extends Object> treeMapSort) {
                this.treeMapSort = treeMapSort;
                return this;
            }

            public TreeMapSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TreeMapFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TreeMapFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTreeMapAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TreeMapFieldWellsProperty> {
            Object treeMapAggregatedFieldWells;

            public Builder treeMapAggregatedFieldWells(IResolvable treeMapAggregatedFieldWells) {
                this.treeMapAggregatedFieldWells = treeMapAggregatedFieldWells;
                return this;
            }

            public Builder treeMapAggregatedFieldWells(TreeMapAggregatedFieldWellsProperty treeMapAggregatedFieldWells) {
                this.treeMapAggregatedFieldWells = treeMapAggregatedFieldWells;
                return this;
            }

            public TreeMapFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TreeMapConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TreeMapConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColorLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getColorScale() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getGroupLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getSizeLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TreeMapConfigurationProperty> {
            Object colorLabelOptions;
            Object colorScale;
            Object dataLabels;
            Object fieldWells;
            Object groupLabelOptions;
            Object legend;
            Object sizeLabelOptions;
            Object sortConfiguration;
            Object tooltip;

            public Builder colorLabelOptions(IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder colorScale(IResolvable colorScale) {
                this.colorScale = colorScale;
                return this;
            }

            public Builder colorScale(ColorScaleProperty colorScale) {
                this.colorScale = colorScale;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(TreeMapFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder groupLabelOptions(IResolvable groupLabelOptions) {
                this.groupLabelOptions = groupLabelOptions;
                return this;
            }

            public Builder groupLabelOptions(ChartAxisLabelOptionsProperty groupLabelOptions) {
                this.groupLabelOptions = groupLabelOptions;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder sizeLabelOptions(IResolvable sizeLabelOptions) {
                this.sizeLabelOptions = sizeLabelOptions;
                return this;
            }

            public Builder sizeLabelOptions(ChartAxisLabelOptionsProperty sizeLabelOptions) {
                this.sizeLabelOptions = sizeLabelOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(TreeMapSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public TreeMapConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TreeMapAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TreeMapAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColors() {
            return null;
        }

        @Nullable
        default public Object getGroups() {
            return null;
        }

        @Nullable
        default public Object getSizes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TreeMapAggregatedFieldWellsProperty> {
            Object colors;
            Object groups;
            Object sizes;

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder groups(IResolvable groups) {
                this.groups = groups;
                return this;
            }

            public Builder groups(List<? extends Object> groups) {
                this.groups = groups;
                return this;
            }

            public Builder sizes(IResolvable sizes) {
                this.sizes = sizes;
                return this;
            }

            public Builder sizes(List<? extends Object> sizes) {
                this.sizes = sizes;
                return this;
            }

            public TreeMapAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TotalOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TotalOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public String getPlacement() {
            return null;
        }

        @Nullable
        default public String getScrollStatus() {
            return null;
        }

        @Nullable
        default public Object getTotalCellStyle() {
            return null;
        }

        @Nullable
        default public String getTotalsVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TotalOptionsProperty> {
            String customLabel;
            String placement;
            String scrollStatus;
            Object totalCellStyle;
            String totalsVisibility;

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder placement(String placement) {
                this.placement = placement;
                return this;
            }

            public Builder scrollStatus(String scrollStatus) {
                this.scrollStatus = scrollStatus;
                return this;
            }

            public Builder totalCellStyle(IResolvable totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalCellStyle(TableCellStyleProperty totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalsVisibility(String totalsVisibility) {
                this.totalsVisibility = totalsVisibility;
                return this;
            }

            public TotalOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TotalAggregationComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TotalAggregationComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getValue();

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TotalAggregationComputationProperty> {
            String computationId;
            Object value;
            String name;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public TotalAggregationComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TopBottomRankedComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopBottomRankedComputationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCategory();

        @NotNull
        public String getComputationId();

        @NotNull
        public String getType();

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getResultSize() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopBottomRankedComputationProperty> {
            Object category;
            String computationId;
            String type;
            String name;
            Number resultSize;
            Object value;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(DimensionFieldProperty category) {
                this.category = category;
                return this;
            }

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder resultSize(Number resultSize) {
                this.resultSize = resultSize;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public TopBottomRankedComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TopBottomMoversComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopBottomMoversComputationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCategory();

        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @NotNull
        public String getType();

        @Nullable
        default public Number getMoverSize() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getSortOrder() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopBottomMoversComputationProperty> {
            Object category;
            String computationId;
            Object time;
            String type;
            Number moverSize;
            String name;
            String sortOrder;
            Object value;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(DimensionFieldProperty category) {
                this.category = category;
                return this;
            }

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder moverSize(Number moverSize) {
                this.moverSize = moverSize;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public TopBottomMoversComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TopBottomFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopBottomFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAggregationSortConfigurations();

        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @Nullable
        default public Number getLimit() {
            return null;
        }

        @Nullable
        default public String getParameterName() {
            return null;
        }

        @Nullable
        default public String getTimeGranularity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopBottomFilterProperty> {
            Object aggregationSortConfigurations;
            Object column;
            String filterId;
            Number limit;
            String parameterName;
            String timeGranularity;

            public Builder aggregationSortConfigurations(IResolvable aggregationSortConfigurations) {
                this.aggregationSortConfigurations = aggregationSortConfigurations;
                return this;
            }

            public Builder aggregationSortConfigurations(List<? extends Object> aggregationSortConfigurations) {
                this.aggregationSortConfigurations = aggregationSortConfigurations;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder limit(Number limit) {
                this.limit = limit;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public TopBottomFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TooltipOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TooltipOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldBasedTooltip() {
            return null;
        }

        @Nullable
        default public String getSelectedTooltipType() {
            return null;
        }

        @Nullable
        default public String getTooltipVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TooltipOptionsProperty> {
            Object fieldBasedTooltip;
            String selectedTooltipType;
            String tooltipVisibility;

            public Builder fieldBasedTooltip(IResolvable fieldBasedTooltip) {
                this.fieldBasedTooltip = fieldBasedTooltip;
                return this;
            }

            public Builder fieldBasedTooltip(FieldBasedTooltipProperty fieldBasedTooltip) {
                this.fieldBasedTooltip = fieldBasedTooltip;
                return this;
            }

            public Builder selectedTooltipType(String selectedTooltipType) {
                this.selectedTooltipType = selectedTooltipType;
                return this;
            }

            public Builder tooltipVisibility(String tooltipVisibility) {
                this.tooltipVisibility = tooltipVisibility;
                return this;
            }

            public TooltipOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TooltipItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TooltipItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumnTooltipItem() {
            return null;
        }

        @Nullable
        default public Object getFieldTooltipItem() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TooltipItemProperty> {
            Object columnTooltipItem;
            Object fieldTooltipItem;

            public Builder columnTooltipItem(IResolvable columnTooltipItem) {
                this.columnTooltipItem = columnTooltipItem;
                return this;
            }

            public Builder columnTooltipItem(ColumnTooltipItemProperty columnTooltipItem) {
                this.columnTooltipItem = columnTooltipItem;
                return this;
            }

            public Builder fieldTooltipItem(IResolvable fieldTooltipItem) {
                this.fieldTooltipItem = fieldTooltipItem;
                return this;
            }

            public Builder fieldTooltipItem(FieldTooltipItemProperty fieldTooltipItem) {
                this.fieldTooltipItem = fieldTooltipItem;
                return this;
            }

            public TooltipItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TimeRangeFilterValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeRangeFilterValueProperty
    extends JsiiSerializable {
        @Nullable
        default public String getParameter() {
            return null;
        }

        @Nullable
        default public Object getRollingDate() {
            return null;
        }

        @Nullable
        default public String getStaticValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeRangeFilterValueProperty> {
            String parameter;
            Object rollingDate;
            String staticValue;

            public Builder parameter(String parameter) {
                this.parameter = parameter;
                return this;
            }

            public Builder rollingDate(IResolvable rollingDate) {
                this.rollingDate = rollingDate;
                return this;
            }

            public Builder rollingDate(RollingDateConfigurationProperty rollingDate) {
                this.rollingDate = rollingDate;
                return this;
            }

            public Builder staticValue(String staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            public TimeRangeFilterValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TimeRangeFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeRangeFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @NotNull
        public String getNullOption();

        @Nullable
        default public Object getExcludePeriodConfiguration() {
            return null;
        }

        @Nullable
        default public Object getIncludeMaximum() {
            return null;
        }

        @Nullable
        default public Object getIncludeMinimum() {
            return null;
        }

        @Nullable
        default public Object getRangeMaximumValue() {
            return null;
        }

        @Nullable
        default public Object getRangeMinimumValue() {
            return null;
        }

        @Nullable
        default public String getTimeGranularity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeRangeFilterProperty> {
            Object column;
            String filterId;
            String nullOption;
            Object excludePeriodConfiguration;
            Object includeMaximum;
            Object includeMinimum;
            Object rangeMaximumValue;
            Object rangeMinimumValue;
            String timeGranularity;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder excludePeriodConfiguration(IResolvable excludePeriodConfiguration) {
                this.excludePeriodConfiguration = excludePeriodConfiguration;
                return this;
            }

            public Builder excludePeriodConfiguration(ExcludePeriodConfigurationProperty excludePeriodConfiguration) {
                this.excludePeriodConfiguration = excludePeriodConfiguration;
                return this;
            }

            public Builder includeMaximum(Boolean includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            public Builder includeMaximum(IResolvable includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            public Builder includeMinimum(Boolean includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            public Builder includeMinimum(IResolvable includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            public Builder rangeMaximumValue(IResolvable rangeMaximumValue) {
                this.rangeMaximumValue = rangeMaximumValue;
                return this;
            }

            public Builder rangeMaximumValue(TimeRangeFilterValueProperty rangeMaximumValue) {
                this.rangeMaximumValue = rangeMaximumValue;
                return this;
            }

            public Builder rangeMinimumValue(IResolvable rangeMinimumValue) {
                this.rangeMinimumValue = rangeMinimumValue;
                return this;
            }

            public Builder rangeMinimumValue(TimeRangeFilterValueProperty rangeMinimumValue) {
                this.rangeMinimumValue = rangeMinimumValue;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public TimeRangeFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeRangeDrillDownFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getRangeMaximum();

        @NotNull
        public String getRangeMinimum();

        @NotNull
        public String getTimeGranularity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeRangeDrillDownFilterProperty> {
            Object column;
            String rangeMaximum;
            String rangeMinimum;
            String timeGranularity;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder rangeMaximum(String rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            public Builder rangeMinimum(String rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public TimeRangeDrillDownFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TimeEqualityFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeEqualityFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @Nullable
        default public String getParameterName() {
            return null;
        }

        @Nullable
        default public String getTimeGranularity() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeEqualityFilterProperty> {
            Object column;
            String filterId;
            String parameterName;
            String timeGranularity;
            String value;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TimeEqualityFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TimeBasedForecastPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeBasedForecastPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getLowerBoundary() {
            return null;
        }

        @Nullable
        default public Number getPeriodsBackward() {
            return null;
        }

        @Nullable
        default public Number getPeriodsForward() {
            return null;
        }

        @Nullable
        default public Number getPredictionInterval() {
            return null;
        }

        @Nullable
        default public Number getSeasonality() {
            return null;
        }

        @Nullable
        default public Number getUpperBoundary() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeBasedForecastPropertiesProperty> {
            Number lowerBoundary;
            Number periodsBackward;
            Number periodsForward;
            Number predictionInterval;
            Number seasonality;
            Number upperBoundary;

            public Builder lowerBoundary(Number lowerBoundary) {
                this.lowerBoundary = lowerBoundary;
                return this;
            }

            public Builder periodsBackward(Number periodsBackward) {
                this.periodsBackward = periodsBackward;
                return this;
            }

            public Builder periodsForward(Number periodsForward) {
                this.periodsForward = periodsForward;
                return this;
            }

            public Builder predictionInterval(Number predictionInterval) {
                this.predictionInterval = predictionInterval;
                return this;
            }

            public Builder seasonality(Number seasonality) {
                this.seasonality = seasonality;
                return this;
            }

            public Builder upperBoundary(Number upperBoundary) {
                this.upperBoundary = upperBoundary;
                return this;
            }

            public TimeBasedForecastPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ThousandSeparatorOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSymbol() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ThousandSeparatorOptionsProperty> {
            String symbol;
            String visibility;

            public Builder symbol(String symbol) {
                this.symbol = symbol;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ThousandSeparatorOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextFieldControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPlaceholderOptions() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextFieldControlDisplayOptionsProperty> {
            Object placeholderOptions;
            Object titleOptions;

            public Builder placeholderOptions(IResolvable placeholderOptions) {
                this.placeholderOptions = placeholderOptions;
                return this;
            }

            public Builder placeholderOptions(TextControlPlaceholderOptionsProperty placeholderOptions) {
                this.placeholderOptions = placeholderOptions;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public TextFieldControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextControlPlaceholderOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextControlPlaceholderOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public TextControlPlaceholderOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TextConditionalFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextConditionalFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Object getIcon() {
            return null;
        }

        @Nullable
        default public Object getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextConditionalFormatProperty> {
            Object backgroundColor;
            Object icon;
            Object textColor;

            public Builder backgroundColor(IResolvable backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundColor(ConditionalFormattingColorProperty backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder icon(IResolvable icon) {
                this.icon = icon;
                return this;
            }

            public Builder icon(ConditionalFormattingIconProperty icon) {
                this.icon = icon;
                return this;
            }

            public Builder textColor(IResolvable textColor) {
                this.textColor = textColor;
                return this;
            }

            public Builder textColor(ConditionalFormattingColorProperty textColor) {
                this.textColor = textColor;
                return this;
            }

            public TextConditionalFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextAreaControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPlaceholderOptions() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextAreaControlDisplayOptionsProperty> {
            Object placeholderOptions;
            Object titleOptions;

            public Builder placeholderOptions(IResolvable placeholderOptions) {
                this.placeholderOptions = placeholderOptions;
                return this;
            }

            public Builder placeholderOptions(TextControlPlaceholderOptionsProperty placeholderOptions) {
                this.placeholderOptions = placeholderOptions;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public TextAreaControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getConditionalFormatting() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object conditionalFormatting;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(TableConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder conditionalFormatting(IResolvable conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder conditionalFormatting(TableConditionalFormattingProperty conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public TableVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableUnaggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableUnaggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableUnaggregatedFieldWellsProperty> {
            Object values;

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public TableUnaggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPaginationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRowSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableSortConfigurationProperty> {
            Object paginationConfiguration;
            Object rowSort;

            public Builder paginationConfiguration(IResolvable paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            public Builder paginationConfiguration(PaginationConfigurationProperty paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            public Builder rowSort(IResolvable rowSort) {
                this.rowSort = rowSort;
                return this;
            }

            public Builder rowSort(List<? extends Object> rowSort) {
                this.rowSort = rowSort;
                return this;
            }

            public TableSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableSideBorderOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableSideBorderOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBottom() {
            return null;
        }

        @Nullable
        default public Object getInnerHorizontal() {
            return null;
        }

        @Nullable
        default public Object getInnerVertical() {
            return null;
        }

        @Nullable
        default public Object getLeft() {
            return null;
        }

        @Nullable
        default public Object getRight() {
            return null;
        }

        @Nullable
        default public Object getTop() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableSideBorderOptionsProperty> {
            Object bottom;
            Object innerHorizontal;
            Object innerVertical;
            Object left;
            Object right;
            Object top;

            public Builder bottom(IResolvable bottom) {
                this.bottom = bottom;
                return this;
            }

            public Builder bottom(TableBorderOptionsProperty bottom) {
                this.bottom = bottom;
                return this;
            }

            public Builder innerHorizontal(IResolvable innerHorizontal) {
                this.innerHorizontal = innerHorizontal;
                return this;
            }

            public Builder innerHorizontal(TableBorderOptionsProperty innerHorizontal) {
                this.innerHorizontal = innerHorizontal;
                return this;
            }

            public Builder innerVertical(IResolvable innerVertical) {
                this.innerVertical = innerVertical;
                return this;
            }

            public Builder innerVertical(TableBorderOptionsProperty innerVertical) {
                this.innerVertical = innerVertical;
                return this;
            }

            public Builder left(IResolvable left) {
                this.left = left;
                return this;
            }

            public Builder left(TableBorderOptionsProperty left) {
                this.left = left;
                return this;
            }

            public Builder right(IResolvable right) {
                this.right = right;
                return this;
            }

            public Builder right(TableBorderOptionsProperty right) {
                this.right = right;
                return this;
            }

            public Builder top(IResolvable top) {
                this.top = top;
                return this;
            }

            public Builder top(TableBorderOptionsProperty top) {
                this.top = top;
                return this;
            }

            public TableSideBorderOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableRowConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableRowConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Object getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableRowConditionalFormattingProperty> {
            Object backgroundColor;
            Object textColor;

            public Builder backgroundColor(IResolvable backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundColor(ConditionalFormattingColorProperty backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder textColor(IResolvable textColor) {
                this.textColor = textColor;
                return this;
            }

            public Builder textColor(ConditionalFormattingColorProperty textColor) {
                this.textColor = textColor;
                return this;
            }

            public TableRowConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TablePaginatedReportOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TablePaginatedReportOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOverflowColumnHeaderVisibility() {
            return null;
        }

        @Nullable
        default public String getVerticalOverflowVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TablePaginatedReportOptionsProperty> {
            String overflowColumnHeaderVisibility;
            String verticalOverflowVisibility;

            public Builder overflowColumnHeaderVisibility(String overflowColumnHeaderVisibility) {
                this.overflowColumnHeaderVisibility = overflowColumnHeaderVisibility;
                return this;
            }

            public Builder verticalOverflowVisibility(String verticalOverflowVisibility) {
                this.verticalOverflowVisibility = verticalOverflowVisibility;
                return this;
            }

            public TablePaginatedReportOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCellStyle() {
            return null;
        }

        @Nullable
        default public Object getHeaderStyle() {
            return null;
        }

        @Nullable
        default public String getOrientation() {
            return null;
        }

        @Nullable
        default public Object getRowAlternateColorOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableOptionsProperty> {
            Object cellStyle;
            Object headerStyle;
            String orientation;
            Object rowAlternateColorOptions;

            public Builder cellStyle(IResolvable cellStyle) {
                this.cellStyle = cellStyle;
                return this;
            }

            public Builder cellStyle(TableCellStyleProperty cellStyle) {
                this.cellStyle = cellStyle;
                return this;
            }

            public Builder headerStyle(IResolvable headerStyle) {
                this.headerStyle = headerStyle;
                return this;
            }

            public Builder headerStyle(TableCellStyleProperty headerStyle) {
                this.headerStyle = headerStyle;
                return this;
            }

            public Builder orientation(String orientation) {
                this.orientation = orientation;
                return this;
            }

            public Builder rowAlternateColorOptions(IResolvable rowAlternateColorOptions) {
                this.rowAlternateColorOptions = rowAlternateColorOptions;
                return this;
            }

            public Builder rowAlternateColorOptions(RowAlternateColorOptionsProperty rowAlternateColorOptions) {
                this.rowAlternateColorOptions = rowAlternateColorOptions;
                return this;
            }

            public TableOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableInlineVisualizationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableInlineVisualizationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataBars() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableInlineVisualizationProperty> {
            Object dataBars;

            public Builder dataBars(IResolvable dataBars) {
                this.dataBars = dataBars;
                return this;
            }

            public Builder dataBars(DataBarsOptionsProperty dataBars) {
                this.dataBars = dataBars;
                return this;
            }

            public TableInlineVisualizationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTableAggregatedFieldWells() {
            return null;
        }

        @Nullable
        default public Object getTableUnaggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldWellsProperty> {
            Object tableAggregatedFieldWells;
            Object tableUnaggregatedFieldWells;

            public Builder tableAggregatedFieldWells(IResolvable tableAggregatedFieldWells) {
                this.tableAggregatedFieldWells = tableAggregatedFieldWells;
                return this;
            }

            public Builder tableAggregatedFieldWells(TableAggregatedFieldWellsProperty tableAggregatedFieldWells) {
                this.tableAggregatedFieldWells = tableAggregatedFieldWells;
                return this;
            }

            public Builder tableUnaggregatedFieldWells(IResolvable tableUnaggregatedFieldWells) {
                this.tableUnaggregatedFieldWells = tableUnaggregatedFieldWells;
                return this;
            }

            public Builder tableUnaggregatedFieldWells(TableUnaggregatedFieldWellsProperty tableUnaggregatedFieldWells) {
                this.tableUnaggregatedFieldWells = tableUnaggregatedFieldWells;
                return this;
            }

            public TableFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldURLConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldURLConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getImageConfiguration() {
            return null;
        }

        @Nullable
        default public Object getLinkConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldURLConfigurationProperty> {
            Object imageConfiguration;
            Object linkConfiguration;

            public Builder imageConfiguration(IResolvable imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            public Builder imageConfiguration(TableFieldImageConfigurationProperty imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            public Builder linkConfiguration(IResolvable linkConfiguration) {
                this.linkConfiguration = linkConfiguration;
                return this;
            }

            public Builder linkConfiguration(TableFieldLinkConfigurationProperty linkConfiguration) {
                this.linkConfiguration = linkConfiguration;
                return this;
            }

            public TableFieldURLConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getOrder() {
            return null;
        }

        @Nullable
        default public Object getSelectedFieldOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldOptionsProperty> {
            List<String> order;
            Object selectedFieldOptions;

            public Builder order(List<String> order) {
                this.order = order;
                return this;
            }

            public Builder selectedFieldOptions(IResolvable selectedFieldOptions) {
                this.selectedFieldOptions = selectedFieldOptions;
                return this;
            }

            public Builder selectedFieldOptions(List<? extends Object> selectedFieldOptions) {
                this.selectedFieldOptions = selectedFieldOptions;
                return this;
            }

            public TableFieldOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldOptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public Object getUrlStyling() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        @Nullable
        default public String getWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldOptionProperty> {
            String fieldId;
            String customLabel;
            Object urlStyling;
            String visibility;
            String width;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder urlStyling(IResolvable urlStyling) {
                this.urlStyling = urlStyling;
                return this;
            }

            public Builder urlStyling(TableFieldURLConfigurationProperty urlStyling) {
                this.urlStyling = urlStyling;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public TableFieldOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldLinkContentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldLinkContentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomIconContent() {
            return null;
        }

        @Nullable
        default public Object getCustomTextContent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldLinkContentConfigurationProperty> {
            Object customIconContent;
            Object customTextContent;

            public Builder customIconContent(IResolvable customIconContent) {
                this.customIconContent = customIconContent;
                return this;
            }

            public Builder customIconContent(TableFieldCustomIconContentProperty customIconContent) {
                this.customIconContent = customIconContent;
                return this;
            }

            public Builder customTextContent(IResolvable customTextContent) {
                this.customTextContent = customTextContent;
                return this;
            }

            public Builder customTextContent(TableFieldCustomTextContentProperty customTextContent) {
                this.customTextContent = customTextContent;
                return this;
            }

            public TableFieldLinkContentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldLinkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldLinkConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContent();

        @NotNull
        public String getTarget();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldLinkConfigurationProperty> {
            Object content;
            String target;

            public Builder content(IResolvable content) {
                this.content = content;
                return this;
            }

            public Builder content(TableFieldLinkContentConfigurationProperty content) {
                this.content = content;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public TableFieldLinkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldImageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldImageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSizingOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldImageConfigurationProperty> {
            Object sizingOptions;

            public Builder sizingOptions(IResolvable sizingOptions) {
                this.sizingOptions = sizingOptions;
                return this;
            }

            public Builder sizingOptions(TableCellImageSizingConfigurationProperty sizingOptions) {
                this.sizingOptions = sizingOptions;
                return this;
            }

            public TableFieldImageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldCustomTextContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldCustomTextContentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFontConfiguration();

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldCustomTextContentProperty> {
            Object fontConfiguration;
            String value;

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TableFieldCustomTextContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableFieldCustomIconContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableFieldCustomIconContentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getIcon() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableFieldCustomIconContentProperty> {
            String icon;

            public Builder icon(String icon) {
                this.icon = icon;
                return this;
            }

            public TableFieldCustomIconContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getPaginatedReportOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTableInlineVisualizations() {
            return null;
        }

        @Nullable
        default public Object getTableOptions() {
            return null;
        }

        @Nullable
        default public Object getTotalOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableConfigurationProperty> {
            Object fieldOptions;
            Object fieldWells;
            Object paginatedReportOptions;
            Object sortConfiguration;
            Object tableInlineVisualizations;
            Object tableOptions;
            Object totalOptions;

            public Builder fieldOptions(IResolvable fieldOptions) {
                this.fieldOptions = fieldOptions;
                return this;
            }

            public Builder fieldOptions(TableFieldOptionsProperty fieldOptions) {
                this.fieldOptions = fieldOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(TableFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder paginatedReportOptions(IResolvable paginatedReportOptions) {
                this.paginatedReportOptions = paginatedReportOptions;
                return this;
            }

            public Builder paginatedReportOptions(TablePaginatedReportOptionsProperty paginatedReportOptions) {
                this.paginatedReportOptions = paginatedReportOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(TableSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tableInlineVisualizations(IResolvable tableInlineVisualizations) {
                this.tableInlineVisualizations = tableInlineVisualizations;
                return this;
            }

            public Builder tableInlineVisualizations(List<? extends Object> tableInlineVisualizations) {
                this.tableInlineVisualizations = tableInlineVisualizations;
                return this;
            }

            public Builder tableOptions(IResolvable tableOptions) {
                this.tableOptions = tableOptions;
                return this;
            }

            public Builder tableOptions(TableOptionsProperty tableOptions) {
                this.tableOptions = tableOptions;
                return this;
            }

            public Builder totalOptions(IResolvable totalOptions) {
                this.totalOptions = totalOptions;
                return this;
            }

            public Builder totalOptions(TotalOptionsProperty totalOptions) {
                this.totalOptions = totalOptions;
                return this;
            }

            public TableConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditionalFormattingOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableConditionalFormattingProperty> {
            Object conditionalFormattingOptions;

            public Builder conditionalFormattingOptions(IResolvable conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public Builder conditionalFormattingOptions(List<? extends Object> conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public TableConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableConditionalFormattingOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableConditionalFormattingOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCell() {
            return null;
        }

        @Nullable
        default public Object getRow() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableConditionalFormattingOptionProperty> {
            Object cell;
            Object row;

            public Builder cell(IResolvable cell) {
                this.cell = cell;
                return this;
            }

            public Builder cell(TableCellConditionalFormattingProperty cell) {
                this.cell = cell;
                return this;
            }

            public Builder row(IResolvable row) {
                this.row = row;
                return this;
            }

            public Builder row(TableRowConditionalFormattingProperty row) {
                this.row = row;
                return this;
            }

            public TableConditionalFormattingOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableCellStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableCellStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Object getBorder() {
            return null;
        }

        @Nullable
        default public Object getFontConfiguration() {
            return null;
        }

        @Nullable
        default public Number getHeight() {
            return null;
        }

        @Nullable
        default public String getHorizontalTextAlignment() {
            return null;
        }

        @Nullable
        default public String getTextWrap() {
            return null;
        }

        @Nullable
        default public String getVerticalTextAlignment() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableCellStyleProperty> {
            String backgroundColor;
            Object border;
            Object fontConfiguration;
            Number height;
            String horizontalTextAlignment;
            String textWrap;
            String verticalTextAlignment;
            String visibility;

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder border(IResolvable border) {
                this.border = border;
                return this;
            }

            public Builder border(GlobalTableBorderOptionsProperty border) {
                this.border = border;
                return this;
            }

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder height(Number height) {
                this.height = height;
                return this;
            }

            public Builder horizontalTextAlignment(String horizontalTextAlignment) {
                this.horizontalTextAlignment = horizontalTextAlignment;
                return this;
            }

            public Builder textWrap(String textWrap) {
                this.textWrap = textWrap;
                return this;
            }

            public Builder verticalTextAlignment(String verticalTextAlignment) {
                this.verticalTextAlignment = verticalTextAlignment;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public TableCellStyleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableCellImageSizingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableCellImageSizingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTableCellImageScalingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableCellImageSizingConfigurationProperty> {
            String tableCellImageScalingConfiguration;

            public Builder tableCellImageScalingConfiguration(String tableCellImageScalingConfiguration) {
                this.tableCellImageScalingConfiguration = tableCellImageScalingConfiguration;
                return this;
            }

            public TableCellImageSizingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableCellConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableCellConditionalFormattingProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getTextFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableCellConditionalFormattingProperty> {
            String fieldId;
            Object textFormat;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder textFormat(IResolvable textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            public Builder textFormat(TextConditionalFormatProperty textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            public TableCellConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableBorderOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableBorderOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public String getStyle() {
            return null;
        }

        @Nullable
        default public Number getThickness() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableBorderOptionsProperty> {
            String color;
            String style;
            Number thickness;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder style(String style) {
                this.style = style;
                return this;
            }

            public Builder thickness(Number thickness) {
                this.thickness = thickness;
                return this;
            }

            public TableBorderOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.TableAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGroupBy() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableAggregatedFieldWellsProperty> {
            Object groupBy;
            Object values;

            public Builder groupBy(IResolvable groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder groupBy(List<? extends Object> groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public TableAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SubtotalOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubtotalOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public String getFieldLevel() {
            return null;
        }

        @Nullable
        default public Object getFieldLevelOptions() {
            return null;
        }

        @Nullable
        default public Object getMetricHeaderCellStyle() {
            return null;
        }

        @Nullable
        default public Object getTotalCellStyle() {
            return null;
        }

        @Nullable
        default public String getTotalsVisibility() {
            return null;
        }

        @Nullable
        default public Object getValueCellStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubtotalOptionsProperty> {
            String customLabel;
            String fieldLevel;
            Object fieldLevelOptions;
            Object metricHeaderCellStyle;
            Object totalCellStyle;
            String totalsVisibility;
            Object valueCellStyle;

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder fieldLevel(String fieldLevel) {
                this.fieldLevel = fieldLevel;
                return this;
            }

            public Builder fieldLevelOptions(IResolvable fieldLevelOptions) {
                this.fieldLevelOptions = fieldLevelOptions;
                return this;
            }

            public Builder fieldLevelOptions(List<? extends Object> fieldLevelOptions) {
                this.fieldLevelOptions = fieldLevelOptions;
                return this;
            }

            public Builder metricHeaderCellStyle(IResolvable metricHeaderCellStyle) {
                this.metricHeaderCellStyle = metricHeaderCellStyle;
                return this;
            }

            public Builder metricHeaderCellStyle(TableCellStyleProperty metricHeaderCellStyle) {
                this.metricHeaderCellStyle = metricHeaderCellStyle;
                return this;
            }

            public Builder totalCellStyle(IResolvable totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalCellStyle(TableCellStyleProperty totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalsVisibility(String totalsVisibility) {
                this.totalsVisibility = totalsVisibility;
                return this;
            }

            public Builder valueCellStyle(IResolvable valueCellStyle) {
                this.valueCellStyle = valueCellStyle;
                return this;
            }

            public Builder valueCellStyle(TableCellStyleProperty valueCellStyle) {
                this.valueCellStyle = valueCellStyle;
                return this;
            }

            public SubtotalOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.StringValueWhenUnsetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringValueWhenUnsetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomValue() {
            return null;
        }

        @Nullable
        default public String getValueWhenUnsetOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringValueWhenUnsetConfigurationProperty> {
            String customValue;
            String valueWhenUnsetOption;

            public Builder customValue(String customValue) {
                this.customValue = customValue;
                return this;
            }

            public Builder valueWhenUnsetOption(String valueWhenUnsetOption) {
                this.valueWhenUnsetOption = valueWhenUnsetOption;
                return this;
            }

            public StringValueWhenUnsetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.StringParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringParameterProperty> {
            String name;
            List<String> values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public StringParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.StringParameterDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringParameterDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getParameterValueType();

        @Nullable
        default public Object getDefaultValues() {
            return null;
        }

        @Nullable
        default public Object getMappedDataSetParameters() {
            return null;
        }

        @Nullable
        default public Object getValueWhenUnset() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringParameterDeclarationProperty> {
            String name;
            String parameterValueType;
            Object defaultValues;
            Object mappedDataSetParameters;
            Object valueWhenUnset;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameterValueType(String parameterValueType) {
                this.parameterValueType = parameterValueType;
                return this;
            }

            public Builder defaultValues(IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder defaultValues(StringDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder mappedDataSetParameters(IResolvable mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder mappedDataSetParameters(List<? extends Object> mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder valueWhenUnset(IResolvable valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public Builder valueWhenUnset(StringValueWhenUnsetConfigurationProperty valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public StringParameterDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.StringFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getNullValueFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNumericFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringFormatConfigurationProperty> {
            Object nullValueFormatConfiguration;
            Object numericFormatConfiguration;

            public Builder nullValueFormatConfiguration(IResolvable nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(NullValueFormatConfigurationProperty nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder numericFormatConfiguration(IResolvable numericFormatConfiguration) {
                this.numericFormatConfiguration = numericFormatConfiguration;
                return this;
            }

            public Builder numericFormatConfiguration(NumericFormatConfigurationProperty numericFormatConfiguration) {
                this.numericFormatConfiguration = numericFormatConfiguration;
                return this;
            }

            public StringFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.StringDefaultValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringDefaultValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDynamicValue() {
            return null;
        }

        @Nullable
        default public List<String> getStaticValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringDefaultValuesProperty> {
            Object dynamicValue;
            List<String> staticValues;

            public Builder dynamicValue(IResolvable dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder dynamicValue(DynamicDefaultValueProperty dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder staticValues(List<String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public StringDefaultValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SpacingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpacingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBottom() {
            return null;
        }

        @Nullable
        default public String getLeft() {
            return null;
        }

        @Nullable
        default public String getRight() {
            return null;
        }

        @Nullable
        default public String getTop() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpacingProperty> {
            String bottom;
            String left;
            String right;
            String top;

            public Builder bottom(String bottom) {
                this.bottom = bottom;
                return this;
            }

            public Builder left(String left) {
                this.left = left;
                return this;
            }

            public Builder right(String right) {
                this.right = right;
                return this;
            }

            public Builder top(String top) {
                this.top = top;
                return this;
            }

            public SpacingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SmallMultiplesOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SmallMultiplesOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxVisibleColumns() {
            return null;
        }

        @Nullable
        default public Number getMaxVisibleRows() {
            return null;
        }

        @Nullable
        default public Object getPanelConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SmallMultiplesOptionsProperty> {
            Number maxVisibleColumns;
            Number maxVisibleRows;
            Object panelConfiguration;

            public Builder maxVisibleColumns(Number maxVisibleColumns) {
                this.maxVisibleColumns = maxVisibleColumns;
                return this;
            }

            public Builder maxVisibleRows(Number maxVisibleRows) {
                this.maxVisibleRows = maxVisibleRows;
                return this;
            }

            public Builder panelConfiguration(IResolvable panelConfiguration) {
                this.panelConfiguration = panelConfiguration;
                return this;
            }

            public Builder panelConfiguration(PanelConfigurationProperty panelConfiguration) {
                this.panelConfiguration = panelConfiguration;
                return this;
            }

            public SmallMultiplesOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SliderControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SliderControlDisplayOptionsProperty> {
            Object titleOptions;

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public SliderControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SimpleClusterMarkerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SimpleClusterMarkerProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SimpleClusterMarkerProperty> {
            String color;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public SimpleClusterMarkerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ShortFormatTextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ShortFormatTextProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPlainText() {
            return null;
        }

        @Nullable
        default public String getRichText() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ShortFormatTextProperty> {
            String plainText;
            String richText;

            public Builder plainText(String plainText) {
                this.plainText = plainText;
                return this;
            }

            public Builder richText(String richText) {
                this.richText = richText;
                return this;
            }

            public ShortFormatTextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetVisualScopingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetVisualScopingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getScope();

        @NotNull
        public String getSheetId();

        @Nullable
        default public List<String> getVisualIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetVisualScopingConfigurationProperty> {
            String scope;
            String sheetId;
            List<String> visualIds;

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder sheetId(String sheetId) {
                this.sheetId = sheetId;
                return this;
            }

            public Builder visualIds(List<String> visualIds) {
                this.visualIds = visualIds;
                return this;
            }

            public SheetVisualScopingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetTextBoxProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetTextBoxProperty
    extends JsiiSerializable {
        @NotNull
        public String getSheetTextBoxId();

        @Nullable
        default public String getContent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetTextBoxProperty> {
            String sheetTextBoxId;
            String content;

            public Builder sheetTextBoxId(String sheetTextBoxId) {
                this.sheetTextBoxId = sheetTextBoxId;
                return this;
            }

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public SheetTextBoxProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getSheetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetProperty> {
            String name;
            String sheetId;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sheetId(String sheetId) {
                this.sheetId = sheetId;
                return this;
            }

            public SheetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetElementRenderingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetElementRenderingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConfigurationOverrides();

        @NotNull
        public String getExpression();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetElementRenderingRuleProperty> {
            Object configurationOverrides;
            String expression;

            public Builder configurationOverrides(IResolvable configurationOverrides) {
                this.configurationOverrides = configurationOverrides;
                return this;
            }

            public Builder configurationOverrides(SheetElementConfigurationOverridesProperty configurationOverrides) {
                this.configurationOverrides = configurationOverrides;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public SheetElementRenderingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetElementConfigurationOverridesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetElementConfigurationOverridesProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public SheetElementConfigurationOverridesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getSheetId();

        @Nullable
        default public String getContentType() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getFilterControls() {
            return null;
        }

        @Nullable
        default public Object getLayouts() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getParameterControls() {
            return null;
        }

        @Nullable
        default public Object getSheetControlLayouts() {
            return null;
        }

        @Nullable
        default public Object getTextBoxes() {
            return null;
        }

        @Nullable
        default public String getTitle() {
            return null;
        }

        @Nullable
        default public Object getVisuals() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetDefinitionProperty> {
            String sheetId;
            String contentType;
            String description;
            Object filterControls;
            Object layouts;
            String name;
            Object parameterControls;
            Object sheetControlLayouts;
            Object textBoxes;
            String title;
            Object visuals;

            public Builder sheetId(String sheetId) {
                this.sheetId = sheetId;
                return this;
            }

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder filterControls(IResolvable filterControls) {
                this.filterControls = filterControls;
                return this;
            }

            public Builder filterControls(List<? extends Object> filterControls) {
                this.filterControls = filterControls;
                return this;
            }

            public Builder layouts(IResolvable layouts) {
                this.layouts = layouts;
                return this;
            }

            public Builder layouts(List<? extends Object> layouts) {
                this.layouts = layouts;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameterControls(IResolvable parameterControls) {
                this.parameterControls = parameterControls;
                return this;
            }

            public Builder parameterControls(List<? extends Object> parameterControls) {
                this.parameterControls = parameterControls;
                return this;
            }

            public Builder sheetControlLayouts(IResolvable sheetControlLayouts) {
                this.sheetControlLayouts = sheetControlLayouts;
                return this;
            }

            public Builder sheetControlLayouts(List<? extends Object> sheetControlLayouts) {
                this.sheetControlLayouts = sheetControlLayouts;
                return this;
            }

            public Builder textBoxes(IResolvable textBoxes) {
                this.textBoxes = textBoxes;
                return this;
            }

            public Builder textBoxes(List<? extends Object> textBoxes) {
                this.textBoxes = textBoxes;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder visuals(IResolvable visuals) {
                this.visuals = visuals;
                return this;
            }

            public Builder visuals(List<? extends Object> visuals) {
                this.visuals = visuals;
                return this;
            }

            public SheetDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetControlLayoutProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetControlLayoutProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetControlLayoutProperty> {
            Object configuration;

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(SheetControlLayoutConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public SheetControlLayoutProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SheetControlLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SheetControlLayoutConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGridLayout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SheetControlLayoutConfigurationProperty> {
            Object gridLayout;

            public Builder gridLayout(IResolvable gridLayout) {
                this.gridLayout = gridLayout;
                return this;
            }

            public Builder gridLayout(GridLayoutConfigurationProperty gridLayout) {
                this.gridLayout = gridLayout;
                return this;
            }

            public SheetControlLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ShapeConditionalFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ShapeConditionalFormatProperty
    extends JsiiSerializable {
        @NotNull
        public Object getBackgroundColor();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ShapeConditionalFormatProperty> {
            Object backgroundColor;

            public Builder backgroundColor(IResolvable backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundColor(ConditionalFormattingColorProperty backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public ShapeConditionalFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SetParameterValueConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetParameterValueConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestinationParameterName();

        @NotNull
        public Object getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetParameterValueConfigurationProperty> {
            String destinationParameterName;
            Object value;

            public Builder destinationParameterName(String destinationParameterName) {
                this.destinationParameterName = destinationParameterName;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(DestinationParameterValueConfigurationProperty value) {
                this.value = value;
                return this;
            }

            public SetParameterValueConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SeriesItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SeriesItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataFieldSeriesItem() {
            return null;
        }

        @Nullable
        default public Object getFieldSeriesItem() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SeriesItemProperty> {
            Object dataFieldSeriesItem;
            Object fieldSeriesItem;

            public Builder dataFieldSeriesItem(IResolvable dataFieldSeriesItem) {
                this.dataFieldSeriesItem = dataFieldSeriesItem;
                return this;
            }

            public Builder dataFieldSeriesItem(DataFieldSeriesItemProperty dataFieldSeriesItem) {
                this.dataFieldSeriesItem = dataFieldSeriesItem;
                return this;
            }

            public Builder fieldSeriesItem(IResolvable fieldSeriesItem) {
                this.fieldSeriesItem = fieldSeriesItem;
                return this;
            }

            public Builder fieldSeriesItem(FieldSeriesItemProperty fieldSeriesItem) {
                this.fieldSeriesItem = fieldSeriesItem;
                return this;
            }

            public SeriesItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SelectedSheetsFilterScopeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelectedSheetsFilterScopeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSheetVisualScopingConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelectedSheetsFilterScopeConfigurationProperty> {
            Object sheetVisualScopingConfigurations;

            public Builder sheetVisualScopingConfigurations(IResolvable sheetVisualScopingConfigurations) {
                this.sheetVisualScopingConfigurations = sheetVisualScopingConfigurations;
                return this;
            }

            public Builder sheetVisualScopingConfigurations(List<? extends Object> sheetVisualScopingConfigurations) {
                this.sheetVisualScopingConfigurations = sheetVisualScopingConfigurations;
                return this;
            }

            public SelectedSheetsFilterScopeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHeight() {
            return null;
        }

        @Nullable
        default public Object getPadding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionStyleProperty> {
            String height;
            Object padding;

            public Builder height(String height) {
                this.height = height;
                return this;
            }

            public Builder padding(IResolvable padding) {
                this.padding = padding;
                return this;
            }

            public Builder padding(SpacingProperty padding) {
                this.padding = padding;
                return this;
            }

            public SectionStyleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionPageBreakConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionPageBreakConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAfter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionPageBreakConfigurationProperty> {
            Object after;

            public Builder after(IResolvable after) {
                this.after = after;
                return this;
            }

            public Builder after(SectionAfterPageBreakProperty after) {
                this.after = after;
                return this;
            }

            public SectionPageBreakConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFreeFormLayout();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionLayoutConfigurationProperty> {
            Object freeFormLayout;

            public Builder freeFormLayout(IResolvable freeFormLayout) {
                this.freeFormLayout = freeFormLayout;
                return this;
            }

            public Builder freeFormLayout(FreeFormSectionLayoutConfigurationProperty freeFormLayout) {
                this.freeFormLayout = freeFormLayout;
                return this;
            }

            public SectionLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionBasedLayoutPaperCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPaperMargin() {
            return null;
        }

        @Nullable
        default public String getPaperOrientation() {
            return null;
        }

        @Nullable
        default public String getPaperSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionBasedLayoutPaperCanvasSizeOptionsProperty> {
            Object paperMargin;
            String paperOrientation;
            String paperSize;

            public Builder paperMargin(IResolvable paperMargin) {
                this.paperMargin = paperMargin;
                return this;
            }

            public Builder paperMargin(SpacingProperty paperMargin) {
                this.paperMargin = paperMargin;
                return this;
            }

            public Builder paperOrientation(String paperOrientation) {
                this.paperOrientation = paperOrientation;
                return this;
            }

            public Builder paperSize(String paperSize) {
                this.paperSize = paperSize;
                return this;
            }

            public SectionBasedLayoutPaperCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionBasedLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionBasedLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getBodySections();

        @NotNull
        public Object getCanvasSizeOptions();

        @NotNull
        public Object getFooterSections();

        @NotNull
        public Object getHeaderSections();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionBasedLayoutConfigurationProperty> {
            Object bodySections;
            Object canvasSizeOptions;
            Object footerSections;
            Object headerSections;

            public Builder bodySections(IResolvable bodySections) {
                this.bodySections = bodySections;
                return this;
            }

            public Builder bodySections(List<? extends Object> bodySections) {
                this.bodySections = bodySections;
                return this;
            }

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder footerSections(IResolvable footerSections) {
                this.footerSections = footerSections;
                return this;
            }

            public Builder footerSections(List<? extends Object> footerSections) {
                this.footerSections = footerSections;
                return this;
            }

            public Builder headerSections(IResolvable headerSections) {
                this.headerSections = headerSections;
                return this;
            }

            public Builder headerSections(List<? extends Object> headerSections) {
                this.headerSections = headerSections;
                return this;
            }

            public SectionBasedLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionBasedLayoutCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPaperCanvasSizeOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionBasedLayoutCanvasSizeOptionsProperty> {
            Object paperCanvasSizeOptions;

            public Builder paperCanvasSizeOptions(IResolvable paperCanvasSizeOptions) {
                this.paperCanvasSizeOptions = paperCanvasSizeOptions;
                return this;
            }

            public Builder paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty paperCanvasSizeOptions) {
                this.paperCanvasSizeOptions = paperCanvasSizeOptions;
                return this;
            }

            public SectionBasedLayoutCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SectionAfterPageBreakProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SectionAfterPageBreakProperty
    extends JsiiSerializable {
        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SectionAfterPageBreakProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public SectionAfterPageBreakProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SecondaryValueOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecondaryValueOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecondaryValueOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public SecondaryValueOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScrollBarOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScrollBarOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        @Nullable
        default public Object getVisibleRange() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScrollBarOptionsProperty> {
            String visibility;
            Object visibleRange;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public Builder visibleRange(IResolvable visibleRange) {
                this.visibleRange = visibleRange;
                return this;
            }

            public Builder visibleRange(VisibleRangeOptionsProperty visibleRange) {
                this.visibleRange = visibleRange;
                return this;
            }

            public ScrollBarOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScatterPlotVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScatterPlotVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScatterPlotVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(ScatterPlotConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public ScatterPlotVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScatterPlotUnaggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScatterPlotUnaggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSize() {
            return null;
        }

        @Nullable
        default public Object getXAxis() {
            return null;
        }

        @Nullable
        default public Object getYAxis() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScatterPlotUnaggregatedFieldWellsProperty> {
            Object size;
            Object xAxis;
            Object yAxis;

            public Builder size(IResolvable size) {
                this.size = size;
                return this;
            }

            public Builder size(List<? extends Object> size) {
                this.size = size;
                return this;
            }

            public Builder xAxis(IResolvable xAxis) {
                this.xAxis = xAxis;
                return this;
            }

            public Builder xAxis(List<? extends Object> xAxis) {
                this.xAxis = xAxis;
                return this;
            }

            public Builder yAxis(IResolvable yAxis) {
                this.yAxis = yAxis;
                return this;
            }

            public Builder yAxis(List<? extends Object> yAxis) {
                this.yAxis = yAxis;
                return this;
            }

            public ScatterPlotUnaggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScatterPlotFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScatterPlotFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getScatterPlotCategoricallyAggregatedFieldWells() {
            return null;
        }

        @Nullable
        default public Object getScatterPlotUnaggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScatterPlotFieldWellsProperty> {
            Object scatterPlotCategoricallyAggregatedFieldWells;
            Object scatterPlotUnaggregatedFieldWells;

            public Builder scatterPlotCategoricallyAggregatedFieldWells(IResolvable scatterPlotCategoricallyAggregatedFieldWells) {
                this.scatterPlotCategoricallyAggregatedFieldWells = scatterPlotCategoricallyAggregatedFieldWells;
                return this;
            }

            public Builder scatterPlotCategoricallyAggregatedFieldWells(ScatterPlotCategoricallyAggregatedFieldWellsProperty scatterPlotCategoricallyAggregatedFieldWells) {
                this.scatterPlotCategoricallyAggregatedFieldWells = scatterPlotCategoricallyAggregatedFieldWells;
                return this;
            }

            public Builder scatterPlotUnaggregatedFieldWells(IResolvable scatterPlotUnaggregatedFieldWells) {
                this.scatterPlotUnaggregatedFieldWells = scatterPlotUnaggregatedFieldWells;
                return this;
            }

            public Builder scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWellsProperty scatterPlotUnaggregatedFieldWells) {
                this.scatterPlotUnaggregatedFieldWells = scatterPlotUnaggregatedFieldWells;
                return this;
            }

            public ScatterPlotFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScatterPlotConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScatterPlotConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        @Nullable
        default public Object getXAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getXAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getYAxisLabelOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScatterPlotConfigurationProperty> {
            Object dataLabels;
            Object fieldWells;
            Object legend;
            Object tooltip;
            Object visualPalette;
            Object xAxisDisplayOptions;
            Object xAxisLabelOptions;
            Object yAxisDisplayOptions;
            Object yAxisLabelOptions;

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(ScatterPlotFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder xAxisDisplayOptions(IResolvable xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisDisplayOptions(AxisDisplayOptionsProperty xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisLabelOptions(IResolvable xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public Builder xAxisLabelOptions(ChartAxisLabelOptionsProperty xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public Builder yAxisDisplayOptions(IResolvable yAxisDisplayOptions) {
                this.yAxisDisplayOptions = yAxisDisplayOptions;
                return this;
            }

            public Builder yAxisDisplayOptions(AxisDisplayOptionsProperty yAxisDisplayOptions) {
                this.yAxisDisplayOptions = yAxisDisplayOptions;
                return this;
            }

            public Builder yAxisLabelOptions(IResolvable yAxisLabelOptions) {
                this.yAxisLabelOptions = yAxisLabelOptions;
                return this;
            }

            public Builder yAxisLabelOptions(ChartAxisLabelOptionsProperty yAxisLabelOptions) {
                this.yAxisLabelOptions = yAxisLabelOptions;
                return this;
            }

            public ScatterPlotConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ScatterPlotCategoricallyAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScatterPlotCategoricallyAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getSize() {
            return null;
        }

        @Nullable
        default public Object getXAxis() {
            return null;
        }

        @Nullable
        default public Object getYAxis() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScatterPlotCategoricallyAggregatedFieldWellsProperty> {
            Object category;
            Object size;
            Object xAxis;
            Object yAxis;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder size(IResolvable size) {
                this.size = size;
                return this;
            }

            public Builder size(List<? extends Object> size) {
                this.size = size;
                return this;
            }

            public Builder xAxis(IResolvable xAxis) {
                this.xAxis = xAxis;
                return this;
            }

            public Builder xAxis(List<? extends Object> xAxis) {
                this.xAxis = xAxis;
                return this;
            }

            public Builder yAxis(IResolvable yAxis) {
                this.yAxis = yAxis;
                return this;
            }

            public Builder yAxis(List<? extends Object> yAxis) {
                this.yAxis = yAxis;
                return this;
            }

            public ScatterPlotCategoricallyAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SankeyDiagramVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SankeyDiagramVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SankeyDiagramVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(SankeyDiagramChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public SankeyDiagramVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SankeyDiagramSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SankeyDiagramSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinationItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getSourceItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getWeightSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SankeyDiagramSortConfigurationProperty> {
            Object destinationItemsLimit;
            Object sourceItemsLimit;
            Object weightSort;

            public Builder destinationItemsLimit(IResolvable destinationItemsLimit) {
                this.destinationItemsLimit = destinationItemsLimit;
                return this;
            }

            public Builder destinationItemsLimit(ItemsLimitConfigurationProperty destinationItemsLimit) {
                this.destinationItemsLimit = destinationItemsLimit;
                return this;
            }

            public Builder sourceItemsLimit(IResolvable sourceItemsLimit) {
                this.sourceItemsLimit = sourceItemsLimit;
                return this;
            }

            public Builder sourceItemsLimit(ItemsLimitConfigurationProperty sourceItemsLimit) {
                this.sourceItemsLimit = sourceItemsLimit;
                return this;
            }

            public Builder weightSort(IResolvable weightSort) {
                this.weightSort = weightSort;
                return this;
            }

            public Builder weightSort(List<? extends Object> weightSort) {
                this.weightSort = weightSort;
                return this;
            }

            public SankeyDiagramSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SankeyDiagramFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SankeyDiagramFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSankeyDiagramAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SankeyDiagramFieldWellsProperty> {
            Object sankeyDiagramAggregatedFieldWells;

            public Builder sankeyDiagramAggregatedFieldWells(IResolvable sankeyDiagramAggregatedFieldWells) {
                this.sankeyDiagramAggregatedFieldWells = sankeyDiagramAggregatedFieldWells;
                return this;
            }

            public Builder sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWellsProperty sankeyDiagramAggregatedFieldWells) {
                this.sankeyDiagramAggregatedFieldWells = sankeyDiagramAggregatedFieldWells;
                return this;
            }

            public SankeyDiagramFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SankeyDiagramChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SankeyDiagramChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SankeyDiagramChartConfigurationProperty> {
            Object dataLabels;
            Object fieldWells;
            Object sortConfiguration;

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(SankeyDiagramFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(SankeyDiagramSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public SankeyDiagramChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SankeyDiagramAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SankeyDiagramAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public Object getSource() {
            return null;
        }

        @Nullable
        default public Object getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SankeyDiagramAggregatedFieldWellsProperty> {
            Object destination;
            Object source;
            Object weight;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(List<? extends Object> destination) {
                this.destination = destination;
                return this;
            }

            public Builder source(IResolvable source) {
                this.source = source;
                return this;
            }

            public Builder source(List<? extends Object> source) {
                this.source = source;
                return this;
            }

            public Builder weight(IResolvable weight) {
                this.weight = weight;
                return this;
            }

            public Builder weight(List<? extends Object> weight) {
                this.weight = weight;
                return this;
            }

            public SankeyDiagramAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SameSheetTargetVisualConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTargetVisualOptions() {
            return null;
        }

        @Nullable
        default public List<String> getTargetVisuals() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SameSheetTargetVisualConfigurationProperty> {
            String targetVisualOptions;
            List<String> targetVisuals;

            public Builder targetVisualOptions(String targetVisualOptions) {
                this.targetVisualOptions = targetVisualOptions;
                return this;
            }

            public Builder targetVisuals(List<String> targetVisuals) {
                this.targetVisuals = targetVisuals;
                return this;
            }

            public SameSheetTargetVisualConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RowAlternateColorOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RowAlternateColorOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getRowAlternateColors() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RowAlternateColorOptionsProperty> {
            List<String> rowAlternateColors;
            String status;

            public Builder rowAlternateColors(List<String> rowAlternateColors) {
                this.rowAlternateColors = rowAlternateColors;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public RowAlternateColorOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RollingDateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RollingDateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @Nullable
        default public String getDataSetIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RollingDateConfigurationProperty> {
            String expression;
            String dataSetIdentifier;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public RollingDateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourcePermissionProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getActions();

        @NotNull
        public String getPrincipal();

        @Nullable
        default public String getResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            List<String> actions;
            String principal;
            String resource;

            public Builder actions(List<String> actions) {
                this.actions = actions;
                return this;
            }

            public Builder principal(String principal) {
                this.principal = principal;
                return this;
            }

            public Builder resource(String resource) {
                this.resource = resource;
                return this;
            }

            public ResourcePermissionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RelativeDatesFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelativeDatesFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAnchorDateConfiguration();

        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @NotNull
        public String getNullOption();

        @NotNull
        public String getRelativeDateType();

        @NotNull
        public String getTimeGranularity();

        @Nullable
        default public Object getExcludePeriodConfiguration() {
            return null;
        }

        @Nullable
        default public String getMinimumGranularity() {
            return null;
        }

        @Nullable
        default public String getParameterName() {
            return null;
        }

        @Nullable
        default public Number getRelativeDateValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelativeDatesFilterProperty> {
            Object anchorDateConfiguration;
            Object column;
            String filterId;
            String nullOption;
            String relativeDateType;
            String timeGranularity;
            Object excludePeriodConfiguration;
            String minimumGranularity;
            String parameterName;
            Number relativeDateValue;

            public Builder anchorDateConfiguration(IResolvable anchorDateConfiguration) {
                this.anchorDateConfiguration = anchorDateConfiguration;
                return this;
            }

            public Builder anchorDateConfiguration(AnchorDateConfigurationProperty anchorDateConfiguration) {
                this.anchorDateConfiguration = anchorDateConfiguration;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder relativeDateType(String relativeDateType) {
                this.relativeDateType = relativeDateType;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public Builder excludePeriodConfiguration(IResolvable excludePeriodConfiguration) {
                this.excludePeriodConfiguration = excludePeriodConfiguration;
                return this;
            }

            public Builder excludePeriodConfiguration(ExcludePeriodConfigurationProperty excludePeriodConfiguration) {
                this.excludePeriodConfiguration = excludePeriodConfiguration;
                return this;
            }

            public Builder minimumGranularity(String minimumGranularity) {
                this.minimumGranularity = minimumGranularity;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder relativeDateValue(Number relativeDateValue) {
                this.relativeDateValue = relativeDateValue;
                return this;
            }

            public RelativeDatesFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelativeDateTimeControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDateTimeFormat() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelativeDateTimeControlDisplayOptionsProperty> {
            String dateTimeFormat;
            Object titleOptions;

            public Builder dateTimeFormat(String dateTimeFormat) {
                this.dateTimeFormat = dateTimeFormat;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public RelativeDateTimeControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineValueLabelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineValueLabelConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getRelativePosition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineValueLabelConfigurationProperty> {
            Object formatConfiguration;
            String relativePosition;

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(NumericFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder relativePosition(String relativePosition) {
                this.relativePosition = relativePosition;
                return this;
            }

            public ReferenceLineValueLabelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineStyleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineStyleConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public String getPattern() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineStyleConfigurationProperty> {
            String color;
            String pattern;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder pattern(String pattern) {
                this.pattern = pattern;
                return this;
            }

            public ReferenceLineStyleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineStaticDataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineStaticDataConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineStaticDataConfigurationProperty> {
            Number value;

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public ReferenceLineStaticDataConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDataConfiguration();

        @Nullable
        default public Object getLabelConfiguration() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        @Nullable
        default public Object getStyleConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineProperty> {
            Object dataConfiguration;
            Object labelConfiguration;
            String status;
            Object styleConfiguration;

            public Builder dataConfiguration(IResolvable dataConfiguration) {
                this.dataConfiguration = dataConfiguration;
                return this;
            }

            public Builder dataConfiguration(ReferenceLineDataConfigurationProperty dataConfiguration) {
                this.dataConfiguration = dataConfiguration;
                return this;
            }

            public Builder labelConfiguration(IResolvable labelConfiguration) {
                this.labelConfiguration = labelConfiguration;
                return this;
            }

            public Builder labelConfiguration(ReferenceLineLabelConfigurationProperty labelConfiguration) {
                this.labelConfiguration = labelConfiguration;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder styleConfiguration(IResolvable styleConfiguration) {
                this.styleConfiguration = styleConfiguration;
                return this;
            }

            public Builder styleConfiguration(ReferenceLineStyleConfigurationProperty styleConfiguration) {
                this.styleConfiguration = styleConfiguration;
                return this;
            }

            public ReferenceLineProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineLabelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineLabelConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomLabelConfiguration() {
            return null;
        }

        @Nullable
        default public String getFontColor() {
            return null;
        }

        @Nullable
        default public Object getFontConfiguration() {
            return null;
        }

        @Nullable
        default public String getHorizontalPosition() {
            return null;
        }

        @Nullable
        default public Object getValueLabelConfiguration() {
            return null;
        }

        @Nullable
        default public String getVerticalPosition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineLabelConfigurationProperty> {
            Object customLabelConfiguration;
            String fontColor;
            Object fontConfiguration;
            String horizontalPosition;
            Object valueLabelConfiguration;
            String verticalPosition;

            public Builder customLabelConfiguration(IResolvable customLabelConfiguration) {
                this.customLabelConfiguration = customLabelConfiguration;
                return this;
            }

            public Builder customLabelConfiguration(ReferenceLineCustomLabelConfigurationProperty customLabelConfiguration) {
                this.customLabelConfiguration = customLabelConfiguration;
                return this;
            }

            public Builder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder horizontalPosition(String horizontalPosition) {
                this.horizontalPosition = horizontalPosition;
                return this;
            }

            public Builder valueLabelConfiguration(IResolvable valueLabelConfiguration) {
                this.valueLabelConfiguration = valueLabelConfiguration;
                return this;
            }

            public Builder valueLabelConfiguration(ReferenceLineValueLabelConfigurationProperty valueLabelConfiguration) {
                this.valueLabelConfiguration = valueLabelConfiguration;
                return this;
            }

            public Builder verticalPosition(String verticalPosition) {
                this.verticalPosition = verticalPosition;
                return this;
            }

            public ReferenceLineLabelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineDynamicDataConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCalculation();

        @NotNull
        public Object getColumn();

        @NotNull
        public Object getMeasureAggregationFunction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineDynamicDataConfigurationProperty> {
            Object calculation;
            Object column;
            Object measureAggregationFunction;

            public Builder calculation(IResolvable calculation) {
                this.calculation = calculation;
                return this;
            }

            public Builder calculation(NumericalAggregationFunctionProperty calculation) {
                this.calculation = calculation;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder measureAggregationFunction(IResolvable measureAggregationFunction) {
                this.measureAggregationFunction = measureAggregationFunction;
                return this;
            }

            public Builder measureAggregationFunction(AggregationFunctionProperty measureAggregationFunction) {
                this.measureAggregationFunction = measureAggregationFunction;
                return this;
            }

            public ReferenceLineDynamicDataConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineDataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineDataConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAxisBinding() {
            return null;
        }

        @Nullable
        default public Object getDynamicConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStaticConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineDataConfigurationProperty> {
            String axisBinding;
            Object dynamicConfiguration;
            Object staticConfiguration;

            public Builder axisBinding(String axisBinding) {
                this.axisBinding = axisBinding;
                return this;
            }

            public Builder dynamicConfiguration(IResolvable dynamicConfiguration) {
                this.dynamicConfiguration = dynamicConfiguration;
                return this;
            }

            public Builder dynamicConfiguration(ReferenceLineDynamicDataConfigurationProperty dynamicConfiguration) {
                this.dynamicConfiguration = dynamicConfiguration;
                return this;
            }

            public Builder staticConfiguration(IResolvable staticConfiguration) {
                this.staticConfiguration = staticConfiguration;
                return this;
            }

            public Builder staticConfiguration(ReferenceLineStaticDataConfigurationProperty staticConfiguration) {
                this.staticConfiguration = staticConfiguration;
                return this;
            }

            public ReferenceLineDataConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceLineCustomLabelConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCustomLabel();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceLineCustomLabelConfigurationProperty> {
            String customLabel;

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public ReferenceLineCustomLabelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RangeEndsLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RangeEndsLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RangeEndsLabelTypeProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public RangeEndsLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(RadarChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public RadarChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getColorItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getColorSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;
            Object colorItemsLimit;
            Object colorSort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder colorItemsLimit(IResolvable colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorItemsLimit(ItemsLimitConfigurationProperty colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorSort(IResolvable colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public Builder colorSort(List<? extends Object> colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public RadarChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartSeriesSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartSeriesSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAreaStyleSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartSeriesSettingsProperty> {
            Object areaStyleSettings;

            public Builder areaStyleSettings(IResolvable areaStyleSettings) {
                this.areaStyleSettings = areaStyleSettings;
                return this;
            }

            public Builder areaStyleSettings(RadarChartAreaStyleSettingsProperty areaStyleSettings) {
                this.areaStyleSettings = areaStyleSettings;
                return this;
            }

            public RadarChartSeriesSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRadarChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartFieldWellsProperty> {
            Object radarChartAggregatedFieldWells;

            public Builder radarChartAggregatedFieldWells(IResolvable radarChartAggregatedFieldWells) {
                this.radarChartAggregatedFieldWells = radarChartAggregatedFieldWells;
                return this;
            }

            public Builder radarChartAggregatedFieldWells(RadarChartAggregatedFieldWellsProperty radarChartAggregatedFieldWells) {
                this.radarChartAggregatedFieldWells = radarChartAggregatedFieldWells;
                return this;
            }

            public RadarChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlternateBandColorsVisibility() {
            return null;
        }

        @Nullable
        default public String getAlternateBandEvenColor() {
            return null;
        }

        @Nullable
        default public String getAlternateBandOddColor() {
            return null;
        }

        @Nullable
        default public Object getBaseSeriesSettings() {
            return null;
        }

        @Nullable
        default public Object getCategoryAxis() {
            return null;
        }

        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getColorAxis() {
            return null;
        }

        @Nullable
        default public Object getColorLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public String getShape() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Number getStartAngle() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartConfigurationProperty> {
            String alternateBandColorsVisibility;
            String alternateBandEvenColor;
            String alternateBandOddColor;
            Object baseSeriesSettings;
            Object categoryAxis;
            Object categoryLabelOptions;
            Object colorAxis;
            Object colorLabelOptions;
            Object fieldWells;
            Object legend;
            String shape;
            Object sortConfiguration;
            Number startAngle;
            Object visualPalette;

            public Builder alternateBandColorsVisibility(String alternateBandColorsVisibility) {
                this.alternateBandColorsVisibility = alternateBandColorsVisibility;
                return this;
            }

            public Builder alternateBandEvenColor(String alternateBandEvenColor) {
                this.alternateBandEvenColor = alternateBandEvenColor;
                return this;
            }

            public Builder alternateBandOddColor(String alternateBandOddColor) {
                this.alternateBandOddColor = alternateBandOddColor;
                return this;
            }

            public Builder baseSeriesSettings(IResolvable baseSeriesSettings) {
                this.baseSeriesSettings = baseSeriesSettings;
                return this;
            }

            public Builder baseSeriesSettings(RadarChartSeriesSettingsProperty baseSeriesSettings) {
                this.baseSeriesSettings = baseSeriesSettings;
                return this;
            }

            public Builder categoryAxis(IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryAxis(AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder colorAxis(IResolvable colorAxis) {
                this.colorAxis = colorAxis;
                return this;
            }

            public Builder colorAxis(AxisDisplayOptionsProperty colorAxis) {
                this.colorAxis = colorAxis;
                return this;
            }

            public Builder colorLabelOptions(IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(RadarChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder shape(String shape) {
                this.shape = shape;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(RadarChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder startAngle(Number startAngle) {
                this.startAngle = startAngle;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public RadarChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartAreaStyleSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartAreaStyleSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartAreaStyleSettingsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public RadarChartAreaStyleSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.RadarChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RadarChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getColor() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RadarChartAggregatedFieldWellsProperty> {
            Object category;
            Object color;
            Object values;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder color(IResolvable color) {
                this.color = color;
                return this;
            }

            public Builder color(List<? extends Object> color) {
                this.color = color;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public RadarChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ProgressBarOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProgressBarOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProgressBarOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ProgressBarOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PredefinedHierarchyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PredefinedHierarchyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumns();

        @NotNull
        public String getHierarchyId();

        @Nullable
        default public Object getDrillDownFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PredefinedHierarchyProperty> {
            Object columns;
            String hierarchyId;
            Object drillDownFilters;

            public Builder columns(IResolvable columns) {
                this.columns = columns;
                return this;
            }

            public Builder columns(List<? extends Object> columns) {
                this.columns = columns;
                return this;
            }

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public Builder drillDownFilters(IResolvable drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public Builder drillDownFilters(List<? extends Object> drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public PredefinedHierarchyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTotalOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTotalOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public Object getMetricHeaderCellStyle() {
            return null;
        }

        @Nullable
        default public String getPlacement() {
            return null;
        }

        @Nullable
        default public String getScrollStatus() {
            return null;
        }

        @Nullable
        default public Object getTotalCellStyle() {
            return null;
        }

        @Nullable
        default public String getTotalsVisibility() {
            return null;
        }

        @Nullable
        default public Object getValueCellStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTotalOptionsProperty> {
            String customLabel;
            Object metricHeaderCellStyle;
            String placement;
            String scrollStatus;
            Object totalCellStyle;
            String totalsVisibility;
            Object valueCellStyle;

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder metricHeaderCellStyle(IResolvable metricHeaderCellStyle) {
                this.metricHeaderCellStyle = metricHeaderCellStyle;
                return this;
            }

            public Builder metricHeaderCellStyle(TableCellStyleProperty metricHeaderCellStyle) {
                this.metricHeaderCellStyle = metricHeaderCellStyle;
                return this;
            }

            public Builder placement(String placement) {
                this.placement = placement;
                return this;
            }

            public Builder scrollStatus(String scrollStatus) {
                this.scrollStatus = scrollStatus;
                return this;
            }

            public Builder totalCellStyle(IResolvable totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalCellStyle(TableCellStyleProperty totalCellStyle) {
                this.totalCellStyle = totalCellStyle;
                return this;
            }

            public Builder totalsVisibility(String totalsVisibility) {
                this.totalsVisibility = totalsVisibility;
                return this;
            }

            public Builder valueCellStyle(IResolvable valueCellStyle) {
                this.valueCellStyle = valueCellStyle;
                return this;
            }

            public Builder valueCellStyle(TableCellStyleProperty valueCellStyle) {
                this.valueCellStyle = valueCellStyle;
                return this;
            }

            public PivotTotalOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getConditionalFormatting() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object conditionalFormatting;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(PivotTableConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder conditionalFormatting(IResolvable conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder conditionalFormatting(PivotTableConditionalFormattingProperty conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public PivotTableVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableTotalOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableTotalOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumnSubtotalOptions() {
            return null;
        }

        @Nullable
        default public Object getColumnTotalOptions() {
            return null;
        }

        @Nullable
        default public Object getRowSubtotalOptions() {
            return null;
        }

        @Nullable
        default public Object getRowTotalOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableTotalOptionsProperty> {
            Object columnSubtotalOptions;
            Object columnTotalOptions;
            Object rowSubtotalOptions;
            Object rowTotalOptions;

            public Builder columnSubtotalOptions(IResolvable columnSubtotalOptions) {
                this.columnSubtotalOptions = columnSubtotalOptions;
                return this;
            }

            public Builder columnSubtotalOptions(SubtotalOptionsProperty columnSubtotalOptions) {
                this.columnSubtotalOptions = columnSubtotalOptions;
                return this;
            }

            public Builder columnTotalOptions(IResolvable columnTotalOptions) {
                this.columnTotalOptions = columnTotalOptions;
                return this;
            }

            public Builder columnTotalOptions(PivotTotalOptionsProperty columnTotalOptions) {
                this.columnTotalOptions = columnTotalOptions;
                return this;
            }

            public Builder rowSubtotalOptions(IResolvable rowSubtotalOptions) {
                this.rowSubtotalOptions = rowSubtotalOptions;
                return this;
            }

            public Builder rowSubtotalOptions(SubtotalOptionsProperty rowSubtotalOptions) {
                this.rowSubtotalOptions = rowSubtotalOptions;
                return this;
            }

            public Builder rowTotalOptions(IResolvable rowTotalOptions) {
                this.rowTotalOptions = rowTotalOptions;
                return this;
            }

            public Builder rowTotalOptions(PivotTotalOptionsProperty rowTotalOptions) {
                this.rowTotalOptions = rowTotalOptions;
                return this;
            }

            public PivotTableTotalOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldSortOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableSortConfigurationProperty> {
            Object fieldSortOptions;

            public Builder fieldSortOptions(IResolvable fieldSortOptions) {
                this.fieldSortOptions = fieldSortOptions;
                return this;
            }

            public Builder fieldSortOptions(List<? extends Object> fieldSortOptions) {
                this.fieldSortOptions = fieldSortOptions;
                return this;
            }

            public PivotTableSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableSortByProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableSortByProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumn() {
            return null;
        }

        @Nullable
        default public Object getDataPath() {
            return null;
        }

        @Nullable
        default public Object getField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableSortByProperty> {
            Object column;
            Object dataPath;
            Object field;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnSortProperty column) {
                this.column = column;
                return this;
            }

            public Builder dataPath(IResolvable dataPath) {
                this.dataPath = dataPath;
                return this;
            }

            public Builder dataPath(DataPathSortProperty dataPath) {
                this.dataPath = dataPath;
                return this;
            }

            public Builder field(IResolvable field) {
                this.field = field;
                return this;
            }

            public Builder field(FieldSortProperty field) {
                this.field = field;
                return this;
            }

            public PivotTableSortByProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTablePaginatedReportOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTablePaginatedReportOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOverflowColumnHeaderVisibility() {
            return null;
        }

        @Nullable
        default public String getVerticalOverflowVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTablePaginatedReportOptionsProperty> {
            String overflowColumnHeaderVisibility;
            String verticalOverflowVisibility;

            public Builder overflowColumnHeaderVisibility(String overflowColumnHeaderVisibility) {
                this.overflowColumnHeaderVisibility = overflowColumnHeaderVisibility;
                return this;
            }

            public Builder verticalOverflowVisibility(String verticalOverflowVisibility) {
                this.verticalOverflowVisibility = verticalOverflowVisibility;
                return this;
            }

            public PivotTablePaginatedReportOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCellStyle() {
            return null;
        }

        @Nullable
        default public Object getColumnHeaderStyle() {
            return null;
        }

        @Nullable
        default public String getColumnNamesVisibility() {
            return null;
        }

        @Nullable
        default public String getMetricPlacement() {
            return null;
        }

        @Nullable
        default public Object getRowAlternateColorOptions() {
            return null;
        }

        @Nullable
        default public Object getRowFieldNamesStyle() {
            return null;
        }

        @Nullable
        default public Object getRowHeaderStyle() {
            return null;
        }

        @Nullable
        default public String getSingleMetricVisibility() {
            return null;
        }

        @Nullable
        default public String getToggleButtonsVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableOptionsProperty> {
            Object cellStyle;
            Object columnHeaderStyle;
            String columnNamesVisibility;
            String metricPlacement;
            Object rowAlternateColorOptions;
            Object rowFieldNamesStyle;
            Object rowHeaderStyle;
            String singleMetricVisibility;
            String toggleButtonsVisibility;

            public Builder cellStyle(IResolvable cellStyle) {
                this.cellStyle = cellStyle;
                return this;
            }

            public Builder cellStyle(TableCellStyleProperty cellStyle) {
                this.cellStyle = cellStyle;
                return this;
            }

            public Builder columnHeaderStyle(IResolvable columnHeaderStyle) {
                this.columnHeaderStyle = columnHeaderStyle;
                return this;
            }

            public Builder columnHeaderStyle(TableCellStyleProperty columnHeaderStyle) {
                this.columnHeaderStyle = columnHeaderStyle;
                return this;
            }

            public Builder columnNamesVisibility(String columnNamesVisibility) {
                this.columnNamesVisibility = columnNamesVisibility;
                return this;
            }

            public Builder metricPlacement(String metricPlacement) {
                this.metricPlacement = metricPlacement;
                return this;
            }

            public Builder rowAlternateColorOptions(IResolvable rowAlternateColorOptions) {
                this.rowAlternateColorOptions = rowAlternateColorOptions;
                return this;
            }

            public Builder rowAlternateColorOptions(RowAlternateColorOptionsProperty rowAlternateColorOptions) {
                this.rowAlternateColorOptions = rowAlternateColorOptions;
                return this;
            }

            public Builder rowFieldNamesStyle(IResolvable rowFieldNamesStyle) {
                this.rowFieldNamesStyle = rowFieldNamesStyle;
                return this;
            }

            public Builder rowFieldNamesStyle(TableCellStyleProperty rowFieldNamesStyle) {
                this.rowFieldNamesStyle = rowFieldNamesStyle;
                return this;
            }

            public Builder rowHeaderStyle(IResolvable rowHeaderStyle) {
                this.rowHeaderStyle = rowHeaderStyle;
                return this;
            }

            public Builder rowHeaderStyle(TableCellStyleProperty rowHeaderStyle) {
                this.rowHeaderStyle = rowHeaderStyle;
                return this;
            }

            public Builder singleMetricVisibility(String singleMetricVisibility) {
                this.singleMetricVisibility = singleMetricVisibility;
                return this;
            }

            public Builder toggleButtonsVisibility(String toggleButtonsVisibility) {
                this.toggleButtonsVisibility = toggleButtonsVisibility;
                return this;
            }

            public PivotTableOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPivotTableAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableFieldWellsProperty> {
            Object pivotTableAggregatedFieldWells;

            public Builder pivotTableAggregatedFieldWells(IResolvable pivotTableAggregatedFieldWells) {
                this.pivotTableAggregatedFieldWells = pivotTableAggregatedFieldWells;
                return this;
            }

            public Builder pivotTableAggregatedFieldWells(PivotTableAggregatedFieldWellsProperty pivotTableAggregatedFieldWells) {
                this.pivotTableAggregatedFieldWells = pivotTableAggregatedFieldWells;
                return this;
            }

            public PivotTableFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableFieldSubtotalOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableFieldSubtotalOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFieldId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableFieldSubtotalOptionsProperty> {
            String fieldId;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public PivotTableFieldSubtotalOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableFieldOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableFieldOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataPathOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectedFieldOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableFieldOptionsProperty> {
            Object dataPathOptions;
            Object selectedFieldOptions;

            public Builder dataPathOptions(IResolvable dataPathOptions) {
                this.dataPathOptions = dataPathOptions;
                return this;
            }

            public Builder dataPathOptions(List<? extends Object> dataPathOptions) {
                this.dataPathOptions = dataPathOptions;
                return this;
            }

            public Builder selectedFieldOptions(IResolvable selectedFieldOptions) {
                this.selectedFieldOptions = selectedFieldOptions;
                return this;
            }

            public Builder selectedFieldOptions(List<? extends Object> selectedFieldOptions) {
                this.selectedFieldOptions = selectedFieldOptions;
                return this;
            }

            public PivotTableFieldOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableFieldOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableFieldOptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableFieldOptionProperty> {
            String fieldId;
            String customLabel;
            String visibility;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public PivotTableFieldOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableDataPathOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableDataPathOptionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDataPathList();

        @Nullable
        default public String getWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableDataPathOptionProperty> {
            Object dataPathList;
            String width;

            public Builder dataPathList(IResolvable dataPathList) {
                this.dataPathList = dataPathList;
                return this;
            }

            public Builder dataPathList(List<? extends Object> dataPathList) {
                this.dataPathList = dataPathList;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public PivotTableDataPathOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getPaginatedReportOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTableOptions() {
            return null;
        }

        @Nullable
        default public Object getTotalOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableConfigurationProperty> {
            Object fieldOptions;
            Object fieldWells;
            Object paginatedReportOptions;
            Object sortConfiguration;
            Object tableOptions;
            Object totalOptions;

            public Builder fieldOptions(IResolvable fieldOptions) {
                this.fieldOptions = fieldOptions;
                return this;
            }

            public Builder fieldOptions(PivotTableFieldOptionsProperty fieldOptions) {
                this.fieldOptions = fieldOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(PivotTableFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder paginatedReportOptions(IResolvable paginatedReportOptions) {
                this.paginatedReportOptions = paginatedReportOptions;
                return this;
            }

            public Builder paginatedReportOptions(PivotTablePaginatedReportOptionsProperty paginatedReportOptions) {
                this.paginatedReportOptions = paginatedReportOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(PivotTableSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tableOptions(IResolvable tableOptions) {
                this.tableOptions = tableOptions;
                return this;
            }

            public Builder tableOptions(PivotTableOptionsProperty tableOptions) {
                this.tableOptions = tableOptions;
                return this;
            }

            public Builder totalOptions(IResolvable totalOptions) {
                this.totalOptions = totalOptions;
                return this;
            }

            public Builder totalOptions(PivotTableTotalOptionsProperty totalOptions) {
                this.totalOptions = totalOptions;
                return this;
            }

            public PivotTableConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableConditionalFormattingScopeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableConditionalFormattingScopeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRole() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableConditionalFormattingScopeProperty> {
            String role;

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public PivotTableConditionalFormattingScopeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditionalFormattingOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableConditionalFormattingProperty> {
            Object conditionalFormattingOptions;

            public Builder conditionalFormattingOptions(IResolvable conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public Builder conditionalFormattingOptions(List<? extends Object> conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public PivotTableConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableConditionalFormattingOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableConditionalFormattingOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCell() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableConditionalFormattingOptionProperty> {
            Object cell;

            public Builder cell(IResolvable cell) {
                this.cell = cell;
                return this;
            }

            public Builder cell(PivotTableCellConditionalFormattingProperty cell) {
                this.cell = cell;
                return this;
            }

            public PivotTableConditionalFormattingOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableCellConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableCellConditionalFormattingProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getScope() {
            return null;
        }

        @Nullable
        default public Object getTextFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableCellConditionalFormattingProperty> {
            String fieldId;
            Object scope;
            Object textFormat;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder scope(IResolvable scope) {
                this.scope = scope;
                return this;
            }

            public Builder scope(PivotTableConditionalFormattingScopeProperty scope) {
                this.scope = scope;
                return this;
            }

            public Builder textFormat(IResolvable textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            public Builder textFormat(TextConditionalFormatProperty textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            public PivotTableCellConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotTableAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotTableAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumns() {
            return null;
        }

        @Nullable
        default public Object getRows() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotTableAggregatedFieldWellsProperty> {
            Object columns;
            Object rows;
            Object values;

            public Builder columns(IResolvable columns) {
                this.columns = columns;
                return this;
            }

            public Builder columns(List<? extends Object> columns) {
                this.columns = columns;
                return this;
            }

            public Builder rows(IResolvable rows) {
                this.rows = rows;
                return this;
            }

            public Builder rows(List<? extends Object> rows) {
                this.rows = rows;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public PivotTableAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PivotFieldSortOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PivotFieldSortOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @NotNull
        public Object getSortBy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PivotFieldSortOptionsProperty> {
            String fieldId;
            Object sortBy;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder sortBy(IResolvable sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            public Builder sortBy(PivotTableSortByProperty sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            public PivotFieldSortOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PieChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PieChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PieChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(PieChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public PieChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PieChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PieChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PieChartSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;
            Object smallMultiplesLimitConfiguration;
            Object smallMultiplesSort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(IResolvable smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesSort(IResolvable smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public Builder smallMultiplesSort(List<? extends Object> smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public PieChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PieChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PieChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPieChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PieChartFieldWellsProperty> {
            Object pieChartAggregatedFieldWells;

            public Builder pieChartAggregatedFieldWells(IResolvable pieChartAggregatedFieldWells) {
                this.pieChartAggregatedFieldWells = pieChartAggregatedFieldWells;
                return this;
            }

            public Builder pieChartAggregatedFieldWells(PieChartAggregatedFieldWellsProperty pieChartAggregatedFieldWells) {
                this.pieChartAggregatedFieldWells = pieChartAggregatedFieldWells;
                return this;
            }

            public PieChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PieChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PieChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getContributionAnalysisDefaults() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getDonutOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getValueLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PieChartConfigurationProperty> {
            Object categoryLabelOptions;
            Object contributionAnalysisDefaults;
            Object dataLabels;
            Object donutOptions;
            Object fieldWells;
            Object legend;
            Object smallMultiplesOptions;
            Object sortConfiguration;
            Object tooltip;
            Object valueLabelOptions;
            Object visualPalette;

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder contributionAnalysisDefaults(IResolvable contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder contributionAnalysisDefaults(List<? extends Object> contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder donutOptions(IResolvable donutOptions) {
                this.donutOptions = donutOptions;
                return this;
            }

            public Builder donutOptions(DonutOptionsProperty donutOptions) {
                this.donutOptions = donutOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(PieChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder smallMultiplesOptions(IResolvable smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder smallMultiplesOptions(SmallMultiplesOptionsProperty smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(PieChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder valueLabelOptions(IResolvable valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder valueLabelOptions(ChartAxisLabelOptionsProperty valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public PieChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PieChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PieChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiples() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PieChartAggregatedFieldWellsProperty> {
            Object category;
            Object smallMultiples;
            Object values;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder smallMultiples(IResolvable smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder smallMultiples(List<? extends Object> smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public PieChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PeriodToDateComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PeriodToDateComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getPeriodTimeGranularity() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PeriodToDateComputationProperty> {
            String computationId;
            Object time;
            String name;
            String periodTimeGranularity;
            Object value;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder periodTimeGranularity(String periodTimeGranularity) {
                this.periodTimeGranularity = periodTimeGranularity;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public PeriodToDateComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PeriodOverPeriodComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PeriodOverPeriodComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PeriodOverPeriodComputationProperty> {
            String computationId;
            Object time;
            String name;
            Object value;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public PeriodOverPeriodComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PercentileAggregationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PercentileAggregationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getPercentileValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PercentileAggregationProperty> {
            Number percentileValue;

            public Builder percentileValue(Number percentileValue) {
                this.percentileValue = percentileValue;
                return this;
            }

            public PercentileAggregationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PercentageDisplayFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDecimalPlacesConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNegativeValueConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNullValueFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getSeparatorConfiguration() {
            return null;
        }

        @Nullable
        default public String getSuffix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PercentageDisplayFormatConfigurationProperty> {
            Object decimalPlacesConfiguration;
            Object negativeValueConfiguration;
            Object nullValueFormatConfiguration;
            String prefix;
            Object separatorConfiguration;
            String suffix;

            public Builder decimalPlacesConfiguration(IResolvable decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder decimalPlacesConfiguration(DecimalPlacesConfigurationProperty decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(IResolvable negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(NegativeValueConfigurationProperty negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(IResolvable nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(NullValueFormatConfigurationProperty nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder separatorConfiguration(IResolvable separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder separatorConfiguration(NumericSeparatorConfigurationProperty separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder suffix(String suffix) {
                this.suffix = suffix;
                return this;
            }

            public PercentageDisplayFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PercentVisibleRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PercentVisibleRangeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFrom() {
            return null;
        }

        @Nullable
        default public Number getTo() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PercentVisibleRangeProperty> {
            Number from;
            Number to;

            public Builder from(Number from) {
                this.from = from;
                return this;
            }

            public Builder to(Number to) {
                this.to = to;
                return this;
            }

            public PercentVisibleRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimeParameters() {
            return null;
        }

        @Nullable
        default public Object getDecimalParameters() {
            return null;
        }

        @Nullable
        default public Object getIntegerParameters() {
            return null;
        }

        @Nullable
        default public Object getStringParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParametersProperty> {
            Object dateTimeParameters;
            Object decimalParameters;
            Object integerParameters;
            Object stringParameters;

            public Builder dateTimeParameters(IResolvable dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            public Builder dateTimeParameters(List<? extends Object> dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            public Builder decimalParameters(IResolvable decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            public Builder decimalParameters(List<? extends Object> decimalParameters) {
                this.decimalParameters = decimalParameters;
                return this;
            }

            public Builder integerParameters(IResolvable integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            public Builder integerParameters(List<? extends Object> integerParameters) {
                this.integerParameters = integerParameters;
                return this;
            }

            public Builder stringParameters(IResolvable stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            public Builder stringParameters(List<? extends Object> stringParameters) {
                this.stringParameters = stringParameters;
                return this;
            }

            public ParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterTextFieldControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterTextFieldControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterTextFieldControlProperty> {
            String parameterControlId;
            String sourceParameterName;
            String title;
            Object displayOptions;

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(TextFieldControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public ParameterTextFieldControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterTextAreaControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterTextAreaControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public String getTitle();

        @Nullable
        default public String getDelimiter() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterTextAreaControlProperty> {
            String parameterControlId;
            String sourceParameterName;
            String title;
            String delimiter;
            Object displayOptions;

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder delimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(TextAreaControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public ParameterTextAreaControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterSliderControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterSliderControlProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaximumValue();

        @NotNull
        public Number getMinimumValue();

        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public Number getStepSize();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterSliderControlProperty> {
            Number maximumValue;
            Number minimumValue;
            String parameterControlId;
            String sourceParameterName;
            Number stepSize;
            String title;
            Object displayOptions;

            public Builder maximumValue(Number maximumValue) {
                this.maximumValue = maximumValue;
                return this;
            }

            public Builder minimumValue(Number minimumValue) {
                this.minimumValue = minimumValue;
                return this;
            }

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder stepSize(Number stepSize) {
                this.stepSize = stepSize;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(SliderControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public ParameterSliderControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterSelectableValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterSelectableValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLinkToDataSetColumn() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterSelectableValuesProperty> {
            Object linkToDataSetColumn;
            List<String> values;

            public Builder linkToDataSetColumn(IResolvable linkToDataSetColumn) {
                this.linkToDataSetColumn = linkToDataSetColumn;
                return this;
            }

            public Builder linkToDataSetColumn(ColumnIdentifierProperty linkToDataSetColumn) {
                this.linkToDataSetColumn = linkToDataSetColumn;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public ParameterSelectableValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterListControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterListControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getCascadingControlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectableValues() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterListControlProperty> {
            String parameterControlId;
            String sourceParameterName;
            String title;
            Object cascadingControlConfiguration;
            Object displayOptions;
            Object selectableValues;
            String type;

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder cascadingControlConfiguration(IResolvable cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder cascadingControlConfiguration(CascadingControlConfigurationProperty cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(ListControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder selectableValues(IResolvable selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder selectableValues(ParameterSelectableValuesProperty selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ParameterListControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterDropDownControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterDropDownControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getCascadingControlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectableValues() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterDropDownControlProperty> {
            String parameterControlId;
            String sourceParameterName;
            String title;
            Object cascadingControlConfiguration;
            Object displayOptions;
            Object selectableValues;
            String type;

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder cascadingControlConfiguration(IResolvable cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder cascadingControlConfiguration(CascadingControlConfigurationProperty cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(DropDownControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder selectableValues(IResolvable selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder selectableValues(ParameterSelectableValuesProperty selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ParameterDropDownControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterDeclarationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimeParameterDeclaration() {
            return null;
        }

        @Nullable
        default public Object getDecimalParameterDeclaration() {
            return null;
        }

        @Nullable
        default public Object getIntegerParameterDeclaration() {
            return null;
        }

        @Nullable
        default public Object getStringParameterDeclaration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterDeclarationProperty> {
            Object dateTimeParameterDeclaration;
            Object decimalParameterDeclaration;
            Object integerParameterDeclaration;
            Object stringParameterDeclaration;

            public Builder dateTimeParameterDeclaration(IResolvable dateTimeParameterDeclaration) {
                this.dateTimeParameterDeclaration = dateTimeParameterDeclaration;
                return this;
            }

            public Builder dateTimeParameterDeclaration(DateTimeParameterDeclarationProperty dateTimeParameterDeclaration) {
                this.dateTimeParameterDeclaration = dateTimeParameterDeclaration;
                return this;
            }

            public Builder decimalParameterDeclaration(IResolvable decimalParameterDeclaration) {
                this.decimalParameterDeclaration = decimalParameterDeclaration;
                return this;
            }

            public Builder decimalParameterDeclaration(DecimalParameterDeclarationProperty decimalParameterDeclaration) {
                this.decimalParameterDeclaration = decimalParameterDeclaration;
                return this;
            }

            public Builder integerParameterDeclaration(IResolvable integerParameterDeclaration) {
                this.integerParameterDeclaration = integerParameterDeclaration;
                return this;
            }

            public Builder integerParameterDeclaration(IntegerParameterDeclarationProperty integerParameterDeclaration) {
                this.integerParameterDeclaration = integerParameterDeclaration;
                return this;
            }

            public Builder stringParameterDeclaration(IResolvable stringParameterDeclaration) {
                this.stringParameterDeclaration = stringParameterDeclaration;
                return this;
            }

            public Builder stringParameterDeclaration(StringParameterDeclarationProperty stringParameterDeclaration) {
                this.stringParameterDeclaration = stringParameterDeclaration;
                return this;
            }

            public ParameterDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterDateTimePickerControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterDateTimePickerControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterControlId();

        @NotNull
        public String getSourceParameterName();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterDateTimePickerControlProperty> {
            String parameterControlId;
            String sourceParameterName;
            String title;
            Object displayOptions;

            public Builder parameterControlId(String parameterControlId) {
                this.parameterControlId = parameterControlId;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(DateTimePickerControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public ParameterDateTimePickerControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ParameterControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterControlProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimePicker() {
            return null;
        }

        @Nullable
        default public Object getDropdown() {
            return null;
        }

        @Nullable
        default public Object getList() {
            return null;
        }

        @Nullable
        default public Object getSlider() {
            return null;
        }

        @Nullable
        default public Object getTextArea() {
            return null;
        }

        @Nullable
        default public Object getTextField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterControlProperty> {
            Object dateTimePicker;
            Object dropdown;
            Object list;
            Object slider;
            Object textArea;
            Object textField;

            public Builder dateTimePicker(IResolvable dateTimePicker) {
                this.dateTimePicker = dateTimePicker;
                return this;
            }

            public Builder dateTimePicker(ParameterDateTimePickerControlProperty dateTimePicker) {
                this.dateTimePicker = dateTimePicker;
                return this;
            }

            public Builder dropdown(IResolvable dropdown) {
                this.dropdown = dropdown;
                return this;
            }

            public Builder dropdown(ParameterDropDownControlProperty dropdown) {
                this.dropdown = dropdown;
                return this;
            }

            public Builder list(IResolvable list) {
                this.list = list;
                return this;
            }

            public Builder list(ParameterListControlProperty list) {
                this.list = list;
                return this;
            }

            public Builder slider(IResolvable slider) {
                this.slider = slider;
                return this;
            }

            public Builder slider(ParameterSliderControlProperty slider) {
                this.slider = slider;
                return this;
            }

            public Builder textArea(IResolvable textArea) {
                this.textArea = textArea;
                return this;
            }

            public Builder textArea(ParameterTextAreaControlProperty textArea) {
                this.textArea = textArea;
                return this;
            }

            public Builder textField(IResolvable textField) {
                this.textField = textField;
                return this;
            }

            public Builder textField(ParameterTextFieldControlProperty textField) {
                this.textField = textField;
                return this;
            }

            public ParameterControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PanelTitleOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PanelTitleOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFontConfiguration() {
            return null;
        }

        @Nullable
        default public String getHorizontalTextAlignment() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PanelTitleOptionsProperty> {
            Object fontConfiguration;
            String horizontalTextAlignment;
            String visibility;

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder horizontalTextAlignment(String horizontalTextAlignment) {
                this.horizontalTextAlignment = horizontalTextAlignment;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public PanelTitleOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PanelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PanelConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public String getBackgroundVisibility() {
            return null;
        }

        @Nullable
        default public String getBorderColor() {
            return null;
        }

        @Nullable
        default public String getBorderStyle() {
            return null;
        }

        @Nullable
        default public String getBorderThickness() {
            return null;
        }

        @Nullable
        default public String getBorderVisibility() {
            return null;
        }

        @Nullable
        default public String getGutterSpacing() {
            return null;
        }

        @Nullable
        default public String getGutterVisibility() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PanelConfigurationProperty> {
            String backgroundColor;
            String backgroundVisibility;
            String borderColor;
            String borderStyle;
            String borderThickness;
            String borderVisibility;
            String gutterSpacing;
            String gutterVisibility;
            Object title;

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundVisibility(String backgroundVisibility) {
                this.backgroundVisibility = backgroundVisibility;
                return this;
            }

            public Builder borderColor(String borderColor) {
                this.borderColor = borderColor;
                return this;
            }

            public Builder borderStyle(String borderStyle) {
                this.borderStyle = borderStyle;
                return this;
            }

            public Builder borderThickness(String borderThickness) {
                this.borderThickness = borderThickness;
                return this;
            }

            public Builder borderVisibility(String borderVisibility) {
                this.borderVisibility = borderVisibility;
                return this;
            }

            public Builder gutterSpacing(String gutterSpacing) {
                this.gutterSpacing = gutterSpacing;
                return this;
            }

            public Builder gutterVisibility(String gutterVisibility) {
                this.gutterVisibility = gutterVisibility;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(PanelTitleOptionsProperty title) {
                this.title = title;
                return this;
            }

            public PanelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.PaginationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PaginationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPageNumber();

        @NotNull
        public Number getPageSize();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PaginationConfigurationProperty> {
            Number pageNumber;
            Number pageSize;

            public Builder pageNumber(Number pageNumber) {
                this.pageNumber = pageNumber;
                return this;
            }

            public Builder pageSize(Number pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public PaginationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericalMeasureFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericalMeasureFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getAggregationFunction() {
            return null;
        }

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericalMeasureFieldProperty> {
            Object column;
            String fieldId;
            Object aggregationFunction;
            Object formatConfiguration;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder aggregationFunction(IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder aggregationFunction(NumericalAggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(NumberFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public NumericalMeasureFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericalDimensionFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericalDimensionFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getHierarchyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericalDimensionFieldProperty> {
            Object column;
            String fieldId;
            Object formatConfiguration;
            String hierarchyId;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(NumberFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public NumericalDimensionFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericalAggregationFunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericalAggregationFunctionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPercentileAggregation() {
            return null;
        }

        @Nullable
        default public String getSimpleNumericalAggregation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericalAggregationFunctionProperty> {
            Object percentileAggregation;
            String simpleNumericalAggregation;

            public Builder percentileAggregation(IResolvable percentileAggregation) {
                this.percentileAggregation = percentileAggregation;
                return this;
            }

            public Builder percentileAggregation(PercentileAggregationProperty percentileAggregation) {
                this.percentileAggregation = percentileAggregation;
                return this;
            }

            public Builder simpleNumericalAggregation(String simpleNumericalAggregation) {
                this.simpleNumericalAggregation = simpleNumericalAggregation;
                return this;
            }

            public NumericalAggregationFunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericSeparatorConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDecimalSeparator() {
            return null;
        }

        @Nullable
        default public Object getThousandsSeparator() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericSeparatorConfigurationProperty> {
            String decimalSeparator;
            Object thousandsSeparator;

            public Builder decimalSeparator(String decimalSeparator) {
                this.decimalSeparator = decimalSeparator;
                return this;
            }

            public Builder thousandsSeparator(IResolvable thousandsSeparator) {
                this.thousandsSeparator = thousandsSeparator;
                return this;
            }

            public Builder thousandsSeparator(ThousandSeparatorOptionsProperty thousandsSeparator) {
                this.thousandsSeparator = thousandsSeparator;
                return this;
            }

            public NumericSeparatorConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericRangeFilterValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericRangeFilterValueProperty
    extends JsiiSerializable {
        @Nullable
        default public String getParameter() {
            return null;
        }

        @Nullable
        default public Number getStaticValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericRangeFilterValueProperty> {
            String parameter;
            Number staticValue;

            public Builder parameter(String parameter) {
                this.parameter = parameter;
                return this;
            }

            public Builder staticValue(Number staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            public NumericRangeFilterValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericRangeFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericRangeFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @NotNull
        public String getNullOption();

        @Nullable
        default public Object getAggregationFunction() {
            return null;
        }

        @Nullable
        default public Object getIncludeMaximum() {
            return null;
        }

        @Nullable
        default public Object getIncludeMinimum() {
            return null;
        }

        @Nullable
        default public Object getRangeMaximum() {
            return null;
        }

        @Nullable
        default public Object getRangeMinimum() {
            return null;
        }

        @Nullable
        default public String getSelectAllOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericRangeFilterProperty> {
            Object column;
            String filterId;
            String nullOption;
            Object aggregationFunction;
            Object includeMaximum;
            Object includeMinimum;
            Object rangeMaximum;
            Object rangeMinimum;
            String selectAllOptions;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder aggregationFunction(IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder aggregationFunction(AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder includeMaximum(Boolean includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            public Builder includeMaximum(IResolvable includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            public Builder includeMinimum(Boolean includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            public Builder includeMinimum(IResolvable includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            public Builder rangeMaximum(IResolvable rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            public Builder rangeMaximum(NumericRangeFilterValueProperty rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            public Builder rangeMinimum(IResolvable rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            public Builder rangeMinimum(NumericRangeFilterValueProperty rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            public Builder selectAllOptions(String selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public NumericRangeFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCurrencyDisplayFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNumberDisplayFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPercentageDisplayFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericFormatConfigurationProperty> {
            Object currencyDisplayFormatConfiguration;
            Object numberDisplayFormatConfiguration;
            Object percentageDisplayFormatConfiguration;

            public Builder currencyDisplayFormatConfiguration(IResolvable currencyDisplayFormatConfiguration) {
                this.currencyDisplayFormatConfiguration = currencyDisplayFormatConfiguration;
                return this;
            }

            public Builder currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty currencyDisplayFormatConfiguration) {
                this.currencyDisplayFormatConfiguration = currencyDisplayFormatConfiguration;
                return this;
            }

            public Builder numberDisplayFormatConfiguration(IResolvable numberDisplayFormatConfiguration) {
                this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
                return this;
            }

            public Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty numberDisplayFormatConfiguration) {
                this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
                return this;
            }

            public Builder percentageDisplayFormatConfiguration(IResolvable percentageDisplayFormatConfiguration) {
                this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
                return this;
            }

            public Builder percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty percentageDisplayFormatConfiguration) {
                this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
                return this;
            }

            public NumericFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericEqualityFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericEqualityFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFilterId();

        @NotNull
        public String getMatchOperator();

        @NotNull
        public String getNullOption();

        @Nullable
        default public Object getAggregationFunction() {
            return null;
        }

        @Nullable
        default public String getParameterName() {
            return null;
        }

        @Nullable
        default public String getSelectAllOptions() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericEqualityFilterProperty> {
            Object column;
            String filterId;
            String matchOperator;
            String nullOption;
            Object aggregationFunction;
            String parameterName;
            String selectAllOptions;
            Number value;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public Builder matchOperator(String matchOperator) {
                this.matchOperator = matchOperator;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder aggregationFunction(IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder aggregationFunction(AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder selectAllOptions(String selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public NumericEqualityFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericEqualityDrillDownFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericEqualityDrillDownFilterProperty> {
            Object column;
            Number value;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public NumericEqualityDrillDownFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumericAxisOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumericAxisOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRange() {
            return null;
        }

        @Nullable
        default public Object getScale() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumericAxisOptionsProperty> {
            Object range;
            Object scale;

            public Builder range(IResolvable range) {
                this.range = range;
                return this;
            }

            public Builder range(AxisDisplayRangeProperty range) {
                this.range = range;
                return this;
            }

            public Builder scale(IResolvable scale) {
                this.scale = scale;
                return this;
            }

            public Builder scale(AxisScaleProperty scale) {
                this.scale = scale;
                return this;
            }

            public NumericAxisOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumberFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumberFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumberFormatConfigurationProperty> {
            Object formatConfiguration;

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(NumericFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public NumberFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumberDisplayFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDecimalPlacesConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNegativeValueConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNullValueFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getNumberScale() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getSeparatorConfiguration() {
            return null;
        }

        @Nullable
        default public String getSuffix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumberDisplayFormatConfigurationProperty> {
            Object decimalPlacesConfiguration;
            Object negativeValueConfiguration;
            Object nullValueFormatConfiguration;
            String numberScale;
            String prefix;
            Object separatorConfiguration;
            String suffix;

            public Builder decimalPlacesConfiguration(IResolvable decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder decimalPlacesConfiguration(DecimalPlacesConfigurationProperty decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(IResolvable negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(NegativeValueConfigurationProperty negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(IResolvable nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(NullValueFormatConfigurationProperty nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder numberScale(String numberScale) {
                this.numberScale = numberScale;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder separatorConfiguration(IResolvable separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder separatorConfiguration(NumericSeparatorConfigurationProperty separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder suffix(String suffix) {
                this.suffix = suffix;
                return this;
            }

            public NumberDisplayFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NullValueFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NullValueFormatConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getNullString();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NullValueFormatConfigurationProperty> {
            String nullString;

            public Builder nullString(String nullString) {
                this.nullString = nullString;
                return this;
            }

            public NullValueFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.NegativeValueConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NegativeValueConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDisplayMode();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NegativeValueConfigurationProperty> {
            String displayMode;

            public Builder displayMode(String displayMode) {
                this.displayMode = displayMode;
                return this;
            }

            public NegativeValueConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MissingDataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MissingDataConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTreatmentOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MissingDataConfigurationProperty> {
            String treatmentOption;

            public Builder treatmentOption(String treatmentOption) {
                this.treatmentOption = treatmentOption;
                return this;
            }

            public MissingDataConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MinimumLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MinimumLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MinimumLabelTypeProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public MinimumLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MetricComparisonComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricComparisonComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getFromValue();

        @NotNull
        public Object getTargetValue();

        @NotNull
        public Object getTime();

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricComparisonComputationProperty> {
            String computationId;
            Object fromValue;
            Object targetValue;
            Object time;
            String name;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder fromValue(IResolvable fromValue) {
                this.fromValue = fromValue;
                return this;
            }

            public Builder fromValue(MeasureFieldProperty fromValue) {
                this.fromValue = fromValue;
                return this;
            }

            public Builder targetValue(IResolvable targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            public Builder targetValue(MeasureFieldProperty targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public MetricComparisonComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MeasureFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MeasureFieldProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCalculatedMeasureField() {
            return null;
        }

        @Nullable
        default public Object getCategoricalMeasureField() {
            return null;
        }

        @Nullable
        default public Object getDateMeasureField() {
            return null;
        }

        @Nullable
        default public Object getNumericalMeasureField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MeasureFieldProperty> {
            Object calculatedMeasureField;
            Object categoricalMeasureField;
            Object dateMeasureField;
            Object numericalMeasureField;

            public Builder calculatedMeasureField(IResolvable calculatedMeasureField) {
                this.calculatedMeasureField = calculatedMeasureField;
                return this;
            }

            public Builder calculatedMeasureField(CalculatedMeasureFieldProperty calculatedMeasureField) {
                this.calculatedMeasureField = calculatedMeasureField;
                return this;
            }

            public Builder categoricalMeasureField(IResolvable categoricalMeasureField) {
                this.categoricalMeasureField = categoricalMeasureField;
                return this;
            }

            public Builder categoricalMeasureField(CategoricalMeasureFieldProperty categoricalMeasureField) {
                this.categoricalMeasureField = categoricalMeasureField;
                return this;
            }

            public Builder dateMeasureField(IResolvable dateMeasureField) {
                this.dateMeasureField = dateMeasureField;
                return this;
            }

            public Builder dateMeasureField(DateMeasureFieldProperty dateMeasureField) {
                this.dateMeasureField = dateMeasureField;
                return this;
            }

            public Builder numericalMeasureField(IResolvable numericalMeasureField) {
                this.numericalMeasureField = numericalMeasureField;
                return this;
            }

            public Builder numericalMeasureField(NumericalMeasureFieldProperty numericalMeasureField) {
                this.numericalMeasureField = numericalMeasureField;
                return this;
            }

            public MeasureFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MaximumMinimumComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MaximumMinimumComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @NotNull
        public String getType();

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MaximumMinimumComputationProperty> {
            String computationId;
            Object time;
            String type;
            String name;
            Object value;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public MaximumMinimumComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MaximumLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MaximumLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MaximumLabelTypeProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public MaximumLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.MappedDataSetParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappedDataSetParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetIdentifier();

        @NotNull
        public String getDataSetParameterName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappedDataSetParameterProperty> {
            String dataSetIdentifier;
            String dataSetParameterName;

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public Builder dataSetParameterName(String dataSetParameterName) {
                this.dataSetParameterName = dataSetParameterName;
                return this;
            }

            public MappedDataSetParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LongFormatTextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LongFormatTextProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPlainText() {
            return null;
        }

        @Nullable
        default public String getRichText() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LongFormatTextProperty> {
            String plainText;
            String richText;

            public Builder plainText(String plainText) {
                this.plainText = plainText;
                return this;
            }

            public Builder richText(String richText) {
                this.richText = richText;
                return this;
            }

            public LongFormatTextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LocalNavigationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocalNavigationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetSheetId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocalNavigationConfigurationProperty> {
            String targetSheetId;

            public Builder targetSheetId(String targetSheetId) {
                this.targetSheetId = targetSheetId;
                return this;
            }

            public LocalNavigationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LoadingAnimationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadingAnimationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadingAnimationProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public LoadingAnimationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ListControlSelectAllOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ListControlSelectAllOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ListControlSelectAllOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ListControlSearchOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ListControlSearchOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ListControlSearchOptionsProperty> {
            String visibility;

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ListControlSearchOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ListControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ListControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSearchOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectAllOptions() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ListControlDisplayOptionsProperty> {
            Object searchOptions;
            Object selectAllOptions;
            Object titleOptions;

            public Builder searchOptions(IResolvable searchOptions) {
                this.searchOptions = searchOptions;
                return this;
            }

            public Builder searchOptions(ListControlSearchOptionsProperty searchOptions) {
                this.searchOptions = searchOptions;
                return this;
            }

            public Builder selectAllOptions(IResolvable selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public Builder selectAllOptions(ListControlSelectAllOptionsProperty selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public ListControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineSeriesAxisDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineSeriesAxisDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAxisOptions() {
            return null;
        }

        @Nullable
        default public Object getMissingDataConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineSeriesAxisDisplayOptionsProperty> {
            Object axisOptions;
            Object missingDataConfigurations;

            public Builder axisOptions(IResolvable axisOptions) {
                this.axisOptions = axisOptions;
                return this;
            }

            public Builder axisOptions(AxisDisplayOptionsProperty axisOptions) {
                this.axisOptions = axisOptions;
                return this;
            }

            public Builder missingDataConfigurations(IResolvable missingDataConfigurations) {
                this.missingDataConfigurations = missingDataConfigurations;
                return this;
            }

            public Builder missingDataConfigurations(List<? extends Object> missingDataConfigurations) {
                this.missingDataConfigurations = missingDataConfigurations;
                return this;
            }

            public LineSeriesAxisDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(LineChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public LineChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getColorItemsLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartSortConfigurationProperty> {
            Object categoryItemsLimitConfiguration;
            Object categorySort;
            Object colorItemsLimitConfiguration;
            Object smallMultiplesLimitConfiguration;
            Object smallMultiplesSort;

            public Builder categoryItemsLimitConfiguration(IResolvable categoryItemsLimitConfiguration) {
                this.categoryItemsLimitConfiguration = categoryItemsLimitConfiguration;
                return this;
            }

            public Builder categoryItemsLimitConfiguration(ItemsLimitConfigurationProperty categoryItemsLimitConfiguration) {
                this.categoryItemsLimitConfiguration = categoryItemsLimitConfiguration;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder colorItemsLimitConfiguration(IResolvable colorItemsLimitConfiguration) {
                this.colorItemsLimitConfiguration = colorItemsLimitConfiguration;
                return this;
            }

            public Builder colorItemsLimitConfiguration(ItemsLimitConfigurationProperty colorItemsLimitConfiguration) {
                this.colorItemsLimitConfiguration = colorItemsLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(IResolvable smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesSort(IResolvable smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public Builder smallMultiplesSort(List<? extends Object> smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public LineChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartSeriesSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartSeriesSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLineStyleSettings() {
            return null;
        }

        @Nullable
        default public Object getMarkerStyleSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartSeriesSettingsProperty> {
            Object lineStyleSettings;
            Object markerStyleSettings;

            public Builder lineStyleSettings(IResolvable lineStyleSettings) {
                this.lineStyleSettings = lineStyleSettings;
                return this;
            }

            public Builder lineStyleSettings(LineChartLineStyleSettingsProperty lineStyleSettings) {
                this.lineStyleSettings = lineStyleSettings;
                return this;
            }

            public Builder markerStyleSettings(IResolvable markerStyleSettings) {
                this.markerStyleSettings = markerStyleSettings;
                return this;
            }

            public Builder markerStyleSettings(LineChartMarkerStyleSettingsProperty markerStyleSettings) {
                this.markerStyleSettings = markerStyleSettings;
                return this;
            }

            public LineChartSeriesSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartMarkerStyleSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartMarkerStyleSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMarkerColor() {
            return null;
        }

        @Nullable
        default public String getMarkerShape() {
            return null;
        }

        @Nullable
        default public String getMarkerSize() {
            return null;
        }

        @Nullable
        default public String getMarkerVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartMarkerStyleSettingsProperty> {
            String markerColor;
            String markerShape;
            String markerSize;
            String markerVisibility;

            public Builder markerColor(String markerColor) {
                this.markerColor = markerColor;
                return this;
            }

            public Builder markerShape(String markerShape) {
                this.markerShape = markerShape;
                return this;
            }

            public Builder markerSize(String markerSize) {
                this.markerSize = markerSize;
                return this;
            }

            public Builder markerVisibility(String markerVisibility) {
                this.markerVisibility = markerVisibility;
                return this;
            }

            public LineChartMarkerStyleSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartLineStyleSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartLineStyleSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLineInterpolation() {
            return null;
        }

        @Nullable
        default public String getLineStyle() {
            return null;
        }

        @Nullable
        default public String getLineVisibility() {
            return null;
        }

        @Nullable
        default public String getLineWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartLineStyleSettingsProperty> {
            String lineInterpolation;
            String lineStyle;
            String lineVisibility;
            String lineWidth;

            public Builder lineInterpolation(String lineInterpolation) {
                this.lineInterpolation = lineInterpolation;
                return this;
            }

            public Builder lineStyle(String lineStyle) {
                this.lineStyle = lineStyle;
                return this;
            }

            public Builder lineVisibility(String lineVisibility) {
                this.lineVisibility = lineVisibility;
                return this;
            }

            public Builder lineWidth(String lineWidth) {
                this.lineWidth = lineWidth;
                return this;
            }

            public LineChartLineStyleSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLineChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartFieldWellsProperty> {
            Object lineChartAggregatedFieldWells;

            public Builder lineChartAggregatedFieldWells(IResolvable lineChartAggregatedFieldWells) {
                this.lineChartAggregatedFieldWells = lineChartAggregatedFieldWells;
                return this;
            }

            public Builder lineChartAggregatedFieldWells(LineChartAggregatedFieldWellsProperty lineChartAggregatedFieldWells) {
                this.lineChartAggregatedFieldWells = lineChartAggregatedFieldWells;
                return this;
            }

            public LineChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartDefaultSeriesSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartDefaultSeriesSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAxisBinding() {
            return null;
        }

        @Nullable
        default public Object getLineStyleSettings() {
            return null;
        }

        @Nullable
        default public Object getMarkerStyleSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartDefaultSeriesSettingsProperty> {
            String axisBinding;
            Object lineStyleSettings;
            Object markerStyleSettings;

            public Builder axisBinding(String axisBinding) {
                this.axisBinding = axisBinding;
                return this;
            }

            public Builder lineStyleSettings(IResolvable lineStyleSettings) {
                this.lineStyleSettings = lineStyleSettings;
                return this;
            }

            public Builder lineStyleSettings(LineChartLineStyleSettingsProperty lineStyleSettings) {
                this.lineStyleSettings = lineStyleSettings;
                return this;
            }

            public Builder markerStyleSettings(IResolvable markerStyleSettings) {
                this.markerStyleSettings = markerStyleSettings;
                return this;
            }

            public Builder markerStyleSettings(LineChartMarkerStyleSettingsProperty markerStyleSettings) {
                this.markerStyleSettings = markerStyleSettings;
                return this;
            }

            public LineChartDefaultSeriesSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContributionAnalysisDefaults() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getDefaultSeriesSettings() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getForecastConfigurations() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getReferenceLines() {
            return null;
        }

        @Nullable
        default public Object getSecondaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSecondaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getSeries() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        @Nullable
        default public Object getXAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getXAxisLabelOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartConfigurationProperty> {
            Object contributionAnalysisDefaults;
            Object dataLabels;
            Object defaultSeriesSettings;
            Object fieldWells;
            Object forecastConfigurations;
            Object legend;
            Object primaryYAxisDisplayOptions;
            Object primaryYAxisLabelOptions;
            Object referenceLines;
            Object secondaryYAxisDisplayOptions;
            Object secondaryYAxisLabelOptions;
            Object series;
            Object smallMultiplesOptions;
            Object sortConfiguration;
            Object tooltip;
            String type;
            Object visualPalette;
            Object xAxisDisplayOptions;
            Object xAxisLabelOptions;

            public Builder contributionAnalysisDefaults(IResolvable contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder contributionAnalysisDefaults(List<? extends Object> contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder defaultSeriesSettings(IResolvable defaultSeriesSettings) {
                this.defaultSeriesSettings = defaultSeriesSettings;
                return this;
            }

            public Builder defaultSeriesSettings(LineChartDefaultSeriesSettingsProperty defaultSeriesSettings) {
                this.defaultSeriesSettings = defaultSeriesSettings;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(LineChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder forecastConfigurations(IResolvable forecastConfigurations) {
                this.forecastConfigurations = forecastConfigurations;
                return this;
            }

            public Builder forecastConfigurations(List<? extends Object> forecastConfigurations) {
                this.forecastConfigurations = forecastConfigurations;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder referenceLines(IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder referenceLines(List<? extends Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder secondaryYAxisDisplayOptions(IResolvable secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            public Builder secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptionsProperty secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            public Builder secondaryYAxisLabelOptions(IResolvable secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            public Builder secondaryYAxisLabelOptions(ChartAxisLabelOptionsProperty secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            public Builder series(IResolvable series) {
                this.series = series;
                return this;
            }

            public Builder series(List<? extends Object> series) {
                this.series = series;
                return this;
            }

            public Builder smallMultiplesOptions(IResolvable smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder smallMultiplesOptions(SmallMultiplesOptionsProperty smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(LineChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder xAxisDisplayOptions(IResolvable xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisDisplayOptions(AxisDisplayOptionsProperty xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisLabelOptions(IResolvable xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public Builder xAxisLabelOptions(ChartAxisLabelOptionsProperty xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public LineChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LineChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getColors() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiples() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineChartAggregatedFieldWellsProperty> {
            Object category;
            Object colors;
            Object smallMultiples;
            Object values;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder smallMultiples(IResolvable smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder smallMultiples(List<? extends Object> smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public LineChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LegendOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LegendOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHeight() {
            return null;
        }

        @Nullable
        default public String getPosition() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        @Nullable
        default public String getWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LegendOptionsProperty> {
            String height;
            String position;
            Object title;
            String visibility;
            String width;

            public Builder height(String height) {
                this.height = height;
                return this;
            }

            public Builder position(String position) {
                this.position = position;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(LabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public LegendOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LayoutProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LayoutProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LayoutProperty> {
            Object configuration;

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(LayoutConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public LayoutProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LayoutConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFreeFormLayout() {
            return null;
        }

        @Nullable
        default public Object getGridLayout() {
            return null;
        }

        @Nullable
        default public Object getSectionBasedLayout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LayoutConfigurationProperty> {
            Object freeFormLayout;
            Object gridLayout;
            Object sectionBasedLayout;

            public Builder freeFormLayout(IResolvable freeFormLayout) {
                this.freeFormLayout = freeFormLayout;
                return this;
            }

            public Builder freeFormLayout(FreeFormLayoutConfigurationProperty freeFormLayout) {
                this.freeFormLayout = freeFormLayout;
                return this;
            }

            public Builder gridLayout(IResolvable gridLayout) {
                this.gridLayout = gridLayout;
                return this;
            }

            public Builder gridLayout(GridLayoutConfigurationProperty gridLayout) {
                this.gridLayout = gridLayout;
                return this;
            }

            public Builder sectionBasedLayout(IResolvable sectionBasedLayout) {
                this.sectionBasedLayout = sectionBasedLayout;
                return this;
            }

            public Builder sectionBasedLayout(SectionBasedLayoutConfigurationProperty sectionBasedLayout) {
                this.sectionBasedLayout = sectionBasedLayout;
                return this;
            }

            public LayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.LabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public Object getFontConfiguration() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LabelOptionsProperty> {
            String customLabel;
            Object fontConfiguration;
            String visibility;

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public LabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getConditionalFormatting() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object conditionalFormatting;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(KPIConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder conditionalFormatting(IResolvable conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder conditionalFormatting(KPIConditionalFormattingProperty conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public KPIVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPISortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPISortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTrendGroupSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPISortConfigurationProperty> {
            Object trendGroupSort;

            public Builder trendGroupSort(IResolvable trendGroupSort) {
                this.trendGroupSort = trendGroupSort;
                return this;
            }

            public Builder trendGroupSort(List<? extends Object> trendGroupSort) {
                this.trendGroupSort = trendGroupSort;
                return this;
            }

            public KPISortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIProgressBarConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIProgressBarConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getForegroundColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIProgressBarConditionalFormattingProperty> {
            Object foregroundColor;

            public Builder foregroundColor(IResolvable foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public Builder foregroundColor(ConditionalFormattingColorProperty foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public KPIProgressBarConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIPrimaryValueConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIPrimaryValueConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIcon() {
            return null;
        }

        @Nullable
        default public Object getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIPrimaryValueConditionalFormattingProperty> {
            Object icon;
            Object textColor;

            public Builder icon(IResolvable icon) {
                this.icon = icon;
                return this;
            }

            public Builder icon(ConditionalFormattingIconProperty icon) {
                this.icon = icon;
                return this;
            }

            public Builder textColor(IResolvable textColor) {
                this.textColor = textColor;
                return this;
            }

            public Builder textColor(ConditionalFormattingColorProperty textColor) {
                this.textColor = textColor;
                return this;
            }

            public KPIPrimaryValueConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getComparison() {
            return null;
        }

        @Nullable
        default public String getPrimaryValueDisplayType() {
            return null;
        }

        @Nullable
        default public Object getPrimaryValueFontConfiguration() {
            return null;
        }

        @Nullable
        default public Object getProgressBar() {
            return null;
        }

        @Nullable
        default public Object getSecondaryValue() {
            return null;
        }

        @Nullable
        default public Object getSecondaryValueFontConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTrendArrows() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIOptionsProperty> {
            Object comparison;
            String primaryValueDisplayType;
            Object primaryValueFontConfiguration;
            Object progressBar;
            Object secondaryValue;
            Object secondaryValueFontConfiguration;
            Object trendArrows;

            public Builder comparison(IResolvable comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder comparison(ComparisonConfigurationProperty comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder primaryValueDisplayType(String primaryValueDisplayType) {
                this.primaryValueDisplayType = primaryValueDisplayType;
                return this;
            }

            public Builder primaryValueFontConfiguration(IResolvable primaryValueFontConfiguration) {
                this.primaryValueFontConfiguration = primaryValueFontConfiguration;
                return this;
            }

            public Builder primaryValueFontConfiguration(FontConfigurationProperty primaryValueFontConfiguration) {
                this.primaryValueFontConfiguration = primaryValueFontConfiguration;
                return this;
            }

            public Builder progressBar(IResolvable progressBar) {
                this.progressBar = progressBar;
                return this;
            }

            public Builder progressBar(ProgressBarOptionsProperty progressBar) {
                this.progressBar = progressBar;
                return this;
            }

            public Builder secondaryValue(IResolvable secondaryValue) {
                this.secondaryValue = secondaryValue;
                return this;
            }

            public Builder secondaryValue(SecondaryValueOptionsProperty secondaryValue) {
                this.secondaryValue = secondaryValue;
                return this;
            }

            public Builder secondaryValueFontConfiguration(IResolvable secondaryValueFontConfiguration) {
                this.secondaryValueFontConfiguration = secondaryValueFontConfiguration;
                return this;
            }

            public Builder secondaryValueFontConfiguration(FontConfigurationProperty secondaryValueFontConfiguration) {
                this.secondaryValueFontConfiguration = secondaryValueFontConfiguration;
                return this;
            }

            public Builder trendArrows(IResolvable trendArrows) {
                this.trendArrows = trendArrows;
                return this;
            }

            public Builder trendArrows(TrendArrowOptionsProperty trendArrows) {
                this.trendArrows = trendArrows;
                return this;
            }

            public KPIOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTargetValues() {
            return null;
        }

        @Nullable
        default public Object getTrendGroups() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIFieldWellsProperty> {
            Object targetValues;
            Object trendGroups;
            Object values;

            public Builder targetValues(IResolvable targetValues) {
                this.targetValues = targetValues;
                return this;
            }

            public Builder targetValues(List<? extends Object> targetValues) {
                this.targetValues = targetValues;
                return this;
            }

            public Builder trendGroups(IResolvable trendGroups) {
                this.trendGroups = trendGroups;
                return this;
            }

            public Builder trendGroups(List<? extends Object> trendGroups) {
                this.trendGroups = trendGroups;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public KPIFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getKpiOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIConfigurationProperty> {
            Object fieldWells;
            Object kpiOptions;
            Object sortConfiguration;

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(KPIFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder kpiOptions(IResolvable kpiOptions) {
                this.kpiOptions = kpiOptions;
                return this;
            }

            public Builder kpiOptions(KPIOptionsProperty kpiOptions) {
                this.kpiOptions = kpiOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(KPISortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public KPIConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditionalFormattingOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIConditionalFormattingProperty> {
            Object conditionalFormattingOptions;

            public Builder conditionalFormattingOptions(IResolvable conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public Builder conditionalFormattingOptions(List<? extends Object> conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public KPIConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.KPIConditionalFormattingOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KPIConditionalFormattingOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPrimaryValue() {
            return null;
        }

        @Nullable
        default public Object getProgressBar() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KPIConditionalFormattingOptionProperty> {
            Object primaryValue;
            Object progressBar;

            public Builder primaryValue(IResolvable primaryValue) {
                this.primaryValue = primaryValue;
                return this;
            }

            public Builder primaryValue(KPIPrimaryValueConditionalFormattingProperty primaryValue) {
                this.primaryValue = primaryValue;
                return this;
            }

            public Builder progressBar(IResolvable progressBar) {
                this.progressBar = progressBar;
                return this;
            }

            public Builder progressBar(KPIProgressBarConditionalFormattingProperty progressBar) {
                this.progressBar = progressBar;
                return this;
            }

            public KPIConditionalFormattingOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ItemsLimitConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ItemsLimitConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getItemsLimit() {
            return null;
        }

        @Nullable
        default public String getOtherCategories() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ItemsLimitConfigurationProperty> {
            Number itemsLimit;
            String otherCategories;

            public Builder itemsLimit(Number itemsLimit) {
                this.itemsLimit = itemsLimit;
                return this;
            }

            public Builder otherCategories(String otherCategories) {
                this.otherCategories = otherCategories;
                return this;
            }

            public ItemsLimitConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerValueWhenUnsetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegerValueWhenUnsetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCustomValue() {
            return null;
        }

        @Nullable
        default public String getValueWhenUnsetOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegerValueWhenUnsetConfigurationProperty> {
            Number customValue;
            String valueWhenUnsetOption;

            public Builder customValue(Number customValue) {
                this.customValue = customValue;
                return this;
            }

            public Builder valueWhenUnsetOption(String valueWhenUnsetOption) {
                this.valueWhenUnsetOption = valueWhenUnsetOption;
                return this;
            }

            public IntegerValueWhenUnsetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegerParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Object getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegerParameterProperty> {
            String name;
            Object values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<? extends Number> values) {
                this.values = values;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public IntegerParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerParameterDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegerParameterDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getParameterValueType();

        @Nullable
        default public Object getDefaultValues() {
            return null;
        }

        @Nullable
        default public Object getMappedDataSetParameters() {
            return null;
        }

        @Nullable
        default public Object getValueWhenUnset() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegerParameterDeclarationProperty> {
            String name;
            String parameterValueType;
            Object defaultValues;
            Object mappedDataSetParameters;
            Object valueWhenUnset;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameterValueType(String parameterValueType) {
                this.parameterValueType = parameterValueType;
                return this;
            }

            public Builder defaultValues(IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder defaultValues(IntegerDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder mappedDataSetParameters(IResolvable mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder mappedDataSetParameters(List<? extends Object> mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder valueWhenUnset(IResolvable valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public Builder valueWhenUnset(IntegerValueWhenUnsetConfigurationProperty valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public IntegerParameterDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.IntegerDefaultValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegerDefaultValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDynamicValue() {
            return null;
        }

        @Nullable
        default public Object getStaticValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegerDefaultValuesProperty> {
            Object dynamicValue;
            Object staticValues;

            public Builder dynamicValue(IResolvable dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder dynamicValue(DynamicDefaultValueProperty dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder staticValues(List<? extends Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public Builder staticValues(IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public IntegerDefaultValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.InsightVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InsightVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetIdentifier();

        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getInsightConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InsightVisualProperty> {
            String dataSetIdentifier;
            String visualId;
            Object actions;
            Object insightConfiguration;
            Object subtitle;
            Object title;

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder insightConfiguration(IResolvable insightConfiguration) {
                this.insightConfiguration = insightConfiguration;
                return this;
            }

            public Builder insightConfiguration(InsightConfigurationProperty insightConfiguration) {
                this.insightConfiguration = insightConfiguration;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public InsightVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.InsightConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InsightConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getComputations() {
            return null;
        }

        @Nullable
        default public Object getCustomNarrative() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InsightConfigurationProperty> {
            Object computations;
            Object customNarrative;

            public Builder computations(IResolvable computations) {
                this.computations = computations;
                return this;
            }

            public Builder computations(List<? extends Object> computations) {
                this.computations = computations;
                return this;
            }

            public Builder customNarrative(IResolvable customNarrative) {
                this.customNarrative = customNarrative;
                return this;
            }

            public Builder customNarrative(CustomNarrativeOptionsProperty customNarrative) {
                this.customNarrative = customNarrative;
                return this;
            }

            public InsightConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HistogramVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HistogramVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HistogramVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(HistogramConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public HistogramVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HistogramFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HistogramFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHistogramAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HistogramFieldWellsProperty> {
            Object histogramAggregatedFieldWells;

            public Builder histogramAggregatedFieldWells(IResolvable histogramAggregatedFieldWells) {
                this.histogramAggregatedFieldWells = histogramAggregatedFieldWells;
                return this;
            }

            public Builder histogramAggregatedFieldWells(HistogramAggregatedFieldWellsProperty histogramAggregatedFieldWells) {
                this.histogramAggregatedFieldWells = histogramAggregatedFieldWells;
                return this;
            }

            public HistogramFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HistogramConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HistogramConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBinOptions() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        @Nullable
        default public Object getXAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getXAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getYAxisDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HistogramConfigurationProperty> {
            Object binOptions;
            Object dataLabels;
            Object fieldWells;
            Object tooltip;
            Object visualPalette;
            Object xAxisDisplayOptions;
            Object xAxisLabelOptions;
            Object yAxisDisplayOptions;

            public Builder binOptions(IResolvable binOptions) {
                this.binOptions = binOptions;
                return this;
            }

            public Builder binOptions(HistogramBinOptionsProperty binOptions) {
                this.binOptions = binOptions;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(HistogramFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder xAxisDisplayOptions(IResolvable xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisDisplayOptions(AxisDisplayOptionsProperty xAxisDisplayOptions) {
                this.xAxisDisplayOptions = xAxisDisplayOptions;
                return this;
            }

            public Builder xAxisLabelOptions(IResolvable xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public Builder xAxisLabelOptions(ChartAxisLabelOptionsProperty xAxisLabelOptions) {
                this.xAxisLabelOptions = xAxisLabelOptions;
                return this;
            }

            public Builder yAxisDisplayOptions(IResolvable yAxisDisplayOptions) {
                this.yAxisDisplayOptions = yAxisDisplayOptions;
                return this;
            }

            public Builder yAxisDisplayOptions(AxisDisplayOptionsProperty yAxisDisplayOptions) {
                this.yAxisDisplayOptions = yAxisDisplayOptions;
                return this;
            }

            public HistogramConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HistogramBinOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HistogramBinOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBinCount() {
            return null;
        }

        @Nullable
        default public Object getBinWidth() {
            return null;
        }

        @Nullable
        default public String getSelectedBinType() {
            return null;
        }

        @Nullable
        default public Number getStartValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HistogramBinOptionsProperty> {
            Object binCount;
            Object binWidth;
            String selectedBinType;
            Number startValue;

            public Builder binCount(IResolvable binCount) {
                this.binCount = binCount;
                return this;
            }

            public Builder binCount(BinCountOptionsProperty binCount) {
                this.binCount = binCount;
                return this;
            }

            public Builder binWidth(IResolvable binWidth) {
                this.binWidth = binWidth;
                return this;
            }

            public Builder binWidth(BinWidthOptionsProperty binWidth) {
                this.binWidth = binWidth;
                return this;
            }

            public Builder selectedBinType(String selectedBinType) {
                this.selectedBinType = selectedBinType;
                return this;
            }

            public Builder startValue(Number startValue) {
                this.startValue = startValue;
                return this;
            }

            public HistogramBinOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HistogramAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HistogramAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HistogramAggregatedFieldWellsProperty> {
            Object values;

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public HistogramAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeatMapVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeatMapVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeatMapVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(HeatMapConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public HeatMapVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeatMapSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeatMapSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeatMapColumnItemsLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHeatMapColumnSort() {
            return null;
        }

        @Nullable
        default public Object getHeatMapRowItemsLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHeatMapRowSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeatMapSortConfigurationProperty> {
            Object heatMapColumnItemsLimitConfiguration;
            Object heatMapColumnSort;
            Object heatMapRowItemsLimitConfiguration;
            Object heatMapRowSort;

            public Builder heatMapColumnItemsLimitConfiguration(IResolvable heatMapColumnItemsLimitConfiguration) {
                this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration;
                return this;
            }

            public Builder heatMapColumnItemsLimitConfiguration(ItemsLimitConfigurationProperty heatMapColumnItemsLimitConfiguration) {
                this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration;
                return this;
            }

            public Builder heatMapColumnSort(IResolvable heatMapColumnSort) {
                this.heatMapColumnSort = heatMapColumnSort;
                return this;
            }

            public Builder heatMapColumnSort(List<? extends Object> heatMapColumnSort) {
                this.heatMapColumnSort = heatMapColumnSort;
                return this;
            }

            public Builder heatMapRowItemsLimitConfiguration(IResolvable heatMapRowItemsLimitConfiguration) {
                this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration;
                return this;
            }

            public Builder heatMapRowItemsLimitConfiguration(ItemsLimitConfigurationProperty heatMapRowItemsLimitConfiguration) {
                this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration;
                return this;
            }

            public Builder heatMapRowSort(IResolvable heatMapRowSort) {
                this.heatMapRowSort = heatMapRowSort;
                return this;
            }

            public Builder heatMapRowSort(List<? extends Object> heatMapRowSort) {
                this.heatMapRowSort = heatMapRowSort;
                return this;
            }

            public HeatMapSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeatMapFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeatMapFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeatMapAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeatMapFieldWellsProperty> {
            Object heatMapAggregatedFieldWells;

            public Builder heatMapAggregatedFieldWells(IResolvable heatMapAggregatedFieldWells) {
                this.heatMapAggregatedFieldWells = heatMapAggregatedFieldWells;
                return this;
            }

            public Builder heatMapAggregatedFieldWells(HeatMapAggregatedFieldWellsProperty heatMapAggregatedFieldWells) {
                this.heatMapAggregatedFieldWells = heatMapAggregatedFieldWells;
                return this;
            }

            public HeatMapFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeatMapConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeatMapConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColorScale() {
            return null;
        }

        @Nullable
        default public Object getColumnLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getRowLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeatMapConfigurationProperty> {
            Object colorScale;
            Object columnLabelOptions;
            Object dataLabels;
            Object fieldWells;
            Object legend;
            Object rowLabelOptions;
            Object sortConfiguration;
            Object tooltip;

            public Builder colorScale(IResolvable colorScale) {
                this.colorScale = colorScale;
                return this;
            }

            public Builder colorScale(ColorScaleProperty colorScale) {
                this.colorScale = colorScale;
                return this;
            }

            public Builder columnLabelOptions(IResolvable columnLabelOptions) {
                this.columnLabelOptions = columnLabelOptions;
                return this;
            }

            public Builder columnLabelOptions(ChartAxisLabelOptionsProperty columnLabelOptions) {
                this.columnLabelOptions = columnLabelOptions;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(HeatMapFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder rowLabelOptions(IResolvable rowLabelOptions) {
                this.rowLabelOptions = rowLabelOptions;
                return this;
            }

            public Builder rowLabelOptions(ChartAxisLabelOptionsProperty rowLabelOptions) {
                this.rowLabelOptions = rowLabelOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(HeatMapSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public HeatMapConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeatMapAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeatMapAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumns() {
            return null;
        }

        @Nullable
        default public Object getRows() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeatMapAggregatedFieldWellsProperty> {
            Object columns;
            Object rows;
            Object values;

            public Builder columns(IResolvable columns) {
                this.columns = columns;
                return this;
            }

            public Builder columns(List<? extends Object> columns) {
                this.columns = columns;
                return this;
            }

            public Builder rows(IResolvable rows) {
                this.rows = rows;
                return this;
            }

            public Builder rows(List<? extends Object> rows) {
                this.rows = rows;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public HeatMapAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.HeaderFooterSectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeaderFooterSectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLayout();

        @NotNull
        public String getSectionId();

        @Nullable
        default public Object getStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeaderFooterSectionConfigurationProperty> {
            Object layout;
            String sectionId;
            Object style;

            public Builder layout(IResolvable layout) {
                this.layout = layout;
                return this;
            }

            public Builder layout(SectionLayoutConfigurationProperty layout) {
                this.layout = layout;
                return this;
            }

            public Builder sectionId(String sectionId) {
                this.sectionId = sectionId;
                return this;
            }

            public Builder style(IResolvable style) {
                this.style = style;
                return this;
            }

            public Builder style(SectionStyleProperty style) {
                this.style = style;
                return this;
            }

            public HeaderFooterSectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GrowthRateComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GrowthRateComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getPeriodSize() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GrowthRateComputationProperty> {
            String computationId;
            Object time;
            String name;
            Number periodSize;
            Object value;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder periodSize(Number periodSize) {
                this.periodSize = periodSize;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public GrowthRateComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GridLayoutScreenCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getResizeOption();

        @Nullable
        default public String getOptimizedViewPortWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GridLayoutScreenCanvasSizeOptionsProperty> {
            String resizeOption;
            String optimizedViewPortWidth;

            public Builder resizeOption(String resizeOption) {
                this.resizeOption = resizeOption;
                return this;
            }

            public Builder optimizedViewPortWidth(String optimizedViewPortWidth) {
                this.optimizedViewPortWidth = optimizedViewPortWidth;
                return this;
            }

            public GridLayoutScreenCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GridLayoutElementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GridLayoutElementProperty
    extends JsiiSerializable {
        @NotNull
        public Number getColumnSpan();

        @NotNull
        public String getElementId();

        @NotNull
        public String getElementType();

        @NotNull
        public Number getRowSpan();

        @Nullable
        default public Number getColumnIndex() {
            return null;
        }

        @Nullable
        default public Number getRowIndex() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GridLayoutElementProperty> {
            Number columnSpan;
            String elementId;
            String elementType;
            Number rowSpan;
            Number columnIndex;
            Number rowIndex;

            public Builder columnSpan(Number columnSpan) {
                this.columnSpan = columnSpan;
                return this;
            }

            public Builder elementId(String elementId) {
                this.elementId = elementId;
                return this;
            }

            public Builder elementType(String elementType) {
                this.elementType = elementType;
                return this;
            }

            public Builder rowSpan(Number rowSpan) {
                this.rowSpan = rowSpan;
                return this;
            }

            public Builder columnIndex(Number columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public Builder rowIndex(Number rowIndex) {
                this.rowIndex = rowIndex;
                return this;
            }

            public GridLayoutElementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GridLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GridLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getElements();

        @Nullable
        default public Object getCanvasSizeOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GridLayoutConfigurationProperty> {
            Object elements;
            Object canvasSizeOptions;

            public Builder elements(IResolvable elements) {
                this.elements = elements;
                return this;
            }

            public Builder elements(List<? extends Object> elements) {
                this.elements = elements;
                return this;
            }

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public GridLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GridLayoutCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getScreenCanvasSizeOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GridLayoutCanvasSizeOptionsProperty> {
            Object screenCanvasSizeOptions;

            public Builder screenCanvasSizeOptions(IResolvable screenCanvasSizeOptions) {
                this.screenCanvasSizeOptions = screenCanvasSizeOptions;
                return this;
            }

            public Builder screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty screenCanvasSizeOptions) {
                this.screenCanvasSizeOptions = screenCanvasSizeOptions;
                return this;
            }

            public GridLayoutCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GradientStopProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GradientStopProperty
    extends JsiiSerializable {
        @NotNull
        public Number getGradientOffset();

        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public Number getDataValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GradientStopProperty> {
            Number gradientOffset;
            String color;
            Number dataValue;

            public Builder gradientOffset(Number gradientOffset) {
                this.gradientOffset = gradientOffset;
                return this;
            }

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder dataValue(Number dataValue) {
                this.dataValue = dataValue;
                return this;
            }

            public GradientStopProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GradientColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GradientColorProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getStops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GradientColorProperty> {
            Object stops;

            public Builder stops(IResolvable stops) {
                this.stops = stops;
                return this;
            }

            public Builder stops(List<? extends Object> stops) {
                this.stops = stops;
                return this;
            }

            public GradientColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GlobalTableBorderOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlobalTableBorderOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSideSpecificBorder() {
            return null;
        }

        @Nullable
        default public Object getUniformBorder() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlobalTableBorderOptionsProperty> {
            Object sideSpecificBorder;
            Object uniformBorder;

            public Builder sideSpecificBorder(IResolvable sideSpecificBorder) {
                this.sideSpecificBorder = sideSpecificBorder;
                return this;
            }

            public Builder sideSpecificBorder(TableSideBorderOptionsProperty sideSpecificBorder) {
                this.sideSpecificBorder = sideSpecificBorder;
                return this;
            }

            public Builder uniformBorder(IResolvable uniformBorder) {
                this.uniformBorder = uniformBorder;
                return this;
            }

            public Builder uniformBorder(TableBorderOptionsProperty uniformBorder) {
                this.uniformBorder = uniformBorder;
                return this;
            }

            public GlobalTableBorderOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialWindowOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialWindowOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBounds() {
            return null;
        }

        @Nullable
        default public String getMapZoomMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialWindowOptionsProperty> {
            Object bounds;
            String mapZoomMode;

            public Builder bounds(IResolvable bounds) {
                this.bounds = bounds;
                return this;
            }

            public Builder bounds(GeospatialCoordinateBoundsProperty bounds) {
                this.bounds = bounds;
                return this;
            }

            public Builder mapZoomMode(String mapZoomMode) {
                this.mapZoomMode = mapZoomMode;
                return this;
            }

            public GeospatialWindowOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialPointStyleOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialPointStyleOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getClusterMarkerConfiguration() {
            return null;
        }

        @Nullable
        default public String getSelectedPointStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialPointStyleOptionsProperty> {
            Object clusterMarkerConfiguration;
            String selectedPointStyle;

            public Builder clusterMarkerConfiguration(IResolvable clusterMarkerConfiguration) {
                this.clusterMarkerConfiguration = clusterMarkerConfiguration;
                return this;
            }

            public Builder clusterMarkerConfiguration(ClusterMarkerConfigurationProperty clusterMarkerConfiguration) {
                this.clusterMarkerConfiguration = clusterMarkerConfiguration;
                return this;
            }

            public Builder selectedPointStyle(String selectedPointStyle) {
                this.selectedPointStyle = selectedPointStyle;
                return this;
            }

            public GeospatialPointStyleOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialMapVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialMapVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialMapVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(GeospatialMapConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public GeospatialMapVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialMapStyleOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialMapStyleOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBaseMapStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialMapStyleOptionsProperty> {
            String baseMapStyle;

            public Builder baseMapStyle(String baseMapStyle) {
                this.baseMapStyle = baseMapStyle;
                return this;
            }

            public GeospatialMapStyleOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialMapFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialMapFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGeospatialMapAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialMapFieldWellsProperty> {
            Object geospatialMapAggregatedFieldWells;

            public Builder geospatialMapAggregatedFieldWells(IResolvable geospatialMapAggregatedFieldWells) {
                this.geospatialMapAggregatedFieldWells = geospatialMapAggregatedFieldWells;
                return this;
            }

            public Builder geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWellsProperty geospatialMapAggregatedFieldWells) {
                this.geospatialMapAggregatedFieldWells = geospatialMapAggregatedFieldWells;
                return this;
            }

            public GeospatialMapFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialMapConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialMapConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getMapStyleOptions() {
            return null;
        }

        @Nullable
        default public Object getPointStyleOptions() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        @Nullable
        default public Object getWindowOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialMapConfigurationProperty> {
            Object fieldWells;
            Object legend;
            Object mapStyleOptions;
            Object pointStyleOptions;
            Object tooltip;
            Object visualPalette;
            Object windowOptions;

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(GeospatialMapFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder mapStyleOptions(IResolvable mapStyleOptions) {
                this.mapStyleOptions = mapStyleOptions;
                return this;
            }

            public Builder mapStyleOptions(GeospatialMapStyleOptionsProperty mapStyleOptions) {
                this.mapStyleOptions = mapStyleOptions;
                return this;
            }

            public Builder pointStyleOptions(IResolvable pointStyleOptions) {
                this.pointStyleOptions = pointStyleOptions;
                return this;
            }

            public Builder pointStyleOptions(GeospatialPointStyleOptionsProperty pointStyleOptions) {
                this.pointStyleOptions = pointStyleOptions;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder windowOptions(IResolvable windowOptions) {
                this.windowOptions = windowOptions;
                return this;
            }

            public Builder windowOptions(GeospatialWindowOptionsProperty windowOptions) {
                this.windowOptions = windowOptions;
                return this;
            }

            public GeospatialMapConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialMapAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialMapAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColors() {
            return null;
        }

        @Nullable
        default public Object getGeospatial() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialMapAggregatedFieldWellsProperty> {
            Object colors;
            Object geospatial;
            Object values;

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder geospatial(IResolvable geospatial) {
                this.geospatial = geospatial;
                return this;
            }

            public Builder geospatial(List<? extends Object> geospatial) {
                this.geospatial = geospatial;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public GeospatialMapAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GeospatialCoordinateBoundsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeospatialCoordinateBoundsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getEast();

        @NotNull
        public Number getNorth();

        @NotNull
        public Number getSouth();

        @NotNull
        public Number getWest();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeospatialCoordinateBoundsProperty> {
            Number east;
            Number north;
            Number south;
            Number west;

            public Builder east(Number east) {
                this.east = east;
                return this;
            }

            public Builder north(Number north) {
                this.north = north;
                return this;
            }

            public Builder south(Number south) {
                this.south = south;
                return this;
            }

            public Builder west(Number west) {
                this.west = west;
                return this;
            }

            public GeospatialCoordinateBoundsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getConditionalFormatting() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object conditionalFormatting;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(GaugeChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder conditionalFormatting(IResolvable conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder conditionalFormatting(GaugeChartConditionalFormattingProperty conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public GaugeChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartPrimaryValueConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartPrimaryValueConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIcon() {
            return null;
        }

        @Nullable
        default public Object getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartPrimaryValueConditionalFormattingProperty> {
            Object icon;
            Object textColor;

            public Builder icon(IResolvable icon) {
                this.icon = icon;
                return this;
            }

            public Builder icon(ConditionalFormattingIconProperty icon) {
                this.icon = icon;
                return this;
            }

            public Builder textColor(IResolvable textColor) {
                this.textColor = textColor;
                return this;
            }

            public Builder textColor(ConditionalFormattingColorProperty textColor) {
                this.textColor = textColor;
                return this;
            }

            public GaugeChartPrimaryValueConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArc() {
            return null;
        }

        @Nullable
        default public Object getArcAxis() {
            return null;
        }

        @Nullable
        default public Object getComparison() {
            return null;
        }

        @Nullable
        default public String getPrimaryValueDisplayType() {
            return null;
        }

        @Nullable
        default public Object getPrimaryValueFontConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartOptionsProperty> {
            Object arc;
            Object arcAxis;
            Object comparison;
            String primaryValueDisplayType;
            Object primaryValueFontConfiguration;

            public Builder arc(IResolvable arc) {
                this.arc = arc;
                return this;
            }

            public Builder arc(ArcConfigurationProperty arc) {
                this.arc = arc;
                return this;
            }

            public Builder arcAxis(IResolvable arcAxis) {
                this.arcAxis = arcAxis;
                return this;
            }

            public Builder arcAxis(ArcAxisConfigurationProperty arcAxis) {
                this.arcAxis = arcAxis;
                return this;
            }

            public Builder comparison(IResolvable comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder comparison(ComparisonConfigurationProperty comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder primaryValueDisplayType(String primaryValueDisplayType) {
                this.primaryValueDisplayType = primaryValueDisplayType;
                return this;
            }

            public Builder primaryValueFontConfiguration(IResolvable primaryValueFontConfiguration) {
                this.primaryValueFontConfiguration = primaryValueFontConfiguration;
                return this;
            }

            public Builder primaryValueFontConfiguration(FontConfigurationProperty primaryValueFontConfiguration) {
                this.primaryValueFontConfiguration = primaryValueFontConfiguration;
                return this;
            }

            public GaugeChartOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTargetValues() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartFieldWellsProperty> {
            Object targetValues;
            Object values;

            public Builder targetValues(IResolvable targetValues) {
                this.targetValues = targetValues;
                return this;
            }

            public Builder targetValues(List<? extends Object> targetValues) {
                this.targetValues = targetValues;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public GaugeChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getGaugeChartOptions() {
            return null;
        }

        @Nullable
        default public Object getTooltipOptions() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartConfigurationProperty> {
            Object dataLabels;
            Object fieldWells;
            Object gaugeChartOptions;
            Object tooltipOptions;
            Object visualPalette;

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(GaugeChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder gaugeChartOptions(IResolvable gaugeChartOptions) {
                this.gaugeChartOptions = gaugeChartOptions;
                return this;
            }

            public Builder gaugeChartOptions(GaugeChartOptionsProperty gaugeChartOptions) {
                this.gaugeChartOptions = gaugeChartOptions;
                return this;
            }

            public Builder tooltipOptions(IResolvable tooltipOptions) {
                this.tooltipOptions = tooltipOptions;
                return this;
            }

            public Builder tooltipOptions(TooltipOptionsProperty tooltipOptions) {
                this.tooltipOptions = tooltipOptions;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public GaugeChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditionalFormattingOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartConditionalFormattingProperty> {
            Object conditionalFormattingOptions;

            public Builder conditionalFormattingOptions(IResolvable conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public Builder conditionalFormattingOptions(List<? extends Object> conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public GaugeChartConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartConditionalFormattingOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartConditionalFormattingOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArc() {
            return null;
        }

        @Nullable
        default public Object getPrimaryValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartConditionalFormattingOptionProperty> {
            Object arc;
            Object primaryValue;

            public Builder arc(IResolvable arc) {
                this.arc = arc;
                return this;
            }

            public Builder arc(GaugeChartArcConditionalFormattingProperty arc) {
                this.arc = arc;
                return this;
            }

            public Builder primaryValue(IResolvable primaryValue) {
                this.primaryValue = primaryValue;
                return this;
            }

            public Builder primaryValue(GaugeChartPrimaryValueConditionalFormattingProperty primaryValue) {
                this.primaryValue = primaryValue;
                return this;
            }

            public GaugeChartConditionalFormattingOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.GaugeChartArcConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GaugeChartArcConditionalFormattingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getForegroundColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GaugeChartArcConditionalFormattingProperty> {
            Object foregroundColor;

            public Builder foregroundColor(IResolvable foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public Builder foregroundColor(ConditionalFormattingColorProperty foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public GaugeChartArcConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(FunnelChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public FunnelChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public FunnelChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFunnelChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartFieldWellsProperty> {
            Object funnelChartAggregatedFieldWells;

            public Builder funnelChartAggregatedFieldWells(IResolvable funnelChartAggregatedFieldWells) {
                this.funnelChartAggregatedFieldWells = funnelChartAggregatedFieldWells;
                return this;
            }

            public Builder funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWellsProperty funnelChartAggregatedFieldWells) {
                this.funnelChartAggregatedFieldWells = funnelChartAggregatedFieldWells;
                return this;
            }

            public FunnelChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartDataLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartDataLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCategoryLabelVisibility() {
            return null;
        }

        @Nullable
        default public String getLabelColor() {
            return null;
        }

        @Nullable
        default public Object getLabelFontConfiguration() {
            return null;
        }

        @Nullable
        default public String getMeasureDataLabelStyle() {
            return null;
        }

        @Nullable
        default public String getMeasureLabelVisibility() {
            return null;
        }

        @Nullable
        default public String getPosition() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartDataLabelOptionsProperty> {
            String categoryLabelVisibility;
            String labelColor;
            Object labelFontConfiguration;
            String measureDataLabelStyle;
            String measureLabelVisibility;
            String position;
            String visibility;

            public Builder categoryLabelVisibility(String categoryLabelVisibility) {
                this.categoryLabelVisibility = categoryLabelVisibility;
                return this;
            }

            public Builder labelColor(String labelColor) {
                this.labelColor = labelColor;
                return this;
            }

            public Builder labelFontConfiguration(IResolvable labelFontConfiguration) {
                this.labelFontConfiguration = labelFontConfiguration;
                return this;
            }

            public Builder labelFontConfiguration(FontConfigurationProperty labelFontConfiguration) {
                this.labelFontConfiguration = labelFontConfiguration;
                return this;
            }

            public Builder measureDataLabelStyle(String measureDataLabelStyle) {
                this.measureDataLabelStyle = measureDataLabelStyle;
                return this;
            }

            public Builder measureLabelVisibility(String measureLabelVisibility) {
                this.measureLabelVisibility = measureLabelVisibility;
                return this;
            }

            public Builder position(String position) {
                this.position = position;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FunnelChartDataLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getDataLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getValueLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartConfigurationProperty> {
            Object categoryLabelOptions;
            Object dataLabelOptions;
            Object fieldWells;
            Object sortConfiguration;
            Object tooltip;
            Object valueLabelOptions;
            Object visualPalette;

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder dataLabelOptions(IResolvable dataLabelOptions) {
                this.dataLabelOptions = dataLabelOptions;
                return this;
            }

            public Builder dataLabelOptions(FunnelChartDataLabelOptionsProperty dataLabelOptions) {
                this.dataLabelOptions = dataLabelOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(FunnelChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(FunnelChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder valueLabelOptions(IResolvable valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder valueLabelOptions(ChartAxisLabelOptionsProperty valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public FunnelChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FunnelChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunnelChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunnelChartAggregatedFieldWellsProperty> {
            Object category;
            Object values;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public FunnelChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormSectionLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getElements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormSectionLayoutConfigurationProperty> {
            Object elements;

            public Builder elements(IResolvable elements) {
                this.elements = elements;
                return this;
            }

            public Builder elements(List<? extends Object> elements) {
                this.elements = elements;
                return this;
            }

            public FreeFormSectionLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutScreenCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getOptimizedViewPortWidth();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutScreenCanvasSizeOptionsProperty> {
            String optimizedViewPortWidth;

            public Builder optimizedViewPortWidth(String optimizedViewPortWidth) {
                this.optimizedViewPortWidth = optimizedViewPortWidth;
                return this;
            }

            public FreeFormLayoutScreenCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutElementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutElementProperty
    extends JsiiSerializable {
        @NotNull
        public String getElementId();

        @NotNull
        public String getElementType();

        @NotNull
        public String getHeight();

        @NotNull
        public String getWidth();

        @NotNull
        public String getXAxisLocation();

        @NotNull
        public String getYAxisLocation();

        @Nullable
        default public Object getBackgroundStyle() {
            return null;
        }

        @Nullable
        default public Object getBorderStyle() {
            return null;
        }

        @Nullable
        default public Object getLoadingAnimation() {
            return null;
        }

        @Nullable
        default public Object getRenderingRules() {
            return null;
        }

        @Nullable
        default public Object getSelectedBorderStyle() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutElementProperty> {
            String elementId;
            String elementType;
            String height;
            String width;
            String xAxisLocation;
            String yAxisLocation;
            Object backgroundStyle;
            Object borderStyle;
            Object loadingAnimation;
            Object renderingRules;
            Object selectedBorderStyle;
            String visibility;

            public Builder elementId(String elementId) {
                this.elementId = elementId;
                return this;
            }

            public Builder elementType(String elementType) {
                this.elementType = elementType;
                return this;
            }

            public Builder height(String height) {
                this.height = height;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public Builder xAxisLocation(String xAxisLocation) {
                this.xAxisLocation = xAxisLocation;
                return this;
            }

            public Builder yAxisLocation(String yAxisLocation) {
                this.yAxisLocation = yAxisLocation;
                return this;
            }

            public Builder backgroundStyle(IResolvable backgroundStyle) {
                this.backgroundStyle = backgroundStyle;
                return this;
            }

            public Builder backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty backgroundStyle) {
                this.backgroundStyle = backgroundStyle;
                return this;
            }

            public Builder borderStyle(IResolvable borderStyle) {
                this.borderStyle = borderStyle;
                return this;
            }

            public Builder borderStyle(FreeFormLayoutElementBorderStyleProperty borderStyle) {
                this.borderStyle = borderStyle;
                return this;
            }

            public Builder loadingAnimation(IResolvable loadingAnimation) {
                this.loadingAnimation = loadingAnimation;
                return this;
            }

            public Builder loadingAnimation(LoadingAnimationProperty loadingAnimation) {
                this.loadingAnimation = loadingAnimation;
                return this;
            }

            public Builder renderingRules(IResolvable renderingRules) {
                this.renderingRules = renderingRules;
                return this;
            }

            public Builder renderingRules(List<? extends Object> renderingRules) {
                this.renderingRules = renderingRules;
                return this;
            }

            public Builder selectedBorderStyle(IResolvable selectedBorderStyle) {
                this.selectedBorderStyle = selectedBorderStyle;
                return this;
            }

            public Builder selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty selectedBorderStyle) {
                this.selectedBorderStyle = selectedBorderStyle;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FreeFormLayoutElementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutElementBorderStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutElementBorderStyleProperty> {
            String color;
            String visibility;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FreeFormLayoutElementBorderStyleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutElementBackgroundStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutElementBackgroundStyleProperty> {
            String color;
            String visibility;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FreeFormLayoutElementBackgroundStyleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getElements();

        @Nullable
        default public Object getCanvasSizeOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutConfigurationProperty> {
            Object elements;
            Object canvasSizeOptions;

            public Builder elements(IResolvable elements) {
                this.elements = elements;
                return this;
            }

            public Builder elements(List<? extends Object> elements) {
                this.elements = elements;
                return this;
            }

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public FreeFormLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FreeFormLayoutCanvasSizeOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getScreenCanvasSizeOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FreeFormLayoutCanvasSizeOptionsProperty> {
            Object screenCanvasSizeOptions;

            public Builder screenCanvasSizeOptions(IResolvable screenCanvasSizeOptions) {
                this.screenCanvasSizeOptions = screenCanvasSizeOptions;
                return this;
            }

            public Builder screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty screenCanvasSizeOptions) {
                this.screenCanvasSizeOptions = screenCanvasSizeOptions;
                return this;
            }

            public FreeFormLayoutCanvasSizeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimeFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNumberFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStringFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FormatConfigurationProperty> {
            Object dateTimeFormatConfiguration;
            Object numberFormatConfiguration;
            Object stringFormatConfiguration;

            public Builder dateTimeFormatConfiguration(IResolvable dateTimeFormatConfiguration) {
                this.dateTimeFormatConfiguration = dateTimeFormatConfiguration;
                return this;
            }

            public Builder dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty dateTimeFormatConfiguration) {
                this.dateTimeFormatConfiguration = dateTimeFormatConfiguration;
                return this;
            }

            public Builder numberFormatConfiguration(IResolvable numberFormatConfiguration) {
                this.numberFormatConfiguration = numberFormatConfiguration;
                return this;
            }

            public Builder numberFormatConfiguration(NumberFormatConfigurationProperty numberFormatConfiguration) {
                this.numberFormatConfiguration = numberFormatConfiguration;
                return this;
            }

            public Builder stringFormatConfiguration(IResolvable stringFormatConfiguration) {
                this.stringFormatConfiguration = stringFormatConfiguration;
                return this;
            }

            public Builder stringFormatConfiguration(StringFormatConfigurationProperty stringFormatConfiguration) {
                this.stringFormatConfiguration = stringFormatConfiguration;
                return this;
            }

            public FormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ForecastScenarioProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForecastScenarioProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getWhatIfPointScenario() {
            return null;
        }

        @Nullable
        default public Object getWhatIfRangeScenario() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForecastScenarioProperty> {
            Object whatIfPointScenario;
            Object whatIfRangeScenario;

            public Builder whatIfPointScenario(IResolvable whatIfPointScenario) {
                this.whatIfPointScenario = whatIfPointScenario;
                return this;
            }

            public Builder whatIfPointScenario(WhatIfPointScenarioProperty whatIfPointScenario) {
                this.whatIfPointScenario = whatIfPointScenario;
                return this;
            }

            public Builder whatIfRangeScenario(IResolvable whatIfRangeScenario) {
                this.whatIfRangeScenario = whatIfRangeScenario;
                return this;
            }

            public Builder whatIfRangeScenario(WhatIfRangeScenarioProperty whatIfRangeScenario) {
                this.whatIfRangeScenario = whatIfRangeScenario;
                return this;
            }

            public ForecastScenarioProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ForecastConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForecastConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getForecastProperties() {
            return null;
        }

        @Nullable
        default public Object getScenario() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForecastConfigurationProperty> {
            Object forecastProperties;
            Object scenario;

            public Builder forecastProperties(IResolvable forecastProperties) {
                this.forecastProperties = forecastProperties;
                return this;
            }

            public Builder forecastProperties(TimeBasedForecastPropertiesProperty forecastProperties) {
                this.forecastProperties = forecastProperties;
                return this;
            }

            public Builder scenario(IResolvable scenario) {
                this.scenario = scenario;
                return this;
            }

            public Builder scenario(ForecastScenarioProperty scenario) {
                this.scenario = scenario;
                return this;
            }

            public ForecastConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ForecastComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForecastComputationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputationId();

        @NotNull
        public Object getTime();

        @Nullable
        default public Number getCustomSeasonalityValue() {
            return null;
        }

        @Nullable
        default public Number getLowerBoundary() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getPeriodsBackward() {
            return null;
        }

        @Nullable
        default public Number getPeriodsForward() {
            return null;
        }

        @Nullable
        default public Number getPredictionInterval() {
            return null;
        }

        @Nullable
        default public String getSeasonality() {
            return null;
        }

        @Nullable
        default public Number getUpperBoundary() {
            return null;
        }

        @Nullable
        default public Object getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForecastComputationProperty> {
            String computationId;
            Object time;
            Number customSeasonalityValue;
            Number lowerBoundary;
            String name;
            Number periodsBackward;
            Number periodsForward;
            Number predictionInterval;
            String seasonality;
            Number upperBoundary;
            Object value;

            public Builder computationId(String computationId) {
                this.computationId = computationId;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(DimensionFieldProperty time) {
                this.time = time;
                return this;
            }

            public Builder customSeasonalityValue(Number customSeasonalityValue) {
                this.customSeasonalityValue = customSeasonalityValue;
                return this;
            }

            public Builder lowerBoundary(Number lowerBoundary) {
                this.lowerBoundary = lowerBoundary;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder periodsBackward(Number periodsBackward) {
                this.periodsBackward = periodsBackward;
                return this;
            }

            public Builder periodsForward(Number periodsForward) {
                this.periodsForward = periodsForward;
                return this;
            }

            public Builder predictionInterval(Number predictionInterval) {
                this.predictionInterval = predictionInterval;
                return this;
            }

            public Builder seasonality(String seasonality) {
                this.seasonality = seasonality;
                return this;
            }

            public Builder upperBoundary(Number upperBoundary) {
                this.upperBoundary = upperBoundary;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(MeasureFieldProperty value) {
                this.value = value;
                return this;
            }

            public ForecastComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FontWeightProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FontWeightProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FontWeightProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public FontWeightProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FontSizeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FontSizeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRelative() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FontSizeProperty> {
            String relative;

            public Builder relative(String relative) {
                this.relative = relative;
                return this;
            }

            public FontSizeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FontConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FontConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFontColor() {
            return null;
        }

        @Nullable
        default public String getFontDecoration() {
            return null;
        }

        @Nullable
        default public Object getFontSize() {
            return null;
        }

        @Nullable
        default public String getFontStyle() {
            return null;
        }

        @Nullable
        default public Object getFontWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FontConfigurationProperty> {
            String fontColor;
            String fontDecoration;
            Object fontSize;
            String fontStyle;
            Object fontWeight;

            public Builder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            public Builder fontDecoration(String fontDecoration) {
                this.fontDecoration = fontDecoration;
                return this;
            }

            public Builder fontSize(IResolvable fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public Builder fontSize(FontSizeProperty fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public Builder fontStyle(String fontStyle) {
                this.fontStyle = fontStyle;
                return this;
            }

            public Builder fontWeight(IResolvable fontWeight) {
                this.fontWeight = fontWeight;
                return this;
            }

            public Builder fontWeight(FontWeightProperty fontWeight) {
                this.fontWeight = fontWeight;
                return this;
            }

            public FontConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterTextFieldControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterTextFieldControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterTextFieldControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            Object displayOptions;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(TextFieldControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public FilterTextFieldControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterTextAreaControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterTextAreaControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public String getDelimiter() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterTextAreaControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            String delimiter;
            Object displayOptions;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder delimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(TextAreaControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public FilterTextAreaControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterSliderControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterSliderControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public Number getMaximumValue();

        @NotNull
        public Number getMinimumValue();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public Number getStepSize();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterSliderControlProperty> {
            String filterControlId;
            Number maximumValue;
            Number minimumValue;
            String sourceFilterId;
            Number stepSize;
            String title;
            Object displayOptions;
            String type;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder maximumValue(Number maximumValue) {
                this.maximumValue = maximumValue;
                return this;
            }

            public Builder minimumValue(Number minimumValue) {
                this.minimumValue = minimumValue;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder stepSize(Number stepSize) {
                this.stepSize = stepSize;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(SliderControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FilterSliderControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterSelectableValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterSelectableValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterSelectableValuesProperty> {
            List<String> values;

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public FilterSelectableValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterScopeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterScopeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSelectedSheets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterScopeConfigurationProperty> {
            Object selectedSheets;

            public Builder selectedSheets(IResolvable selectedSheets) {
                this.selectedSheets = selectedSheets;
                return this;
            }

            public Builder selectedSheets(SelectedSheetsFilterScopeConfigurationProperty selectedSheets) {
                this.selectedSheets = selectedSheets;
                return this;
            }

            public FilterScopeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterRelativeDateTimeControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterRelativeDateTimeControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterRelativeDateTimeControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            Object displayOptions;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(RelativeDateTimeControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public FilterRelativeDateTimeControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryFilter() {
            return null;
        }

        @Nullable
        default public Object getNumericEqualityFilter() {
            return null;
        }

        @Nullable
        default public Object getNumericRangeFilter() {
            return null;
        }

        @Nullable
        default public Object getRelativeDatesFilter() {
            return null;
        }

        @Nullable
        default public Object getTimeEqualityFilter() {
            return null;
        }

        @Nullable
        default public Object getTimeRangeFilter() {
            return null;
        }

        @Nullable
        default public Object getTopBottomFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterProperty> {
            Object categoryFilter;
            Object numericEqualityFilter;
            Object numericRangeFilter;
            Object relativeDatesFilter;
            Object timeEqualityFilter;
            Object timeRangeFilter;
            Object topBottomFilter;

            public Builder categoryFilter(IResolvable categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            public Builder categoryFilter(CategoryFilterProperty categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            public Builder numericEqualityFilter(IResolvable numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            public Builder numericEqualityFilter(NumericEqualityFilterProperty numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            public Builder numericRangeFilter(IResolvable numericRangeFilter) {
                this.numericRangeFilter = numericRangeFilter;
                return this;
            }

            public Builder numericRangeFilter(NumericRangeFilterProperty numericRangeFilter) {
                this.numericRangeFilter = numericRangeFilter;
                return this;
            }

            public Builder relativeDatesFilter(IResolvable relativeDatesFilter) {
                this.relativeDatesFilter = relativeDatesFilter;
                return this;
            }

            public Builder relativeDatesFilter(RelativeDatesFilterProperty relativeDatesFilter) {
                this.relativeDatesFilter = relativeDatesFilter;
                return this;
            }

            public Builder timeEqualityFilter(IResolvable timeEqualityFilter) {
                this.timeEqualityFilter = timeEqualityFilter;
                return this;
            }

            public Builder timeEqualityFilter(TimeEqualityFilterProperty timeEqualityFilter) {
                this.timeEqualityFilter = timeEqualityFilter;
                return this;
            }

            public Builder timeRangeFilter(IResolvable timeRangeFilter) {
                this.timeRangeFilter = timeRangeFilter;
                return this;
            }

            public Builder timeRangeFilter(TimeRangeFilterProperty timeRangeFilter) {
                this.timeRangeFilter = timeRangeFilter;
                return this;
            }

            public Builder topBottomFilter(IResolvable topBottomFilter) {
                this.topBottomFilter = topBottomFilter;
                return this;
            }

            public Builder topBottomFilter(TopBottomFilterProperty topBottomFilter) {
                this.topBottomFilter = topBottomFilter;
                return this;
            }

            public FilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterOperationTargetVisualsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSameSheetTargetVisualConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterOperationTargetVisualsConfigurationProperty> {
            Object sameSheetTargetVisualConfiguration;

            public Builder sameSheetTargetVisualConfiguration(IResolvable sameSheetTargetVisualConfiguration) {
                this.sameSheetTargetVisualConfiguration = sameSheetTargetVisualConfiguration;
                return this;
            }

            public Builder sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfigurationProperty sameSheetTargetVisualConfiguration) {
                this.sameSheetTargetVisualConfiguration = sameSheetTargetVisualConfiguration;
                return this;
            }

            public FilterOperationTargetVisualsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterOperationSelectedFieldsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSelectedFieldOptions() {
            return null;
        }

        @Nullable
        default public List<String> getSelectedFields() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterOperationSelectedFieldsConfigurationProperty> {
            String selectedFieldOptions;
            List<String> selectedFields;

            public Builder selectedFieldOptions(String selectedFieldOptions) {
                this.selectedFieldOptions = selectedFieldOptions;
                return this;
            }

            public Builder selectedFields(List<String> selectedFields) {
                this.selectedFields = selectedFields;
                return this;
            }

            public FilterOperationSelectedFieldsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterListControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterListControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getCascadingControlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectableValues() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterListControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            Object cascadingControlConfiguration;
            Object displayOptions;
            Object selectableValues;
            String type;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder cascadingControlConfiguration(IResolvable cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder cascadingControlConfiguration(CascadingControlConfigurationProperty cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(ListControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder selectableValues(IResolvable selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder selectableValues(FilterSelectableValuesProperty selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FilterListControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterListConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterListConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMatchOperator();

        @Nullable
        default public List<String> getCategoryValues() {
            return null;
        }

        @Nullable
        default public String getSelectAllOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterListConfigurationProperty> {
            String matchOperator;
            List<String> categoryValues;
            String selectAllOptions;

            public Builder matchOperator(String matchOperator) {
                this.matchOperator = matchOperator;
                return this;
            }

            public Builder categoryValues(List<String> categoryValues) {
                this.categoryValues = categoryValues;
                return this;
            }

            public Builder selectAllOptions(String selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public FilterListConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterGroupProperty
    extends JsiiSerializable {
        @NotNull
        public String getCrossDataset();

        @NotNull
        public String getFilterGroupId();

        @NotNull
        public Object getFilters();

        @NotNull
        public Object getScopeConfiguration();

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterGroupProperty> {
            String crossDataset;
            String filterGroupId;
            Object filters;
            Object scopeConfiguration;
            String status;

            public Builder crossDataset(String crossDataset) {
                this.crossDataset = crossDataset;
                return this;
            }

            public Builder filterGroupId(String filterGroupId) {
                this.filterGroupId = filterGroupId;
                return this;
            }

            public Builder filters(IResolvable filters) {
                this.filters = filters;
                return this;
            }

            public Builder filters(List<? extends Object> filters) {
                this.filters = filters;
                return this;
            }

            public Builder scopeConfiguration(IResolvable scopeConfiguration) {
                this.scopeConfiguration = scopeConfiguration;
                return this;
            }

            public Builder scopeConfiguration(FilterScopeConfigurationProperty scopeConfiguration) {
                this.scopeConfiguration = scopeConfiguration;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public FilterGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterDropDownControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterDropDownControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getCascadingControlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSelectableValues() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterDropDownControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            Object cascadingControlConfiguration;
            Object displayOptions;
            Object selectableValues;
            String type;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder cascadingControlConfiguration(IResolvable cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder cascadingControlConfiguration(CascadingControlConfigurationProperty cascadingControlConfiguration) {
                this.cascadingControlConfiguration = cascadingControlConfiguration;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(DropDownControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder selectableValues(IResolvable selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder selectableValues(FilterSelectableValuesProperty selectableValues) {
                this.selectableValues = selectableValues;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FilterDropDownControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterDateTimePickerControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterDateTimePickerControlProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterControlId();

        @NotNull
        public String getSourceFilterId();

        @NotNull
        public String getTitle();

        @Nullable
        default public Object getDisplayOptions() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterDateTimePickerControlProperty> {
            String filterControlId;
            String sourceFilterId;
            String title;
            Object displayOptions;
            String type;

            public Builder filterControlId(String filterControlId) {
                this.filterControlId = filterControlId;
                return this;
            }

            public Builder sourceFilterId(String sourceFilterId) {
                this.sourceFilterId = sourceFilterId;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder displayOptions(IResolvable displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder displayOptions(DateTimePickerControlDisplayOptionsProperty displayOptions) {
                this.displayOptions = displayOptions;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FilterDateTimePickerControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilterControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterControlProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimePicker() {
            return null;
        }

        @Nullable
        default public Object getDropdown() {
            return null;
        }

        @Nullable
        default public Object getList() {
            return null;
        }

        @Nullable
        default public Object getRelativeDateTime() {
            return null;
        }

        @Nullable
        default public Object getSlider() {
            return null;
        }

        @Nullable
        default public Object getTextArea() {
            return null;
        }

        @Nullable
        default public Object getTextField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterControlProperty> {
            Object dateTimePicker;
            Object dropdown;
            Object list;
            Object relativeDateTime;
            Object slider;
            Object textArea;
            Object textField;

            public Builder dateTimePicker(IResolvable dateTimePicker) {
                this.dateTimePicker = dateTimePicker;
                return this;
            }

            public Builder dateTimePicker(FilterDateTimePickerControlProperty dateTimePicker) {
                this.dateTimePicker = dateTimePicker;
                return this;
            }

            public Builder dropdown(IResolvable dropdown) {
                this.dropdown = dropdown;
                return this;
            }

            public Builder dropdown(FilterDropDownControlProperty dropdown) {
                this.dropdown = dropdown;
                return this;
            }

            public Builder list(IResolvable list) {
                this.list = list;
                return this;
            }

            public Builder list(FilterListControlProperty list) {
                this.list = list;
                return this;
            }

            public Builder relativeDateTime(IResolvable relativeDateTime) {
                this.relativeDateTime = relativeDateTime;
                return this;
            }

            public Builder relativeDateTime(FilterRelativeDateTimeControlProperty relativeDateTime) {
                this.relativeDateTime = relativeDateTime;
                return this;
            }

            public Builder slider(IResolvable slider) {
                this.slider = slider;
                return this;
            }

            public Builder slider(FilterSliderControlProperty slider) {
                this.slider = slider;
                return this;
            }

            public Builder textArea(IResolvable textArea) {
                this.textArea = textArea;
                return this;
            }

            public Builder textArea(FilterTextAreaControlProperty textArea) {
                this.textArea = textArea;
                return this;
            }

            public Builder textField(IResolvable textField) {
                this.textField = textField;
                return this;
            }

            public Builder textField(FilterTextFieldControlProperty textField) {
                this.textField = textField;
                return this;
            }

            public FilterControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getConditionalFormatting() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object conditionalFormatting;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(FilledMapConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder conditionalFormatting(IResolvable conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder conditionalFormatting(FilledMapConditionalFormattingProperty conditionalFormatting) {
                this.conditionalFormatting = conditionalFormatting;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public FilledMapVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapSortConfigurationProperty> {
            Object categorySort;

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public FilledMapSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapShapeConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapShapeConditionalFormattingProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapShapeConditionalFormattingProperty> {
            String fieldId;
            Object format;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder format(IResolvable format) {
                this.format = format;
                return this;
            }

            public Builder format(ShapeConditionalFormatProperty format) {
                this.format = format;
                return this;
            }

            public FilledMapShapeConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilledMapAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapFieldWellsProperty> {
            Object filledMapAggregatedFieldWells;

            public Builder filledMapAggregatedFieldWells(IResolvable filledMapAggregatedFieldWells) {
                this.filledMapAggregatedFieldWells = filledMapAggregatedFieldWells;
                return this;
            }

            public Builder filledMapAggregatedFieldWells(FilledMapAggregatedFieldWellsProperty filledMapAggregatedFieldWells) {
                this.filledMapAggregatedFieldWells = filledMapAggregatedFieldWells;
                return this;
            }

            public FilledMapFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getMapStyleOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getWindowOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapConfigurationProperty> {
            Object fieldWells;
            Object legend;
            Object mapStyleOptions;
            Object sortConfiguration;
            Object tooltip;
            Object windowOptions;

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(FilledMapFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder mapStyleOptions(IResolvable mapStyleOptions) {
                this.mapStyleOptions = mapStyleOptions;
                return this;
            }

            public Builder mapStyleOptions(GeospatialMapStyleOptionsProperty mapStyleOptions) {
                this.mapStyleOptions = mapStyleOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(FilledMapSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder windowOptions(IResolvable windowOptions) {
                this.windowOptions = windowOptions;
                return this;
            }

            public Builder windowOptions(GeospatialWindowOptionsProperty windowOptions) {
                this.windowOptions = windowOptions;
                return this;
            }

            public FilledMapConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapConditionalFormattingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapConditionalFormattingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConditionalFormattingOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapConditionalFormattingProperty> {
            Object conditionalFormattingOptions;

            public Builder conditionalFormattingOptions(IResolvable conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public Builder conditionalFormattingOptions(List<? extends Object> conditionalFormattingOptions) {
                this.conditionalFormattingOptions = conditionalFormattingOptions;
                return this;
            }

            public FilledMapConditionalFormattingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapConditionalFormattingOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapConditionalFormattingOptionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getShape();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapConditionalFormattingOptionProperty> {
            Object shape;

            public Builder shape(IResolvable shape) {
                this.shape = shape;
                return this;
            }

            public Builder shape(FilledMapShapeConditionalFormattingProperty shape) {
                this.shape = shape;
                return this;
            }

            public FilledMapConditionalFormattingOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FilledMapAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilledMapAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGeospatial() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilledMapAggregatedFieldWellsProperty> {
            Object geospatial;
            Object values;

            public Builder geospatial(IResolvable geospatial) {
                this.geospatial = geospatial;
                return this;
            }

            public Builder geospatial(List<? extends Object> geospatial) {
                this.geospatial = geospatial;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public FilledMapAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldTooltipItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldTooltipItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public String getLabel() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldTooltipItemProperty> {
            String fieldId;
            String label;
            String visibility;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder label(String label) {
                this.label = label;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FieldTooltipItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldSortProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldSortProperty
    extends JsiiSerializable {
        @NotNull
        public String getDirection();

        @NotNull
        public String getFieldId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldSortProperty> {
            String direction;
            String fieldId;

            public Builder direction(String direction) {
                this.direction = direction;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public FieldSortProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldSortOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldSortOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumnSort() {
            return null;
        }

        @Nullable
        default public Object getFieldSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldSortOptionsProperty> {
            Object columnSort;
            Object fieldSort;

            public Builder columnSort(IResolvable columnSort) {
                this.columnSort = columnSort;
                return this;
            }

            public Builder columnSort(ColumnSortProperty columnSort) {
                this.columnSort = columnSort;
                return this;
            }

            public Builder fieldSort(IResolvable fieldSort) {
                this.fieldSort = fieldSort;
                return this;
            }

            public Builder fieldSort(FieldSortProperty fieldSort) {
                this.fieldSort = fieldSort;
                return this;
            }

            public FieldSortOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldSeriesItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldSeriesItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getAxisBinding();

        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldSeriesItemProperty> {
            String axisBinding;
            String fieldId;
            Object settings;

            public Builder axisBinding(String axisBinding) {
                this.axisBinding = axisBinding;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder settings(IResolvable settings) {
                this.settings = settings;
                return this;
            }

            public Builder settings(LineChartSeriesSettingsProperty settings) {
                this.settings = settings;
                return this;
            }

            public FieldSeriesItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFieldId() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldLabelTypeProperty> {
            String fieldId;
            String visibility;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public FieldLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.FieldBasedTooltipProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldBasedTooltipProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAggregationVisibility() {
            return null;
        }

        @Nullable
        default public Object getTooltipFields() {
            return null;
        }

        @Nullable
        default public String getTooltipTitleType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldBasedTooltipProperty> {
            String aggregationVisibility;
            Object tooltipFields;
            String tooltipTitleType;

            public Builder aggregationVisibility(String aggregationVisibility) {
                this.aggregationVisibility = aggregationVisibility;
                return this;
            }

            public Builder tooltipFields(IResolvable tooltipFields) {
                this.tooltipFields = tooltipFields;
                return this;
            }

            public Builder tooltipFields(List<? extends Object> tooltipFields) {
                this.tooltipFields = tooltipFields;
                return this;
            }

            public Builder tooltipTitleType(String tooltipTitleType) {
                this.tooltipTitleType = tooltipTitleType;
                return this;
            }

            public FieldBasedTooltipProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ExplicitHierarchyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExplicitHierarchyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumns();

        @NotNull
        public String getHierarchyId();

        @Nullable
        default public Object getDrillDownFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExplicitHierarchyProperty> {
            Object columns;
            String hierarchyId;
            Object drillDownFilters;

            public Builder columns(IResolvable columns) {
                this.columns = columns;
                return this;
            }

            public Builder columns(List<? extends Object> columns) {
                this.columns = columns;
                return this;
            }

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public Builder drillDownFilters(IResolvable drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public Builder drillDownFilters(List<? extends Object> drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public ExplicitHierarchyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ExcludePeriodConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExcludePeriodConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getAmount();

        @NotNull
        public String getGranularity();

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExcludePeriodConfigurationProperty> {
            Number amount;
            String granularity;
            String status;

            public Builder amount(Number amount) {
                this.amount = amount;
                return this;
            }

            public Builder granularity(String granularity) {
                this.granularity = granularity;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public ExcludePeriodConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.EntityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EntityProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EntityProperty> {
            String path;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public EntityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.EmptyVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmptyVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetIdentifier();

        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmptyVisualProperty> {
            String dataSetIdentifier;
            String visualId;
            Object actions;

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public EmptyVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DynamicDefaultValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamicDefaultValueProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDefaultValueColumn();

        @Nullable
        default public Object getGroupNameColumn() {
            return null;
        }

        @Nullable
        default public Object getUserNameColumn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamicDefaultValueProperty> {
            Object defaultValueColumn;
            Object groupNameColumn;
            Object userNameColumn;

            public Builder defaultValueColumn(IResolvable defaultValueColumn) {
                this.defaultValueColumn = defaultValueColumn;
                return this;
            }

            public Builder defaultValueColumn(ColumnIdentifierProperty defaultValueColumn) {
                this.defaultValueColumn = defaultValueColumn;
                return this;
            }

            public Builder groupNameColumn(IResolvable groupNameColumn) {
                this.groupNameColumn = groupNameColumn;
                return this;
            }

            public Builder groupNameColumn(ColumnIdentifierProperty groupNameColumn) {
                this.groupNameColumn = groupNameColumn;
                return this;
            }

            public Builder userNameColumn(IResolvable userNameColumn) {
                this.userNameColumn = userNameColumn;
                return this;
            }

            public Builder userNameColumn(ColumnIdentifierProperty userNameColumn) {
                this.userNameColumn = userNameColumn;
                return this;
            }

            public DynamicDefaultValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DropDownControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSelectAllOptions() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DropDownControlDisplayOptionsProperty> {
            Object selectAllOptions;
            Object titleOptions;

            public Builder selectAllOptions(IResolvable selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public Builder selectAllOptions(ListControlSelectAllOptionsProperty selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public DropDownControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DrillDownFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DrillDownFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryFilter() {
            return null;
        }

        @Nullable
        default public Object getNumericEqualityFilter() {
            return null;
        }

        @Nullable
        default public Object getTimeRangeFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DrillDownFilterProperty> {
            Object categoryFilter;
            Object numericEqualityFilter;
            Object timeRangeFilter;

            public Builder categoryFilter(IResolvable categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            public Builder categoryFilter(CategoryDrillDownFilterProperty categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            public Builder numericEqualityFilter(IResolvable numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            public Builder numericEqualityFilter(NumericEqualityDrillDownFilterProperty numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            public Builder timeRangeFilter(IResolvable timeRangeFilter) {
                this.timeRangeFilter = timeRangeFilter;
                return this;
            }

            public Builder timeRangeFilter(TimeRangeDrillDownFilterProperty timeRangeFilter) {
                this.timeRangeFilter = timeRangeFilter;
                return this;
            }

            public DrillDownFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DonutOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DonutOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArcOptions() {
            return null;
        }

        @Nullable
        default public Object getDonutCenterOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DonutOptionsProperty> {
            Object arcOptions;
            Object donutCenterOptions;

            public Builder arcOptions(IResolvable arcOptions) {
                this.arcOptions = arcOptions;
                return this;
            }

            public Builder arcOptions(ArcOptionsProperty arcOptions) {
                this.arcOptions = arcOptions;
                return this;
            }

            public Builder donutCenterOptions(IResolvable donutCenterOptions) {
                this.donutCenterOptions = donutCenterOptions;
                return this;
            }

            public Builder donutCenterOptions(DonutCenterOptionsProperty donutCenterOptions) {
                this.donutCenterOptions = donutCenterOptions;
                return this;
            }

            public DonutOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DonutCenterOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DonutCenterOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLabelVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DonutCenterOptionsProperty> {
            String labelVisibility;

            public Builder labelVisibility(String labelVisibility) {
                this.labelVisibility = labelVisibility;
                return this;
            }

            public DonutCenterOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DimensionFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DimensionFieldProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoricalDimensionField() {
            return null;
        }

        @Nullable
        default public Object getDateDimensionField() {
            return null;
        }

        @Nullable
        default public Object getNumericalDimensionField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DimensionFieldProperty> {
            Object categoricalDimensionField;
            Object dateDimensionField;
            Object numericalDimensionField;

            public Builder categoricalDimensionField(IResolvable categoricalDimensionField) {
                this.categoricalDimensionField = categoricalDimensionField;
                return this;
            }

            public Builder categoricalDimensionField(CategoricalDimensionFieldProperty categoricalDimensionField) {
                this.categoricalDimensionField = categoricalDimensionField;
                return this;
            }

            public Builder dateDimensionField(IResolvable dateDimensionField) {
                this.dateDimensionField = dateDimensionField;
                return this;
            }

            public Builder dateDimensionField(DateDimensionFieldProperty dateDimensionField) {
                this.dateDimensionField = dateDimensionField;
                return this;
            }

            public Builder numericalDimensionField(IResolvable numericalDimensionField) {
                this.numericalDimensionField = numericalDimensionField;
                return this;
            }

            public Builder numericalDimensionField(NumericalDimensionFieldProperty numericalDimensionField) {
                this.numericalDimensionField = numericalDimensionField;
                return this;
            }

            public DimensionFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationParameterValueConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomValuesConfiguration() {
            return null;
        }

        @Nullable
        default public String getSelectAllValueOptions() {
            return null;
        }

        @Nullable
        default public String getSourceField() {
            return null;
        }

        @Nullable
        default public String getSourceParameterName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationParameterValueConfigurationProperty> {
            Object customValuesConfiguration;
            String selectAllValueOptions;
            String sourceField;
            String sourceParameterName;

            public Builder customValuesConfiguration(IResolvable customValuesConfiguration) {
                this.customValuesConfiguration = customValuesConfiguration;
                return this;
            }

            public Builder customValuesConfiguration(CustomValuesConfigurationProperty customValuesConfiguration) {
                this.customValuesConfiguration = customValuesConfiguration;
                return this;
            }

            public Builder selectAllValueOptions(String selectAllValueOptions) {
                this.selectAllValueOptions = selectAllValueOptions;
                return this;
            }

            public Builder sourceField(String sourceField) {
                this.sourceField = sourceField;
                return this;
            }

            public Builder sourceParameterName(String sourceParameterName) {
                this.sourceParameterName = sourceParameterName;
                return this;
            }

            public DestinationParameterValueConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultSectionBasedLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCanvasSizeOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultSectionBasedLayoutConfigurationProperty> {
            Object canvasSizeOptions;

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public DefaultSectionBasedLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultPaginatedLayoutConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSectionBased() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultPaginatedLayoutConfigurationProperty> {
            Object sectionBased;

            public Builder sectionBased(IResolvable sectionBased) {
                this.sectionBased = sectionBased;
                return this;
            }

            public Builder sectionBased(DefaultSectionBasedLayoutConfigurationProperty sectionBased) {
                this.sectionBased = sectionBased;
                return this;
            }

            public DefaultPaginatedLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultNewSheetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInteractiveLayoutConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPaginatedLayoutConfiguration() {
            return null;
        }

        @Nullable
        default public String getSheetContentType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultNewSheetConfigurationProperty> {
            Object interactiveLayoutConfiguration;
            Object paginatedLayoutConfiguration;
            String sheetContentType;

            public Builder interactiveLayoutConfiguration(IResolvable interactiveLayoutConfiguration) {
                this.interactiveLayoutConfiguration = interactiveLayoutConfiguration;
                return this;
            }

            public Builder interactiveLayoutConfiguration(DefaultInteractiveLayoutConfigurationProperty interactiveLayoutConfiguration) {
                this.interactiveLayoutConfiguration = interactiveLayoutConfiguration;
                return this;
            }

            public Builder paginatedLayoutConfiguration(IResolvable paginatedLayoutConfiguration) {
                this.paginatedLayoutConfiguration = paginatedLayoutConfiguration;
                return this;
            }

            public Builder paginatedLayoutConfiguration(DefaultPaginatedLayoutConfigurationProperty paginatedLayoutConfiguration) {
                this.paginatedLayoutConfiguration = paginatedLayoutConfiguration;
                return this;
            }

            public Builder sheetContentType(String sheetContentType) {
                this.sheetContentType = sheetContentType;
                return this;
            }

            public DefaultNewSheetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultInteractiveLayoutConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFreeForm() {
            return null;
        }

        @Nullable
        default public Object getGrid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultInteractiveLayoutConfigurationProperty> {
            Object freeForm;
            Object grid;

            public Builder freeForm(IResolvable freeForm) {
                this.freeForm = freeForm;
                return this;
            }

            public Builder freeForm(DefaultFreeFormLayoutConfigurationProperty freeForm) {
                this.freeForm = freeForm;
                return this;
            }

            public Builder grid(IResolvable grid) {
                this.grid = grid;
                return this;
            }

            public Builder grid(DefaultGridLayoutConfigurationProperty grid) {
                this.grid = grid;
                return this;
            }

            public DefaultInteractiveLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultGridLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCanvasSizeOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultGridLayoutConfigurationProperty> {
            Object canvasSizeOptions;

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public DefaultGridLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultFreeFormLayoutConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCanvasSizeOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultFreeFormLayoutConfigurationProperty> {
            Object canvasSizeOptions;

            public Builder canvasSizeOptions(IResolvable canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty canvasSizeOptions) {
                this.canvasSizeOptions = canvasSizeOptions;
                return this;
            }

            public DefaultFreeFormLayoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecimalValueWhenUnsetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCustomValue() {
            return null;
        }

        @Nullable
        default public String getValueWhenUnsetOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecimalValueWhenUnsetConfigurationProperty> {
            Number customValue;
            String valueWhenUnsetOption;

            public Builder customValue(Number customValue) {
                this.customValue = customValue;
                return this;
            }

            public Builder valueWhenUnsetOption(String valueWhenUnsetOption) {
                this.valueWhenUnsetOption = valueWhenUnsetOption;
                return this;
            }

            public DecimalValueWhenUnsetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecimalPlacesConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDecimalPlaces();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecimalPlacesConfigurationProperty> {
            Number decimalPlaces;

            public Builder decimalPlaces(Number decimalPlaces) {
                this.decimalPlaces = decimalPlaces;
                return this;
            }

            public DecimalPlacesConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecimalParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Object getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecimalParameterProperty> {
            String name;
            Object values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<? extends Number> values) {
                this.values = values;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public DecimalParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecimalParameterDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getParameterValueType();

        @Nullable
        default public Object getDefaultValues() {
            return null;
        }

        @Nullable
        default public Object getMappedDataSetParameters() {
            return null;
        }

        @Nullable
        default public Object getValueWhenUnset() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecimalParameterDeclarationProperty> {
            String name;
            String parameterValueType;
            Object defaultValues;
            Object mappedDataSetParameters;
            Object valueWhenUnset;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameterValueType(String parameterValueType) {
                this.parameterValueType = parameterValueType;
                return this;
            }

            public Builder defaultValues(IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder defaultValues(DecimalDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder mappedDataSetParameters(IResolvable mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder mappedDataSetParameters(List<? extends Object> mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder valueWhenUnset(IResolvable valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public Builder valueWhenUnset(DecimalValueWhenUnsetConfigurationProperty valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public DecimalParameterDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalDefaultValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecimalDefaultValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDynamicValue() {
            return null;
        }

        @Nullable
        default public Object getStaticValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecimalDefaultValuesProperty> {
            Object dynamicValue;
            Object staticValues;

            public Builder dynamicValue(IResolvable dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder dynamicValue(DynamicDefaultValueProperty dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder staticValues(List<? extends Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public Builder staticValues(IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public DecimalDefaultValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeValueWhenUnsetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCustomValue() {
            return null;
        }

        @Nullable
        default public String getValueWhenUnsetOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeValueWhenUnsetConfigurationProperty> {
            String customValue;
            String valueWhenUnsetOption;

            public Builder customValue(String customValue) {
                this.customValue = customValue;
                return this;
            }

            public Builder valueWhenUnsetOption(String valueWhenUnsetOption) {
                this.valueWhenUnsetOption = valueWhenUnsetOption;
                return this;
            }

            public DateTimeValueWhenUnsetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimePickerControlDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDateTimeFormat() {
            return null;
        }

        @Nullable
        default public Object getTitleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimePickerControlDisplayOptionsProperty> {
            String dateTimeFormat;
            Object titleOptions;

            public Builder dateTimeFormat(String dateTimeFormat) {
                this.dateTimeFormat = dateTimeFormat;
                return this;
            }

            public Builder titleOptions(IResolvable titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public Builder titleOptions(LabelOptionsProperty titleOptions) {
                this.titleOptions = titleOptions;
                return this;
            }

            public DateTimePickerControlDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeParameterProperty> {
            String name;
            List<String> values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public DateTimeParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeParameterDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public Object getDefaultValues() {
            return null;
        }

        @Nullable
        default public Object getMappedDataSetParameters() {
            return null;
        }

        @Nullable
        default public String getTimeGranularity() {
            return null;
        }

        @Nullable
        default public Object getValueWhenUnset() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeParameterDeclarationProperty> {
            String name;
            Object defaultValues;
            Object mappedDataSetParameters;
            String timeGranularity;
            Object valueWhenUnset;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder defaultValues(IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder defaultValues(DateTimeDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            public Builder mappedDataSetParameters(IResolvable mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder mappedDataSetParameters(List<? extends Object> mappedDataSetParameters) {
                this.mappedDataSetParameters = mappedDataSetParameters;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public Builder valueWhenUnset(IResolvable valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public Builder valueWhenUnset(DateTimeValueWhenUnsetConfigurationProperty valueWhenUnset) {
                this.valueWhenUnset = valueWhenUnset;
                return this;
            }

            public DateTimeParameterDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeHierarchyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeHierarchyProperty
    extends JsiiSerializable {
        @NotNull
        public String getHierarchyId();

        @Nullable
        default public Object getDrillDownFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeHierarchyProperty> {
            String hierarchyId;
            Object drillDownFilters;

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public Builder drillDownFilters(IResolvable drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public Builder drillDownFilters(List<? extends Object> drillDownFilters) {
                this.drillDownFilters = drillDownFilters;
                return this;
            }

            public DateTimeHierarchyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDateTimeFormat() {
            return null;
        }

        @Nullable
        default public Object getNullValueFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNumericFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeFormatConfigurationProperty> {
            String dateTimeFormat;
            Object nullValueFormatConfiguration;
            Object numericFormatConfiguration;

            public Builder dateTimeFormat(String dateTimeFormat) {
                this.dateTimeFormat = dateTimeFormat;
                return this;
            }

            public Builder nullValueFormatConfiguration(IResolvable nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(NullValueFormatConfigurationProperty nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder numericFormatConfiguration(IResolvable numericFormatConfiguration) {
                this.numericFormatConfiguration = numericFormatConfiguration;
                return this;
            }

            public Builder numericFormatConfiguration(NumericFormatConfigurationProperty numericFormatConfiguration) {
                this.numericFormatConfiguration = numericFormatConfiguration;
                return this;
            }

            public DateTimeFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeDefaultValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateTimeDefaultValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDynamicValue() {
            return null;
        }

        @Nullable
        default public Object getRollingDate() {
            return null;
        }

        @Nullable
        default public List<String> getStaticValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateTimeDefaultValuesProperty> {
            Object dynamicValue;
            Object rollingDate;
            List<String> staticValues;

            public Builder dynamicValue(IResolvable dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder dynamicValue(DynamicDefaultValueProperty dynamicValue) {
                this.dynamicValue = dynamicValue;
                return this;
            }

            public Builder rollingDate(IResolvable rollingDate) {
                this.rollingDate = rollingDate;
                return this;
            }

            public Builder rollingDate(RollingDateConfigurationProperty rollingDate) {
                this.rollingDate = rollingDate;
                return this;
            }

            public Builder staticValues(List<String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            public DateTimeDefaultValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateMeasureFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateMeasureFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public String getAggregationFunction() {
            return null;
        }

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateMeasureFieldProperty> {
            Object column;
            String fieldId;
            String aggregationFunction;
            Object formatConfiguration;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder aggregationFunction(String aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(DateTimeFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public DateMeasureFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateDimensionFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateDimensionFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public String getDateGranularity() {
            return null;
        }

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getHierarchyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateDimensionFieldProperty> {
            Object column;
            String fieldId;
            String dateGranularity;
            Object formatConfiguration;
            String hierarchyId;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder dateGranularity(String dateGranularity) {
                this.dateGranularity = dateGranularity;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(DateTimeFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public DateDimensionFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateAxisOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateAxisOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMissingDateVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateAxisOptionsProperty> {
            String missingDateVisibility;

            public Builder missingDateVisibility(String missingDateVisibility) {
                this.missingDateVisibility = missingDateVisibility;
                return this;
            }

            public DateAxisOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetReferenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSetReferenceProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetArn();

        @NotNull
        public String getDataSetPlaceholder();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSetReferenceProperty> {
            String dataSetArn;
            String dataSetPlaceholder;

            public Builder dataSetArn(String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            public Builder dataSetPlaceholder(String dataSetPlaceholder) {
                this.dataSetPlaceholder = dataSetPlaceholder;
                return this;
            }

            public DataSetReferenceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetIdentifierDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSetIdentifierDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetArn();

        @NotNull
        public String getIdentifier();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSetIdentifierDeclarationProperty> {
            String dataSetArn;
            String identifier;

            public Builder dataSetArn(String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            public Builder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            public DataSetIdentifierDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataPathValueProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @NotNull
        public String getFieldValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataPathValueProperty> {
            String fieldId;
            String fieldValue;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder fieldValue(String fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            public DataPathValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathSortProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataPathSortProperty
    extends JsiiSerializable {
        @NotNull
        public String getDirection();

        @NotNull
        public Object getSortPaths();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataPathSortProperty> {
            String direction;
            Object sortPaths;

            public Builder direction(String direction) {
                this.direction = direction;
                return this;
            }

            public Builder sortPaths(IResolvable sortPaths) {
                this.sortPaths = sortPaths;
                return this;
            }

            public Builder sortPaths(List<? extends Object> sortPaths) {
                this.sortPaths = sortPaths;
                return this;
            }

            public DataPathSortProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataPathLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFieldId() {
            return null;
        }

        @Nullable
        default public String getFieldValue() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataPathLabelTypeProperty> {
            String fieldId;
            String fieldValue;
            String visibility;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder fieldValue(String fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public DataPathLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataPathColorProperty
    extends JsiiSerializable {
        @NotNull
        public String getColor();

        @NotNull
        public Object getElement();

        @Nullable
        default public String getTimeGranularity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataPathColorProperty> {
            String color;
            Object element;
            String timeGranularity;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder element(IResolvable element) {
                this.element = element;
                return this;
            }

            public Builder element(DataPathValueProperty element) {
                this.element = element;
                return this;
            }

            public Builder timeGranularity(String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            public DataPathColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataLabelTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataLabelTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataPathLabelType() {
            return null;
        }

        @Nullable
        default public Object getFieldLabelType() {
            return null;
        }

        @Nullable
        default public Object getMaximumLabelType() {
            return null;
        }

        @Nullable
        default public Object getMinimumLabelType() {
            return null;
        }

        @Nullable
        default public Object getRangeEndsLabelType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataLabelTypeProperty> {
            Object dataPathLabelType;
            Object fieldLabelType;
            Object maximumLabelType;
            Object minimumLabelType;
            Object rangeEndsLabelType;

            public Builder dataPathLabelType(IResolvable dataPathLabelType) {
                this.dataPathLabelType = dataPathLabelType;
                return this;
            }

            public Builder dataPathLabelType(DataPathLabelTypeProperty dataPathLabelType) {
                this.dataPathLabelType = dataPathLabelType;
                return this;
            }

            public Builder fieldLabelType(IResolvable fieldLabelType) {
                this.fieldLabelType = fieldLabelType;
                return this;
            }

            public Builder fieldLabelType(FieldLabelTypeProperty fieldLabelType) {
                this.fieldLabelType = fieldLabelType;
                return this;
            }

            public Builder maximumLabelType(IResolvable maximumLabelType) {
                this.maximumLabelType = maximumLabelType;
                return this;
            }

            public Builder maximumLabelType(MaximumLabelTypeProperty maximumLabelType) {
                this.maximumLabelType = maximumLabelType;
                return this;
            }

            public Builder minimumLabelType(IResolvable minimumLabelType) {
                this.minimumLabelType = minimumLabelType;
                return this;
            }

            public Builder minimumLabelType(MinimumLabelTypeProperty minimumLabelType) {
                this.minimumLabelType = minimumLabelType;
                return this;
            }

            public Builder rangeEndsLabelType(IResolvable rangeEndsLabelType) {
                this.rangeEndsLabelType = rangeEndsLabelType;
                return this;
            }

            public Builder rangeEndsLabelType(RangeEndsLabelTypeProperty rangeEndsLabelType) {
                this.rangeEndsLabelType = rangeEndsLabelType;
                return this;
            }

            public DataLabelTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCategoryLabelVisibility() {
            return null;
        }

        @Nullable
        default public Object getDataLabelTypes() {
            return null;
        }

        @Nullable
        default public String getLabelColor() {
            return null;
        }

        @Nullable
        default public String getLabelContent() {
            return null;
        }

        @Nullable
        default public Object getLabelFontConfiguration() {
            return null;
        }

        @Nullable
        default public String getMeasureLabelVisibility() {
            return null;
        }

        @Nullable
        default public String getOverlap() {
            return null;
        }

        @Nullable
        default public String getPosition() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataLabelOptionsProperty> {
            String categoryLabelVisibility;
            Object dataLabelTypes;
            String labelColor;
            String labelContent;
            Object labelFontConfiguration;
            String measureLabelVisibility;
            String overlap;
            String position;
            String visibility;

            public Builder categoryLabelVisibility(String categoryLabelVisibility) {
                this.categoryLabelVisibility = categoryLabelVisibility;
                return this;
            }

            public Builder dataLabelTypes(IResolvable dataLabelTypes) {
                this.dataLabelTypes = dataLabelTypes;
                return this;
            }

            public Builder dataLabelTypes(List<? extends Object> dataLabelTypes) {
                this.dataLabelTypes = dataLabelTypes;
                return this;
            }

            public Builder labelColor(String labelColor) {
                this.labelColor = labelColor;
                return this;
            }

            public Builder labelContent(String labelContent) {
                this.labelContent = labelContent;
                return this;
            }

            public Builder labelFontConfiguration(IResolvable labelFontConfiguration) {
                this.labelFontConfiguration = labelFontConfiguration;
                return this;
            }

            public Builder labelFontConfiguration(FontConfigurationProperty labelFontConfiguration) {
                this.labelFontConfiguration = labelFontConfiguration;
                return this;
            }

            public Builder measureLabelVisibility(String measureLabelVisibility) {
                this.measureLabelVisibility = measureLabelVisibility;
                return this;
            }

            public Builder overlap(String overlap) {
                this.overlap = overlap;
                return this;
            }

            public Builder position(String position) {
                this.position = position;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public DataLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataFieldSeriesItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataFieldSeriesItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getAxisBinding();

        @NotNull
        public String getFieldId();

        @Nullable
        default public String getFieldValue() {
            return null;
        }

        @Nullable
        default public Object getSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataFieldSeriesItemProperty> {
            String axisBinding;
            String fieldId;
            String fieldValue;
            Object settings;

            public Builder axisBinding(String axisBinding) {
                this.axisBinding = axisBinding;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder fieldValue(String fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            public Builder settings(IResolvable settings) {
                this.settings = settings;
                return this;
            }

            public Builder settings(LineChartSeriesSettingsProperty settings) {
                this.settings = settings;
                return this;
            }

            public DataFieldSeriesItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataColorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public Number getDataValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataColorProperty> {
            String color;
            Number dataValue;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder dataValue(Number dataValue) {
                this.dataValue = dataValue;
                return this;
            }

            public DataColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataBarsOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataBarsOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldId();

        @Nullable
        default public String getNegativeColor() {
            return null;
        }

        @Nullable
        default public String getPositiveColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataBarsOptionsProperty> {
            String fieldId;
            String negativeColor;
            String positiveColor;

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder negativeColor(String negativeColor) {
                this.negativeColor = negativeColor;
                return this;
            }

            public Builder positiveColor(String positiveColor) {
                this.positiveColor = positiveColor;
                return this;
            }

            public DataBarsOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomValuesConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomValuesConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCustomValues();

        @Nullable
        default public Object getIncludeNullValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomValuesConfigurationProperty> {
            Object customValues;
            Object includeNullValue;

            public Builder customValues(IResolvable customValues) {
                this.customValues = customValues;
                return this;
            }

            public Builder customValues(CustomParameterValuesProperty customValues) {
                this.customValues = customValues;
                return this;
            }

            public Builder includeNullValue(Boolean includeNullValue) {
                this.includeNullValue = includeNullValue;
                return this;
            }

            public Builder includeNullValue(IResolvable includeNullValue) {
                this.includeNullValue = includeNullValue;
                return this;
            }

            public CustomValuesConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomParameterValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomParameterValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getDateTimeValues() {
            return null;
        }

        @Nullable
        default public Object getDecimalValues() {
            return null;
        }

        @Nullable
        default public Object getIntegerValues() {
            return null;
        }

        @Nullable
        default public List<String> getStringValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomParameterValuesProperty> {
            List<String> dateTimeValues;
            Object decimalValues;
            Object integerValues;
            List<String> stringValues;

            public Builder dateTimeValues(List<String> dateTimeValues) {
                this.dateTimeValues = dateTimeValues;
                return this;
            }

            public Builder decimalValues(List<? extends Number> decimalValues) {
                this.decimalValues = decimalValues;
                return this;
            }

            public Builder decimalValues(IResolvable decimalValues) {
                this.decimalValues = decimalValues;
                return this;
            }

            public Builder integerValues(List<? extends Number> integerValues) {
                this.integerValues = integerValues;
                return this;
            }

            public Builder integerValues(IResolvable integerValues) {
                this.integerValues = integerValues;
                return this;
            }

            public Builder stringValues(List<String> stringValues) {
                this.stringValues = stringValues;
                return this;
            }

            public CustomParameterValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomNarrativeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomNarrativeOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getNarrative();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomNarrativeOptionsProperty> {
            String narrative;

            public Builder narrative(String narrative) {
                this.narrative = narrative;
                return this;
            }

            public CustomNarrativeOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomFilterListConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomFilterListConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMatchOperator();

        @NotNull
        public String getNullOption();

        @Nullable
        default public List<String> getCategoryValues() {
            return null;
        }

        @Nullable
        default public String getSelectAllOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomFilterListConfigurationProperty> {
            String matchOperator;
            String nullOption;
            List<String> categoryValues;
            String selectAllOptions;

            public Builder matchOperator(String matchOperator) {
                this.matchOperator = matchOperator;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder categoryValues(List<String> categoryValues) {
                this.categoryValues = categoryValues;
                return this;
            }

            public Builder selectAllOptions(String selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public CustomFilterListConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomFilterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomFilterConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMatchOperator();

        @NotNull
        public String getNullOption();

        @Nullable
        default public String getCategoryValue() {
            return null;
        }

        @Nullable
        default public String getParameterName() {
            return null;
        }

        @Nullable
        default public String getSelectAllOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomFilterConfigurationProperty> {
            String matchOperator;
            String nullOption;
            String categoryValue;
            String parameterName;
            String selectAllOptions;

            public Builder matchOperator(String matchOperator) {
                this.matchOperator = matchOperator;
                return this;
            }

            public Builder nullOption(String nullOption) {
                this.nullOption = nullOption;
                return this;
            }

            public Builder categoryValue(String categoryValue) {
                this.categoryValue = categoryValue;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder selectAllOptions(String selectAllOptions) {
                this.selectAllOptions = selectAllOptions;
                return this;
            }

            public CustomFilterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomContentVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomContentVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetIdentifier();

        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomContentVisualProperty> {
            String dataSetIdentifier;
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object subtitle;
            Object title;

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(CustomContentConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public CustomContentVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomContentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomContentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContentType() {
            return null;
        }

        @Nullable
        default public String getContentUrl() {
            return null;
        }

        @Nullable
        default public String getImageScaling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomContentConfigurationProperty> {
            String contentType;
            String contentUrl;
            String imageScaling;

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder contentUrl(String contentUrl) {
                this.contentUrl = contentUrl;
                return this;
            }

            public Builder imageScaling(String imageScaling) {
                this.imageScaling = imageScaling;
                return this;
            }

            public CustomContentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomColorProperty
    extends JsiiSerializable {
        @NotNull
        public String getColor();

        @Nullable
        default public String getFieldValue() {
            return null;
        }

        @Nullable
        default public String getSpecialValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomColorProperty> {
            String color;
            String fieldValue;
            String specialValue;

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder fieldValue(String fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            public Builder specialValue(String specialValue) {
                this.specialValue = specialValue;
                return this;
            }

            public CustomColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionURLOperationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomActionURLOperationProperty
    extends JsiiSerializable {
        @NotNull
        public String getUrlTarget();

        @NotNull
        public String getUrlTemplate();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomActionURLOperationProperty> {
            String urlTarget;
            String urlTemplate;

            public Builder urlTarget(String urlTarget) {
                this.urlTarget = urlTarget;
                return this;
            }

            public Builder urlTemplate(String urlTemplate) {
                this.urlTemplate = urlTemplate;
                return this;
            }

            public CustomActionURLOperationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomActionSetParametersOperationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getParameterValueConfigurations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomActionSetParametersOperationProperty> {
            Object parameterValueConfigurations;

            public Builder parameterValueConfigurations(IResolvable parameterValueConfigurations) {
                this.parameterValueConfigurations = parameterValueConfigurations;
                return this;
            }

            public Builder parameterValueConfigurations(List<? extends Object> parameterValueConfigurations) {
                this.parameterValueConfigurations = parameterValueConfigurations;
                return this;
            }

            public CustomActionSetParametersOperationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionNavigationOperationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomActionNavigationOperationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLocalNavigationConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomActionNavigationOperationProperty> {
            Object localNavigationConfiguration;

            public Builder localNavigationConfiguration(IResolvable localNavigationConfiguration) {
                this.localNavigationConfiguration = localNavigationConfiguration;
                return this;
            }

            public Builder localNavigationConfiguration(LocalNavigationConfigurationProperty localNavigationConfiguration) {
                this.localNavigationConfiguration = localNavigationConfiguration;
                return this;
            }

            public CustomActionNavigationOperationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionFilterOperationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomActionFilterOperationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSelectedFieldsConfiguration();

        @NotNull
        public Object getTargetVisualsConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomActionFilterOperationProperty> {
            Object selectedFieldsConfiguration;
            Object targetVisualsConfiguration;

            public Builder selectedFieldsConfiguration(IResolvable selectedFieldsConfiguration) {
                this.selectedFieldsConfiguration = selectedFieldsConfiguration;
                return this;
            }

            public Builder selectedFieldsConfiguration(FilterOperationSelectedFieldsConfigurationProperty selectedFieldsConfiguration) {
                this.selectedFieldsConfiguration = selectedFieldsConfiguration;
                return this;
            }

            public Builder targetVisualsConfiguration(IResolvable targetVisualsConfiguration) {
                this.targetVisualsConfiguration = targetVisualsConfiguration;
                return this;
            }

            public Builder targetVisualsConfiguration(FilterOperationTargetVisualsConfigurationProperty targetVisualsConfiguration) {
                this.targetVisualsConfiguration = targetVisualsConfiguration;
                return this;
            }

            public CustomActionFilterOperationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CurrencyDisplayFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDecimalPlacesConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNegativeValueConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNullValueFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getNumberScale() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getSeparatorConfiguration() {
            return null;
        }

        @Nullable
        default public String getSuffix() {
            return null;
        }

        @Nullable
        default public String getSymbol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CurrencyDisplayFormatConfigurationProperty> {
            Object decimalPlacesConfiguration;
            Object negativeValueConfiguration;
            Object nullValueFormatConfiguration;
            String numberScale;
            String prefix;
            Object separatorConfiguration;
            String suffix;
            String symbol;

            public Builder decimalPlacesConfiguration(IResolvable decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder decimalPlacesConfiguration(DecimalPlacesConfigurationProperty decimalPlacesConfiguration) {
                this.decimalPlacesConfiguration = decimalPlacesConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(IResolvable negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder negativeValueConfiguration(NegativeValueConfigurationProperty negativeValueConfiguration) {
                this.negativeValueConfiguration = negativeValueConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(IResolvable nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder nullValueFormatConfiguration(NullValueFormatConfigurationProperty nullValueFormatConfiguration) {
                this.nullValueFormatConfiguration = nullValueFormatConfiguration;
                return this;
            }

            public Builder numberScale(String numberScale) {
                this.numberScale = numberScale;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder separatorConfiguration(IResolvable separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder separatorConfiguration(NumericSeparatorConfigurationProperty separatorConfiguration) {
                this.separatorConfiguration = separatorConfiguration;
                return this;
            }

            public Builder suffix(String suffix) {
                this.suffix = suffix;
                return this;
            }

            public Builder symbol(String symbol) {
                this.symbol = symbol;
                return this;
            }

            public CurrencyDisplayFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ContributionAnalysisDefaultProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContributionAnalysisDefaultProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContributorDimensions();

        @NotNull
        public String getMeasureFieldId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContributionAnalysisDefaultProperty> {
            Object contributorDimensions;
            String measureFieldId;

            public Builder contributorDimensions(IResolvable contributorDimensions) {
                this.contributorDimensions = contributorDimensions;
                return this;
            }

            public Builder contributorDimensions(List<? extends Object> contributorDimensions) {
                this.contributorDimensions = contributorDimensions;
                return this;
            }

            public Builder measureFieldId(String measureFieldId) {
                this.measureFieldId = measureFieldId;
                return this;
            }

            public ContributionAnalysisDefaultProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingSolidColorProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @Nullable
        default public String getColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingSolidColorProperty> {
            String expression;
            String color;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public ConditionalFormattingSolidColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingIconSetProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @Nullable
        default public String getIconSetType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingIconSetProperty> {
            String expression;
            String iconSetType;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder iconSetType(String iconSetType) {
                this.iconSetType = iconSetType;
                return this;
            }

            public ConditionalFormattingIconSetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingIconProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomCondition() {
            return null;
        }

        @Nullable
        default public Object getIconSet() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingIconProperty> {
            Object customCondition;
            Object iconSet;

            public Builder customCondition(IResolvable customCondition) {
                this.customCondition = customCondition;
                return this;
            }

            public Builder customCondition(ConditionalFormattingCustomIconConditionProperty customCondition) {
                this.customCondition = customCondition;
                return this;
            }

            public Builder iconSet(IResolvable iconSet) {
                this.iconSet = iconSet;
                return this;
            }

            public Builder iconSet(ConditionalFormattingIconSetProperty iconSet) {
                this.iconSet = iconSet;
                return this;
            }

            public ConditionalFormattingIconProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingIconDisplayConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getIconDisplayOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingIconDisplayConfigurationProperty> {
            String iconDisplayOption;

            public Builder iconDisplayOption(String iconDisplayOption) {
                this.iconDisplayOption = iconDisplayOption;
                return this;
            }

            public ConditionalFormattingIconDisplayConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingGradientColorProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColor();

        @NotNull
        public String getExpression();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingGradientColorProperty> {
            Object color;
            String expression;

            public Builder color(IResolvable color) {
                this.color = color;
                return this;
            }

            public Builder color(GradientColorProperty color) {
                this.color = color;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public ConditionalFormattingGradientColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingCustomIconOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getIcon() {
            return null;
        }

        @Nullable
        default public String getUnicodeIcon() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingCustomIconOptionsProperty> {
            String icon;
            String unicodeIcon;

            public Builder icon(String icon) {
                this.icon = icon;
                return this;
            }

            public Builder unicodeIcon(String unicodeIcon) {
                this.unicodeIcon = unicodeIcon;
                return this;
            }

            public ConditionalFormattingCustomIconOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingCustomIconConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingCustomIconConditionProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public Object getIconOptions();

        @Nullable
        default public String getColor() {
            return null;
        }

        @Nullable
        default public Object getDisplayConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingCustomIconConditionProperty> {
            String expression;
            Object iconOptions;
            String color;
            Object displayConfiguration;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder iconOptions(IResolvable iconOptions) {
                this.iconOptions = iconOptions;
                return this;
            }

            public Builder iconOptions(ConditionalFormattingCustomIconOptionsProperty iconOptions) {
                this.iconOptions = iconOptions;
                return this;
            }

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder displayConfiguration(IResolvable displayConfiguration) {
                this.displayConfiguration = displayConfiguration;
                return this;
            }

            public Builder displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty displayConfiguration) {
                this.displayConfiguration = displayConfiguration;
                return this;
            }

            public ConditionalFormattingCustomIconConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingColorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionalFormattingColorProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGradient() {
            return null;
        }

        @Nullable
        default public Object getSolid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionalFormattingColorProperty> {
            Object gradient;
            Object solid;

            public Builder gradient(IResolvable gradient) {
                this.gradient = gradient;
                return this;
            }

            public Builder gradient(ConditionalFormattingGradientColorProperty gradient) {
                this.gradient = gradient;
                return this;
            }

            public Builder solid(IResolvable solid) {
                this.solid = solid;
                return this;
            }

            public Builder solid(ConditionalFormattingSolidColorProperty solid) {
                this.solid = solid;
                return this;
            }

            public ConditionalFormattingColorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComputationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComputationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getForecast() {
            return null;
        }

        @Nullable
        default public Object getGrowthRate() {
            return null;
        }

        @Nullable
        default public Object getMaximumMinimum() {
            return null;
        }

        @Nullable
        default public Object getMetricComparison() {
            return null;
        }

        @Nullable
        default public Object getPeriodOverPeriod() {
            return null;
        }

        @Nullable
        default public Object getPeriodToDate() {
            return null;
        }

        @Nullable
        default public Object getTopBottomMovers() {
            return null;
        }

        @Nullable
        default public Object getTopBottomRanked() {
            return null;
        }

        @Nullable
        default public Object getTotalAggregation() {
            return null;
        }

        @Nullable
        default public Object getUniqueValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComputationProperty> {
            Object forecast;
            Object growthRate;
            Object maximumMinimum;
            Object metricComparison;
            Object periodOverPeriod;
            Object periodToDate;
            Object topBottomMovers;
            Object topBottomRanked;
            Object totalAggregation;
            Object uniqueValues;

            public Builder forecast(IResolvable forecast) {
                this.forecast = forecast;
                return this;
            }

            public Builder forecast(ForecastComputationProperty forecast) {
                this.forecast = forecast;
                return this;
            }

            public Builder growthRate(IResolvable growthRate) {
                this.growthRate = growthRate;
                return this;
            }

            public Builder growthRate(GrowthRateComputationProperty growthRate) {
                this.growthRate = growthRate;
                return this;
            }

            public Builder maximumMinimum(IResolvable maximumMinimum) {
                this.maximumMinimum = maximumMinimum;
                return this;
            }

            public Builder maximumMinimum(MaximumMinimumComputationProperty maximumMinimum) {
                this.maximumMinimum = maximumMinimum;
                return this;
            }

            public Builder metricComparison(IResolvable metricComparison) {
                this.metricComparison = metricComparison;
                return this;
            }

            public Builder metricComparison(MetricComparisonComputationProperty metricComparison) {
                this.metricComparison = metricComparison;
                return this;
            }

            public Builder periodOverPeriod(IResolvable periodOverPeriod) {
                this.periodOverPeriod = periodOverPeriod;
                return this;
            }

            public Builder periodOverPeriod(PeriodOverPeriodComputationProperty periodOverPeriod) {
                this.periodOverPeriod = periodOverPeriod;
                return this;
            }

            public Builder periodToDate(IResolvable periodToDate) {
                this.periodToDate = periodToDate;
                return this;
            }

            public Builder periodToDate(PeriodToDateComputationProperty periodToDate) {
                this.periodToDate = periodToDate;
                return this;
            }

            public Builder topBottomMovers(IResolvable topBottomMovers) {
                this.topBottomMovers = topBottomMovers;
                return this;
            }

            public Builder topBottomMovers(TopBottomMoversComputationProperty topBottomMovers) {
                this.topBottomMovers = topBottomMovers;
                return this;
            }

            public Builder topBottomRanked(IResolvable topBottomRanked) {
                this.topBottomRanked = topBottomRanked;
                return this;
            }

            public Builder topBottomRanked(TopBottomRankedComputationProperty topBottomRanked) {
                this.topBottomRanked = topBottomRanked;
                return this;
            }

            public Builder totalAggregation(IResolvable totalAggregation) {
                this.totalAggregation = totalAggregation;
                return this;
            }

            public Builder totalAggregation(TotalAggregationComputationProperty totalAggregation) {
                this.totalAggregation = totalAggregation;
                return this;
            }

            public Builder uniqueValues(IResolvable uniqueValues) {
                this.uniqueValues = uniqueValues;
                return this;
            }

            public Builder uniqueValues(UniqueValuesComputationProperty uniqueValues) {
                this.uniqueValues = uniqueValues;
                return this;
            }

            public ComputationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComparisonFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComparisonFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getNumberDisplayFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPercentageDisplayFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComparisonFormatConfigurationProperty> {
            Object numberDisplayFormatConfiguration;
            Object percentageDisplayFormatConfiguration;

            public Builder numberDisplayFormatConfiguration(IResolvable numberDisplayFormatConfiguration) {
                this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
                return this;
            }

            public Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty numberDisplayFormatConfiguration) {
                this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
                return this;
            }

            public Builder percentageDisplayFormatConfiguration(IResolvable percentageDisplayFormatConfiguration) {
                this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
                return this;
            }

            public Builder percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty percentageDisplayFormatConfiguration) {
                this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
                return this;
            }

            public ComparisonFormatConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComparisonConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComparisonConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getComparisonFormat() {
            return null;
        }

        @Nullable
        default public String getComparisonMethod() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComparisonConfigurationProperty> {
            Object comparisonFormat;
            String comparisonMethod;

            public Builder comparisonFormat(IResolvable comparisonFormat) {
                this.comparisonFormat = comparisonFormat;
                return this;
            }

            public Builder comparisonFormat(ComparisonFormatConfigurationProperty comparisonFormat) {
                this.comparisonFormat = comparisonFormat;
                return this;
            }

            public Builder comparisonMethod(String comparisonMethod) {
                this.comparisonMethod = comparisonMethod;
                return this;
            }

            public ComparisonConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComboChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComboChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(ComboChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public ComboChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComboChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getColorItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getColorSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComboChartSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;
            Object colorItemsLimit;
            Object colorSort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder colorItemsLimit(IResolvable colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorItemsLimit(ItemsLimitConfigurationProperty colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorSort(IResolvable colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public Builder colorSort(List<? extends Object> colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public ComboChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComboChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getComboChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComboChartFieldWellsProperty> {
            Object comboChartAggregatedFieldWells;

            public Builder comboChartAggregatedFieldWells(IResolvable comboChartAggregatedFieldWells) {
                this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells;
                return this;
            }

            public Builder comboChartAggregatedFieldWells(ComboChartAggregatedFieldWellsProperty comboChartAggregatedFieldWells) {
                this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells;
                return this;
            }

            public ComboChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComboChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBarDataLabels() {
            return null;
        }

        @Nullable
        default public String getBarsArrangement() {
            return null;
        }

        @Nullable
        default public Object getCategoryAxis() {
            return null;
        }

        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getColorLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getLineDataLabels() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getReferenceLines() {
            return null;
        }

        @Nullable
        default public Object getSecondaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getSecondaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComboChartConfigurationProperty> {
            Object barDataLabels;
            String barsArrangement;
            Object categoryAxis;
            Object categoryLabelOptions;
            Object colorLabelOptions;
            Object fieldWells;
            Object legend;
            Object lineDataLabels;
            Object primaryYAxisDisplayOptions;
            Object primaryYAxisLabelOptions;
            Object referenceLines;
            Object secondaryYAxisDisplayOptions;
            Object secondaryYAxisLabelOptions;
            Object sortConfiguration;
            Object tooltip;
            Object visualPalette;

            public Builder barDataLabels(IResolvable barDataLabels) {
                this.barDataLabels = barDataLabels;
                return this;
            }

            public Builder barDataLabels(DataLabelOptionsProperty barDataLabels) {
                this.barDataLabels = barDataLabels;
                return this;
            }

            public Builder barsArrangement(String barsArrangement) {
                this.barsArrangement = barsArrangement;
                return this;
            }

            public Builder categoryAxis(IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryAxis(AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(ComboChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder lineDataLabels(IResolvable lineDataLabels) {
                this.lineDataLabels = lineDataLabels;
                return this;
            }

            public Builder lineDataLabels(DataLabelOptionsProperty lineDataLabels) {
                this.lineDataLabels = lineDataLabels;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(AxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder referenceLines(IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder referenceLines(List<? extends Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder secondaryYAxisDisplayOptions(IResolvable secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            public Builder secondaryYAxisDisplayOptions(AxisDisplayOptionsProperty secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            public Builder secondaryYAxisLabelOptions(IResolvable secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            public Builder secondaryYAxisLabelOptions(ChartAxisLabelOptionsProperty secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(ComboChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public ComboChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComboChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBarValues() {
            return null;
        }

        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getColors() {
            return null;
        }

        @Nullable
        default public Object getLineValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComboChartAggregatedFieldWellsProperty> {
            Object barValues;
            Object category;
            Object colors;
            Object lineValues;

            public Builder barValues(IResolvable barValues) {
                this.barValues = barValues;
                return this;
            }

            public Builder barValues(List<? extends Object> barValues) {
                this.barValues = barValues;
                return this;
            }

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder lineValues(IResolvable lineValues) {
                this.lineValues = lineValues;
                return this;
            }

            public Builder lineValues(List<? extends Object> lineValues) {
                this.lineValues = lineValues;
                return this;
            }

            public ComboChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnTooltipItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnTooltipItemProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @Nullable
        default public Object getAggregation() {
            return null;
        }

        @Nullable
        default public String getLabel() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnTooltipItemProperty> {
            Object column;
            Object aggregation;
            String label;
            String visibility;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder aggregation(IResolvable aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            public Builder aggregation(AggregationFunctionProperty aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            public Builder label(String label) {
                this.label = label;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ColumnTooltipItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnSortProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnSortProperty
    extends JsiiSerializable {
        @NotNull
        public String getDirection();

        @NotNull
        public Object getSortBy();

        @Nullable
        default public Object getAggregationFunction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnSortProperty> {
            String direction;
            Object sortBy;
            Object aggregationFunction;

            public Builder direction(String direction) {
                this.direction = direction;
                return this;
            }

            public Builder sortBy(IResolvable sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            public Builder sortBy(ColumnIdentifierProperty sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            public Builder aggregationFunction(IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder aggregationFunction(AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public ColumnSortProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnIdentifierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnIdentifierProperty
    extends JsiiSerializable {
        @NotNull
        public String getColumnName();

        @NotNull
        public String getDataSetIdentifier();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnIdentifierProperty> {
            String columnName;
            String dataSetIdentifier;

            public Builder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public ColumnIdentifierProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnHierarchyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnHierarchyProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateTimeHierarchy() {
            return null;
        }

        @Nullable
        default public Object getExplicitHierarchy() {
            return null;
        }

        @Nullable
        default public Object getPredefinedHierarchy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnHierarchyProperty> {
            Object dateTimeHierarchy;
            Object explicitHierarchy;
            Object predefinedHierarchy;

            public Builder dateTimeHierarchy(IResolvable dateTimeHierarchy) {
                this.dateTimeHierarchy = dateTimeHierarchy;
                return this;
            }

            public Builder dateTimeHierarchy(DateTimeHierarchyProperty dateTimeHierarchy) {
                this.dateTimeHierarchy = dateTimeHierarchy;
                return this;
            }

            public Builder explicitHierarchy(IResolvable explicitHierarchy) {
                this.explicitHierarchy = explicitHierarchy;
                return this;
            }

            public Builder explicitHierarchy(ExplicitHierarchyProperty explicitHierarchy) {
                this.explicitHierarchy = explicitHierarchy;
                return this;
            }

            public Builder predefinedHierarchy(IResolvable predefinedHierarchy) {
                this.predefinedHierarchy = predefinedHierarchy;
                return this;
            }

            public Builder predefinedHierarchy(PredefinedHierarchyProperty predefinedHierarchy) {
                this.predefinedHierarchy = predefinedHierarchy;
                return this;
            }

            public ColumnHierarchyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @Nullable
        default public Object getColorsConfiguration() {
            return null;
        }

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getRole() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            Object column;
            Object colorsConfiguration;
            Object formatConfiguration;
            String role;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder colorsConfiguration(IResolvable colorsConfiguration) {
                this.colorsConfiguration = colorsConfiguration;
                return this;
            }

            public Builder colorsConfiguration(ColorsConfigurationProperty colorsConfiguration) {
                this.colorsConfiguration = colorsConfiguration;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(FormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public ColumnConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColorsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomColors() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColorsConfigurationProperty> {
            Object customColors;

            public Builder customColors(IResolvable customColors) {
                this.customColors = customColors;
                return this;
            }

            public Builder customColors(List<? extends Object> customColors) {
                this.customColors = customColors;
                return this;
            }

            public ColorsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorScaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColorScaleProperty
    extends JsiiSerializable {
        @NotNull
        public String getColorFillType();

        @NotNull
        public Object getColors();

        @Nullable
        default public Object getNullValueColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColorScaleProperty> {
            String colorFillType;
            Object colors;
            Object nullValueColor;

            public Builder colorFillType(String colorFillType) {
                this.colorFillType = colorFillType;
                return this;
            }

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder nullValueColor(IResolvable nullValueColor) {
                this.nullValueColor = nullValueColor;
                return this;
            }

            public Builder nullValueColor(DataColorProperty nullValueColor) {
                this.nullValueColor = nullValueColor;
                return this;
            }

            public ColorScaleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterMarkerProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSimpleClusterMarker() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterMarkerProperty> {
            Object simpleClusterMarker;

            public Builder simpleClusterMarker(IResolvable simpleClusterMarker) {
                this.simpleClusterMarker = simpleClusterMarker;
                return this;
            }

            public Builder simpleClusterMarker(SimpleClusterMarkerProperty simpleClusterMarker) {
                this.simpleClusterMarker = simpleClusterMarker;
                return this;
            }

            public ClusterMarkerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterMarkerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getClusterMarker() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterMarkerConfigurationProperty> {
            Object clusterMarker;

            public Builder clusterMarker(IResolvable clusterMarker) {
                this.clusterMarker = clusterMarker;
                return this;
            }

            public Builder clusterMarker(ClusterMarkerProperty clusterMarker) {
                this.clusterMarker = clusterMarker;
                return this;
            }

            public ClusterMarkerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChartAxisLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public String getSortIconVisibility() {
            return null;
        }

        @Nullable
        default public String getVisibility() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChartAxisLabelOptionsProperty> {
            Object axisLabelOptions;
            String sortIconVisibility;
            String visibility;

            public Builder axisLabelOptions(IResolvable axisLabelOptions) {
                this.axisLabelOptions = axisLabelOptions;
                return this;
            }

            public Builder axisLabelOptions(List<? extends Object> axisLabelOptions) {
                this.axisLabelOptions = axisLabelOptions;
                return this;
            }

            public Builder sortIconVisibility(String sortIconVisibility) {
                this.sortIconVisibility = sortIconVisibility;
                return this;
            }

            public Builder visibility(String visibility) {
                this.visibility = visibility;
                return this;
            }

            public ChartAxisLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CategoryFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public Object getConfiguration();

        @NotNull
        public String getFilterId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CategoryFilterProperty> {
            Object column;
            Object configuration;
            String filterId;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(CategoryFilterConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder filterId(String filterId) {
                this.filterId = filterId;
                return this;
            }

            public CategoryFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CategoryFilterConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomFilterConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCustomFilterListConfiguration() {
            return null;
        }

        @Nullable
        default public Object getFilterListConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CategoryFilterConfigurationProperty> {
            Object customFilterConfiguration;
            Object customFilterListConfiguration;
            Object filterListConfiguration;

            public Builder customFilterConfiguration(IResolvable customFilterConfiguration) {
                this.customFilterConfiguration = customFilterConfiguration;
                return this;
            }

            public Builder customFilterConfiguration(CustomFilterConfigurationProperty customFilterConfiguration) {
                this.customFilterConfiguration = customFilterConfiguration;
                return this;
            }

            public Builder customFilterListConfiguration(IResolvable customFilterListConfiguration) {
                this.customFilterListConfiguration = customFilterListConfiguration;
                return this;
            }

            public Builder customFilterListConfiguration(CustomFilterListConfigurationProperty customFilterListConfiguration) {
                this.customFilterListConfiguration = customFilterListConfiguration;
                return this;
            }

            public Builder filterListConfiguration(IResolvable filterListConfiguration) {
                this.filterListConfiguration = filterListConfiguration;
                return this;
            }

            public Builder filterListConfiguration(FilterListConfigurationProperty filterListConfiguration) {
                this.filterListConfiguration = filterListConfiguration;
                return this;
            }

            public CategoryFilterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryDrillDownFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CategoryDrillDownFilterProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getCategoryValues();

        @NotNull
        public Object getColumn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CategoryDrillDownFilterProperty> {
            List<String> categoryValues;
            Object column;

            public Builder categoryValues(List<String> categoryValues) {
                this.categoryValues = categoryValues;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public CategoryDrillDownFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalMeasureFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CategoricalMeasureFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public String getAggregationFunction() {
            return null;
        }

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CategoricalMeasureFieldProperty> {
            Object column;
            String fieldId;
            String aggregationFunction;
            Object formatConfiguration;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder aggregationFunction(String aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(StringFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public CategoricalMeasureFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalDimensionFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CategoricalDimensionFieldProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        @Nullable
        default public Object getFormatConfiguration() {
            return null;
        }

        @Nullable
        default public String getHierarchyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CategoricalDimensionFieldProperty> {
            Object column;
            String fieldId;
            Object formatConfiguration;
            String hierarchyId;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public Builder formatConfiguration(IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder formatConfiguration(StringFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            public Builder hierarchyId(String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            public CategoricalDimensionFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CascadingControlSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumnToMatch() {
            return null;
        }

        @Nullable
        default public String getSourceSheetControlId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CascadingControlSourceProperty> {
            Object columnToMatch;
            String sourceSheetControlId;

            public Builder columnToMatch(IResolvable columnToMatch) {
                this.columnToMatch = columnToMatch;
                return this;
            }

            public Builder columnToMatch(ColumnIdentifierProperty columnToMatch) {
                this.columnToMatch = columnToMatch;
                return this;
            }

            public Builder sourceSheetControlId(String sourceSheetControlId) {
                this.sourceSheetControlId = sourceSheetControlId;
                return this;
            }

            public CascadingControlSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CascadingControlConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSourceControls() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CascadingControlConfigurationProperty> {
            Object sourceControls;

            public Builder sourceControls(IResolvable sourceControls) {
                this.sourceControls = sourceControls;
                return this;
            }

            public Builder sourceControls(List<? extends Object> sourceControls) {
                this.sourceControls = sourceControls;
                return this;
            }

            public CascadingControlConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedMeasureFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CalculatedMeasureFieldProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public String getFieldId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CalculatedMeasureFieldProperty> {
            String expression;
            String fieldId;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public CalculatedMeasureFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CalculatedFieldProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSetIdentifier();

        @NotNull
        public String getExpression();

        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CalculatedFieldProperty> {
            String dataSetIdentifier;
            String expression;
            String name;

            public Builder dataSetIdentifier(String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public CalculatedFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(BoxPlotChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public BoxPlotVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotStyleOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFillStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotStyleOptionsProperty> {
            String fillStyle;

            public Builder fillStyle(String fillStyle) {
                this.fillStyle = fillStyle;
                return this;
            }

            public BoxPlotStyleOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getPaginationConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotSortConfigurationProperty> {
            Object categorySort;
            Object paginationConfiguration;

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder paginationConfiguration(IResolvable paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            public Builder paginationConfiguration(PaginationConfigurationProperty paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            public BoxPlotSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAllDataPointsVisibility() {
            return null;
        }

        @Nullable
        default public String getOutlierVisibility() {
            return null;
        }

        @Nullable
        default public Object getStyleOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotOptionsProperty> {
            String allDataPointsVisibility;
            String outlierVisibility;
            Object styleOptions;

            public Builder allDataPointsVisibility(String allDataPointsVisibility) {
                this.allDataPointsVisibility = allDataPointsVisibility;
                return this;
            }

            public Builder outlierVisibility(String outlierVisibility) {
                this.outlierVisibility = outlierVisibility;
                return this;
            }

            public Builder styleOptions(IResolvable styleOptions) {
                this.styleOptions = styleOptions;
                return this;
            }

            public Builder styleOptions(BoxPlotStyleOptionsProperty styleOptions) {
                this.styleOptions = styleOptions;
                return this;
            }

            public BoxPlotOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBoxPlotAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotFieldWellsProperty> {
            Object boxPlotAggregatedFieldWells;

            public Builder boxPlotAggregatedFieldWells(IResolvable boxPlotAggregatedFieldWells) {
                this.boxPlotAggregatedFieldWells = boxPlotAggregatedFieldWells;
                return this;
            }

            public Builder boxPlotAggregatedFieldWells(BoxPlotAggregatedFieldWellsProperty boxPlotAggregatedFieldWells) {
                this.boxPlotAggregatedFieldWells = boxPlotAggregatedFieldWells;
                return this;
            }

            public BoxPlotFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBoxPlotOptions() {
            return null;
        }

        @Nullable
        default public Object getCategoryAxis() {
            return null;
        }

        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        @Nullable
        default public Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getReferenceLines() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotChartConfigurationProperty> {
            Object boxPlotOptions;
            Object categoryAxis;
            Object categoryLabelOptions;
            Object fieldWells;
            Object legend;
            Object primaryYAxisDisplayOptions;
            Object primaryYAxisLabelOptions;
            Object referenceLines;
            Object sortConfiguration;
            Object tooltip;
            Object visualPalette;

            public Builder boxPlotOptions(IResolvable boxPlotOptions) {
                this.boxPlotOptions = boxPlotOptions;
                return this;
            }

            public Builder boxPlotOptions(BoxPlotOptionsProperty boxPlotOptions) {
                this.boxPlotOptions = boxPlotOptions;
                return this;
            }

            public Builder categoryAxis(IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryAxis(AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(BoxPlotFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisDisplayOptions(AxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder primaryYAxisLabelOptions(ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            public Builder referenceLines(IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder referenceLines(List<? extends Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(BoxPlotSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public BoxPlotChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BoxPlotAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGroupBy() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BoxPlotAggregatedFieldWellsProperty> {
            Object groupBy;
            Object values;

            public Builder groupBy(IResolvable groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder groupBy(List<? extends Object> groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public BoxPlotAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BodySectionContentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLayout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BodySectionContentProperty> {
            Object layout;

            public Builder layout(IResolvable layout) {
                this.layout = layout;
                return this;
            }

            public Builder layout(SectionLayoutConfigurationProperty layout) {
                this.layout = layout;
                return this;
            }

            public BodySectionContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BodySectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContent();

        @NotNull
        public String getSectionId();

        @Nullable
        default public Object getPageBreakConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStyle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BodySectionConfigurationProperty> {
            Object content;
            String sectionId;
            Object pageBreakConfiguration;
            Object style;

            public Builder content(IResolvable content) {
                this.content = content;
                return this;
            }

            public Builder content(BodySectionContentProperty content) {
                this.content = content;
                return this;
            }

            public Builder sectionId(String sectionId) {
                this.sectionId = sectionId;
                return this;
            }

            public Builder pageBreakConfiguration(IResolvable pageBreakConfiguration) {
                this.pageBreakConfiguration = pageBreakConfiguration;
                return this;
            }

            public Builder pageBreakConfiguration(SectionPageBreakConfigurationProperty pageBreakConfiguration) {
                this.pageBreakConfiguration = pageBreakConfiguration;
                return this;
            }

            public Builder style(IResolvable style) {
                this.style = style;
                return this;
            }

            public Builder style(SectionStyleProperty style) {
                this.style = style;
                return this;
            }

            public BodySectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BinWidthOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BinWidthOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBinCountLimit() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BinWidthOptionsProperty> {
            Number binCountLimit;
            Number value;

            public Builder binCountLimit(Number binCountLimit) {
                this.binCountLimit = binCountLimit;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public BinWidthOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BinCountOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BinCountOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BinCountOptionsProperty> {
            Number value;

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public BinCountOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartVisualProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BarChartVisualProperty
    extends JsiiSerializable {
        @NotNull
        public String getVisualId();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public Object getChartConfiguration() {
            return null;
        }

        @Nullable
        default public Object getColumnHierarchies() {
            return null;
        }

        @Nullable
        default public Object getSubtitle() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BarChartVisualProperty> {
            String visualId;
            Object actions;
            Object chartConfiguration;
            Object columnHierarchies;
            Object subtitle;
            Object title;

            public Builder visualId(String visualId) {
                this.visualId = visualId;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder chartConfiguration(IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder chartConfiguration(BarChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            public Builder columnHierarchies(IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder columnHierarchies(List<? extends Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            public Builder subtitle(IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder subtitle(VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            public BarChartVisualProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BarChartSortConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategoryItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getCategorySort() {
            return null;
        }

        @Nullable
        default public Object getColorItemsLimit() {
            return null;
        }

        @Nullable
        default public Object getColorSort() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesLimitConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesSort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BarChartSortConfigurationProperty> {
            Object categoryItemsLimit;
            Object categorySort;
            Object colorItemsLimit;
            Object colorSort;
            Object smallMultiplesLimitConfiguration;
            Object smallMultiplesSort;

            public Builder categoryItemsLimit(IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categoryItemsLimit(ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            public Builder categorySort(IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder categorySort(List<? extends Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            public Builder colorItemsLimit(IResolvable colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorItemsLimit(ItemsLimitConfigurationProperty colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            public Builder colorSort(IResolvable colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public Builder colorSort(List<? extends Object> colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(IResolvable smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            public Builder smallMultiplesSort(IResolvable smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public Builder smallMultiplesSort(List<? extends Object> smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            public BarChartSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BarChartFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBarChartAggregatedFieldWells() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BarChartFieldWellsProperty> {
            Object barChartAggregatedFieldWells;

            public Builder barChartAggregatedFieldWells(IResolvable barChartAggregatedFieldWells) {
                this.barChartAggregatedFieldWells = barChartAggregatedFieldWells;
                return this;
            }

            public Builder barChartAggregatedFieldWells(BarChartAggregatedFieldWellsProperty barChartAggregatedFieldWells) {
                this.barChartAggregatedFieldWells = barChartAggregatedFieldWells;
                return this;
            }

            public BarChartFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BarChartConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBarsArrangement() {
            return null;
        }

        @Nullable
        default public Object getCategoryAxis() {
            return null;
        }

        @Nullable
        default public Object getCategoryLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getColorLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getContributionAnalysisDefaults() {
            return null;
        }

        @Nullable
        default public Object getDataLabels() {
            return null;
        }

        @Nullable
        default public Object getFieldWells() {
            return null;
        }

        @Nullable
        default public Object getLegend() {
            return null;
        }

        @Nullable
        default public String getOrientation() {
            return null;
        }

        @Nullable
        default public Object getReferenceLines() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiplesOptions() {
            return null;
        }

        @Nullable
        default public Object getSortConfiguration() {
            return null;
        }

        @Nullable
        default public Object getTooltip() {
            return null;
        }

        @Nullable
        default public Object getValueAxis() {
            return null;
        }

        @Nullable
        default public Object getValueLabelOptions() {
            return null;
        }

        @Nullable
        default public Object getVisualPalette() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BarChartConfigurationProperty> {
            String barsArrangement;
            Object categoryAxis;
            Object categoryLabelOptions;
            Object colorLabelOptions;
            Object contributionAnalysisDefaults;
            Object dataLabels;
            Object fieldWells;
            Object legend;
            String orientation;
            Object referenceLines;
            Object smallMultiplesOptions;
            Object sortConfiguration;
            Object tooltip;
            Object valueAxis;
            Object valueLabelOptions;
            Object visualPalette;

            public Builder barsArrangement(String barsArrangement) {
                this.barsArrangement = barsArrangement;
                return this;
            }

            public Builder categoryAxis(IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryAxis(AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            public Builder categoryLabelOptions(IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder categoryLabelOptions(ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder colorLabelOptions(ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            public Builder contributionAnalysisDefaults(IResolvable contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder contributionAnalysisDefaults(List<? extends Object> contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            public Builder dataLabels(IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder dataLabels(DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            public Builder fieldWells(IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder fieldWells(BarChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            public Builder legend(IResolvable legend) {
                this.legend = legend;
                return this;
            }

            public Builder legend(LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            public Builder orientation(String orientation) {
                this.orientation = orientation;
                return this;
            }

            public Builder referenceLines(IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder referenceLines(List<? extends Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            public Builder smallMultiplesOptions(IResolvable smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder smallMultiplesOptions(SmallMultiplesOptionsProperty smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            public Builder sortConfiguration(IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder sortConfiguration(BarChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            public Builder tooltip(IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder tooltip(TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            public Builder valueAxis(IResolvable valueAxis) {
                this.valueAxis = valueAxis;
                return this;
            }

            public Builder valueAxis(AxisDisplayOptionsProperty valueAxis) {
                this.valueAxis = valueAxis;
                return this;
            }

            public Builder valueLabelOptions(IResolvable valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder valueLabelOptions(ChartAxisLabelOptionsProperty valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            public Builder visualPalette(IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public Builder visualPalette(VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            public BarChartConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BarChartAggregatedFieldWellsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCategory() {
            return null;
        }

        @Nullable
        default public Object getColors() {
            return null;
        }

        @Nullable
        default public Object getSmallMultiples() {
            return null;
        }

        @Nullable
        default public Object getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BarChartAggregatedFieldWellsProperty> {
            Object category;
            Object colors;
            Object smallMultiples;
            Object values;

            public Builder category(IResolvable category) {
                this.category = category;
                return this;
            }

            public Builder category(List<? extends Object> category) {
                this.category = category;
                return this;
            }

            public Builder colors(IResolvable colors) {
                this.colors = colors;
                return this;
            }

            public Builder colors(List<? extends Object> colors) {
                this.colors = colors;
                return this;
            }

            public Builder smallMultiples(IResolvable smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder smallMultiples(List<? extends Object> smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            public Builder values(IResolvable values) {
                this.values = values;
                return this;
            }

            public Builder values(List<? extends Object> values) {
                this.values = values;
                return this;
            }

            public BarChartAggregatedFieldWellsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisTickLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisTickLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLabelOptions() {
            return null;
        }

        @Nullable
        default public Number getRotationAngle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisTickLabelOptionsProperty> {
            Object labelOptions;
            Number rotationAngle;

            public Builder labelOptions(IResolvable labelOptions) {
                this.labelOptions = labelOptions;
                return this;
            }

            public Builder labelOptions(LabelOptionsProperty labelOptions) {
                this.labelOptions = labelOptions;
                return this;
            }

            public Builder rotationAngle(Number rotationAngle) {
                this.rotationAngle = rotationAngle;
                return this;
            }

            public AxisTickLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisScaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisScaleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLinear() {
            return null;
        }

        @Nullable
        default public Object getLogarithmic() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisScaleProperty> {
            Object linear;
            Object logarithmic;

            public Builder linear(IResolvable linear) {
                this.linear = linear;
                return this;
            }

            public Builder linear(AxisLinearScaleProperty linear) {
                this.linear = linear;
                return this;
            }

            public Builder logarithmic(IResolvable logarithmic) {
                this.logarithmic = logarithmic;
                return this;
            }

            public Builder logarithmic(AxisLogarithmicScaleProperty logarithmic) {
                this.logarithmic = logarithmic;
                return this;
            }

            public AxisScaleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLogarithmicScaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisLogarithmicScaleProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBase() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisLogarithmicScaleProperty> {
            Number base;

            public Builder base(Number base) {
                this.base = base;
                return this;
            }

            public AxisLogarithmicScaleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLinearScaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisLinearScaleProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getStepCount() {
            return null;
        }

        @Nullable
        default public Number getStepSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisLinearScaleProperty> {
            Number stepCount;
            Number stepSize;

            public Builder stepCount(Number stepCount) {
                this.stepCount = stepCount;
                return this;
            }

            public Builder stepSize(Number stepSize) {
                this.stepSize = stepSize;
                return this;
            }

            public AxisLinearScaleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisLabelReferenceOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @NotNull
        public String getFieldId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisLabelReferenceOptionsProperty> {
            Object column;
            String fieldId;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder fieldId(String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            public AxisLabelReferenceOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisLabelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getApplyTo() {
            return null;
        }

        @Nullable
        default public String getCustomLabel() {
            return null;
        }

        @Nullable
        default public Object getFontConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisLabelOptionsProperty> {
            Object applyTo;
            String customLabel;
            Object fontConfiguration;

            public Builder applyTo(IResolvable applyTo) {
                this.applyTo = applyTo;
                return this;
            }

            public Builder applyTo(AxisLabelReferenceOptionsProperty applyTo) {
                this.applyTo = applyTo;
                return this;
            }

            public Builder customLabel(String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            public Builder fontConfiguration(IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public Builder fontConfiguration(FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            public AxisLabelOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisDisplayRangeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataDriven() {
            return null;
        }

        @Nullable
        default public Object getMinMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisDisplayRangeProperty> {
            Object dataDriven;
            Object minMax;

            public Builder dataDriven(Object dataDriven) {
                this.dataDriven = dataDriven;
                return this;
            }

            public Builder minMax(IResolvable minMax) {
                this.minMax = minMax;
                return this;
            }

            public Builder minMax(AxisDisplayMinMaxRangeProperty minMax) {
                this.minMax = minMax;
                return this;
            }

            public AxisDisplayRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisDisplayOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAxisLineVisibility() {
            return null;
        }

        @Nullable
        default public String getAxisOffset() {
            return null;
        }

        @Nullable
        default public Object getDataOptions() {
            return null;
        }

        @Nullable
        default public String getGridLineVisibility() {
            return null;
        }

        @Nullable
        default public Object getScrollbarOptions() {
            return null;
        }

        @Nullable
        default public Object getTickLabelOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisDisplayOptionsProperty> {
            String axisLineVisibility;
            String axisOffset;
            Object dataOptions;
            String gridLineVisibility;
            Object scrollbarOptions;
            Object tickLabelOptions;

            public Builder axisLineVisibility(String axisLineVisibility) {
                this.axisLineVisibility = axisLineVisibility;
                return this;
            }

            public Builder axisOffset(String axisOffset) {
                this.axisOffset = axisOffset;
                return this;
            }

            public Builder dataOptions(IResolvable dataOptions) {
                this.dataOptions = dataOptions;
                return this;
            }

            public Builder dataOptions(AxisDataOptionsProperty dataOptions) {
                this.dataOptions = dataOptions;
                return this;
            }

            public Builder gridLineVisibility(String gridLineVisibility) {
                this.gridLineVisibility = gridLineVisibility;
                return this;
            }

            public Builder scrollbarOptions(IResolvable scrollbarOptions) {
                this.scrollbarOptions = scrollbarOptions;
                return this;
            }

            public Builder scrollbarOptions(ScrollBarOptionsProperty scrollbarOptions) {
                this.scrollbarOptions = scrollbarOptions;
                return this;
            }

            public Builder tickLabelOptions(IResolvable tickLabelOptions) {
                this.tickLabelOptions = tickLabelOptions;
                return this;
            }

            public Builder tickLabelOptions(AxisTickLabelOptionsProperty tickLabelOptions) {
                this.tickLabelOptions = tickLabelOptions;
                return this;
            }

            public AxisDisplayOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisDisplayMinMaxRangeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaximum() {
            return null;
        }

        @Nullable
        default public Number getMinimum() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisDisplayMinMaxRangeProperty> {
            Number maximum;
            Number minimum;

            public Builder maximum(Number maximum) {
                this.maximum = maximum;
                return this;
            }

            public Builder minimum(Number minimum) {
                this.minimum = minimum;
                return this;
            }

            public AxisDisplayMinMaxRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDataOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AxisDataOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateAxisOptions() {
            return null;
        }

        @Nullable
        default public Object getNumericAxisOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AxisDataOptionsProperty> {
            Object dateAxisOptions;
            Object numericAxisOptions;

            public Builder dateAxisOptions(IResolvable dateAxisOptions) {
                this.dateAxisOptions = dateAxisOptions;
                return this;
            }

            public Builder dateAxisOptions(DateAxisOptionsProperty dateAxisOptions) {
                this.dateAxisOptions = dateAxisOptions;
                return this;
            }

            public Builder numericAxisOptions(IResolvable numericAxisOptions) {
                this.numericAxisOptions = numericAxisOptions;
                return this;
            }

            public Builder numericAxisOptions(NumericAxisOptionsProperty numericAxisOptions) {
                this.numericAxisOptions = numericAxisOptions;
                return this;
            }

            public AxisDataOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArcOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArcThickness() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArcOptionsProperty> {
            String arcThickness;

            public Builder arcThickness(String arcThickness) {
                this.arcThickness = arcThickness;
                return this;
            }

            public ArcOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArcConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getArcAngle() {
            return null;
        }

        @Nullable
        default public String getArcThickness() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArcConfigurationProperty> {
            Number arcAngle;
            String arcThickness;

            public Builder arcAngle(Number arcAngle) {
                this.arcAngle = arcAngle;
                return this;
            }

            public Builder arcThickness(String arcThickness) {
                this.arcThickness = arcThickness;
                return this;
            }

            public ArcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArcAxisDisplayRangeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArcAxisDisplayRangeProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public ArcAxisDisplayRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArcAxisConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRange() {
            return null;
        }

        @Nullable
        default public Number getReserveRange() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArcAxisConfigurationProperty> {
            Object range;
            Number reserveRange;

            public Builder range(IResolvable range) {
                this.range = range;
                return this;
            }

            public Builder range(ArcAxisDisplayRangeProperty range) {
                this.range = range;
                return this;
            }

            public Builder reserveRange(Number reserveRange) {
                this.reserveRange = reserveRange;
                return this;
            }

            public ArcAxisConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnchorDateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnchorDateConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAnchorOption() {
            return null;
        }

        @Nullable
        default public String getParameterName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnchorDateConfigurationProperty> {
            String anchorOption;
            String parameterName;

            public Builder anchorOption(String anchorOption) {
                this.anchorOption = anchorOption;
                return this;
            }

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public AnchorDateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisSourceTemplateProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public Object getDataSetReferences();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisSourceTemplateProperty> {
            String arn;
            Object dataSetReferences;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder dataSetReferences(IResolvable dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            public Builder dataSetReferences(List<? extends Object> dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            public AnalysisSourceTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisSourceEntityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSourceTemplate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisSourceEntityProperty> {
            Object sourceTemplate;

            public Builder sourceTemplate(IResolvable sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            public Builder sourceTemplate(AnalysisSourceTemplateProperty sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            public AnalysisSourceEntityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisErrorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMessage() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public Object getViolatedEntities() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisErrorProperty> {
            String message;
            String type;
            Object violatedEntities;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder violatedEntities(IResolvable violatedEntities) {
                this.violatedEntities = violatedEntities;
                return this;
            }

            public Builder violatedEntities(List<? extends Object> violatedEntities) {
                this.violatedEntities = violatedEntities;
                return this;
            }

            public AnalysisErrorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDataSetIdentifierDeclarations();

        @Nullable
        default public Object getAnalysisDefaults() {
            return null;
        }

        @Nullable
        default public Object getCalculatedFields() {
            return null;
        }

        @Nullable
        default public Object getColumnConfigurations() {
            return null;
        }

        @Nullable
        default public Object getFilterGroups() {
            return null;
        }

        @Nullable
        default public Object getParameterDeclarations() {
            return null;
        }

        @Nullable
        default public Object getSheets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisDefinitionProperty> {
            Object dataSetIdentifierDeclarations;
            Object analysisDefaults;
            Object calculatedFields;
            Object columnConfigurations;
            Object filterGroups;
            Object parameterDeclarations;
            Object sheets;

            public Builder dataSetIdentifierDeclarations(IResolvable dataSetIdentifierDeclarations) {
                this.dataSetIdentifierDeclarations = dataSetIdentifierDeclarations;
                return this;
            }

            public Builder dataSetIdentifierDeclarations(List<? extends Object> dataSetIdentifierDeclarations) {
                this.dataSetIdentifierDeclarations = dataSetIdentifierDeclarations;
                return this;
            }

            public Builder analysisDefaults(IResolvable analysisDefaults) {
                this.analysisDefaults = analysisDefaults;
                return this;
            }

            public Builder analysisDefaults(AnalysisDefaultsProperty analysisDefaults) {
                this.analysisDefaults = analysisDefaults;
                return this;
            }

            public Builder calculatedFields(IResolvable calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            public Builder calculatedFields(List<? extends Object> calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            public Builder columnConfigurations(IResolvable columnConfigurations) {
                this.columnConfigurations = columnConfigurations;
                return this;
            }

            public Builder columnConfigurations(List<? extends Object> columnConfigurations) {
                this.columnConfigurations = columnConfigurations;
                return this;
            }

            public Builder filterGroups(IResolvable filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            public Builder filterGroups(List<? extends Object> filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            public Builder parameterDeclarations(IResolvable parameterDeclarations) {
                this.parameterDeclarations = parameterDeclarations;
                return this;
            }

            public Builder parameterDeclarations(List<? extends Object> parameterDeclarations) {
                this.parameterDeclarations = parameterDeclarations;
                return this;
            }

            public Builder sheets(IResolvable sheets) {
                this.sheets = sheets;
                return this;
            }

            public Builder sheets(List<? extends Object> sheets) {
                this.sheets = sheets;
                return this;
            }

            public AnalysisDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefaultsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisDefaultsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDefaultNewSheetConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisDefaultsProperty> {
            Object defaultNewSheetConfiguration;

            public Builder defaultNewSheetConfiguration(IResolvable defaultNewSheetConfiguration) {
                this.defaultNewSheetConfiguration = defaultNewSheetConfiguration;
                return this;
            }

            public Builder defaultNewSheetConfiguration(DefaultNewSheetConfigurationProperty defaultNewSheetConfiguration) {
                this.defaultNewSheetConfiguration = defaultNewSheetConfiguration;
                return this;
            }

            public AnalysisDefaultsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationSortConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AggregationSortConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAggregationFunction();

        @NotNull
        public Object getColumn();

        @NotNull
        public String getSortDirection();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AggregationSortConfigurationProperty> {
            Object aggregationFunction;
            Object column;
            String sortDirection;

            public Builder aggregationFunction(IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder aggregationFunction(AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            public Builder sortDirection(String sortDirection) {
                this.sortDirection = sortDirection;
                return this;
            }

            public AggregationSortConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationFunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AggregationFunctionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCategoricalAggregationFunction() {
            return null;
        }

        @Nullable
        default public String getDateAggregationFunction() {
            return null;
        }

        @Nullable
        default public Object getNumericalAggregationFunction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AggregationFunctionProperty> {
            String categoricalAggregationFunction;
            String dateAggregationFunction;
            Object numericalAggregationFunction;

            public Builder categoricalAggregationFunction(String categoricalAggregationFunction) {
                this.categoricalAggregationFunction = categoricalAggregationFunction;
                return this;
            }

            public Builder dateAggregationFunction(String dateAggregationFunction) {
                this.dateAggregationFunction = dateAggregationFunction;
                return this;
            }

            public Builder numericalAggregationFunction(IResolvable numericalAggregationFunction) {
                this.numericalAggregationFunction = numericalAggregationFunction;
                return this;
            }

            public Builder numericalAggregationFunction(NumericalAggregationFunctionProperty numericalAggregationFunction) {
                this.numericalAggregationFunction = numericalAggregationFunction;
                return this;
            }

            public AggregationFunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

