/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.ResourceProps;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.IBucketNotificationDestination;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions;
import software.amazon.awscdk.services.s3.TransferAccelerationUrlOptions;
import software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3.BucketBase")
public abstract class BucketBase
extends Resource
implements IBucket {
    protected BucketBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BucketBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected BucketBase(@NotNull Construct scope, @NotNull String id, @Nullable ResourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected BucketBase(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void addEventNotification(@NotNull EventType event, @NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addEventNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(event, "event is required"), Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    @Override
    public void addObjectCreatedNotification(@NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addObjectCreatedNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    @Override
    public void addObjectRemovedNotification(@NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addObjectRemovedNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement permission) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(permission, "permission is required")});
    }

    @Override
    @NotNull
    public String arnForObjects(@NotNull String keyPattern) {
        return (String)Kernel.call((Object)this, (String)"arnForObjects", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(keyPattern, "keyPattern is required")});
    }

    @Override
    public void enableEventBridgeNotification() {
        Kernel.call((Object)this, (String)"enableEventBridgeNotification", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Grant grantDelete(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantDelete", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantDelete(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantDelete", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPublicAccess(@Nullable String keyPrefix, String ... allowedActions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPublicAccess", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{keyPrefix}), Arrays.stream(allowedActions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantPut(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPut", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantPut(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPut", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPutAcl(@NotNull IGrantable identity, @Nullable String objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPutAcl", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantPutAcl(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPutAcl", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern, @Nullable List<String> allowedActionPatterns) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern, allowedActionPatterns}));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern}));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCloudTrailPutObject(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailPutObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailPutObject(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailPutObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCloudTrailWriteObject(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailWriteObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailWriteObject(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailWriteObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public String s3UrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"s3UrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String s3UrlForObject() {
        return (String)Kernel.call((Object)this, (String)"s3UrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String transferAccelerationUrlForObject(@Nullable String key, @Nullable TransferAccelerationUrlOptions options) {
        return (String)Kernel.call((Object)this, (String)"transferAccelerationUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key, options});
    }

    @Override
    @NotNull
    public String transferAccelerationUrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"transferAccelerationUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String transferAccelerationUrlForObject() {
        return (String)Kernel.call((Object)this, (String)"transferAccelerationUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String urlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"urlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String urlForObject() {
        return (String)Kernel.call((Object)this, (String)"urlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key, @Nullable VirtualHostedStyleUrlOptions options) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key, options});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject() {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public abstract String getBucketArn();

    @Override
    @NotNull
    public abstract String getBucketDomainName();

    @Override
    @NotNull
    public abstract String getBucketDualStackDomainName();

    @Override
    @NotNull
    public abstract String getBucketName();

    @Override
    @NotNull
    public abstract String getBucketRegionalDomainName();

    @Override
    @NotNull
    public abstract String getBucketWebsiteDomainName();

    @Override
    @NotNull
    public abstract String getBucketWebsiteUrl();

    @Override
    @Nullable
    public abstract IKey getEncryptionKey();

    @Override
    @Nullable
    public abstract Boolean getIsWebsite();

    @NotNull
    protected abstract Boolean getAutoCreatePolicy();

    protected abstract void setAutoCreatePolicy(@NotNull Boolean var1);

    @Nullable
    protected abstract Boolean getDisallowPublicAccess();

    protected abstract void setDisallowPublicAccess(@Nullable Boolean var1);

    @Nullable
    protected IRole getNotificationsHandlerRole() {
        return (IRole)Kernel.get((Object)this, (String)"notificationsHandlerRole", (NativeType)NativeType.forClass(IRole.class));
    }

    protected void setNotificationsHandlerRole(@Nullable IRole value) {
        Kernel.set((Object)this, (String)"notificationsHandlerRole", (Object)value);
    }

    @Override
    @Nullable
    public abstract BucketPolicy getPolicy();

    @Override
    public abstract void setPolicy(@Nullable BucketPolicy var1);
}

