/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ses.DkimIdentity;
import software.amazon.awscdk.services.ses.DkimRecord;
import software.amazon.awscdk.services.ses.EmailIdentityProps;
import software.amazon.awscdk.services.ses.IConfigurationSet;
import software.amazon.awscdk.services.ses.IEmailIdentity;
import software.amazon.awscdk.services.ses.Identity;
import software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ses.EmailIdentity")
public class EmailIdentity
extends Resource
implements IEmailIdentity {
    protected EmailIdentity(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailIdentity(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EmailIdentity(@NotNull Construct scope, @NotNull String id, @NotNull EmailIdentityProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEmailIdentity fromEmailIdentityName(@NotNull Construct scope, @NotNull String id, @NotNull String emailIdentityName) {
        return (IEmailIdentity)JsiiObject.jsiiStaticCall(EmailIdentity.class, (String)"fromEmailIdentityName", (NativeType)NativeType.forClass(IEmailIdentity.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(emailIdentityName, "emailIdentityName is required")});
    }

    @NotNull
    public String getDkimDnsTokenName1() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenName1", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDkimDnsTokenName2() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenName2", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDkimDnsTokenName3() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenName3", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDkimDnsTokenValue1() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenValue1", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDkimDnsTokenValue2() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenValue2", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDkimDnsTokenValue3() {
        return (String)Kernel.get((Object)this, (String)"dkimDnsTokenValue3", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<DkimRecord> getDkimRecords() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dkimRecords", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(DkimRecord.class))));
    }

    @Override
    @NotNull
    public String getEmailIdentityName() {
        return (String)Kernel.get((Object)this, (String)"emailIdentityName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EmailIdentity> {
        private final Construct scope;
        private final String id;
        private final EmailIdentityProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EmailIdentityProps.Builder();
        }

        public Builder identity(Identity identity) {
            this.props.identity(identity);
            return this;
        }

        public Builder configurationSet(IConfigurationSet configurationSet) {
            this.props.configurationSet(configurationSet);
            return this;
        }

        public Builder dkimIdentity(DkimIdentity dkimIdentity) {
            this.props.dkimIdentity(dkimIdentity);
            return this;
        }

        public Builder dkimSigning(Boolean dkimSigning) {
            this.props.dkimSigning(dkimSigning);
            return this;
        }

        public Builder feedbackForwarding(Boolean feedbackForwarding) {
            this.props.feedbackForwarding(feedbackForwarding);
            return this;
        }

        public Builder mailFromBehaviorOnMxFailure(MailFromBehaviorOnMxFailure mailFromBehaviorOnMxFailure) {
            this.props.mailFromBehaviorOnMxFailure(mailFromBehaviorOnMxFailure);
            return this;
        }

        public Builder mailFromDomain(String mailFromDomain) {
            this.props.mailFromDomain(mailFromDomain);
            return this;
        }

        public EmailIdentity build() {
            return new EmailIdentity(this.scope, this.id, this.props.build());
        }
    }
}

