/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.batch.;
import software.amazon.awscdk.services.batch.AllocationStrategy;
import software.amazon.awscdk.services.batch.ComputeResourceType;
import software.amazon.awscdk.services.batch.ComputeResources;
import software.amazon.awscdk.services.batch.LaunchTemplateSpecification;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-batch.ComputeResources")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ComputeResources
extends JsiiSerializable {
    @NotNull
    public IVpc getVpc();

    @Nullable
    default public AllocationStrategy getAllocationStrategy() {
        return null;
    }

    @Nullable
    default public Number getBidPercentage() {
        return null;
    }

    @Nullable
    default public Map<String, String> getComputeResourcesTags() {
        return null;
    }

    @Nullable
    default public Number getDesiredvCpus() {
        return null;
    }

    @Nullable
    default public String getEc2KeyPair() {
        return null;
    }

    @Nullable
    default public IMachineImage getImage() {
        return null;
    }

    @Nullable
    default public String getInstanceRole() {
        return null;
    }

    @Nullable
    default public List<InstanceType> getInstanceTypes() {
        return null;
    }

    @Nullable
    default public LaunchTemplateSpecification getLaunchTemplate() {
        return null;
    }

    @Nullable
    default public Number getMaxvCpus() {
        return null;
    }

    @Nullable
    default public Number getMinvCpus() {
        return null;
    }

    @Nullable
    default public String getPlacementGroup() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public IRole getSpotFleetRole() {
        return null;
    }

    @Nullable
    default public ComputeResourceType getType() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ComputeResources> {
        private IVpc vpc;
        private AllocationStrategy allocationStrategy;
        private Number bidPercentage;
        private Map<String, String> computeResourcesTags;
        private Number desiredvCpus;
        private String ec2KeyPair;
        private IMachineImage image;
        private String instanceRole;
        private List<InstanceType> instanceTypes;
        private LaunchTemplateSpecification launchTemplate;
        private Number maxvCpus;
        private Number minvCpus;
        private String placementGroup;
        private List<ISecurityGroup> securityGroups;
        private IRole spotFleetRole;
        private ComputeResourceType type;
        private SubnetSelection vpcSubnets;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        public Builder bidPercentage(Number bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public Builder computeResourcesTags(Map<String, String> computeResourcesTags) {
            this.computeResourcesTags = computeResourcesTags;
            return this;
        }

        public Builder desiredvCpus(Number desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public Builder image(IMachineImage image) {
            this.image = image;
            return this;
        }

        public Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public Builder instanceTypes(List<? extends InstanceType> instanceTypes) {
            this.instanceTypes = instanceTypes;
            return this;
        }

        public Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public Builder maxvCpus(Number maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public Builder minvCpus(Number minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder spotFleetRole(IRole spotFleetRole) {
            this.spotFleetRole = spotFleetRole;
            return this;
        }

        public Builder type(ComputeResourceType type) {
            this.type = type;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ComputeResources build() {
            return new Jsii.Proxy(this.vpc, this.allocationStrategy, this.bidPercentage, this.computeResourcesTags, this.desiredvCpus, this.ec2KeyPair, this.image, this.instanceRole, this.instanceTypes, this.launchTemplate, this.maxvCpus, this.minvCpus, this.placementGroup, this.securityGroups, this.spotFleetRole, this.type, this.vpcSubnets);
        }
    }
}

