/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.batch.;
import software.amazon.awscdk.services.batch.JobDefinitionContainer;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.MountPoint;
import software.amazon.awscdk.services.ecs.Ulimit;
import software.amazon.awscdk.services.ecs.Volume;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-batch.JobDefinitionContainer")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface JobDefinitionContainer
extends JsiiSerializable {
    @NotNull
    public ContainerImage getImage();

    @Nullable
    default public List<String> getCommand() {
        return null;
    }

    @Nullable
    default public Map<String, String> getEnvironment() {
        return null;
    }

    @Nullable
    default public Number getGpuCount() {
        return null;
    }

    @Nullable
    default public InstanceType getInstanceType() {
        return null;
    }

    @Nullable
    default public IRole getJobRole() {
        return null;
    }

    @Nullable
    default public LinuxParameters getLinuxParams() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public List<MountPoint> getMountPoints() {
        return null;
    }

    @Nullable
    default public Boolean getPrivileged() {
        return null;
    }

    @Nullable
    default public Boolean getReadOnly() {
        return null;
    }

    @Nullable
    default public List<Ulimit> getUlimits() {
        return null;
    }

    @Nullable
    default public String getUser() {
        return null;
    }

    @Nullable
    default public Number getVcpus() {
        return null;
    }

    @Nullable
    default public List<Volume> getVolumes() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<JobDefinitionContainer> {
        private ContainerImage image;
        private List<String> command;
        private Map<String, String> environment;
        private Number gpuCount;
        private InstanceType instanceType;
        private IRole jobRole;
        private LinuxParameters linuxParams;
        private Number memoryLimitMiB;
        private List<MountPoint> mountPoints;
        private Boolean privileged;
        private Boolean readOnly;
        private List<Ulimit> ulimits;
        private String user;
        private Number vcpus;
        private List<Volume> volumes;

        public Builder image(ContainerImage image) {
            this.image = image;
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder jobRole(IRole jobRole) {
            this.jobRole = jobRole;
            return this;
        }

        public Builder linuxParams(LinuxParameters linuxParams) {
            this.linuxParams = linuxParams;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder mountPoints(List<MountPoint> mountPoints) {
            this.mountPoints = mountPoints;
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder ulimits(List<Ulimit> ulimits) {
            this.ulimits = ulimits;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder vcpus(Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public Builder volumes(List<Volume> volumes) {
            this.volumes = volumes;
            return this;
        }

        public JobDefinitionContainer build() {
            return new Jsii.Proxy(this.image, this.command, this.environment, this.gpuCount, this.instanceType, this.jobRole, this.linuxParams, this.memoryLimitMiB, this.mountPoints, this.privileged, this.readOnly, this.ulimits, this.user, this.vcpus, this.volumes, null);
        }
    }
}

