/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnOutput;
import software.amazon.awscdk.pipelines.;
import software.amazon.awscdk.pipelines.CodeBuildStepProps;
import software.amazon.awscdk.pipelines.IFileSetProducer;
import software.amazon.awscdk.pipelines.ShellStepProps;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/pipelines.CodeBuildStepProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CodeBuildStepProps
extends JsiiSerializable,
ShellStepProps {
    @Nullable
    default public BuildEnvironment getBuildEnvironment() {
        return null;
    }

    @Nullable
    default public BuildSpec getPartialBuildSpec() {
        return null;
    }

    @Nullable
    default public String getProjectName() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public List<PolicyStatement> getRolePolicyStatements() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnetSelection() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodeBuildStepProps> {
        private BuildEnvironment buildEnvironment;
        private BuildSpec partialBuildSpec;
        private String projectName;
        private IRole role;
        private List<PolicyStatement> rolePolicyStatements;
        private List<ISecurityGroup> securityGroups;
        private SubnetSelection subnetSelection;
        private IVpc vpc;
        private List<String> commands;
        private Map<String, IFileSetProducer> additionalInputs;
        private Map<String, String> env;
        private Map<String, CfnOutput> envFromCfnOutputs;
        private IFileSetProducer input;
        private List<String> installCommands;
        private String primaryOutputDirectory;

        public Builder buildEnvironment(BuildEnvironment buildEnvironment) {
            this.buildEnvironment = buildEnvironment;
            return this;
        }

        public Builder partialBuildSpec(BuildSpec partialBuildSpec) {
            this.partialBuildSpec = partialBuildSpec;
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder rolePolicyStatements(List<? extends PolicyStatement> rolePolicyStatements) {
            this.rolePolicyStatements = rolePolicyStatements;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder commands(List<String> commands) {
            this.commands = commands;
            return this;
        }

        public Builder additionalInputs(Map<String, ? extends IFileSetProducer> additionalInputs) {
            this.additionalInputs = additionalInputs;
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public Builder envFromCfnOutputs(Map<String, ? extends CfnOutput> envFromCfnOutputs) {
            this.envFromCfnOutputs = envFromCfnOutputs;
            return this;
        }

        public Builder input(IFileSetProducer input) {
            this.input = input;
            return this;
        }

        public Builder installCommands(List<String> installCommands) {
            this.installCommands = installCommands;
            return this;
        }

        public Builder primaryOutputDirectory(String primaryOutputDirectory) {
            this.primaryOutputDirectory = primaryOutputDirectory;
            return this;
        }

        public CodeBuildStepProps build() {
            return new Jsii.Proxy(this.buildEnvironment, this.partialBuildSpec, this.projectName, this.role, this.rolePolicyStatements, this.securityGroups, this.subnetSelection, this.vpc, this.commands, this.additionalInputs, this.env, this.envFromCfnOutputs, this.input, this.installCommands, this.primaryOutputDirectory);
        }
    }
}

