package software.amazon.awscdk.services.ecr;

/**
 * Authorization token to access private ECR repositories in the current environment via Docker CLI.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * User user = new User(this, "User");
 * AuthorizationToken.grantRead(user);
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry_auth.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:27:58.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecr.$Module.class, fqn = "@aws-cdk/aws-ecr.AuthorizationToken")
public class AuthorizationToken extends software.amazon.jsii.JsiiObject {

    protected AuthorizationToken(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AuthorizationToken(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Grant access to retrieve an authorization token.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.AuthorizationToken.class, "grantRead", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }
}
