/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.$Module;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs-patterns.NetworkLoadBalancedEc2ServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NetworkLoadBalancedEc2ServiceProps
extends JsiiSerializable,
NetworkLoadBalancedServiceBaseProps {
    @Nullable
    default public Number getCpu() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public Number getMemoryReservationMiB() {
        return null;
    }

    @Nullable
    default public Ec2TaskDefinition getTaskDefinition() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkLoadBalancedEc2ServiceProps> {
        private Number cpu;
        private Number memoryLimitMiB;
        private Number memoryReservationMiB;
        private Ec2TaskDefinition taskDefinition;
        private DeploymentCircuitBreaker circuitBreaker;
        private CloudMapOptions cloudMapOptions;
        private ICluster cluster;
        private DeploymentController deploymentController;
        private Number desiredCount;
        private String domainName;
        private IHostedZone domainZone;
        private Boolean enableEcsManagedTags;
        private Duration healthCheckGracePeriod;
        private Number listenerPort;
        private INetworkLoadBalancer loadBalancer;
        private Number maxHealthyPercent;
        private Number minHealthyPercent;
        private PropagatedTagSource propagateTags;
        private Boolean publicLoadBalancer;
        private NetworkLoadBalancedServiceRecordType recordType;
        private String serviceName;
        private NetworkLoadBalancedTaskImageOptions taskImageOptions;
        private IVpc vpc;

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder domainZone(IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder listenerPort(Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public Builder loadBalancer(INetworkLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder publicLoadBalancer(Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        public Builder recordType(NetworkLoadBalancedServiceRecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder taskImageOptions(NetworkLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public NetworkLoadBalancedEc2ServiceProps build() {
            return new Jsii.Proxy(this.cpu, this.memoryLimitMiB, this.memoryReservationMiB, this.taskDefinition, this.circuitBreaker, this.cloudMapOptions, this.cluster, this.deploymentController, this.desiredCount, this.domainName, this.domainZone, this.enableEcsManagedTags, this.healthCheckGracePeriod, this.listenerPort, this.loadBalancer, this.maxHealthyPercent, this.minHealthyPercent, this.propagateTags, this.publicLoadBalancer, this.recordType, this.serviceName, this.taskImageOptions, this.vpc);
        }
    }
}

