/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2Service;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBase;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.QueueProcessingEc2Service")
public class QueueProcessingEc2Service
extends QueueProcessingServiceBase {
    protected QueueProcessingEc2Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingEc2Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public QueueProcessingEc2Service(@NotNull Construct scope, @NotNull String id, @NotNull QueueProcessingEc2ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Ec2Service getService() {
        return (Ec2Service)Kernel.get((Object)((Object)this), (String)"service", (NativeType)NativeType.forClass(Ec2Service.class));
    }

    @NotNull
    public Ec2TaskDefinition getTaskDefinition() {
        return (Ec2TaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(Ec2TaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<QueueProcessingEc2Service> {
        private final Construct scope;
        private final String id;
        private final QueueProcessingEc2ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new QueueProcessingEc2ServiceProps.Builder();
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        @Deprecated
        public Builder desiredTaskCount(Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.props.enableLogging(enableLogging);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder family(String family) {
            this.props.family(family);
            return this;
        }

        public Builder logDriver(LogDriver logDriver) {
            this.props.logDriver(logDriver);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder maxReceiveCount(Number maxReceiveCount) {
            this.props.maxReceiveCount(maxReceiveCount);
            return this;
        }

        public Builder maxScalingCapacity(Number maxScalingCapacity) {
            this.props.maxScalingCapacity(maxScalingCapacity);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder minScalingCapacity(Number minScalingCapacity) {
            this.props.minScalingCapacity(minScalingCapacity);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder queue(IQueue queue) {
            this.props.queue(queue);
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.props.retentionPeriod(retentionPeriod);
            return this;
        }

        public Builder scalingSteps(List<? extends ScalingInterval> scalingSteps) {
            this.props.scalingSteps(scalingSteps);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder visibilityTimeout(Duration visibilityTimeout) {
            this.props.visibilityTimeout(visibilityTimeout);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder containerName(String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.props.placementStrategies(placementStrategies);
            return this;
        }

        public QueueProcessingEc2Service build() {
            return new QueueProcessingEc2Service(this.scope, this.id, this.props.build());
        }
    }
}

