/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancing.;
import software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancing.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.ListenerPort;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancing.LoadBalancer")
public class LoadBalancer
extends Resource
implements IConnectable {
    protected LoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull LoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ListenerPort addListener(@NotNull LoadBalancerListener listener) {
        return (ListenerPort)((Object)Kernel.call((Object)((Object)this), (String)"addListener", (NativeType)NativeType.forClass(ListenerPort.class), (Object[])new Object[]{Objects.requireNonNull(listener, "listener is required")}));
    }

    public void addTarget(@NotNull ILoadBalancerTarget target) {
        Kernel.call((Object)((Object)this), (String)"addTarget", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)((Object)this), (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public List<ListenerPort> getListenerPorts() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"listenerPorts", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ListenerPort.class))));
    }

    @NotNull
    public String getLoadBalancerCanonicalHostedZoneName() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerCanonicalHostedZoneName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getLoadBalancerCanonicalHostedZoneNameId() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerCanonicalHostedZoneNameId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getLoadBalancerDnsName() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getLoadBalancerName() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getLoadBalancerSourceSecurityGroupGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerSourceSecurityGroupGroupName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getLoadBalancerSourceSecurityGroupOwnerAlias() {
        return (String)Kernel.get((Object)((Object)this), (String)"loadBalancerSourceSecurityGroupOwnerAlias", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LoadBalancer> {
        private final Construct scope;
        private final String id;
        private final LoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LoadBalancerProps.Builder();
        }

        public Builder accessLoggingPolicy(CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }

        public Builder crossZone(Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder listeners(List<? extends LoadBalancerListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder targets(List<? extends ILoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

