/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.codepipeline.IPipeline;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.targets.$Module;
import software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-events-targets.CodePipeline")
public class CodePipeline
extends JsiiObject
implements IRuleTarget {
    protected CodePipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CodePipeline(@NotNull IPipeline pipeline, @Nullable CodePipelineTargetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(pipeline, "pipeline is required"), options});
    }

    public CodePipeline(@NotNull IPipeline pipeline) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(pipeline, "pipeline is required")});
    }

    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required"), _id});
    }

    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule) {
        return (RuleTargetConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodePipeline> {
        private final IPipeline pipeline;
        private CodePipelineTargetOptions.Builder options;

        public static Builder create(IPipeline pipeline) {
            return new Builder(pipeline);
        }

        private Builder(IPipeline pipeline) {
            this.pipeline = pipeline;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.options().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.options().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.options().retryAttempts(retryAttempts);
            return this;
        }

        public Builder eventRole(IRole eventRole) {
            this.options().eventRole(eventRole);
            return this;
        }

        public CodePipeline build() {
            return new CodePipeline(this.pipeline, this.options != null ? this.options.build() : null);
        }

        private CodePipelineTargetOptions.Builder options() {
            if (this.options == null) {
                this.options = new CodePipelineTargetOptions.Builder();
            }
            return this.options;
        }
    }
}

