package software.amazon.awscdk.services.lambda;

/**
 * Defines a Code Signing Config.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:28.665Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CodeSigningConfig")
public class CodeSigningConfig extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.lambda.ICodeSigningConfig {

    protected CodeSigningConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeSigningConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeSigningConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeSigningConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Signing Profile construct that represents an external Signing Profile.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param codeSigningConfigArn The ARN of code signing config. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ICodeSigningConfig fromCodeSigningConfigArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String codeSigningConfigArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CodeSigningConfig.class, "fromCodeSigningConfigArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ICodeSigningConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(codeSigningConfigArn, "codeSigningConfigArn is required") });
    }

    /**
     * The ARN of Code Signing Config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCodeSigningConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "codeSigningConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The id of Code Signing Config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCodeSigningConfigId() {
        return software.amazon.jsii.Kernel.get(this, "codeSigningConfigId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CodeSigningConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CodeSigningConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CodeSigningConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CodeSigningConfigProps.Builder();
        }

        /**
         * List of signing profiles that defines a trusted user who can sign a code package.
         * <p>
         * @return {@code this}
         * @param signingProfiles List of signing profiles that defines a trusted user who can sign a code package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingProfiles(final java.util.List<? extends software.amazon.awscdk.services.signer.ISigningProfile> signingProfiles) {
            this.props.signingProfiles(signingProfiles);
            return this;
        }

        /**
         * Code signing configuration description.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description Code signing configuration description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Code signing configuration policy for deployment validation failure.
         * <p>
         * If you set the policy to Enforce, Lambda blocks the deployment request
         * if signature validation checks fail.
         * If you set the policy to Warn, Lambda allows the deployment and
         * creates a CloudWatch log.
         * <p>
         * Default: UntrustedArtifactOnDeployment.WARN
         * <p>
         * @return {@code this}
         * @param untrustedArtifactOnDeployment Code signing configuration policy for deployment validation failure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder untrustedArtifactOnDeployment(final software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment untrustedArtifactOnDeployment) {
            this.props.untrustedArtifactOnDeployment(untrustedArtifactOnDeployment);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.CodeSigningConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CodeSigningConfig build() {
            return new software.amazon.awscdk.services.lambda.CodeSigningConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
