package software.amazon.awscdk.services.lambda;

/**
 * Environment variables options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:28.669Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EnvironmentOptions")
@software.amazon.jsii.Jsii.Proxy(EnvironmentOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnvironmentOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * When used in Lambda@Edge via edgeArn() API, these environment variables will be removed.
     * <p>
     * If not set, an error will be thrown.
     * <p>
     * Default: false - using the function in Lambda
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-requirements-limits.html#lambda-requirements-lambda-function-configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRemoveInEdge() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EnvironmentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EnvironmentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EnvironmentOptions> {
        private java.lang.Boolean removeInEdge;

        /**
         * Sets the value of {@link EnvironmentOptions#getRemoveInEdge}
         * @param removeInEdge When used in Lambda@Edge via edgeArn() API, these environment variables will be removed.
         *                     If not set, an error will be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeInEdge(java.lang.Boolean removeInEdge) {
            this.removeInEdge = removeInEdge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnvironmentOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EnvironmentOptions build() {
            return new Jsii$Proxy(removeInEdge);
        }
    }

    /**
     * An implementation for {@link EnvironmentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentOptions {
        private final java.lang.Boolean removeInEdge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.removeInEdge = software.amazon.jsii.Kernel.get(this, "removeInEdge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean removeInEdge) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.removeInEdge = removeInEdge;
        }

        @Override
        public final java.lang.Boolean getRemoveInEdge() {
            return this.removeInEdge;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRemoveInEdge() != null) {
                data.set("removeInEdge", om.valueToTree(this.getRemoveInEdge()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.EnvironmentOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EnvironmentOptions.Jsii$Proxy that = (EnvironmentOptions.Jsii$Proxy) o;

            return this.removeInEdge != null ? this.removeInEdge.equals(that.removeInEdge) : that.removeInEdge == null;
        }

        @Override
        public final int hashCode() {
            int result = this.removeInEdge != null ? this.removeInEdge.hashCode() : 0;
            return result;
        }
    }
}
