package software.amazon.awscdk.services.lambda;

/**
 * A Lambda that will only ever be added to a stack once.
 * <p>
 * This construct is a way to guarantee that the lambda function will be guaranteed to be part of the stack,
 * once and only once, irrespective of how many times the construct is declared to be part of the stack.
 * This is guaranteed as long as the <code>uuid</code> property and the optional <code>lambdaPurpose</code> property stay the same
 * whenever they're declared into the stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:28.703Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.SingletonFunction")
public class SingletonFunction extends software.amazon.awscdk.services.lambda.FunctionBase {

    protected SingletonFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SingletonFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SingletonFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.SingletonFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Using node.addDependency() does not work on this method as the underlying lambda function is modeled as a singleton across the stack. Use this method instead to declare dependencies.
     * <p>
     * @param up This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable... up) {
        software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(up).toArray(Object[]::new));
    }

    /**
     * Adds a permission to the Lambda resource policy.
     * <p>
     * @param name This parameter is required.
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission) {
        software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * The SingletonFunction construct cannot be added as a dependency of another construct using node.addDependency(). Use this method instead to declare this as a dependency of another construct.
     * <p>
     * @param down This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void dependOn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct down) {
        software.amazon.jsii.Kernel.call(this, "dependOn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(down, "down is required") });
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * <p>
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getCanCreatePermissions() {
        return software.amazon.jsii.Kernel.get(this, "canCreatePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Access the Connections object.
     * <p>
     * Will fail if not a VPC-enabled Lambda Function
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Returns a `lambda.Version` which represents the current version of this singleton Lambda function. A new version will be created every time the function's configuration changes.
     * <p>
     * You can specify options for this version using the <code>currentVersionOptions</code>
     * prop when initializing the <code>lambda.SingletonFunction</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Version getCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Version.class));
    }

    /**
     * The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * Whether or not this Lambda function was bound to a VPC.
     * <p>
     * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc() {
        return software.amazon.jsii.Kernel.get(this, "isBoundToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The construct node where permissions are attached.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getPermissionsNode() {
        return software.amazon.jsii.Kernel.get(this, "permissionsNode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
    }

    /**
     * The IAM role associated with this function.
     * <p>
     * Undefined if the function was imported without a role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.SingletonFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.SingletonFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.SingletonFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.SingletonFunctionProps.Builder();
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.core.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Whether to allow the Lambda to send all network traffic.
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Lambda Functions in a public subnet can NOT access the internet.
         * <p>
         * Use this property to acknowledge this limitation and still place the function in a public subnet.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841
         * @param allowPublicSubnet Lambda Functions in a public subnet can NOT access the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowPublicSubnet(final java.lang.Boolean allowPublicSubnet) {
            this.props.allowPublicSubnet(allowPublicSubnet);
            return this;
        }

        /**
         * Code signing config associated with this function.
         * <p>
         * Default: - Not Sign the Code
         * <p>
         * @return {@code this}
         * @param codeSigningConfig Code signing config associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfig(final software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig) {
            this.props.codeSigningConfig(codeSigningConfig);
            return this;
        }

        /**
         * Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * <p>
         * Default: - default options as described in `VersionOptions`
         * <p>
         * @return {@code this}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.props.currentVersionOptions(currentVersionOptions);
            return this;
        }

        /**
         * The SQS queue to use if DLQ is enabled.
         * <p>
         * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Enabled DLQ.
         * <p>
         * If <code>deadLetterQueue</code> is undefined,
         * an SQS queue with default options will be defined for your Function.
         * <p>
         * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueueEnabled Enabled DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(final java.lang.Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        /**
         * A description of the function.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * <p>
         * Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The AWS KMS key that's used to encrypt your function's environment variables.
         * <p>
         * Default: - AWS Lambda creates and uses an AWS managed customer master key (CMK).
         * <p>
         * @return {@code this}
         * @param environmentEncryption The AWS KMS key that's used to encrypt your function's environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEncryption(final software.amazon.awscdk.services.kms.IKey environmentEncryption) {
            this.props.environmentEncryption(environmentEncryption);
            return this;
        }

        /**
         * Event sources for this function.
         * <p>
         * You can also add event sources using <code>addEventSource</code>.
         * <p>
         * Default: - No event sources.
         * <p>
         * @return {@code this}
         * @param events Event sources for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.props.events(events);
            return this;
        }

        /**
         * The filesystem configuration for the lambda function.
         * <p>
         * Default: - will not mount any filesystem
         * <p>
         * @return {@code this}
         * @param filesystem The filesystem configuration for the lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filesystem(final software.amazon.awscdk.services.lambda.FileSystem filesystem) {
            this.props.filesystem(filesystem);
            return this;
        }

        /**
         * A name for the function.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         * <p>
         * @return {@code this}
         * @param functionName A name for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * Initial policy statements to add to the created Lambda Role.
         * <p>
         * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * <p>
         * Default: - No policy statements are added to the created Lambda role.
         * <p>
         * @return {@code this}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        /**
         * A list of layers to add to the function's execution environment.
         * <p>
         * You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by multiple functions.
         * <p>
         * Default: - No layers.
         * <p>
         * @return {@code this}
         * @param layers A list of layers to add to the function's execution environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<? extends software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         * <p>
         * These options control the retry policy when interacting with CloudWatch APIs.
         * <p>
         * Default: - Default AWS SDK retry options.
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - A new role is created.
         * <p>
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * <p>
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        /**
         * Enable profiling.
         * <p>
         * Default: - No profiling.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html
         * @param profiling Enable profiling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profiling(final java.lang.Boolean profiling) {
            this.props.profiling(profiling);
            return this;
        }

        /**
         * Profiling Group.
         * <p>
         * Default: - A new profiling group will be created if `profiling` is set.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html
         * @param profilingGroup Profiling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroup(final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup) {
            this.props.profilingGroup(profilingGroup);
            return this;
        }

        /**
         * The maximum of concurrent executions you want to reserve for the function.
         * <p>
         * Default: - No specific limit - account limit.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * Lambda execution role.
         * <p>
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * <p>
         * The default Role automatically has permissions granted for Lambda execution. If you
         * provide a Role, you must add the relevant AWS managed policies yourself.
         * <p>
         * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         * "service-role/AWSLambdaVPCAccessExecutionRole".
         * <p>
         * Default: - A unique role will be generated for this lambda function.
         * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         * <p>
         * @return {@code this}
         * @param role Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (deprecated) What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Use securityGroups property instead.
         * Function constructor will throw an error if both are specified.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroups prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @deprecated - This property is deprecated, use securityGroups instead
         * @param securityGroup What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * The list of security groups to associate with the Lambda's network interfaces.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroup prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The function execution time (in seconds) after which Lambda terminates the function.
         * <p>
         * Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * <p>
         * Default: Duration.seconds(3)
         * <p>
         * @return {@code this}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Enable AWS X-Ray Tracing for Lambda Function.
         * <p>
         * Default: Tracing.Disabled
         * <p>
         * @return {@code this}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        /**
         * VPC network to place Lambda network interfaces.
         * <p>
         * Specify this if the Lambda function needs to access resources in a VPC.
         * <p>
         * Default: - Function is not placed within a VPC.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place Lambda network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The source code of your Lambda function.
         * <p>
         * You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         * <p>
         * @return {@code this}
         * @param code The source code of your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * The name of the method within your code that Lambda calls to execute your function.
         * <p>
         * The format includes the file name. It can also include
         * namespaces and other qualifiers, depending on the runtime.
         * For more information, see https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html#gettingstarted-features-programmingmodel.
         * <p>
         * Use <code>Handler.FROM_IMAGE</code> when defining a function from a Docker image.
         * <p>
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         * <p>
         * @return {@code this}
         * @param handler The name of the method within your code that Lambda calls to execute your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final java.lang.String handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * The runtime environment for the Lambda function that you are uploading.
         * <p>
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         * <p>
         * Use <code>Runtime.FROM_IMAGE</code> when when defining a function from a Docker image.
         * <p>
         * @return {@code this}
         * @param runtime The runtime environment for the Lambda function that you are uploading. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * A unique identifier to identify this lambda.
         * <p>
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         * <p>
         * @return {@code this}
         * @param uuid A unique identifier to identify this lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uuid(final java.lang.String uuid) {
            this.props.uuid(uuid);
            return this;
        }

        /**
         * A descriptive name for the purpose of this Lambda.
         * <p>
         * If the Lambda does not have a physical name, this string will be
         * reflected its generated name. The combination of lambdaPurpose
         * and uuid must be unique.
         * <p>
         * Default: SingletonLambda
         * <p>
         * @return {@code this}
         * @param lambdaPurpose A descriptive name for the purpose of this Lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaPurpose(final java.lang.String lambdaPurpose) {
            this.props.lambdaPurpose(lambdaPurpose);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.SingletonFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.SingletonFunction build() {
            return new software.amazon.awscdk.services.lambda.SingletonFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
