/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.ConstructNode;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.$Module;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.EnvironmentOptions;
import software.amazon.awscdk.services.lambda.EventInvokeConfigOptions;
import software.amazon.awscdk.services.lambda.FileSystem;
import software.amazon.awscdk.services.lambda.FunctionAttributes;
import software.amazon.awscdk.services.lambda.FunctionBase;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.lambda.ICodeSigningConfig;
import software.amazon.awscdk.services.lambda.IDestination;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.awscdk.services.lambda.LogRetentionRetryOptions;
import software.amazon.awscdk.services.lambda.Runtime;
import software.amazon.awscdk.services.lambda.Tracing;
import software.amazon.awscdk.services.lambda.Version;
import software.amazon.awscdk.services.lambda.VersionOptions;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.Function")
public class Function
extends FunctionBase {
    protected Function(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Function(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Function(@NotNull Construct scope, @NotNull String id, @NotNull FunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IFunction fromFunctionArn(@NotNull Construct scope, @NotNull String id, @NotNull String functionArn) {
        return (IFunction)JsiiObject.jsiiStaticCall(Function.class, (String)"fromFunctionArn", (NativeType)NativeType.forClass(IFunction.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(functionArn, "functionArn is required")});
    }

    @NotNull
    public static IFunction fromFunctionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull FunctionAttributes attrs) {
        return (IFunction)JsiiObject.jsiiStaticCall(Function.class, (String)"fromFunctionAttributes", (NativeType)NativeType.forClass(IFunction.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public static Metric metricAllConcurrentExecutions(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllConcurrentExecutions", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllConcurrentExecutions() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllConcurrentExecutions", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllDuration(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllDuration", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllDuration() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllDuration", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllErrors(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllErrors() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllInvocations(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllInvocations", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllInvocations() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllInvocations", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllThrottles(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllThrottles", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllThrottles() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllThrottles", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllUnreservedConcurrentExecutions(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllUnreservedConcurrentExecutions", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllUnreservedConcurrentExecutions() {
        return (Metric)JsiiObject.jsiiStaticCall(Function.class, (String)"metricAllUnreservedConcurrentExecutions", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Function addEnvironment(@NotNull String key, @NotNull String value, @Nullable EnvironmentOptions options) {
        return (Function)Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.forClass(Function.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), options});
    }

    @NotNull
    public Function addEnvironment(@NotNull String key, @NotNull String value) {
        return (Function)Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.forClass(Function.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void addLayers(ILayerVersion ... layers) {
        Kernel.call((Object)this, (String)"addLayers", (NativeType)NativeType.VOID, (Object[])Arrays.stream(layers).toArray(Object[]::new));
    }

    @Deprecated
    @NotNull
    public Version addVersion(@NotNull String name, @Nullable String codeSha256, @Nullable String description, @Nullable Number provisionedExecutions, @Nullable EventInvokeConfigOptions asyncInvokeConfig) {
        return (Version)Kernel.call((Object)this, (String)"addVersion", (NativeType)NativeType.forClass(Version.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), codeSha256, description, provisionedExecutions, asyncInvokeConfig});
    }

    @Deprecated
    @NotNull
    public Version addVersion(@NotNull String name, @Nullable String codeSha256, @Nullable String description, @Nullable Number provisionedExecutions) {
        return (Version)Kernel.call((Object)this, (String)"addVersion", (NativeType)NativeType.forClass(Version.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), codeSha256, description, provisionedExecutions});
    }

    @Deprecated
    @NotNull
    public Version addVersion(@NotNull String name, @Nullable String codeSha256, @Nullable String description) {
        return (Version)Kernel.call((Object)this, (String)"addVersion", (NativeType)NativeType.forClass(Version.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), codeSha256, description});
    }

    @Deprecated
    @NotNull
    public Version addVersion(@NotNull String name, @Nullable String codeSha256) {
        return (Version)Kernel.call((Object)this, (String)"addVersion", (NativeType)NativeType.forClass(Version.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), codeSha256});
    }

    @Deprecated
    @NotNull
    public Version addVersion(@NotNull String name) {
        return (Version)Kernel.call((Object)this, (String)"addVersion", (NativeType)NativeType.forClass(Version.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    @Override
    @NotNull
    protected Boolean getCanCreatePermissions() {
        return (Boolean)Kernel.get((Object)this, (String)"canCreatePermissions", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Version getCurrentVersion() {
        return (Version)Kernel.get((Object)this, (String)"currentVersion", (NativeType)NativeType.forClass(Version.class));
    }

    @Override
    @NotNull
    public String getFunctionArn() {
        return (String)Kernel.get((Object)this, (String)"functionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getFunctionName() {
        return (String)Kernel.get((Object)this, (String)"functionName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public ILogGroup getLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"logGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Override
    @NotNull
    public ConstructNode getPermissionsNode() {
        return (ConstructNode)Kernel.get((Object)this, (String)"permissionsNode", (NativeType)NativeType.forClass(ConstructNode.class));
    }

    @NotNull
    public Runtime getRuntime() {
        return (Runtime)((Object)Kernel.get((Object)this, (String)"runtime", (NativeType)NativeType.forClass(Runtime.class)));
    }

    @Nullable
    public IQueue getDeadLetterQueue() {
        return (IQueue)Kernel.get((Object)this, (String)"deadLetterQueue", (NativeType)NativeType.forClass(IQueue.class));
    }

    @Override
    @Nullable
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Function> {
        private final Construct scope;
        private final String id;
        private final FunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FunctionProps.Builder();
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        public Builder onFailure(IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        public Builder onSuccess(IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder allowPublicSubnet(Boolean allowPublicSubnet) {
            this.props.allowPublicSubnet(allowPublicSubnet);
            return this;
        }

        public Builder codeSigningConfig(ICodeSigningConfig codeSigningConfig) {
            this.props.codeSigningConfig(codeSigningConfig);
            return this;
        }

        public Builder currentVersionOptions(VersionOptions currentVersionOptions) {
            this.props.currentVersionOptions(currentVersionOptions);
            return this;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deadLetterQueueEnabled(Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environmentEncryption(IKey environmentEncryption) {
            this.props.environmentEncryption(environmentEncryption);
            return this;
        }

        public Builder events(List<? extends IEventSource> events) {
            this.props.events(events);
            return this;
        }

        public Builder filesystem(FileSystem filesystem) {
            this.props.filesystem(filesystem);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder initialPolicy(List<? extends PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        public Builder layers(List<? extends ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        public Builder logRetention(RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        public Builder logRetentionRetryOptions(LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        public Builder logRetentionRole(IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        public Builder profiling(Boolean profiling) {
            this.props.profiling(profiling);
            return this;
        }

        public Builder profilingGroup(IProfilingGroup profilingGroup) {
            this.props.profilingGroup(profilingGroup);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        @Deprecated
        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracing(Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder code(Code code) {
            this.props.code(code);
            return this;
        }

        public Builder handler(String handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder runtime(Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Function build() {
            return new Function(this.scope, this.id, this.props.build());
        }
    }
}

