/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RevocationReason {
    UNSPECIFIED("UNSPECIFIED"),
    KEY_COMPROMISE("KEY_COMPROMISE"),
    CA_COMPROMISE("CA_COMPROMISE"),
    AFFILIATION_CHANGED("AFFILIATION_CHANGED"),
    SUPERCEDED("SUPERCEDED"),
    SUPERSEDED("SUPERSEDED"),
    CESSATION_OF_OPERATION("CESSATION_OF_OPERATION"),
    CERTIFICATE_HOLD("CERTIFICATE_HOLD"),
    REMOVE_FROM_CRL("REMOVE_FROM_CRL"),
    PRIVILEGE_WITHDRAWN("PRIVILEGE_WITHDRAWN"),
    A_A_COMPROMISE("A_A_COMPROMISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RevocationReason> VALUE_MAP;
    private final String value;

    private RevocationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevocationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevocationReason> knownValues() {
        EnumSet<RevocationReason> knownValues = EnumSet.allOf(RevocationReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RevocationReason.class, RevocationReason::toString);
    }
}

