/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.acmpca.model.AcmPcaException;
import software.amazon.awssdk.services.acmpca.model.CertificateMismatchException;
import software.amazon.awssdk.services.acmpca.model.ConcurrentModificationException;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.InvalidArgsException;
import software.amazon.awssdk.services.acmpca.model.InvalidArnException;
import software.amazon.awssdk.services.acmpca.model.InvalidNextTokenException;
import software.amazon.awssdk.services.acmpca.model.InvalidPolicyException;
import software.amazon.awssdk.services.acmpca.model.InvalidStateException;
import software.amazon.awssdk.services.acmpca.model.InvalidTagException;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.LimitExceededException;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse;
import software.amazon.awssdk.services.acmpca.model.ListTagsRequest;
import software.amazon.awssdk.services.acmpca.model.ListTagsResponse;
import software.amazon.awssdk.services.acmpca.model.MalformedCertificateException;
import software.amazon.awssdk.services.acmpca.model.MalformedCsrException;
import software.amazon.awssdk.services.acmpca.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.acmpca.model.RequestAlreadyProcessedException;
import software.amazon.awssdk.services.acmpca.model.RequestFailedException;
import software.amazon.awssdk.services.acmpca.model.RequestInProgressException;
import software.amazon.awssdk.services.acmpca.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.TooManyTagsException;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable;
import software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable;

/**
 * Service client for accessing ACM-PCA. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * You can use the ACM PCA API to create a private certificate authority (CA). You must first call the
 * <a>CreateCertificateAuthority</a> operation. If successful, the operation returns an Amazon Resource Name (ARN) for
 * your private CA. Use this ARN as input to the <a>GetCertificateAuthorityCsr</a> operation to retrieve the certificate
 * signing request (CSR) for your private CA certificate. Sign the CSR using the root or an intermediate CA in your
 * on-premises PKI hierarchy, and call the <a>ImportCertificateAuthorityCertificate</a> to import your signed private CA
 * certificate into ACM PCA.
 * </p>
 * <p>
 * Use your private CA to issue and revoke certificates. These are private certificates that identify and secure client
 * computers, servers, applications, services, devices, and users over SSLS/TLS connections within your organization.
 * Call the <a>IssueCertificate</a> operation to issue a certificate. Call the <a>RevokeCertificate</a> operation to
 * revoke a certificate.
 * </p>
 * <note>
 * <p>
 * Certificates issued by your private CA can be trusted only within your organization, not publicly.
 * </p>
 * </note>
 * <p>
 * Your private CA can optionally create a certificate revocation list (CRL) to track the certificates you revoke. To
 * create a CRL, you must specify a <a>RevocationConfiguration</a> object when you call the
 * <a>CreateCertificateAuthority</a> operation. ACM PCA writes the CRL to an S3 bucket that you specify. You must
 * specify a bucket policy that grants ACM PCA write permission.
 * </p>
 * <p>
 * You can also call the <a>CreateCertificateAuthorityAuditReport</a> to create an optional audit report, which
 * enumerates all of the issued, valid, expired, and revoked certificates from the CA.
 * </p>
 * <note>
 * <p>
 * Each ACM PCA API operation has a throttling limit which determines the number of times the operation can be called
 * per second. For more information, see <a
 * href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaLimits.html#PcaLimits-api">API Rate Limits in ACM
 * PCA</a> in the ACM PCA user guide.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AcmPcaClient extends SdkClient {
    String SERVICE_NAME = "acm-pca";

    /**
     * Create a {@link AcmPcaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AcmPcaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AcmPcaClient}.
     */
    static AcmPcaClientBuilder builder() {
        return new DefaultAcmPcaClientBuilder();
    }

    /**
     * <p>
     * Creates a private subordinate certificate authority (CA). You must specify the CA configuration, the revocation
     * configuration, the CA type, and an optional idempotency token. The CA configuration specifies the name of the
     * algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses to
     * sign, and X.500 subject information. The CRL (certificate revocation list) configuration specifies the CRL
     * expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a
     * CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this operation
     * returns the Amazon Resource Name (ARN) of the CA.
     * </p>
     *
     * @param createCertificateAuthorityRequest
     * @return Result of the CreateCertificateAuthority operation returned by the service.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidPolicyException
     *         The S3 bucket policy is not valid. The policy must give ACM PCA rights to read from and write to the
     *         bucket and find the bucket location.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreateCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCertificateAuthorityResponse createCertificateAuthority(
            CreateCertificateAuthorityRequest createCertificateAuthorityRequest) throws InvalidArgsException,
            InvalidPolicyException, InvalidTagException, LimitExceededException, AwsServiceException, SdkClientException,
            AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private subordinate certificate authority (CA). You must specify the CA configuration, the revocation
     * configuration, the CA type, and an optional idempotency token. The CA configuration specifies the name of the
     * algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses to
     * sign, and X.500 subject information. The CRL (certificate revocation list) configuration specifies the CRL
     * expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a
     * CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this operation
     * returns the Amazon Resource Name (ARN) of the CA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCertificateAuthorityRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param createCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link CreateCertificateAuthorityRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCertificateAuthority operation returned by the service.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidPolicyException
     *         The S3 bucket policy is not valid. The policy must give ACM PCA rights to read from and write to the
     *         bucket and find the bucket location.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreateCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCertificateAuthorityResponse createCertificateAuthority(
            Consumer<CreateCertificateAuthorityRequest.Builder> createCertificateAuthorityRequest) throws InvalidArgsException,
            InvalidPolicyException, InvalidTagException, LimitExceededException, AwsServiceException, SdkClientException,
            AcmPcaException {
        return createCertificateAuthority(CreateCertificateAuthorityRequest.builder()
                .applyMutation(createCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon
     * S3 bucket that you specify on input. The <a>IssueCertificate</a> and <a>RevokeCertificate</a> operations use the
     * private key. You can generate a new report every 30 minutes.
     * </p>
     *
     * @param createCertificateAuthorityAuditReportRequest
     * @return Result of the CreateCertificateAuthorityAuditReport operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreateCertificateAuthorityAuditReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReport(
            CreateCertificateAuthorityAuditReportRequest createCertificateAuthorityAuditReportRequest)
            throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException,
            InvalidArgsException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon
     * S3 bucket that you specify on input. The <a>IssueCertificate</a> and <a>RevokeCertificate</a> operations use the
     * private key. You can generate a new report every 30 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCertificateAuthorityAuditReportRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCertificateAuthorityAuditReportRequest#builder()}
     * </p>
     *
     * @param createCertificateAuthorityAuditReportRequest
     *        A {@link Consumer} that will call methods on {@link CreateCertificateAuthorityAuditReportRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCertificateAuthorityAuditReport operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreateCertificateAuthorityAuditReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReport(
            Consumer<CreateCertificateAuthorityAuditReportRequest.Builder> createCertificateAuthorityAuditReportRequest)
            throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException,
            InvalidArgsException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        return createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest.builder()
                .applyMutation(createCertificateAuthorityAuditReportRequest).build());
    }

    /**
     * <p>
     * Assigns permissions from a private CA to a designated AWS service. Services are specified by their service
     * principals and can be given permission to create and retrieve certificates on a private CA. Services can also be
     * given permission to list the active permissions that the private CA has granted. For ACM to automatically renew
     * your private CA's certificates, you must assign all possible permissions from the CA to the ACM service
     * principal.
     * </p>
     * <p>
     * At this time, you can only assign permissions to ACM (<code>acm.amazonaws.com</code>). Permissions can be revoked
     * with the <a>DeletePermission</a> operation and listed with the <a>ListPermissions</a> operation.
     * </p>
     *
     * @param createPermissionRequest
     * @return Result of the CreatePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws PermissionAlreadyExistsException
     *         The designated permission has already been given to the user.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreatePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePermissionResponse createPermission(CreatePermissionRequest createPermissionRequest)
            throws ResourceNotFoundException, InvalidArnException, PermissionAlreadyExistsException, LimitExceededException,
            InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns permissions from a private CA to a designated AWS service. Services are specified by their service
     * principals and can be given permission to create and retrieve certificates on a private CA. Services can also be
     * given permission to list the active permissions that the private CA has granted. For ACM to automatically renew
     * your private CA's certificates, you must assign all possible permissions from the CA to the ACM service
     * principal.
     * </p>
     * <p>
     * At this time, you can only assign permissions to ACM (<code>acm.amazonaws.com</code>). Permissions can be revoked
     * with the <a>DeletePermission</a> operation and listed with the <a>ListPermissions</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePermissionRequest#builder()}
     * </p>
     *
     * @param createPermissionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePermissionRequest.Builder} to create a request.
     * @return Result of the CreatePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws PermissionAlreadyExistsException
     *         The designated permission has already been given to the user.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.CreatePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePermissionResponse createPermission(Consumer<CreatePermissionRequest.Builder> createPermissionRequest)
            throws ResourceNotFoundException, InvalidArnException, PermissionAlreadyExistsException, LimitExceededException,
            InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        return createPermission(CreatePermissionRequest.builder().applyMutation(createPermissionRequest).build());
    }

    /**
     * <p>
     * Deletes a private certificate authority (CA). You must provide the ARN (Amazon Resource Name) of the private CA
     * that you want to delete. You can find the ARN by calling the <a>ListCertificateAuthorities</a> operation. Before
     * you can delete a CA, you must disable it. Call the <a>UpdateCertificateAuthority</a> operation and set the
     * <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>.
     * </p>
     * <p>
     * Additionally, you can delete a CA if you are waiting for it to be created (the <b>Status</b> field of the
     * <a>CertificateAuthority</a> is <code>CREATING</code>). You can also delete it if the CA has been created but you
     * haven't yet imported the signed certificate (the <b>Status</b> is <code>PENDING_CERTIFICATE</code>) into ACM PCA.
     * </p>
     * <p>
     * If the CA is in one of the previously mentioned states and you call <a>DeleteCertificateAuthority</a>, the CA's
     * status changes to <code>DELETED</code>. However, the CA won't be permanently deleted until the restoration period
     * has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains
     * restorable for 30 days. You can set the parameter from 7 to 30 days. The <a>DescribeCertificateAuthority</a>
     * operation returns the time remaining in the restoration window of a Private CA in the <code>DELETED</code> state.
     * To restore an eligible CA, call the <a>RestoreCertificateAuthority</a> operation.
     * </p>
     *
     * @param deleteCertificateAuthorityRequest
     * @return Result of the DeleteCertificateAuthority operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DeleteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCertificateAuthorityResponse deleteCertificateAuthority(
            DeleteCertificateAuthorityRequest deleteCertificateAuthorityRequest) throws ConcurrentModificationException,
            ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException,
            AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a private certificate authority (CA). You must provide the ARN (Amazon Resource Name) of the private CA
     * that you want to delete. You can find the ARN by calling the <a>ListCertificateAuthorities</a> operation. Before
     * you can delete a CA, you must disable it. Call the <a>UpdateCertificateAuthority</a> operation and set the
     * <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>.
     * </p>
     * <p>
     * Additionally, you can delete a CA if you are waiting for it to be created (the <b>Status</b> field of the
     * <a>CertificateAuthority</a> is <code>CREATING</code>). You can also delete it if the CA has been created but you
     * haven't yet imported the signed certificate (the <b>Status</b> is <code>PENDING_CERTIFICATE</code>) into ACM PCA.
     * </p>
     * <p>
     * If the CA is in one of the previously mentioned states and you call <a>DeleteCertificateAuthority</a>, the CA's
     * status changes to <code>DELETED</code>. However, the CA won't be permanently deleted until the restoration period
     * has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains
     * restorable for 30 days. You can set the parameter from 7 to 30 days. The <a>DescribeCertificateAuthority</a>
     * operation returns the time remaining in the restoration window of a Private CA in the <code>DELETED</code> state.
     * To restore an eligible CA, call the <a>RestoreCertificateAuthority</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateAuthorityRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param deleteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCertificateAuthorityRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCertificateAuthority operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DeleteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCertificateAuthorityResponse deleteCertificateAuthority(
            Consumer<DeleteCertificateAuthorityRequest.Builder> deleteCertificateAuthorityRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, InvalidArnException, InvalidStateException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return deleteCertificateAuthority(DeleteCertificateAuthorityRequest.builder()
                .applyMutation(deleteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Revokes permissions that a private CA assigned to a designated AWS service. Permissions can be created with the
     * <a>CreatePermission</a> operation and listed with the <a>ListPermissions</a> operation.
     * </p>
     *
     * @param deletePermissionRequest
     * @return Result of the DeletePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DeletePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePermissionResponse deletePermission(DeletePermissionRequest deletePermissionRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes permissions that a private CA assigned to a designated AWS service. Permissions can be created with the
     * <a>CreatePermission</a> operation and listed with the <a>ListPermissions</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePermissionRequest#builder()}
     * </p>
     *
     * @param deletePermissionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionRequest.Builder} to create a request.
     * @return Result of the DeletePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DeletePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePermissionResponse deletePermission(Consumer<DeletePermissionRequest.Builder> deletePermissionRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return deletePermission(DeletePermissionRequest.builder().applyMutation(deletePermissionRequest).build());
    }

    /**
     * <p>
     * Lists information about your private certificate authority (CA). You specify the private CA on input by its ARN
     * (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - ACM PCA is creating your private certificate authority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your on-premises root or subordinate
     * CA to sign your private CA CSR and then import it into PCA.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - Your private CA is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Your private CA has been disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - Your private CA certificate has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or
     * backend AWS failure or other errors. A failed CA can never return to the pending state. You must create a new CA.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted.
     * The length of time remaining in the CA's restoration period is also included in this operation's output.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeCertificateAuthorityRequest
     * @return Result of the DescribeCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DescribeCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCertificateAuthorityResponse describeCertificateAuthority(
            DescribeCertificateAuthorityRequest describeCertificateAuthorityRequest) throws ResourceNotFoundException,
            InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about your private certificate authority (CA). You specify the private CA on input by its ARN
     * (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - ACM PCA is creating your private certificate authority.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your on-premises root or subordinate
     * CA to sign your private CA CSR and then import it into PCA.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - Your private CA is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Your private CA has been disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - Your private CA certificate has expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or
     * backend AWS failure or other errors. A failed CA can never return to the pending state. You must create a new CA.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted.
     * The length of time remaining in the CA's restoration period is also included in this operation's output.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param describeCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificateAuthorityRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DescribeCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCertificateAuthorityResponse describeCertificateAuthority(
            Consumer<DescribeCertificateAuthorityRequest.Builder> describeCertificateAuthorityRequest)
            throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        return describeCertificateAuthority(DescribeCertificateAuthorityRequest.builder()
                .applyMutation(describeCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Lists information about a specific audit report created by calling the
     * <a>CreateCertificateAuthorityAuditReport</a> operation. Audit information is created every time the certificate
     * authority (CA) private key is used. The private key is used when you call the <a>IssueCertificate</a> operation
     * or the <a>RevokeCertificate</a> operation.
     * </p>
     *
     * @param describeCertificateAuthorityAuditReportRequest
     * @return Result of the DescribeCertificateAuthorityAuditReport operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DescribeCertificateAuthorityAuditReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReport(
            DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidArgsException, AwsServiceException, SdkClientException,
            AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a specific audit report created by calling the
     * <a>CreateCertificateAuthorityAuditReport</a> operation. Audit information is created every time the certificate
     * authority (CA) private key is used. The private key is used when you call the <a>IssueCertificate</a> operation
     * or the <a>RevokeCertificate</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeCertificateAuthorityAuditReportRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeCertificateAuthorityAuditReportRequest#builder()}
     * </p>
     *
     * @param describeCertificateAuthorityAuditReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeCertificateAuthorityAuditReportRequest.Builder} to create a request.
     * @return Result of the DescribeCertificateAuthorityAuditReport operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.DescribeCertificateAuthorityAuditReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReport(
            Consumer<DescribeCertificateAuthorityAuditReportRequest.Builder> describeCertificateAuthorityAuditReportRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidArgsException, AwsServiceException, SdkClientException,
            AcmPcaException {
        return describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest.builder()
                .applyMutation(describeCertificateAuthorityAuditReportRequest).build());
    }

    /**
     * <p>
     * Retrieves a certificate from your private CA. The ARN of the certificate is returned when you call the
     * <a>IssueCertificate</a> operation. You must specify both the ARN of your private CA and the ARN of the issued
     * certificate when calling the <b>GetCertificate</b> operation. You can retrieve the certificate if it is in the
     * <b>ISSUED</b> state. You can call the <a>CreateCertificateAuthorityAuditReport</a> operation to create a report
     * that contains information about all of the certificates issued and revoked by your private CA.
     * </p>
     *
     * @param getCertificateRequest
     * @return Result of the GetCertificate operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCertificateResponse getCertificate(GetCertificateRequest getCertificateRequest) throws RequestInProgressException,
            RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException,
            SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a certificate from your private CA. The ARN of the certificate is returned when you call the
     * <a>IssueCertificate</a> operation. You must specify both the ARN of your private CA and the ARN of the issued
     * certificate when calling the <b>GetCertificate</b> operation. You can retrieve the certificate if it is in the
     * <b>ISSUED</b> state. You can call the <a>CreateCertificateAuthorityAuditReport</a> operation to create a report
     * that contains information about all of the certificates issued and revoked by your private CA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCertificateRequest.Builder} avoiding the need to
     * create one manually via {@link GetCertificateRequest#builder()}
     * </p>
     *
     * @param getCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetCertificateRequest.Builder} to create a request.
     * @return Result of the GetCertificate operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCertificateResponse getCertificate(Consumer<GetCertificateRequest.Builder> getCertificateRequest)
            throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException,
            InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        return getCertificate(GetCertificateRequest.builder().applyMutation(getCertificateRequest).build());
    }

    /**
     * <p>
     * Retrieves the certificate and certificate chain for your private certificate authority (CA). Both the certificate
     * and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the
     * chain signs the one before it.
     * </p>
     *
     * @param getCertificateAuthorityCertificateRequest
     * @return Result of the GetCertificateAuthorityCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificateAuthorityCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificate(
            GetCertificateAuthorityCertificateRequest getCertificateAuthorityCertificateRequest)
            throws ResourceNotFoundException, InvalidStateException, InvalidArnException, AwsServiceException,
            SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the certificate and certificate chain for your private certificate authority (CA). Both the certificate
     * and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the
     * chain signs the one before it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCertificateAuthorityCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCertificateAuthorityCertificateRequest#builder()}
     * </p>
     *
     * @param getCertificateAuthorityCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetCertificateAuthorityCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the GetCertificateAuthorityCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificateAuthorityCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificate(
            Consumer<GetCertificateAuthorityCertificateRequest.Builder> getCertificateAuthorityCertificateRequest)
            throws ResourceNotFoundException, InvalidStateException, InvalidArnException, AwsServiceException,
            SdkClientException, AcmPcaException {
        return getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest.builder()
                .applyMutation(getCertificateAuthorityCertificateRequest).build());
    }

    /**
     * <p>
     * Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created
     * when you call the <a>CreateCertificateAuthority</a> operation. Take the CSR to your on-premises X.509
     * infrastructure and sign it by using your root or a subordinate CA. Then import the signed certificate back into
     * ACM PCA by calling the <a>ImportCertificateAuthorityCertificate</a> operation. The CSR is returned as a base64
     * PEM-encoded string.
     * </p>
     *
     * @param getCertificateAuthorityCsrRequest
     * @return Result of the GetCertificateAuthorityCsr operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificateAuthorityCsr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCertificateAuthorityCsrResponse getCertificateAuthorityCsr(
            GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) throws RequestInProgressException,
            RequestFailedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException,
            SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created
     * when you call the <a>CreateCertificateAuthority</a> operation. Take the CSR to your on-premises X.509
     * infrastructure and sign it by using your root or a subordinate CA. Then import the signed certificate back into
     * ACM PCA by calling the <a>ImportCertificateAuthorityCertificate</a> operation. The CSR is returned as a base64
     * PEM-encoded string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCertificateAuthorityCsrRequest.Builder} avoiding
     * the need to create one manually via {@link GetCertificateAuthorityCsrRequest#builder()}
     * </p>
     *
     * @param getCertificateAuthorityCsrRequest
     *        A {@link Consumer} that will call methods on {@link GetCertificateAuthorityCsrRequest.Builder} to create a
     *        request.
     * @return Result of the GetCertificateAuthorityCsr operation returned by the service.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.GetCertificateAuthorityCsr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCertificateAuthorityCsrResponse getCertificateAuthorityCsr(
            Consumer<GetCertificateAuthorityCsrRequest.Builder> getCertificateAuthorityCsrRequest)
            throws RequestInProgressException, RequestFailedException, ResourceNotFoundException, InvalidArnException,
            InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        return getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest.builder()
                .applyMutation(getCertificateAuthorityCsrRequest).build());
    }

    /**
     * <p>
     * Imports your signed private CA certificate into ACM PCA. Before you can call this operation, you must create the
     * private certificate authority by calling the <a>CreateCertificateAuthority</a> operation. You must then generate
     * a certificate signing request (CSR) by calling the <a>GetCertificateAuthorityCsr</a> operation. Take the CSR to
     * your on-premises CA and use the root certificate or a subordinate certificate to sign it. Create a certificate
     * chain and copy the signed certificate and the certificate chain to your working directory.
     * </p>
     * <note>
     * <p>
     * Your certificate chain must not include the private CA certificate that you are importing.
     * </p>
     * </note> <note>
     * <p>
     * Your on-premises CA certificate must be the last certificate in your chain. The subordinate certificate, if any,
     * that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA
     * must come next, and so on until your chain is built.
     * </p>
     * </note> <note>
     * <p>
     * The chain must be PEM-encoded.
     * </p>
     * </note>
     *
     * @param importCertificateAuthorityCertificateRequest
     * @return Result of the ImportCertificateAuthorityCertificate operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws MalformedCertificateException
     *         One or more fields in the certificate are invalid.
     * @throws CertificateMismatchException
     *         The certificate authority certificate you are importing does not comply with conditions specified in the
     *         certificate that signed it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ImportCertificateAuthorityCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificate(
            ImportCertificateAuthorityCertificateRequest importCertificateAuthorityCertificateRequest)
            throws ConcurrentModificationException, RequestInProgressException, RequestFailedException,
            ResourceNotFoundException, InvalidArnException, InvalidStateException, MalformedCertificateException,
            CertificateMismatchException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports your signed private CA certificate into ACM PCA. Before you can call this operation, you must create the
     * private certificate authority by calling the <a>CreateCertificateAuthority</a> operation. You must then generate
     * a certificate signing request (CSR) by calling the <a>GetCertificateAuthorityCsr</a> operation. Take the CSR to
     * your on-premises CA and use the root certificate or a subordinate certificate to sign it. Create a certificate
     * chain and copy the signed certificate and the certificate chain to your working directory.
     * </p>
     * <note>
     * <p>
     * Your certificate chain must not include the private CA certificate that you are importing.
     * </p>
     * </note> <note>
     * <p>
     * Your on-premises CA certificate must be the last certificate in your chain. The subordinate certificate, if any,
     * that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA
     * must come next, and so on until your chain is built.
     * </p>
     * </note> <note>
     * <p>
     * The chain must be PEM-encoded.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ImportCertificateAuthorityCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link ImportCertificateAuthorityCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateAuthorityCertificateRequest
     *        A {@link Consumer} that will call methods on {@link ImportCertificateAuthorityCertificateRequest.Builder}
     *        to create a request.
     * @return Result of the ImportCertificateAuthorityCertificate operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws MalformedCertificateException
     *         One or more fields in the certificate are invalid.
     * @throws CertificateMismatchException
     *         The certificate authority certificate you are importing does not comply with conditions specified in the
     *         certificate that signed it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ImportCertificateAuthorityCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificate(
            Consumer<ImportCertificateAuthorityCertificateRequest.Builder> importCertificateAuthorityCertificateRequest)
            throws ConcurrentModificationException, RequestInProgressException, RequestFailedException,
            ResourceNotFoundException, InvalidArnException, InvalidStateException, MalformedCertificateException,
            CertificateMismatchException, AwsServiceException, SdkClientException, AcmPcaException {
        return importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest.builder()
                .applyMutation(importCertificateAuthorityCertificateRequest).build());
    }

    /**
     * <p>
     * Uses your private certificate authority (CA) to issue a client certificate. This operation returns the Amazon
     * Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a>GetCertificate</a>
     * operation and specifying the ARN.
     * </p>
     * <note>
     * <p>
     * You cannot use the ACM <b>ListCertificateAuthorities</b> operation to retrieve the ARNs of the certificates that
     * you issue by using ACM PCA.
     * </p>
     * </note>
     *
     * @param issueCertificateRequest
     * @return Result of the IssueCertificate operation returned by the service.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws MalformedCsrException
     *         The certificate signing request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.IssueCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default IssueCertificateResponse issueCertificate(IssueCertificateRequest issueCertificateRequest)
            throws LimitExceededException, ResourceNotFoundException, InvalidStateException, InvalidArnException,
            InvalidArgsException, MalformedCsrException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uses your private certificate authority (CA) to issue a client certificate. This operation returns the Amazon
     * Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a>GetCertificate</a>
     * operation and specifying the ARN.
     * </p>
     * <note>
     * <p>
     * You cannot use the ACM <b>ListCertificateAuthorities</b> operation to retrieve the ARNs of the certificates that
     * you issue by using ACM PCA.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IssueCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link IssueCertificateRequest#builder()}
     * </p>
     *
     * @param issueCertificateRequest
     *        A {@link Consumer} that will call methods on {@link IssueCertificateRequest.Builder} to create a request.
     * @return Result of the IssueCertificate operation returned by the service.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws MalformedCsrException
     *         The certificate signing request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.IssueCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default IssueCertificateResponse issueCertificate(Consumer<IssueCertificateRequest.Builder> issueCertificateRequest)
            throws LimitExceededException, ResourceNotFoundException, InvalidStateException, InvalidArnException,
            InvalidArgsException, MalformedCsrException, AwsServiceException, SdkClientException, AcmPcaException {
        return issueCertificate(IssueCertificateRequest.builder().applyMutation(issueCertificateRequest).build());
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     *
     * @return Result of the ListCertificateAuthorities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see #listCertificateAuthorities(ListCertificateAuthoritiesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesResponse listCertificateAuthorities() throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return listCertificateAuthorities(ListCertificateAuthoritiesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     *
     * @param listCertificateAuthoritiesRequest
     * @return Result of the ListCertificateAuthorities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesResponse listCertificateAuthorities(
            ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificateAuthoritiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificateAuthoritiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListCertificateAuthorities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesResponse listCertificateAuthorities(
            Consumer<ListCertificateAuthoritiesRequest.Builder> listCertificateAuthoritiesRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        return listCertificateAuthorities(ListCertificateAuthoritiesRequest.builder()
                .applyMutation(listCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client
     *             .listCertificateAuthoritiesPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see #listCertificateAuthoritiesPaginator(ListCertificateAuthoritiesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesIterable listCertificateAuthoritiesPaginator() throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return listCertificateAuthoritiesPaginator(ListCertificateAuthoritiesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client
     *             .listCertificateAuthoritiesPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCertificateAuthoritiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesIterable listCertificateAuthoritiesPaginator(
            ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client
     *             .listCertificateAuthoritiesPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListCertificateAuthoritiesIterable responses = client.listCertificateAuthoritiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificateAuthorities(software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificateAuthoritiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificateAuthoritiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCertificateAuthoritiesIterable listCertificateAuthoritiesPaginator(
            Consumer<ListCertificateAuthoritiesRequest.Builder> listCertificateAuthoritiesRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        return listCertificateAuthoritiesPaginator(ListCertificateAuthoritiesRequest.builder()
                .applyMutation(listCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the
     * <a>CreatePermission</a> operation and revoked with the <a>DeletePermission</a> operation.
     * </p>
     *
     * @param listPermissionsRequest
     * @return Result of the ListPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException,
            RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the
     * <a>CreatePermission</a> operation and revoked with the <a>DeletePermission</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return Result of the ListPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException,
            RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the
     * <a>CreatePermission</a> operation and revoked with the <a>DeletePermission</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest)} operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException,
            RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the
     * <a>CreatePermission</a> operation and revoked with the <a>DeletePermission</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidNextTokenException
     *         The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your
     *         previous call to <a>ListCertificateAuthorities</a>.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidNextTokenException, InvalidStateException,
            RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify
     * and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a>
     * operation to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> operation to remove tags.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidArnException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify
     * and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a>
     * operation to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> operation to remove tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ResourceNotFoundException,
            InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify
     * and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a>
     * operation to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> operation to remove tags.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.acmpca.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.acmpca.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify
     * and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a>
     * operation to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> operation to remove tags.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.acmpca.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.acmpca.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.acmpca.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.acmpca.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest)
            throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the
     * period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the
     * <a>DeleteCertificateAuthority</a> operation. Currently, you can specify 7 to 30 days. If you did not specify a
     * <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You
     * can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by
     * calling the <a>DescribeCertificateAuthority</a> or <a>ListCertificateAuthorities</a> operations. The status of a
     * restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> operation returns. To
     * change its status to <code>ACTIVE</code>, call the <a>UpdateCertificateAuthority</a> operation. If the private CA
     * was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the
     * <a>ImportCertificateAuthorityCertificate</a> operation to import a certificate authority into the private CA
     * before it can be activated. You cannot restore a CA after the restoration period has ended.
     * </p>
     *
     * @param restoreCertificateAuthorityRequest
     * @return Result of the RestoreCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.RestoreCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreCertificateAuthorityResponse restoreCertificateAuthority(
            RestoreCertificateAuthorityRequest restoreCertificateAuthorityRequest) throws ResourceNotFoundException,
            InvalidStateException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the
     * period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the
     * <a>DeleteCertificateAuthority</a> operation. Currently, you can specify 7 to 30 days. If you did not specify a
     * <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You
     * can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by
     * calling the <a>DescribeCertificateAuthority</a> or <a>ListCertificateAuthorities</a> operations. The status of a
     * restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> operation returns. To
     * change its status to <code>ACTIVE</code>, call the <a>UpdateCertificateAuthority</a> operation. If the private CA
     * was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the
     * <a>ImportCertificateAuthorityCertificate</a> operation to import a certificate authority into the private CA
     * before it can be activated. You cannot restore a CA after the restoration period has ended.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param restoreCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link RestoreCertificateAuthorityRequest.Builder} to create
     *        a request.
     * @return Result of the RestoreCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.RestoreCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreCertificateAuthorityResponse restoreCertificateAuthority(
            Consumer<RestoreCertificateAuthorityRequest.Builder> restoreCertificateAuthorityRequest)
            throws ResourceNotFoundException, InvalidStateException, InvalidArnException, AwsServiceException,
            SdkClientException, AcmPcaException {
        return restoreCertificateAuthority(RestoreCertificateAuthorityRequest.builder()
                .applyMutation(restoreCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Revokes a certificate that you issued by calling the <a>IssueCertificate</a> operation. If you enable a
     * certificate revocation list (CRL) when you create or update your private CA, information about the revoked
     * certificates will be included in the CRL. ACM PCA writes the CRL to an S3 bucket that you specify. For more
     * information about revocation, see the <a>CrlConfiguration</a> structure. ACM PCA also writes revocation
     * information to the audit report. For more information, see <a>CreateCertificateAuthorityAuditReport</a>.
     * </p>
     *
     * @param revokeCertificateRequest
     * @return Result of the RevokeCertificate operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws RequestAlreadyProcessedException
     *         Your request has already been completed.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.RevokeCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeCertificateResponse revokeCertificate(RevokeCertificateRequest revokeCertificateRequest)
            throws ConcurrentModificationException, InvalidArnException, InvalidStateException, LimitExceededException,
            ResourceNotFoundException, RequestAlreadyProcessedException, RequestInProgressException, RequestFailedException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes a certificate that you issued by calling the <a>IssueCertificate</a> operation. If you enable a
     * certificate revocation list (CRL) when you create or update your private CA, information about the revoked
     * certificates will be included in the CRL. ACM PCA writes the CRL to an S3 bucket that you specify. For more
     * information about revocation, see the <a>CrlConfiguration</a> structure. ACM PCA also writes revocation
     * information to the audit report. For more information, see <a>CreateCertificateAuthorityAuditReport</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link RevokeCertificateRequest#builder()}
     * </p>
     *
     * @param revokeCertificateRequest
     *        A {@link Consumer} that will call methods on {@link RevokeCertificateRequest.Builder} to create a request.
     * @return Result of the RevokeCertificate operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws LimitExceededException
     *         An ACM PCA limit has been exceeded. See the exception message returned to determine the limit that was
     *         exceeded.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws RequestAlreadyProcessedException
     *         Your request has already been completed.
     * @throws RequestInProgressException
     *         Your request is already in progress.
     * @throws RequestFailedException
     *         The request has failed for an unspecified reason.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.RevokeCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeCertificateResponse revokeCertificate(Consumer<RevokeCertificateRequest.Builder> revokeCertificateRequest)
            throws ConcurrentModificationException, InvalidArnException, InvalidStateException, LimitExceededException,
            ResourceNotFoundException, RequestAlreadyProcessedException, RequestInProgressException, RequestFailedException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return revokeCertificate(RevokeCertificateRequest.builder().applyMutation(revokeCertificateRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your AWS
     * resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon
     * Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if
     * you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs
     * if you want to filter for a common relationship among those CAs. To remove one or more tags, use the
     * <a>UntagCertificateAuthority</a> operation. Call the <a>ListTags</a> operation to see what tags are associated
     * with your CA.
     * </p>
     *
     * @param tagCertificateAuthorityRequest
     * @return Result of the TagCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws TooManyTagsException
     *         You can associate up to 50 tags with a private CA. Exception information is contained in the exception
     *         message field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.TagCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default TagCertificateAuthorityResponse tagCertificateAuthority(TagCertificateAuthorityRequest tagCertificateAuthorityRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException,
            TooManyTagsException, AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your AWS
     * resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon
     * Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if
     * you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs
     * if you want to filter for a common relationship among those CAs. To remove one or more tags, use the
     * <a>UntagCertificateAuthority</a> operation. Call the <a>ListTags</a> operation to see what tags are associated
     * with your CA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagCertificateAuthorityRequest.Builder} avoiding
     * the need to create one manually via {@link TagCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param tagCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link TagCertificateAuthorityRequest.Builder} to create a
     *        request.
     * @return Result of the TagCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws TooManyTagsException
     *         You can associate up to 50 tags with a private CA. Exception information is contained in the exception
     *         message field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.TagCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default TagCertificateAuthorityResponse tagCertificateAuthority(
            Consumer<TagCertificateAuthorityRequest.Builder> tagCertificateAuthorityRequest) throws ResourceNotFoundException,
            InvalidArnException, InvalidStateException, InvalidTagException, TooManyTagsException, AwsServiceException,
            SdkClientException, AcmPcaException {
        return tagCertificateAuthority(TagCertificateAuthorityRequest.builder().applyMutation(tagCertificateAuthorityRequest)
                .build());
    }

    /**
     * <p>
     * Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value
     * portion of the tag when calling this operation, the tag will be removed regardless of value. If you specify a
     * value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the
     * <a>TagCertificateAuthority</a>. Call the <a>ListTags</a> operation to see what tags are associated with your CA.
     * </p>
     *
     * @param untagCertificateAuthorityRequest
     * @return Result of the UntagCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.UntagCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagCertificateAuthorityResponse untagCertificateAuthority(
            UntagCertificateAuthorityRequest untagCertificateAuthorityRequest) throws ResourceNotFoundException,
            InvalidArnException, InvalidStateException, InvalidTagException, AwsServiceException, SdkClientException,
            AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value
     * portion of the tag when calling this operation, the tag will be removed regardless of value. If you specify a
     * value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the
     * <a>TagCertificateAuthority</a>. Call the <a>ListTags</a> operation to see what tags are associated with your CA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagCertificateAuthorityRequest.Builder} avoiding
     * the need to create one manually via {@link UntagCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param untagCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link UntagCertificateAuthorityRequest.Builder} to create a
     *        request.
     * @return Result of the UntagCertificateAuthority operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidTagException
     *         The tag associated with the CA is not valid. The invalid argument is contained in the message field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.UntagCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagCertificateAuthorityResponse untagCertificateAuthority(
            Consumer<UntagCertificateAuthorityRequest.Builder> untagCertificateAuthorityRequest)
            throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException,
            AwsServiceException, SdkClientException, AcmPcaException {
        return untagCertificateAuthority(UntagCertificateAuthorityRequest.builder()
                .applyMutation(untagCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the
     * <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is
     * in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.
     * </p>
     *
     * @param updateCertificateAuthorityRequest
     * @return Result of the UpdateCertificateAuthority operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidPolicyException
     *         The S3 bucket policy is not valid. The policy must give ACM PCA rights to read from and write to the
     *         bucket and find the bucket location.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.UpdateCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCertificateAuthorityResponse updateCertificateAuthority(
            UpdateCertificateAuthorityRequest updateCertificateAuthorityRequest) throws ConcurrentModificationException,
            ResourceNotFoundException, InvalidArgsException, InvalidArnException, InvalidStateException, InvalidPolicyException,
            AwsServiceException, SdkClientException, AcmPcaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the
     * <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is
     * in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCertificateAuthorityRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param updateCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCertificateAuthorityRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCertificateAuthority operation returned by the service.
     * @throws ConcurrentModificationException
     *         A previous update to your private CA is still ongoing.
     * @throws ResourceNotFoundException
     *         A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.
     * @throws InvalidArgsException
     *         One or more of the specified arguments was not valid.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws InvalidStateException
     *         The private CA is in a state during which a report or certificate cannot be generated.
     * @throws InvalidPolicyException
     *         The S3 bucket policy is not valid. The policy must give ACM PCA rights to read from and write to the
     *         bucket and find the bucket location.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AcmPcaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AcmPcaClient.UpdateCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCertificateAuthorityResponse updateCertificateAuthority(
            Consumer<UpdateCertificateAuthorityRequest.Builder> updateCertificateAuthorityRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, InvalidArgsException, InvalidArnException,
            InvalidStateException, InvalidPolicyException, AwsServiceException, SdkClientException, AcmPcaException {
        return updateCertificateAuthority(UpdateCertificateAuthorityRequest.builder()
                .applyMutation(updateCertificateAuthorityRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("acm-pca");
    }
}
