/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCertificateAuthorityRequest extends AcmPcaRequest implements
        ToCopyableBuilder<CreateCertificateAuthorityRequest.Builder, CreateCertificateAuthorityRequest> {
    private static final SdkField<CertificateAuthorityConfiguration> CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD = SdkField
            .<CertificateAuthorityConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateCertificateAuthorityRequest::certificateAuthorityConfiguration))
            .setter(setter(Builder::certificateAuthorityConfiguration))
            .constructor(CertificateAuthorityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityConfiguration")
                    .build()).build();

    private static final SdkField<RevocationConfiguration> REVOCATION_CONFIGURATION_FIELD = SdkField
            .<RevocationConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateCertificateAuthorityRequest::revocationConfiguration))
            .setter(setter(Builder::revocationConfiguration)).constructor(RevocationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationConfiguration").build())
            .build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCertificateAuthorityRequest::certificateAuthorityTypeAsString))
            .setter(setter(Builder::certificateAuthorityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityType").build())
            .build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCertificateAuthorityRequest::idempotencyToken)).setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateCertificateAuthorityRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD, REVOCATION_CONFIGURATION_FIELD, CERTIFICATE_AUTHORITY_TYPE_FIELD,
            IDEMPOTENCY_TOKEN_FIELD, TAGS_FIELD));

    private final CertificateAuthorityConfiguration certificateAuthorityConfiguration;

    private final RevocationConfiguration revocationConfiguration;

    private final String certificateAuthorityType;

    private final String idempotencyToken;

    private final List<Tag> tags;

    private CreateCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityConfiguration = builder.certificateAuthorityConfiguration;
        this.revocationConfiguration = builder.revocationConfiguration;
        this.certificateAuthorityType = builder.certificateAuthorityType;
        this.idempotencyToken = builder.idempotencyToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject
     * information.
     * </p>
     * 
     * @return Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate
     *         subject information.
     */
    public CertificateAuthorityConfiguration certificateAuthorityConfiguration() {
        return certificateAuthorityConfiguration;
    }

    /**
     * <p>
     * Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the name of
     * the S3 bucket to which ACM PCA will write the CRL, and an optional CNAME alias that you can use to hide the name
     * of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate. For more information, see
     * the <a>CrlConfiguration</a> structure.
     * </p>
     * 
     * @return Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the
     *         name of the S3 bucket to which ACM PCA will write the CRL, and an optional CNAME alias that you can use
     *         to hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate.
     *         For more information, see the <a>CrlConfiguration</a> structure.
     */
    public RevocationConfiguration revocationConfiguration() {
        return revocationConfiguration;
    }

    /**
     * <p>
     * The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateAuthorityType} will return {@link CertificateAuthorityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #certificateAuthorityTypeAsString}.
     * </p>
     * 
     * @return The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
     * @see CertificateAuthorityType
     */
    public CertificateAuthorityType certificateAuthorityType() {
        return CertificateAuthorityType.fromValue(certificateAuthorityType);
    }

    /**
     * <p>
     * The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateAuthorityType} will return {@link CertificateAuthorityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #certificateAuthorityTypeAsString}.
     * </p>
     * 
     * @return The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
     * @see CertificateAuthorityType
     */
    public String certificateAuthorityTypeAsString() {
        return certificateAuthorityType;
    }

    /**
     * <p>
     * Alphanumeric string that can be used to distinguish between calls to <b>CreateCertificateAuthority</b>.
     * Idempotency tokens time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple
     * times with the same idempotency token within a five minute period, ACM PCA recognizes that you are requesting
     * only one certificate. As a result, ACM PCA issues only one. If you change the idempotency token for each call,
     * however, ACM PCA recognizes that you are requesting multiple certificates.
     * </p>
     * 
     * @return Alphanumeric string that can be used to distinguish between calls to <b>CreateCertificateAuthority</b>.
     *         Idempotency tokens time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b>
     *         multiple times with the same idempotency token within a five minute period, ACM PCA recognizes that you
     *         are requesting only one certificate. As a result, ACM PCA issues only one. If you change the idempotency
     *         token for each call, however, ACM PCA recognizes that you are requesting multiple certificates.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a
     *         private CA.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(revocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityRequest)) {
            return false;
        }
        CreateCertificateAuthorityRequest other = (CreateCertificateAuthorityRequest) obj;
        return Objects.equals(certificateAuthorityConfiguration(), other.certificateAuthorityConfiguration())
                && Objects.equals(revocationConfiguration(), other.revocationConfiguration())
                && Objects.equals(certificateAuthorityTypeAsString(), other.certificateAuthorityTypeAsString())
                && Objects.equals(idempotencyToken(), other.idempotencyToken()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCertificateAuthorityRequest")
                .add("CertificateAuthorityConfiguration", certificateAuthorityConfiguration())
                .add("RevocationConfiguration", revocationConfiguration())
                .add("CertificateAuthorityType", certificateAuthorityTypeAsString()).add("IdempotencyToken", idempotencyToken())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityConfiguration":
            return Optional.ofNullable(clazz.cast(certificateAuthorityConfiguration()));
        case "RevocationConfiguration":
            return Optional.ofNullable(clazz.cast(revocationConfiguration()));
        case "CertificateAuthorityType":
            return Optional.ofNullable(clazz.cast(certificateAuthorityTypeAsString()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCertificateAuthorityRequest> {
        /**
         * <p>
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate
         * subject information.
         * </p>
         * 
         * @param certificateAuthorityConfiguration
         *        Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500
         *        certificate subject information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration certificateAuthorityConfiguration);

        /**
         * <p>
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate
         * subject information.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateAuthorityConfiguration.Builder}
         * avoiding the need to create one manually via {@link CertificateAuthorityConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateAuthorityConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #certificateAuthorityConfiguration(CertificateAuthorityConfiguration)}.
         * 
         * @param certificateAuthorityConfiguration
         *        a consumer that will call methods on {@link CertificateAuthorityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAuthorityConfiguration(CertificateAuthorityConfiguration)
         */
        default Builder certificateAuthorityConfiguration(
                Consumer<CertificateAuthorityConfiguration.Builder> certificateAuthorityConfiguration) {
            return certificateAuthorityConfiguration(CertificateAuthorityConfiguration.builder()
                    .applyMutation(certificateAuthorityConfiguration).build());
        }

        /**
         * <p>
         * Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the
         * name of the S3 bucket to which ACM PCA will write the CRL, and an optional CNAME alias that you can use to
         * hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate. For more
         * information, see the <a>CrlConfiguration</a> structure.
         * </p>
         * 
         * @param revocationConfiguration
         *        Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA,
         *        the name of the S3 bucket to which ACM PCA will write the CRL, and an optional CNAME alias that you
         *        can use to hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA
         *        certificate. For more information, see the <a>CrlConfiguration</a> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationConfiguration(RevocationConfiguration revocationConfiguration);

        /**
         * <p>
         * Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the
         * name of the S3 bucket to which ACM PCA will write the CRL, and an optional CNAME alias that you can use to
         * hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate. For more
         * information, see the <a>CrlConfiguration</a> structure.
         * </p>
         * This is a convenience that creates an instance of the {@link RevocationConfiguration.Builder} avoiding the
         * need to create one manually via {@link RevocationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevocationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #revocationConfiguration(RevocationConfiguration)}.
         * 
         * @param revocationConfiguration
         *        a consumer that will call methods on {@link RevocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revocationConfiguration(RevocationConfiguration)
         */
        default Builder revocationConfiguration(Consumer<RevocationConfiguration.Builder> revocationConfiguration) {
            return revocationConfiguration(RevocationConfiguration.builder().applyMutation(revocationConfiguration).build());
        }

        /**
         * <p>
         * The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
         * </p>
         * 
         * @param certificateAuthorityType
         *        The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
         * @see CertificateAuthorityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateAuthorityType
         */
        Builder certificateAuthorityType(String certificateAuthorityType);

        /**
         * <p>
         * The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
         * </p>
         * 
         * @param certificateAuthorityType
         *        The type of the certificate authority. Currently, this must be <b>SUBORDINATE</b>.
         * @see CertificateAuthorityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateAuthorityType
         */
        Builder certificateAuthorityType(CertificateAuthorityType certificateAuthorityType);

        /**
         * <p>
         * Alphanumeric string that can be used to distinguish between calls to <b>CreateCertificateAuthority</b>.
         * Idempotency tokens time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b>
         * multiple times with the same idempotency token within a five minute period, ACM PCA recognizes that you are
         * requesting only one certificate. As a result, ACM PCA issues only one. If you change the idempotency token
         * for each call, however, ACM PCA recognizes that you are requesting multiple certificates.
         * </p>
         * 
         * @param idempotencyToken
         *        Alphanumeric string that can be used to distinguish between calls to
         *        <b>CreateCertificateAuthority</b>. Idempotency tokens time out after five minutes. Therefore, if you
         *        call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within a five
         *        minute period, ACM PCA recognizes that you are requesting only one certificate. As a result, ACM PCA
         *        issues only one. If you change the idempotency token for each call, however, ACM PCA recognizes that
         *        you are requesting multiple certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private
         * CA.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a
         *        private CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private
         * CA.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a
         *        private CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private
         * CA.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private CertificateAuthorityConfiguration certificateAuthorityConfiguration;

        private RevocationConfiguration revocationConfiguration;

        private String certificateAuthorityType;

        private String idempotencyToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityRequest model) {
            super(model);
            certificateAuthorityConfiguration(model.certificateAuthorityConfiguration);
            revocationConfiguration(model.revocationConfiguration);
            certificateAuthorityType(model.certificateAuthorityType);
            idempotencyToken(model.idempotencyToken);
            tags(model.tags);
        }

        public final CertificateAuthorityConfiguration.Builder getCertificateAuthorityConfiguration() {
            return certificateAuthorityConfiguration != null ? certificateAuthorityConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration;
            return this;
        }

        public final void setCertificateAuthorityConfiguration(
                CertificateAuthorityConfiguration.BuilderImpl certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration != null ? certificateAuthorityConfiguration
                    .build() : null;
        }

        public final RevocationConfiguration.Builder getRevocationConfiguration() {
            return revocationConfiguration != null ? revocationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder revocationConfiguration(RevocationConfiguration revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        public final void setRevocationConfiguration(RevocationConfiguration.BuilderImpl revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration != null ? revocationConfiguration.build() : null;
        }

        public final String getCertificateAuthorityTypeAsString() {
            return certificateAuthorityType;
        }

        @Override
        public final Builder certificateAuthorityType(String certificateAuthorityType) {
            this.certificateAuthorityType = certificateAuthorityType;
            return this;
        }

        @Override
        public final Builder certificateAuthorityType(CertificateAuthorityType certificateAuthorityType) {
            this.certificateAuthorityType(certificateAuthorityType.toString());
            return this;
        }

        public final void setCertificateAuthorityType(String certificateAuthorityType) {
            this.certificateAuthorityType = certificateAuthorityType;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateAuthorityRequest build() {
            return new CreateCertificateAuthorityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
