/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificateAuthoritiesResponse extends AcmPcaResponse implements
        ToCopyableBuilder<ListCertificateAuthoritiesResponse.Builder, ListCertificateAuthoritiesResponse> {
    private static final SdkField<List<CertificateAuthority>> CERTIFICATE_AUTHORITIES_FIELD = SdkField
            .<List<CertificateAuthority>> builder(MarshallingType.LIST)
            .getter(getter(ListCertificateAuthoritiesResponse::certificateAuthorities))
            .setter(setter(Builder::certificateAuthorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateAuthority> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateAuthority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCertificateAuthoritiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CertificateAuthority> certificateAuthorities;

    private final String nextToken;

    private ListCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorities = builder.certificateAuthorities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Summary information about each certificate authority you have created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Summary information about each certificate authority you have created.
     */
    public List<CertificateAuthority> certificateAuthorities() {
        return certificateAuthorities;
    }

    /**
     * <p>
     * When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in
     * a subsequent pagination request.
     * </p>
     * 
     * @return When the list is truncated, this value is present and should be used for the <code>NextToken</code>
     *         parameter in a subsequent pagination request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateAuthoritiesResponse)) {
            return false;
        }
        ListCertificateAuthoritiesResponse other = (ListCertificateAuthoritiesResponse) obj;
        return Objects.equals(certificateAuthorities(), other.certificateAuthorities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCertificateAuthoritiesResponse").add("CertificateAuthorities", certificateAuthorities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorities":
            return Optional.ofNullable(clazz.cast(certificateAuthorities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListCertificateAuthoritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCertificateAuthoritiesResponse> {
        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * 
         * @param certificateAuthorities
         *        Summary information about each certificate authority you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorities(Collection<CertificateAuthority> certificateAuthorities);

        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * 
         * @param certificateAuthorities
         *        Summary information about each certificate authority you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorities(CertificateAuthority... certificateAuthorities);

        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CertificateAuthority>.Builder} avoiding the
         * need to create one manually via {@link List<CertificateAuthority>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CertificateAuthority>.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateAuthorities(List<CertificateAuthority>)}.
         * 
         * @param certificateAuthorities
         *        a consumer that will call methods on {@link List<CertificateAuthority>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAuthorities(List<CertificateAuthority>)
         */
        Builder certificateAuthorities(Consumer<CertificateAuthority.Builder>... certificateAuthorities);

        /**
         * <p>
         * When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter
         * in a subsequent pagination request.
         * </p>
         * 
         * @param nextToken
         *        When the list is truncated, this value is present and should be used for the <code>NextToken</code>
         *        parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private List<CertificateAuthority> certificateAuthorities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateAuthoritiesResponse model) {
            super(model);
            certificateAuthorities(model.certificateAuthorities);
            nextToken(model.nextToken);
        }

        public final Collection<CertificateAuthority.Builder> getCertificateAuthorities() {
            return certificateAuthorities != null ? certificateAuthorities.stream().map(CertificateAuthority::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificateAuthorities(Collection<CertificateAuthority> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copy(certificateAuthorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorities(CertificateAuthority... certificateAuthorities) {
            certificateAuthorities(Arrays.asList(certificateAuthorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorities(Consumer<CertificateAuthority.Builder>... certificateAuthorities) {
            certificateAuthorities(Stream.of(certificateAuthorities)
                    .map(c -> CertificateAuthority.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificateAuthorities(Collection<CertificateAuthority.BuilderImpl> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copyFromBuilder(certificateAuthorities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCertificateAuthoritiesResponse build() {
            return new ListCertificateAuthoritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
