/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressBook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressBook> {
    private static final SdkField<String> ADDRESS_BOOK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressBookArn").getter(AddressBook.getter(AddressBook::addressBookArn)).setter(AddressBook.setter(Builder::addressBookArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressBookArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AddressBook.getter(AddressBook::name)).setter(AddressBook.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AddressBook.getter(AddressBook::description)).setter(AddressBook.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_BOOK_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addressBookArn;
    private final String name;
    private final String description;

    private AddressBook(BuilderImpl builder) {
        this.addressBookArn = builder.addressBookArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    public final String addressBookArn() {
        return this.addressBookArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressBookArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressBook)) {
            return false;
        }
        AddressBook other = (AddressBook)obj;
        return Objects.equals(this.addressBookArn(), other.addressBookArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"AddressBook").add("AddressBookArn", (Object)this.addressBookArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressBookArn": {
                return Optional.ofNullable(clazz.cast(this.addressBookArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddressBook, T> g) {
        return obj -> g.apply((AddressBook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressBookArn;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressBook model) {
            this.addressBookArn(model.addressBookArn);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getAddressBookArn() {
            return this.addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public AddressBook build() {
            return new AddressBook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressBook> {
        public Builder addressBookArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

