/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateContactWithAddressBookRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, AssociateContactWithAddressBookRequest> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(AssociateContactWithAddressBookRequest.getter(AssociateContactWithAddressBookRequest::contactArn)).setter(AssociateContactWithAddressBookRequest.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> ADDRESS_BOOK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressBookArn").getter(AssociateContactWithAddressBookRequest.getter(AssociateContactWithAddressBookRequest::addressBookArn)).setter(AssociateContactWithAddressBookRequest.setter(Builder::addressBookArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressBookArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, ADDRESS_BOOK_ARN_FIELD));
    private final String contactArn;
    private final String addressBookArn;

    private AssociateContactWithAddressBookRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.addressBookArn = builder.addressBookArn;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String addressBookArn() {
        return this.addressBookArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressBookArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateContactWithAddressBookRequest)) {
            return false;
        }
        AssociateContactWithAddressBookRequest other = (AssociateContactWithAddressBookRequest)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.addressBookArn(), other.addressBookArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateContactWithAddressBookRequest").add("ContactArn", (Object)this.contactArn()).add("AddressBookArn", (Object)this.addressBookArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "AddressBookArn": {
                return Optional.ofNullable(clazz.cast(this.addressBookArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateContactWithAddressBookRequest, T> g) {
        return obj -> g.apply((AssociateContactWithAddressBookRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String contactArn;
        private String addressBookArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateContactWithAddressBookRequest model) {
            super(model);
            this.contactArn(model.contactArn);
            this.addressBookArn(model.addressBookArn);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getAddressBookArn() {
            return this.addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateContactWithAddressBookRequest build() {
            return new AssociateContactWithAddressBookRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateContactWithAddressBookRequest> {
        public Builder contactArn(String var1);

        public Builder addressBookArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

