/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDeviceUsageDataRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, DeleteDeviceUsageDataRequest> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(DeleteDeviceUsageDataRequest.getter(DeleteDeviceUsageDataRequest::deviceArn)).setter(DeleteDeviceUsageDataRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DEVICE_USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceUsageType").getter(DeleteDeviceUsageDataRequest.getter(DeleteDeviceUsageDataRequest::deviceUsageTypeAsString)).setter(DeleteDeviceUsageDataRequest.setter(Builder::deviceUsageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceUsageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD, DEVICE_USAGE_TYPE_FIELD));
    private final String deviceArn;
    private final String deviceUsageType;

    private DeleteDeviceUsageDataRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceUsageType = builder.deviceUsageType;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final DeviceUsageType deviceUsageType() {
        return DeviceUsageType.fromValue(this.deviceUsageType);
    }

    public final String deviceUsageTypeAsString() {
        return this.deviceUsageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceUsageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeviceUsageDataRequest)) {
            return false;
        }
        DeleteDeviceUsageDataRequest other = (DeleteDeviceUsageDataRequest)((Object)obj);
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceUsageTypeAsString(), other.deviceUsageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDeviceUsageDataRequest").add("DeviceArn", (Object)this.deviceArn()).add("DeviceUsageType", (Object)this.deviceUsageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceUsageType": {
                return Optional.ofNullable(clazz.cast(this.deviceUsageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDeviceUsageDataRequest, T> g) {
        return obj -> g.apply((DeleteDeviceUsageDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceUsageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeviceUsageDataRequest model) {
            super(model);
            this.deviceArn(model.deviceArn);
            this.deviceUsageType(model.deviceUsageType);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceUsageType() {
            return this.deviceUsageType;
        }

        @Override
        public final Builder deviceUsageType(String deviceUsageType) {
            this.deviceUsageType = deviceUsageType;
            return this;
        }

        @Override
        public final Builder deviceUsageType(DeviceUsageType deviceUsageType) {
            this.deviceUsageType(deviceUsageType == null ? null : deviceUsageType.toString());
            return this;
        }

        public final void setDeviceUsageType(String deviceUsageType) {
            this.deviceUsageType = deviceUsageType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDeviceUsageDataRequest build() {
            return new DeleteDeviceUsageDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDeviceUsageDataRequest> {
        public Builder deviceArn(String var1);

        public Builder deviceUsageType(String var1);

        public Builder deviceUsageType(DeviceUsageType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

