/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateEndOfMeetingReminder;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateInstantBooking;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRequireCheckIn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMeetingRoomConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateMeetingRoomConfiguration> {
    private static final SdkField<Boolean> ROOM_UTILIZATION_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RoomUtilizationMetricsEnabled").getter(UpdateMeetingRoomConfiguration.getter(UpdateMeetingRoomConfiguration::roomUtilizationMetricsEnabled)).setter(UpdateMeetingRoomConfiguration.setter(Builder::roomUtilizationMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomUtilizationMetricsEnabled").build()}).build();
    private static final SdkField<UpdateEndOfMeetingReminder> END_OF_MEETING_REMINDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndOfMeetingReminder").getter(UpdateMeetingRoomConfiguration.getter(UpdateMeetingRoomConfiguration::endOfMeetingReminder)).setter(UpdateMeetingRoomConfiguration.setter(Builder::endOfMeetingReminder)).constructor(UpdateEndOfMeetingReminder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOfMeetingReminder").build()}).build();
    private static final SdkField<UpdateInstantBooking> INSTANT_BOOKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstantBooking").getter(UpdateMeetingRoomConfiguration.getter(UpdateMeetingRoomConfiguration::instantBooking)).setter(UpdateMeetingRoomConfiguration.setter(Builder::instantBooking)).constructor(UpdateInstantBooking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstantBooking").build()}).build();
    private static final SdkField<UpdateRequireCheckIn> REQUIRE_CHECK_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequireCheckIn").getter(UpdateMeetingRoomConfiguration.getter(UpdateMeetingRoomConfiguration::requireCheckIn)).setter(UpdateMeetingRoomConfiguration.setter(Builder::requireCheckIn)).constructor(UpdateRequireCheckIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireCheckIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_UTILIZATION_METRICS_ENABLED_FIELD, END_OF_MEETING_REMINDER_FIELD, INSTANT_BOOKING_FIELD, REQUIRE_CHECK_IN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean roomUtilizationMetricsEnabled;
    private final UpdateEndOfMeetingReminder endOfMeetingReminder;
    private final UpdateInstantBooking instantBooking;
    private final UpdateRequireCheckIn requireCheckIn;

    private UpdateMeetingRoomConfiguration(BuilderImpl builder) {
        this.roomUtilizationMetricsEnabled = builder.roomUtilizationMetricsEnabled;
        this.endOfMeetingReminder = builder.endOfMeetingReminder;
        this.instantBooking = builder.instantBooking;
        this.requireCheckIn = builder.requireCheckIn;
    }

    public final Boolean roomUtilizationMetricsEnabled() {
        return this.roomUtilizationMetricsEnabled;
    }

    public final UpdateEndOfMeetingReminder endOfMeetingReminder() {
        return this.endOfMeetingReminder;
    }

    public final UpdateInstantBooking instantBooking() {
        return this.instantBooking;
    }

    public final UpdateRequireCheckIn requireCheckIn() {
        return this.requireCheckIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomUtilizationMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOfMeetingReminder());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantBooking());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireCheckIn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMeetingRoomConfiguration)) {
            return false;
        }
        UpdateMeetingRoomConfiguration other = (UpdateMeetingRoomConfiguration)obj;
        return Objects.equals(this.roomUtilizationMetricsEnabled(), other.roomUtilizationMetricsEnabled()) && Objects.equals(this.endOfMeetingReminder(), other.endOfMeetingReminder()) && Objects.equals(this.instantBooking(), other.instantBooking()) && Objects.equals(this.requireCheckIn(), other.requireCheckIn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMeetingRoomConfiguration").add("RoomUtilizationMetricsEnabled", (Object)this.roomUtilizationMetricsEnabled()).add("EndOfMeetingReminder", (Object)this.endOfMeetingReminder()).add("InstantBooking", (Object)this.instantBooking()).add("RequireCheckIn", (Object)this.requireCheckIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomUtilizationMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.roomUtilizationMetricsEnabled()));
            }
            case "EndOfMeetingReminder": {
                return Optional.ofNullable(clazz.cast(this.endOfMeetingReminder()));
            }
            case "InstantBooking": {
                return Optional.ofNullable(clazz.cast(this.instantBooking()));
            }
            case "RequireCheckIn": {
                return Optional.ofNullable(clazz.cast(this.requireCheckIn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMeetingRoomConfiguration, T> g) {
        return obj -> g.apply((UpdateMeetingRoomConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean roomUtilizationMetricsEnabled;
        private UpdateEndOfMeetingReminder endOfMeetingReminder;
        private UpdateInstantBooking instantBooking;
        private UpdateRequireCheckIn requireCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMeetingRoomConfiguration model) {
            this.roomUtilizationMetricsEnabled(model.roomUtilizationMetricsEnabled);
            this.endOfMeetingReminder(model.endOfMeetingReminder);
            this.instantBooking(model.instantBooking);
            this.requireCheckIn(model.requireCheckIn);
        }

        public final Boolean getRoomUtilizationMetricsEnabled() {
            return this.roomUtilizationMetricsEnabled;
        }

        @Override
        public final Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
            return this;
        }

        public final void setRoomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
        }

        public final UpdateEndOfMeetingReminder.Builder getEndOfMeetingReminder() {
            return this.endOfMeetingReminder != null ? this.endOfMeetingReminder.toBuilder() : null;
        }

        @Override
        public final Builder endOfMeetingReminder(UpdateEndOfMeetingReminder endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder;
            return this;
        }

        public final void setEndOfMeetingReminder(UpdateEndOfMeetingReminder.BuilderImpl endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder != null ? endOfMeetingReminder.build() : null;
        }

        public final UpdateInstantBooking.Builder getInstantBooking() {
            return this.instantBooking != null ? this.instantBooking.toBuilder() : null;
        }

        @Override
        public final Builder instantBooking(UpdateInstantBooking instantBooking) {
            this.instantBooking = instantBooking;
            return this;
        }

        public final void setInstantBooking(UpdateInstantBooking.BuilderImpl instantBooking) {
            this.instantBooking = instantBooking != null ? instantBooking.build() : null;
        }

        public final UpdateRequireCheckIn.Builder getRequireCheckIn() {
            return this.requireCheckIn != null ? this.requireCheckIn.toBuilder() : null;
        }

        @Override
        public final Builder requireCheckIn(UpdateRequireCheckIn requireCheckIn) {
            this.requireCheckIn = requireCheckIn;
            return this;
        }

        public final void setRequireCheckIn(UpdateRequireCheckIn.BuilderImpl requireCheckIn) {
            this.requireCheckIn = requireCheckIn != null ? requireCheckIn.build() : null;
        }

        public UpdateMeetingRoomConfiguration build() {
            return new UpdateMeetingRoomConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateMeetingRoomConfiguration> {
        public Builder roomUtilizationMetricsEnabled(Boolean var1);

        public Builder endOfMeetingReminder(UpdateEndOfMeetingReminder var1);

        default public Builder endOfMeetingReminder(Consumer<UpdateEndOfMeetingReminder.Builder> endOfMeetingReminder) {
            return this.endOfMeetingReminder((UpdateEndOfMeetingReminder)((UpdateEndOfMeetingReminder.Builder)UpdateEndOfMeetingReminder.builder().applyMutation(endOfMeetingReminder)).build());
        }

        public Builder instantBooking(UpdateInstantBooking var1);

        default public Builder instantBooking(Consumer<UpdateInstantBooking.Builder> instantBooking) {
            return this.instantBooking((UpdateInstantBooking)((UpdateInstantBooking.Builder)UpdateInstantBooking.builder().applyMutation(instantBooking)).build());
        }

        public Builder requireCheckIn(UpdateRequireCheckIn var1);

        default public Builder requireCheckIn(Consumer<UpdateRequireCheckIn.Builder> requireCheckIn) {
            return this.requireCheckIn((UpdateRequireCheckIn)((UpdateRequireCheckIn.Builder)UpdateRequireCheckIn.builder().applyMutation(requireCheckIn)).build());
        }
    }
}

