/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse;

public class SearchNetworkProfilesIterable
implements SdkIterable<SearchNetworkProfilesResponse> {
    private final AlexaForBusinessClient client;
    private final SearchNetworkProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchNetworkProfilesIterable(AlexaForBusinessClient client, SearchNetworkProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchNetworkProfilesResponseFetcher();
    }

    public Iterator<SearchNetworkProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchNetworkProfilesResponseFetcher
    implements SyncPageFetcher<SearchNetworkProfilesResponse> {
        private SearchNetworkProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchNetworkProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchNetworkProfilesResponse nextPage(SearchNetworkProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchNetworkProfilesIterable.this.client.searchNetworkProfiles(SearchNetworkProfilesIterable.this.firstRequest);
            }
            return SearchNetworkProfilesIterable.this.client.searchNetworkProfiles((SearchNetworkProfilesRequest)((Object)SearchNetworkProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

