/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRoomResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetRoomResponse.Builder, GetRoomResponse> {
    private static final SdkField<Room> ROOM_FIELD = SdkField.<Room> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRoomResponse::room)).setter(setter(Builder::room)).constructor(Room::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Room").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_FIELD));

    private final Room room;

    private GetRoomResponse(BuilderImpl builder) {
        super(builder);
        this.room = builder.room;
    }

    /**
     * <p>
     * The details of the room requested.
     * </p>
     * 
     * @return The details of the room requested.
     */
    public Room room() {
        return room;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(room());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoomResponse)) {
            return false;
        }
        GetRoomResponse other = (GetRoomResponse) obj;
        return Objects.equals(room(), other.room());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRoomResponse").add("Room", room()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Room":
            return Optional.ofNullable(clazz.cast(room()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRoomResponse, T> g) {
        return obj -> g.apply((GetRoomResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRoomResponse> {
        /**
         * <p>
         * The details of the room requested.
         * </p>
         * 
         * @param room
         *        The details of the room requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder room(Room room);

        /**
         * <p>
         * The details of the room requested.
         * </p>
         * This is a convenience that creates an instance of the {@link Room.Builder} avoiding the need to create one
         * manually via {@link Room#builder()}.
         *
         * When the {@link Consumer} completes, {@link Room.Builder#build()} is called immediately and its result is
         * passed to {@link #room(Room)}.
         * 
         * @param room
         *        a consumer that will call methods on {@link Room.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #room(Room)
         */
        default Builder room(Consumer<Room.Builder> room) {
            return room(Room.builder().applyMutation(room).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private Room room;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoomResponse model) {
            super(model);
            room(model.room);
        }

        public final Room.Builder getRoom() {
            return room != null ? room.toBuilder() : null;
        }

        @Override
        public final Builder room(Room room) {
            this.room = room;
            return this;
        }

        public final void setRoom(Room.BuilderImpl room) {
            this.room = room != null ? room.build() : null;
        }

        @Override
        public GetRoomResponse build() {
            return new GetRoomResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
