/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBusinessReportSchedulesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListBusinessReportSchedulesResponse.Builder, ListBusinessReportSchedulesResponse> {
    private static final SdkField<List<BusinessReportSchedule>> BUSINESS_REPORT_SCHEDULES_FIELD = SdkField
            .<List<BusinessReportSchedule>> builder(MarshallingType.LIST)
            .getter(getter(ListBusinessReportSchedulesResponse::businessReportSchedules))
            .setter(setter(Builder::businessReportSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessReportSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BusinessReportSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(BusinessReportSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBusinessReportSchedulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUSINESS_REPORT_SCHEDULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<BusinessReportSchedule> businessReportSchedules;

    private final String nextToken;

    private ListBusinessReportSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.businessReportSchedules = builder.businessReportSchedules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The schedule of the reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule of the reports.
     */
    public List<BusinessReportSchedule> businessReportSchedules() {
        return businessReportSchedules;
    }

    /**
     * <p>
     * The token used to list the remaining schedules from the previous API call.
     * </p>
     * 
     * @return The token used to list the remaining schedules from the previous API call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessReportSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBusinessReportSchedulesResponse)) {
            return false;
        }
        ListBusinessReportSchedulesResponse other = (ListBusinessReportSchedulesResponse) obj;
        return Objects.equals(businessReportSchedules(), other.businessReportSchedules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBusinessReportSchedulesResponse").add("BusinessReportSchedules", businessReportSchedules())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BusinessReportSchedules":
            return Optional.ofNullable(clazz.cast(businessReportSchedules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBusinessReportSchedulesResponse, T> g) {
        return obj -> g.apply((ListBusinessReportSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBusinessReportSchedulesResponse> {
        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * 
         * @param businessReportSchedules
         *        The schedule of the reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessReportSchedules(Collection<BusinessReportSchedule> businessReportSchedules);

        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * 
         * @param businessReportSchedules
         *        The schedule of the reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessReportSchedules(BusinessReportSchedule... businessReportSchedules);

        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BusinessReportSchedule>.Builder} avoiding
         * the need to create one manually via {@link List<BusinessReportSchedule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BusinessReportSchedule>.Builder#build()} is called
         * immediately and its result is passed to {@link #businessReportSchedules(List<BusinessReportSchedule>)}.
         * 
         * @param businessReportSchedules
         *        a consumer that will call methods on {@link List<BusinessReportSchedule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessReportSchedules(List<BusinessReportSchedule>)
         */
        Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder>... businessReportSchedules);

        /**
         * <p>
         * The token used to list the remaining schedules from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The token used to list the remaining schedules from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<BusinessReportSchedule> businessReportSchedules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBusinessReportSchedulesResponse model) {
            super(model);
            businessReportSchedules(model.businessReportSchedules);
            nextToken(model.nextToken);
        }

        public final Collection<BusinessReportSchedule.Builder> getBusinessReportSchedules() {
            return businessReportSchedules != null ? businessReportSchedules.stream().map(BusinessReportSchedule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder businessReportSchedules(Collection<BusinessReportSchedule> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copy(businessReportSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(BusinessReportSchedule... businessReportSchedules) {
            businessReportSchedules(Arrays.asList(businessReportSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder>... businessReportSchedules) {
            businessReportSchedules(Stream.of(businessReportSchedules)
                    .map(c -> BusinessReportSchedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBusinessReportSchedules(Collection<BusinessReportSchedule.BuilderImpl> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copyFromBuilder(businessReportSchedules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBusinessReportSchedulesResponse build() {
            return new ListBusinessReportSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
