/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PSTNDialIn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PSTNDialIn> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PSTNDialIn.getter(PSTNDialIn::countryCode)).setter(PSTNDialIn.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PSTNDialIn.getter(PSTNDialIn::phoneNumber)).setter(PSTNDialIn.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> ONE_CLICK_ID_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PSTNDialIn.getter(PSTNDialIn::oneClickIdDelay)).setter(PSTNDialIn.setter(Builder::oneClickIdDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneClickIdDelay").build()}).build();
    private static final SdkField<String> ONE_CLICK_PIN_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PSTNDialIn.getter(PSTNDialIn::oneClickPinDelay)).setter(PSTNDialIn.setter(Builder::oneClickPinDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneClickPinDelay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD, PHONE_NUMBER_FIELD, ONE_CLICK_ID_DELAY_FIELD, ONE_CLICK_PIN_DELAY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String countryCode;
    private final String phoneNumber;
    private final String oneClickIdDelay;
    private final String oneClickPinDelay;

    private PSTNDialIn(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.phoneNumber = builder.phoneNumber;
        this.oneClickIdDelay = builder.oneClickIdDelay;
        this.oneClickPinDelay = builder.oneClickPinDelay;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String oneClickIdDelay() {
        return this.oneClickIdDelay;
    }

    public String oneClickPinDelay() {
        return this.oneClickPinDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.oneClickIdDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.oneClickPinDelay());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PSTNDialIn)) {
            return false;
        }
        PSTNDialIn other = (PSTNDialIn)obj;
        return Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.oneClickIdDelay(), other.oneClickIdDelay()) && Objects.equals(this.oneClickPinDelay(), other.oneClickPinDelay());
    }

    public String toString() {
        return ToString.builder((String)"PSTNDialIn").add("CountryCode", (Object)this.countryCode()).add("PhoneNumber", (Object)this.phoneNumber()).add("OneClickIdDelay", (Object)this.oneClickIdDelay()).add("OneClickPinDelay", (Object)this.oneClickPinDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "OneClickIdDelay": {
                return Optional.ofNullable(clazz.cast(this.oneClickIdDelay()));
            }
            case "OneClickPinDelay": {
                return Optional.ofNullable(clazz.cast(this.oneClickPinDelay()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PSTNDialIn, T> g) {
        return obj -> g.apply((PSTNDialIn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String countryCode;
        private String phoneNumber;
        private String oneClickIdDelay;
        private String oneClickPinDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(PSTNDialIn model) {
            this.countryCode(model.countryCode);
            this.phoneNumber(model.phoneNumber);
            this.oneClickIdDelay(model.oneClickIdDelay);
            this.oneClickPinDelay(model.oneClickPinDelay);
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getOneClickIdDelay() {
            return this.oneClickIdDelay;
        }

        @Override
        public final Builder oneClickIdDelay(String oneClickIdDelay) {
            this.oneClickIdDelay = oneClickIdDelay;
            return this;
        }

        public final void setOneClickIdDelay(String oneClickIdDelay) {
            this.oneClickIdDelay = oneClickIdDelay;
        }

        public final String getOneClickPinDelay() {
            return this.oneClickPinDelay;
        }

        @Override
        public final Builder oneClickPinDelay(String oneClickPinDelay) {
            this.oneClickPinDelay = oneClickPinDelay;
            return this;
        }

        public final void setOneClickPinDelay(String oneClickPinDelay) {
            this.oneClickPinDelay = oneClickPinDelay;
        }

        public PSTNDialIn build() {
            return new PSTNDialIn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PSTNDialIn> {
        public Builder countryCode(String var1);

        public Builder phoneNumber(String var1);

        public Builder oneClickIdDelay(String var1);

        public Builder oneClickPinDelay(String var1);
    }
}

