/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;

public class SearchContactsPublisher
implements SdkPublisher<SearchContactsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchContactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchContactsPublisher(AlexaForBusinessAsyncClient client, SearchContactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchContactsPublisher(AlexaForBusinessAsyncClient client, SearchContactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchContactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchContactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchContactsResponseFetcher
    implements AsyncPageFetcher<SearchContactsResponse> {
        private SearchContactsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchContactsResponse> nextPage(SearchContactsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactsPublisher.this.client.searchContacts(SearchContactsPublisher.this.firstRequest);
            }
            return SearchContactsPublisher.this.client.searchContacts((SearchContactsRequest)((Object)SearchContactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

