/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkSecurityType {
    OPEN("OPEN"),
    WEP("WEP"),
    WPA_PSK("WPA_PSK"),
    WPA2_PSK("WPA2_PSK"),
    WPA2_ENTERPRISE("WPA2_ENTERPRISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkSecurityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkSecurityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkSecurityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkSecurityType> knownValues() {
        return Stream.of(NetworkSecurityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

