/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AuthorizationResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSkillAuthorizationRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, PutSkillAuthorizationRequest> {
    private static final SdkField<Map<String, String>> AUTHORIZATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PutSkillAuthorizationRequest.getter(PutSkillAuthorizationRequest::authorizationResult)).setter(PutSkillAuthorizationRequest.setter(Builder::authorizationResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationResult").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSkillAuthorizationRequest.getter(PutSkillAuthorizationRequest::skillId)).setter(PutSkillAuthorizationRequest.setter(Builder::skillId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()}).build();
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSkillAuthorizationRequest.getter(PutSkillAuthorizationRequest::roomArn)).setter(PutSkillAuthorizationRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_RESULT_FIELD, SKILL_ID_FIELD, ROOM_ARN_FIELD));
    private final Map<String, String> authorizationResult;
    private final String skillId;
    private final String roomArn;

    private PutSkillAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizationResult = builder.authorizationResult;
        this.skillId = builder.skillId;
        this.roomArn = builder.roomArn;
    }

    public Map<String, String> authorizationResult() {
        return this.authorizationResult;
    }

    public String skillId() {
        return this.skillId;
    }

    public String roomArn() {
        return this.roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSkillAuthorizationRequest)) {
            return false;
        }
        PutSkillAuthorizationRequest other = (PutSkillAuthorizationRequest)((Object)obj);
        return Objects.equals(this.authorizationResult(), other.authorizationResult()) && Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.roomArn(), other.roomArn());
    }

    public String toString() {
        return ToString.builder((String)"PutSkillAuthorizationRequest").add("AuthorizationResult", (Object)(this.authorizationResult() == null ? null : "*** Sensitive Data Redacted ***")).add("SkillId", (Object)this.skillId()).add("RoomArn", (Object)this.roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationResult": {
                return Optional.ofNullable(clazz.cast(this.authorizationResult()));
            }
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSkillAuthorizationRequest, T> g) {
        return obj -> g.apply((PutSkillAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private Map<String, String> authorizationResult = DefaultSdkAutoConstructMap.getInstance();
        private String skillId;
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSkillAuthorizationRequest model) {
            super(model);
            this.authorizationResult(model.authorizationResult);
            this.skillId(model.skillId);
            this.roomArn(model.roomArn);
        }

        public final Map<String, String> getAuthorizationResult() {
            return this.authorizationResult;
        }

        @Override
        public final Builder authorizationResult(Map<String, String> authorizationResult) {
            this.authorizationResult = AuthorizationResultCopier.copy(authorizationResult);
            return this;
        }

        public final void setAuthorizationResult(Map<String, String> authorizationResult) {
            this.authorizationResult = AuthorizationResultCopier.copy(authorizationResult);
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSkillAuthorizationRequest build() {
            return new PutSkillAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSkillAuthorizationRequest> {
        public Builder authorizationResult(Map<String, String> var1);

        public Builder skillId(String var1);

        public Builder roomArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

