/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Form;

public class ExportFormsPublisher
implements SdkPublisher<ExportFormsResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ExportFormsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ExportFormsPublisher(AmplifyUiBuilderAsyncClient client, ExportFormsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ExportFormsPublisher(AmplifyUiBuilderAsyncClient client, ExportFormsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ExportFormsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ExportFormsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Form> entities() {
        Function<ExportFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ExportFormsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ExportFormsResponseFetcher
    implements AsyncPageFetcher<ExportFormsResponse> {
        private ExportFormsResponseFetcher() {
        }

        public boolean hasNextPage(ExportFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ExportFormsResponse> nextPage(ExportFormsResponse previousPage) {
            if (previousPage == null) {
                return ExportFormsPublisher.this.client.exportForms(ExportFormsPublisher.this.firstRequest);
            }
            return ExportFormsPublisher.this.client.exportForms((ExportFormsRequest)((Object)ExportFormsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

