/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse;

public class ListLogPatternsIterable
implements SdkIterable<ListLogPatternsResponse> {
    private final ApplicationInsightsClient client;
    private final ListLogPatternsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogPatternsIterable(ApplicationInsightsClient client, ListLogPatternsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLogPatternsResponseFetcher();
    }

    public Iterator<ListLogPatternsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLogPatternsResponseFetcher
    implements SyncPageFetcher<ListLogPatternsResponse> {
        private ListLogPatternsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogPatternsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogPatternsResponse nextPage(ListLogPatternsResponse previousPage) {
            if (previousPage == null) {
                return ListLogPatternsIterable.this.client.listLogPatterns(ListLogPatternsIterable.this.firstRequest);
            }
            return ListLogPatternsIterable.this.client.listLogPatterns((ListLogPatternsRequest)((Object)ListLogPatternsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

