/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DurationUnit {
    MS("ms"),
    S("s"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DurationUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DurationUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DurationUnit.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DurationUnit> knownValues() {
        return Stream.of(DurationUnit.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

