/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionOption {
    SSE_S3("SSE_S3"),
    SSE_KMS("SSE_KMS"),
    CSE_KMS("CSE_KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncryptionOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncryptionOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionOption> knownValues() {
        return Stream.of(EncryptionOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

