/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Athena query error. The <code>AthenaError</code> feature provides standardized error
 * information to help you understand failed queries and take steps after a query failure occurs.
 * <code>AthenaError</code> includes an <code>ErrorCategory</code> field that specifies whether the cause of the failed
 * query is due to system error, user error, or other error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AthenaError implements SdkPojo, Serializable, ToCopyableBuilder<AthenaError.Builder, AthenaError> {
    private static final SdkField<Integer> ERROR_CATEGORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorCategory").getter(getter(AthenaError::errorCategory)).setter(setter(Builder::errorCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCategory").build()).build();

    private static final SdkField<Integer> ERROR_TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorType").getter(getter(AthenaError::errorType)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CATEGORY_FIELD,
            ERROR_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer errorCategory;

    private final Integer errorType;

    private AthenaError(BuilderImpl builder) {
        this.errorCategory = builder.errorCategory;
        this.errorType = builder.errorType;
    }

    /**
     * <p>
     * An integer value that specifies the category of a query failure error. The following list shows the category for
     * each integer value.
     * </p>
     * <p>
     * <b>1</b> - System
     * </p>
     * <p>
     * <b>2</b> - User
     * </p>
     * <p>
     * <b>3</b> - Other
     * </p>
     * 
     * @return An integer value that specifies the category of a query failure error. The following list shows the
     *         category for each integer value.</p>
     *         <p>
     *         <b>1</b> - System
     *         </p>
     *         <p>
     *         <b>2</b> - User
     *         </p>
     *         <p>
     *         <b>3</b> - Other
     */
    public final Integer errorCategory() {
        return errorCategory;
    }

    /**
     * <p>
     * An integer value that provides specific information about an Athena query error. For the meaning of specific
     * values, see the <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference"
     * >Error Type Reference</a> in the <i>Amazon Athena User Guide</i>.
     * </p>
     * 
     * @return An integer value that provides specific information about an Athena query error. For the meaning of
     *         specific values, see the <a href=
     *         "https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference"
     *         >Error Type Reference</a> in the <i>Amazon Athena User Guide</i>.
     */
    public final Integer errorType() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCategory());
        hashCode = 31 * hashCode + Objects.hashCode(errorType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaError)) {
            return false;
        }
        AthenaError other = (AthenaError) obj;
        return Objects.equals(errorCategory(), other.errorCategory()) && Objects.equals(errorType(), other.errorType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AthenaError").add("ErrorCategory", errorCategory()).add("ErrorType", errorType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCategory":
            return Optional.ofNullable(clazz.cast(errorCategory()));
        case "ErrorType":
            return Optional.ofNullable(clazz.cast(errorType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AthenaError, T> g) {
        return obj -> g.apply((AthenaError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AthenaError> {
        /**
         * <p>
         * An integer value that specifies the category of a query failure error. The following list shows the category
         * for each integer value.
         * </p>
         * <p>
         * <b>1</b> - System
         * </p>
         * <p>
         * <b>2</b> - User
         * </p>
         * <p>
         * <b>3</b> - Other
         * </p>
         * 
         * @param errorCategory
         *        An integer value that specifies the category of a query failure error. The following list shows the
         *        category for each integer value.</p>
         *        <p>
         *        <b>1</b> - System
         *        </p>
         *        <p>
         *        <b>2</b> - User
         *        </p>
         *        <p>
         *        <b>3</b> - Other
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCategory(Integer errorCategory);

        /**
         * <p>
         * An integer value that provides specific information about an Athena query error. For the meaning of specific
         * values, see the <a href=
         * "https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference"
         * >Error Type Reference</a> in the <i>Amazon Athena User Guide</i>.
         * </p>
         * 
         * @param errorType
         *        An integer value that provides specific information about an Athena query error. For the meaning of
         *        specific values, see the <a href=
         *        "https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference"
         *        >Error Type Reference</a> in the <i>Amazon Athena User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorType(Integer errorType);
    }

    static final class BuilderImpl implements Builder {
        private Integer errorCategory;

        private Integer errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaError model) {
            errorCategory(model.errorCategory);
            errorType(model.errorType);
        }

        public final Integer getErrorCategory() {
            return errorCategory;
        }

        public final void setErrorCategory(Integer errorCategory) {
            this.errorCategory = errorCategory;
        }

        @Override
        @Transient
        public final Builder errorCategory(Integer errorCategory) {
            this.errorCategory = errorCategory;
            return this;
        }

        public final Integer getErrorType() {
            return errorType;
        }

        public final void setErrorType(Integer errorType) {
            this.errorType = errorType;
        }

        @Override
        @Transient
        public final Builder errorType(Integer errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public AthenaError build() {
            return new AthenaError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
