/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPreparedStatementResponse extends AthenaResponse implements
        ToCopyableBuilder<GetPreparedStatementResponse.Builder, GetPreparedStatementResponse> {
    private static final SdkField<PreparedStatement> PREPARED_STATEMENT_FIELD = SdkField
            .<PreparedStatement> builder(MarshallingType.SDK_POJO).memberName("PreparedStatement")
            .getter(getter(GetPreparedStatementResponse::preparedStatement)).setter(setter(Builder::preparedStatement))
            .constructor(PreparedStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreparedStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARED_STATEMENT_FIELD));

    private final PreparedStatement preparedStatement;

    private GetPreparedStatementResponse(BuilderImpl builder) {
        super(builder);
        this.preparedStatement = builder.preparedStatement;
    }

    /**
     * <p>
     * The name of the prepared statement that was retrieved.
     * </p>
     * 
     * @return The name of the prepared statement that was retrieved.
     */
    public final PreparedStatement preparedStatement() {
        return preparedStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preparedStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPreparedStatementResponse)) {
            return false;
        }
        GetPreparedStatementResponse other = (GetPreparedStatementResponse) obj;
        return Objects.equals(preparedStatement(), other.preparedStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPreparedStatementResponse").add("PreparedStatement", preparedStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreparedStatement":
            return Optional.ofNullable(clazz.cast(preparedStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPreparedStatementResponse, T> g) {
        return obj -> g.apply((GetPreparedStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPreparedStatementResponse> {
        /**
         * <p>
         * The name of the prepared statement that was retrieved.
         * </p>
         * 
         * @param preparedStatement
         *        The name of the prepared statement that was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preparedStatement(PreparedStatement preparedStatement);

        /**
         * <p>
         * The name of the prepared statement that was retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link PreparedStatement.Builder} avoiding the need to
         * create one manually via {@link PreparedStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link PreparedStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #preparedStatement(PreparedStatement)}.
         * 
         * @param preparedStatement
         *        a consumer that will call methods on {@link PreparedStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preparedStatement(PreparedStatement)
         */
        default Builder preparedStatement(Consumer<PreparedStatement.Builder> preparedStatement) {
            return preparedStatement(PreparedStatement.builder().applyMutation(preparedStatement).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private PreparedStatement preparedStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPreparedStatementResponse model) {
            super(model);
            preparedStatement(model.preparedStatement);
        }

        public final PreparedStatement.Builder getPreparedStatement() {
            return preparedStatement != null ? preparedStatement.toBuilder() : null;
        }

        public final void setPreparedStatement(PreparedStatement.BuilderImpl preparedStatement) {
            this.preparedStatement = preparedStatement != null ? preparedStatement.build() : null;
        }

        @Override
        @Transient
        public final Builder preparedStatement(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
            return this;
        }

        @Override
        public GetPreparedStatementResponse build() {
            return new GetPreparedStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
